/*
 * Samsung Exynos5 SoC series Sensor driver
 *
 *
 * Copyright (c) 2011 Samsung Electronics Co., Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/version.h>
#include <linux/gpio.h>
#include <linux/clk.h>
#include <linux/regulator/consumer.h>
#include <linux/videodev2.h>
#include <linux/videodev2_exynos_camera_ext.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/platform_device.h>
#ifdef CONFIG_OF
#include <linux/of_gpio.h>
#endif
#include <mach/regs-gpio.h>
#include <mach/regs-clock.h>
#include <plat/clock.h>
#include <plat/gpio-cfg.h>
#include <media/v4l2-ctrls.h>
#include <media/v4l2-device.h>
#include <media/v4l2-subdev.h>
#include <mach/exynos-fimc-is-sensor.h>

#include "../fimc-is-core.h"
#include "../fimc-is-device-sensor.h"
#include "../fimc-is-resourcemgr.h"
#include "../fimc-is-hw.h"
#include "fimc-is-device-ov5647.h"

#define SENSOR_NAME "OV5647"
#define DEFAULT_SENSOR_WIDTH	184
#define DEFAULT_SENSOR_HEIGHT	104
#define SENSOR_MEMSIZE DEFAULT_SENSOR_WIDTH * DEFAULT_SENSOR_HEIGHT

#define REG_TERM 0xfffe
#define VAL_TERM 0xfe
#define REG_DLY  0xffff


#define SENSOR_REG_VIS_DURATION_MSB			(0x6026)
#define SENSOR_REG_VIS_DURATION_LSB			(0x6027)
#define SENSOR_REG_VIS_FRAME_LENGTH_LINE_ALV_MSB	(0x4340)
#define SENSOR_REG_VIS_FRAME_LENGTH_LINE_ALV_LSB	(0x4341)
#define SENSOR_REG_VIS_LINE_LENGTH_PCLK_ALV_MSB		(0x4342)
#define SENSOR_REG_VIS_LINE_LENGTH_PCLK_ALV_LSB		(0x4343)
#define SENSOR_REG_VIS_GAIN_RED				(0x6029)
#define SENSOR_REG_VIS_GAIN_GREEN			(0x602A)
#define SENSOR_REG_VIS_AE_TARGET			(0x600A)
#define SENSOR_REG_VIS_AE_SPEED				(0x5034)
#define SENSOR_REG_VIS_AE_NUMBER_OF_PIXEL_MSB		(0x5030)
#define SENSOR_REG_VIS_AE_NUMBER_OF_PIXEL_LSB		(0x5031)
#define SENSOR_REG_VIS_AE_WINDOW_WEIGHT_1x1_2		(0x6000)
#define SENSOR_REG_VIS_AE_WINDOW_WEIGHT_1x3_4		(0x6001)
#define SENSOR_REG_VIS_AE_WINDOW_WEIGHT_2x1_2		(0x6002)
#define SENSOR_REG_VIS_AE_WINDOW_WEIGHT_2x3_4		(0x6003)
#define SENSOR_REG_VIS_AE_WINDOW_WEIGHT_3x1_2		(0x6004)
#define SENSOR_REG_VIS_AE_WINDOW_WEIGHT_3x3_4		(0x6005)
#define SENSOR_REG_VIS_AE_WINDOW_WEIGHT_4x1_2		(0x6006)
#define SENSOR_REG_VIS_AE_WINDOW_WEIGHT_4x3_4		(0x6007)
#define SENSOR_REG_VIS_AE_MANUAL_EXP_MSB		(0x5039)
#define SENSOR_REG_VIS_AE_MANUAL_EXP_LSB		(0x503A)
#define SENSOR_REG_VIS_AE_MANUAL_ANG_MSB		(0x503B)
#define SENSOR_REG_VIS_AE_MANUAL_ANG_LSB		(0x503C)
#define SENSOR_REG_VIS_BIT_CONVERTING_MSB		(0x602B)
#define SENSOR_REG_VIS_BIT_CONVERTING_LSB		(0x7203)
#define SENSOR_REG_VIS_AE_OFF				(0x5000)

int sensor_ov5647_stream_off(struct v4l2_subdev *subdev);
int sensor_ov5647_stream_on(struct v4l2_subdev *subdev);

struct regval_list {
	uint16_t addr;
	uint8_t data;
};

static struct regval_list sensor_oe_disable_regs[] = {
	{0x3000, 0x00},
	{0x3001, 0x00},
	{0x3002, 0x00},
};

static struct regval_list sensor_oe_enable_regs[] = {
	{0x3000, 0x0f},
	{0x3001, 0xff},
	{0x3002, 0xe4},
};

static struct regval_list ov5647_640x480[] = {
	{0x0100, 0x00},
	{0x0103, 0x01},
	{0x3034, 0x08},
	{0x3035, 0x21},
	{0x3036, 0x46},
	{0x303c, 0x11},
	{0x3106, 0xf5},
	{0x3821, 0x07},
	{0x3820, 0x41},
	{0x3827, 0xec},
	{0x370c, 0x0f},
	{0x3612, 0x59},
	{0x3618, 0x00},
	{0x5000, 0x06},
	{0x5001, 0x01},
	{0x5002, 0x41},
	{0x5003, 0x08},
	{0x5a00, 0x08},
	{0x3000, 0x00},
	{0x3001, 0x00},
	{0x3002, 0x00},
	{0x3016, 0x08},
	{0x3017, 0xe0},
	{0x3018, 0x44},
	{0x301c, 0xf8},
	{0x301d, 0xf0},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3c01, 0x80},
	{0x3b07, 0x0c},
	{0x380c, 0x07},
	{0x380d, 0x68},
	{0x380e, 0x03},
	{0x380f, 0xd8},
	{0x3814, 0x31},
	{0x3815, 0x31},
	{0x3708, 0x64},
	{0x3709, 0x52},
	{0x3808, 0x02},
	{0x3809, 0x80},
	{0x380a, 0x01},
	{0x380b, 0xE0},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x00},
	{0x3804, 0x0a},
	{0x3805, 0x3f},
	{0x3806, 0x07},
	{0x3807, 0xa1},
	{0x3811, 0x08},
	{0x3813, 0x02},
	{0x3630, 0x2e},
	{0x3632, 0xe2},
	{0x3633, 0x23},
	{0x3634, 0x44},
	{0x3636, 0x06},
	{0x3620, 0x64},
	{0x3621, 0xe0},
	{0x3600, 0x37},
	{0x3704, 0xa0},
	{0x3703, 0x5a},
	{0x3715, 0x78},
	{0x3717, 0x01},
	{0x3731, 0x02},
	{0x370b, 0x60},
	{0x3705, 0x1a},
	{0x3f05, 0x02},
	{0x3f06, 0x10},
	{0x3f01, 0x0a},
	{0x3a08, 0x01},
	{0x3a09, 0x27},
	{0x3a0a, 0x00},
	{0x3a0b, 0xf6},
	{0x3a0d, 0x04},
	{0x3a0e, 0x03},
	{0x3a0f, 0x58},
	{0x3a10, 0x50},
	{0x3a1b, 0x58},
	{0x3a1e, 0x50},
	{0x3a11, 0x60},
	{0x3a1f, 0x28},
	{0x4001, 0x02},
	{0x4004, 0x02},
	{0x4000, 0x09},
	{0x4837, 0x24},
	{0x4050, 0x6e},
	{0x4051, 0x8f},
	{0x0100, 0x01},
};

static struct regval_list ov5647_1080p_regs[] = { //1080: 1920*1080@30fps
  {0x3035,0x11}, //clk                
  {0x3036,0x50}, //clk                
  {0x303c,0x11}, //clk                
  {0x3820,0x00}, //vbin               
  {0x3821,0x06}, //hbin               
  {0x3612,0x4b}, //                   
  {0x3618,0x04}, //                   
  {0x3708,0x24}, //                   
  {0x3709,0x12}, //                   
  {0x370c,0x00}, //                   
  {0x380c,0x09}, //[4:0]hts high      
  {0x380d,0x4e}, //[7:0]hts low       
  {0x380e,0x04}, //[4:0]vts high      
  {0x380f,0x60}, //[7:0]vts low       
  {0x3814,0x11}, //h subsample inc    
  {0x3815,0x11}, //v subsample inc    
  {0x3808,0x07}, //[4:0]dvp h out high
  {0x3809,0x80}, //[7:0]dvp h out low 
  {0x380a,0x04}, //[4:0]dvp v out high
  {0x380b,0x38}, //[7:0]dvp v out low 
  {0x3800,0x01}, //[4:0]dvp h start   
  {0x3801,0x5c}, //[7:0]dvp h start   
  {0x3802,0x01}, //[4:0]dvp v start   
  {0x3803,0xb2}, //[7:0]dvp v start   
  {0x3804,0x08}, //[4:0]dvp h end     
  {0x3805,0xe3}, //[7:0]dvp h end     
  {0x3806,0x05}, //[4:0]dvp v end     
  {0x3807,0xf1}, //[7:0]dvp v end     
//  {0x3a08,0x01}, //
//  {0x3a09,0x4b}, //
//  {0x3a0a,0x01}, //
//  {0x3a0b,0x14}, //
//  {0x3a0d,0x04}, //
//  {0x3a0e,0x03}, //
  //{REG_TERM,VAL_TERM},
};

static struct regval_list ov5647_720p_regs[] = { //720: 1280*720@30fps
  {0x3035,0x21}, //clk                
  {0x3036,0x69}, //clk                
  {0x303c,0x12}, //clk                
  {0x3820,0x41}, //vbin               
  {0x3821,0x07}, //hbin               
  {0x3612,0x49}, //                   
  {0x3618,0x00}, //                   
  {0x3708,0x22}, //                   
  {0x3709,0x52}, //                   
  {0x370c,0x03}, //                   
  {0x380c,0x06}, //[4:0]hts high      
  {0x380d,0xd6}, //[7:0]hts low       
  {0x380e,0x03}, //[4:0]vts high      
  {0x380f,0x20}, //[7:0]vts low       
  {0x3814,0x31}, //h subsample inc    
  {0x3815,0x31}, //v subsample inc    
  {0x3808,0x05}, //[4:0]dvp h out high
  {0x3809,0x00}, //[7:0]dvp h out low 
  {0x380a,0x02}, //[4:0]dvp v out high
  {0x380b,0xd0}, //[7:0]dvp v out low 
  {0x3800,0x00}, //[4:0]dvp h start   
  {0x3801,0x18}, //[7:0]dvp h start   
  {0x3802,0x00}, //[4:0]dvp v start   
  {0x3803,0xf8}, //[7:0]dvp v start   
  {0x3804,0x0a}, //[4:0]dvp h end     
  {0x3805,0x27}, //[7:0]dvp h end     
  {0x3806,0x06}, //[4:0]dvp v end     
  {0x3807,0xa7}, //[7:0]dvp v end     
//  {0x3a08,0x00}, //
//  {0x3a09,0xdf}, //
//  {0x3a0a,0x00}, //
//  {0x3a0b,0xba}, //
//  {0x3a0d,0x04}, //
//  {0x3a0e,0x03}, //
  //{REG_TERM,VAL_TERM},
};
static struct fimc_is_sensor_cfg config_ov5647[] = {
	/* 320x180@10fps : only for vision(settle) */
	FIMC_IS_SENSOR_CFG( 640,  480, 10, 4, 6),
	FIMC_IS_SENSOR_CFG(1024,  768, 30, 4, 6),
	FIMC_IS_SENSOR_CFG(1280,  720, 30, 4, 6),
	FIMC_IS_SENSOR_CFG(1920, 1080, 30, 4, 6),
	FIMC_IS_SENSOR_CFG(2560, 1920, 30, 4, 6),
};

static int ov5647_write(struct v4l2_subdev *subdev, uint16_t reg, uint8_t val)
{
	struct fimc_is_module_enum *module;
	struct fimc_is_module_ov5647 *module_ov5647;
	struct i2c_client *client;

	BUG_ON(!subdev);
	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	module_ov5647 = module->private_data;
	client = module->client;

	return fimc_is_sensor_write(client, reg, val);
}

/**
* @short I2C Read operation
* @param[in] i2c_client I2C client
* @param[in] reg register address
* @param[out] val value read
* @return Error code
*/
static int ov5647_read(struct v4l2_subdev *subdev, uint16_t reg, uint8_t *val)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_ov5647 *module_ov5647;
	struct i2c_client *client;
	uint8_t rval;

	BUG_ON(!subdev);
	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	module_ov5647 = module->private_data;
	client = module->client;

	ret = fimc_is_sensor_read(client, reg, &rval);
	*val = rval;

	return ret;
}

static int ov5647_write_array(struct v4l2_subdev *subdev,
				struct regval_list *regs, int array_size)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_ov5647 *module_ov5647;
	struct i2c_client *client;
	int i = 0;

	BUG_ON(!subdev);
	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	module_ov5647 = module->private_data;
	client = module->client;

	if (!regs)
		return -EINVAL;

	while (i < array_size) {
		if (regs->addr == REG_DLY)
			mdelay(regs->data);
		else
			ret = fimc_is_sensor_write(client, regs->addr, regs->data);
		if (ret == -EIO)
			return ret;
		i++;
		regs++;
	}
	return 0;
}

static void ov5647_set_virtual_channel(struct v4l2_subdev *subdev, int channel)
{
	u8 channel_id;

	ov5647_read(subdev, 0x4814, &channel_id);
	channel_id &= ~(3 << 6);
	ov5647_write(subdev, 0x4814, channel_id | (channel << 6));
}

static int __sensor_init(struct v4l2_subdev *subdev)
{
	int ret;
	uint8_t resetval;
	unsigned char rdval;

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	ret = ov5647_read(subdev, 0x0100, &rdval);
	if (ret != 0)
		return ret;

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	ov5647_write(subdev, 0x4800, 0x25);
	sensor_ov5647_stream_off(subdev);

	ret = ov5647_write_array(subdev, ov5647_640x480,
					ARRAY_SIZE(ov5647_640x480));
	if (ret < 0) {
		v4l2_err(subdev, "write sensor_default_regs error\n");
		return ret;
	}
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);

	ov5647_set_virtual_channel(subdev, 0);

	ov5647_read(subdev, 0x0100, &resetval);
	if (!resetval&0x01) {
		ov5647_write(subdev, 0x0100, 0x01);
	}

	ov5647_write(subdev, 0x4800, 0x04);
	sensor_ov5647_stream_on(subdev);

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

static int sensor_ov5647_open(struct v4l2_subdev *sd,
	struct v4l2_subdev_fh *fh)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);

	pr_info("%s\n", __func__);
	return 0;
}
static int sensor_ov5647_close(struct v4l2_subdev *sd,
	struct v4l2_subdev_fh *fh)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);
	return 0;
}
static int sensor_ov5647_registered(struct v4l2_subdev *sd)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);
	return 0;
}

static void sensor_ov5647_unregistered(struct v4l2_subdev *sd)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);
}

static const struct v4l2_subdev_internal_ops internal_ops = {
	.open = sensor_ov5647_open,
	.close = sensor_ov5647_close,
	.registered = sensor_ov5647_registered,
	.unregistered = sensor_ov5647_unregistered,
};

static int sensor_ov5647_init(struct v4l2_subdev *subdev, u32 val)
{
	int ret = 0;
	struct fimc_is_module_enum *module;

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);

	BUG_ON(!subdev);
	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);

	ret = ov5647_write_array(subdev, sensor_oe_enable_regs,
			ARRAY_SIZE(sensor_oe_enable_regs));
	ret = __sensor_init(subdev);
	if (ret < 0)
		return ret;
	pr_info("[MOD:D:%d] %s(%d)\n", module->id, __func__, val);

	return ret;
}

static int sensor_ov5647_s_ctrl(struct v4l2_subdev *subdev, struct v4l2_control *ctrl)
{
	int ret = 0;

	switch (ctrl->id) {
	case V4L2_CID_SCENEMODE:
	case V4L2_CID_FOCUS_MODE:
	case V4L2_CID_WHITE_BALANCE_PRESET:
	case V4L2_CID_IMAGE_EFFECT:
	case V4L2_CID_CAM_ISO:
	case V4L2_CID_CAM_CONTRAST:
	case V4L2_CID_CAM_SATURATION:
	case V4L2_CID_CAM_SHARPNESS:
	case V4L2_CID_CAM_BRIGHTNESS:
	case V4L2_CID_CAM_METERING:
	case V4L2_CID_CAM_SET_AUTO_FOCUS:
	case V4L2_CID_CAM_OBJECT_POSITION_X:
	case V4L2_CID_CAM_OBJECT_POSITION_Y:
	case V4L2_CID_CAM_FACE_DETECTION:
	case V4L2_CID_CAM_WDR:
	case V4L2_CID_CAM_AUTO_FOCUS_RESULT:
	case V4L2_CID_JPEG_QUALITY:
	case V4L2_CID_CAM_AEAWB_LOCK_UNLOCK:
	case V4L2_CID_CAM_CAF_START_STOP:
	case V4L2_CID_CAM_ZOOM:
		err("invalid ioctl(0x%08X) is requested", ctrl->id);
		break;
	case V4L2_CID_CAM_SINGLE_AUTO_FOCUS:
		break;
	case V4L2_CID_CAPTURE:
		break;
	case V4L2_CID_CAM_FLASH_MODE:
		break;
	case V4L2_CID_CAM_FRAME_RATE:
		break;
	default:
		err("unsupported ioctl(0x%08X) is requested", ctrl->id);
		//ret = -EINVAL;
		ret = 0;
		break;
	}

p_err:
	return ret;
}

static const struct v4l2_subdev_core_ops core_ops = {
	.init = sensor_ov5647_init,
	.s_ctrl	= sensor_ov5647_s_ctrl,
};

static int sensor_ov5647_s_stream(struct v4l2_subdev *subdev, int enable)
{
	int ret = 0;
	struct fimc_is_module_enum *sensor;

	pr_info("%s\n", __func__);

	sensor = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (!sensor) {
		err("sensor is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	if (enable) {
		ret = CALL_MOPS(sensor, stream_on, subdev);
		if (ret) {
			err("s_duration is fail(%d)", ret);
			goto p_err;
		}
	} else {
		ret = CALL_MOPS(sensor, stream_off, subdev);
		if (ret) {
			err("s_duration is fail(%d)", ret);
			goto p_err;
		}
	}

p_err:
	return 0;
}

static int sensor_ov5647_s_param(struct v4l2_subdev *subdev, struct v4l2_streamparm *param)
{
	int ret = 0;
	struct fimc_is_module_enum *sensor;
	struct v4l2_captureparm *cp;
	struct v4l2_fract *tpf;
	u64 duration;

	BUG_ON(!subdev);
	BUG_ON(!param);

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);

	cp = &param->parm.capture;
	tpf = &cp->timeperframe;

	if (!tpf->denominator) {
		err("denominator is 0");
		ret = -EINVAL;
		goto p_err;
	}

	if (!tpf->numerator) {
		err("numerator is 0");
		ret = -EINVAL;
		goto p_err;
	}

	duration = (u64)(tpf->numerator * 1000 * 1000 * 1000) /
					(u64)(tpf->denominator);

	sensor = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (!sensor) {
		err("sensor is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	ret = CALL_MOPS(sensor, s_duration, subdev, duration);
	if (ret) {
		err("s_duration is fail(%d)", ret);
		goto p_err;
	}

p_err:
	return ret;
}

static int sensor_ov5647_s_format(struct v4l2_subdev *subdev, struct v4l2_mbus_framefmt *fmt)
{

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	/* TODO */
	return 0;
}

static const struct v4l2_subdev_video_ops video_ops = {
	.s_stream = sensor_ov5647_s_stream,
	.s_parm = sensor_ov5647_s_param,
	.s_mbus_fmt = sensor_ov5647_s_format
};

static const struct v4l2_subdev_ops subdev_ops = {
	.core = &core_ops,
	.video = &video_ops
};

int sensor_ov5647_stream_on(struct v4l2_subdev *subdev)
{
	int ret = 0;
	struct fimc_is_module_enum *sensor;
	struct i2c_client *client;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);

	BUG_ON(!subdev);

	sensor = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!sensor)) {
		err("sensor is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = sensor->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	ret = fimc_is_sensor_write(client, 0x4202, 0x00);
	if (ret < 0) {
		err("fimc_is_sensor_write is fail(%d)", ret);
		goto p_err;
	}
	ret = fimc_is_sensor_write(client, 0x300D, 0x00);
	if (ret < 0) {
		err("fimc_is_sensor_write is fail(%d)", ret);
		goto p_err;
	}

p_err:
	return 0;
}

int sensor_ov5647_stream_off(struct v4l2_subdev *subdev)
{
	int ret = 0;
	struct fimc_is_module_enum *sensor;
	struct i2c_client *client;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);

	BUG_ON(!subdev);

	sensor = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!sensor)) {
		err("sensor is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = sensor->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	ret = fimc_is_sensor_write(client, 0x4100, 0);
	if (ret < 0) {
		err("fimc_is_sensor_write is fail(%d)", ret);
		goto p_err;
	}

p_err:
	return 0;
}

/*
 * @ brief
 * frame duration time
 * @ unit
 * nano second
 * @ remarks
 */
int sensor_ov5647_s_duration(struct v4l2_subdev *subdev, u64 duration)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

int sensor_ov5647_g_min_duration(struct v4l2_subdev *subdev)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

int sensor_ov5647_g_max_duration(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

int sensor_ov5647_s_exposure(struct v4l2_subdev *subdev, u64 exposure)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

int sensor_ov5647_g_min_exposure(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_ov5647_g_max_exposure(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_ov5647_s_again(struct v4l2_subdev *subdev, u64 sensitivity)
{
	int ret = 0;

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);

	return ret;
}

int sensor_ov5647_g_min_again(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_ov5647_g_max_again(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_ov5647_s_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_ov5647_g_min_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_ov5647_g_max_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

struct fimc_is_sensor_ops module_ov5647_ops = {
	.stream_on	= sensor_ov5647_stream_on,
	.stream_off	= sensor_ov5647_stream_off,
	.s_duration	= sensor_ov5647_s_duration,
	.g_min_duration	= sensor_ov5647_g_min_duration,
	.g_max_duration	= sensor_ov5647_g_max_duration,
	.s_exposure	= sensor_ov5647_s_exposure,
	.g_min_exposure	= sensor_ov5647_g_min_exposure,
	.g_max_exposure	= sensor_ov5647_g_max_exposure,
	.s_again	= sensor_ov5647_s_again,
	.g_min_again	= sensor_ov5647_g_min_again,
	.g_max_again	= sensor_ov5647_g_max_again,
	.s_dgain	= sensor_ov5647_s_dgain,
	.g_min_dgain	= sensor_ov5647_g_min_dgain,
	.g_max_dgain	= sensor_ov5647_g_max_dgain
};

int sensor_ov5647_probe(struct i2c_client *client,
	const struct i2c_device_id *id)
{
	int ret = 0;
	struct fimc_is_core *core;
	struct v4l2_subdev *subdev_module;
	struct fimc_is_module_enum *module;
	struct fimc_is_device_sensor *device;
	struct sensor_open_extended *ext;
	static bool probe_retried = false;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	if (!fimc_is_dev)
		goto probe_defer;

	core = (struct fimc_is_core *)dev_get_drvdata(fimc_is_dev);
	if (!core) {
		err("core device is not yet probed");
		return -EPROBE_DEFER;
	}

	device = &core->sensor[SENSOR_OV5647_INSTANCE];

	subdev_module = kzalloc(sizeof(struct v4l2_subdev), GFP_KERNEL);
	if (!subdev_module) {
		err("subdev_module is NULL");
		ret = -ENOMEM;
		goto p_err;
	}

	/* OV5647 */
	module = &device->module_enum[atomic_read(&core->resourcemgr.rsccount_module)];
	atomic_inc(&core->resourcemgr.rsccount_module);
	module->id = SENSOR_OV5647_NAME;
	module->subdev = subdev_module;
	module->device = SENSOR_OV5647_INSTANCE;
	module->ops = &module_ov5647_ops;
	module->client = client;
	module->active_width = 1920;
	module->active_height = 1080;
	module->pixel_width = module->active_width + 16;
	module->pixel_height = module->active_height + 10;
	module->max_framerate = 30;
	module->position = SENSOR_POSITION_REAR;
//	module->mode = CSI_MODE_VC_ONLY;
//	module->lanes = CSI_DATA_LANES_4;
	module->setfile_name = "setfile_6b2.bin";
	module->cfgs = ARRAY_SIZE(config_ov5647);
	module->cfg = config_ov5647;
	module->private_data = kzalloc(sizeof(struct fimc_is_module_ov5647), GFP_KERNEL);
	if (!module->private_data) {
		err("private_data is NULL");
		ret = -ENOMEM;
		kfree(subdev_module);
		goto p_err;
	}

	ext = &module->ext;
	ext->mipi_lane_num = CSI_DATA_LANES_4;
	ext->I2CSclk = I2C_L0;
	ext->sensor_con.product_name = SENSOR_NAME_OV5647;
	ext->sensor_con.peri_type = SE_I2C;
	ext->sensor_con.peri_setting.i2c.channel = SENSOR_CONTROL_I2C2;
	ext->sensor_con.peri_setting.i2c.slave_address = 0x6c;
	ext->sensor_con.peri_setting.i2c.speed = 400000;

	ext->from_con.product_name = FROMDRV_NAME_NOTHING;

	ext->companion_con.product_name = COMPANION_NAME_NOTHING;

	if (client) {
		v4l2_i2c_subdev_init(subdev_module, client, &subdev_ops);
		subdev_module->internal_ops = &internal_ops;
	} else {
		v4l2_subdev_init(subdev_module, &subdev_ops);
	}

	v4l2_set_subdevdata(subdev_module, module);
	v4l2_set_subdev_hostdata(subdev_module, device);
	snprintf(subdev_module->name, V4L2_SUBDEV_NAME_SIZE, "sensor-subdev.%d", module->id);

//sensor_ov5647_init(subdev_module, 1);
p_err:
	info("%s(%d)\n", __func__, ret);
	return ret;

probe_defer:
	if (probe_retried) {
		err("probe has already been retried!!");
		BUG();
	}

	probe_retried = true;
	err("core device is not yet probed");
	return -EPROBE_DEFER;
}

static int sensor_ov5647_remove(struct i2c_client *client)
{
	int ret = 0;
	return ret;
}

#ifdef CONFIG_OF
static const struct of_device_id exynos_fimc_is_sensor_ov5647_match[] = {
	{
		.compatible = "samsung,exynos5-fimc-is-sensor-ov5647",
	},
	{},
};
#endif

static const struct i2c_device_id sensor_ov5647_idt[] = {
	{ SENSOR_NAME, 0 },
};

static struct i2c_driver sensor_ov5647_driver = {
	.driver = {
		.name	= SENSOR_NAME,
		.owner	= THIS_MODULE,
#ifdef CONFIG_OF
		.of_match_table = exynos_fimc_is_sensor_ov5647_match
#endif
	},
	.probe	= sensor_ov5647_probe,
	.remove	= sensor_ov5647_remove,
	.id_table = sensor_ov5647_idt
};

static int __init sensor_ov5647_load(void)
{
        return i2c_add_driver(&sensor_ov5647_driver);
}

static void __exit sensor_ov5647_unload(void)
{
        i2c_del_driver(&sensor_ov5647_driver);
}

module_init(sensor_ov5647_load);
module_exit(sensor_ov5647_unload);

MODULE_AUTHOR("Gilyeon lim");
MODULE_DESCRIPTION("Sensor 8B1 driver");
MODULE_LICENSE("GPL v2");
