/* linux/arch/arm/mach-exynos/include/mach/map-exynos5.h
 *
 * Copyright (c) 2011 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com/
 *
 * EXYNOS5 - Memory map definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_MAP_EXYNOS5_H
#define __ASM_ARCH_MAP_EXYNOS5_H __FILE__

#define EXYNOS5_PA_SYSRAM		0x02020000
#define EXYNOS5_PA_SYSRAM_NS            0x0204F000

#define EXYNOS5_PA_CHIPID		0x10000000

#define EXYNOS5_PA_CMU			0x10010000

#define EXYNOS5_PA_PMU			0x10040000

#define EXYNOS5_PA_HDMI_CEC		0x101B0000
#define EXYNOS5_PA_SYSTIMER		0x101C0000
#define EXYNOS5_PA_WATCHDOG		0x101D0000
#define EXYNOS5_PA_RTC			0x101E0000

#define EXYNOS5_PA_COMBINER		0x10440000

#define EXYNOS5_PA_GIC_CPU		0x10480000
#define EXYNOS5_PA_GIC_DIST		0x10490000

#define EXYNOS5_PA_SYSCON		0x10050100
#define EXYNOS5_PA_TMU			0x10060000
#define EXYNOS5_PA_ACE			0x10830000

#define EXYNOS5_PA_PPMU_DDR_C		0x10C40000
#define EXYNOS5_PA_PPMU_DDR_R1		0x10C50000
#define EXYNOS5_PA_PPMU_CPU		0x10C60000
#define EXYNOS5_PA_PPMU_DDR_L		0x10CB0000
#define EXYNOS5_PA_PPMU_RIGHT0_BUS	0x13660000

#define EXYNOS5_PA_C2C			0x10E00000
#define EXYNOS5_PA_C2C_CP		0x10E40000

#define EXYNOS5_PA_SYSMMU_MDMA1		0x10A40000
#define EXYNOS5_PA_SYSMMU_SSS		0x10A50000
#define EXYNOS5_PA_SYSMMU_2D		0x10A60000
#define EXYNOS5_PA_SYSMMU_MFC_L		0x11200000
#define EXYNOS5_PA_SYSMMU_MFC_R		0x11210000
#define EXYNOS5_PA_SYSMMU_ROTATOR	0x11D40000
#define EXYNOS5_PA_SYSMMU_MDMA2		0x11D50000
#define EXYNOS5_PA_SYSMMU_JPEG		0x11F20000
#define EXYNOS5_PA_SYSMMU_IOP		0x12360000
#define EXYNOS5_PA_SYSMMU_RTIC		0x12370000
#define EXYNOS5_PA_SYSMMU_GPS		0x12630000
#define EXYNOS5_PA_SYSMMU_ISP		0x13260000
#define EXYNOS5_PA_SYSMMU_DRC		0x12370000
#define EXYNOS5_PA_SYSMMU_SCALERC	0x13280000
#define EXYNOS5_PA_SYSMMU_SCALERP	0x13290000
#define EXYNOS5_PA_SYSMMU_FD		0x132A0000
#define EXYNOS5_PA_SYSMMU_ISPCPU	0x132B0000
#define EXYNOS5_PA_SYSMMU_ODC		0x132C0000
#define EXYNOS5_PA_SYSMMU_DIS0		0x132D0000
#define EXYNOS5_PA_SYSMMU_DIS1		0x132E0000
#define EXYNOS5_PA_SYSMMU_3DNR		0x132F0000
#define EXYNOS5_PA_SYSMMU_LITE0		0x13C40000
#define EXYNOS5_PA_SYSMMU_LITE1		0x13C50000
#define EXYNOS5_PA_SYSMMU_GSC0		0x13E80000
#define EXYNOS5_PA_SYSMMU_GSC1		0x13E90000
#define EXYNOS5_PA_SYSMMU_GSC2		0x13EA0000
#define EXYNOS5_PA_SYSMMU_GSC3		0x13EB0000
#define EXYNOS5_PA_SYSMMU_FIMD1		0x14640000
#define EXYNOS5_PA_SYSMMU_TV		0x14650000

#define EXYNOS5_PA_FIMG2D		0x10850000
#define EXYNOS5_PA_MFC			0x11000000

#define EXYNOS5_PA_GPIO1		0x11400000
#define EXYNOS5_PA_GPIO2		0x13400000
#define EXYNOS5_PA_GPIO3		0x10D10000
#define EXYNOS5_PA_GPIO4		0x03860000

#define EXYNOS5_PA_G3D			0x11800000

#define EXYNOS5_PA_HSMMC(x)		(0x12200000 + ((x) * 0x10000))
#define EXYNOS5_PA_DWMCI		0x12240000

#define EXYNOS5_PA_SS_UDC		0x1200C100
#define EXYNOS5_PA_SS_DRD		0x12000000
#define EXYNOS5_PA_SS_PHY		0x12100000
#define EXYNOS5_PA_EHCI			0x12110000
#define EXYNOS5_PA_OHCI			0x12120000
#define EXYNOS5_PA_HSPHY		0x12130000
#define EXYNOS5_PA_HSOTG		0x12140000

#define EXYNOS5_PA_SATA_PHY_CTRL	0x12170000
#define EXYNOS5_PA_SATA_PHY_I2C		0x121D0000
#define EXYNOS5_PA_SATA_BASE		0x122F0000

#define EXYNOS5_PA_SROMC		0x12250000
#define EXYNOS4_PA_SROM_BANK(x)		(0x04000000 + ((x) * 0x01000000))

#define EXYNOS5_PA_UART			0x12C00000

#define EXYNOS5_PA_IIC(x)		(0x12C60000 + ((x) * 0x10000))
#define EXYNOS5_PA_IIC_HDMIPHY		0x12CE0000

#define EXYNOS5_PA_SPI0			0x12D20000
#define EXYNOS5_PA_SPI1			0x12D30000
#define EXYNOS5_PA_SPI2			0x12D40000

#define EXYNOS5_PA_TIMER		0x12DD0000

#define EXYNOS5_PA_FIMD0		0x13800000
#define EXYNOS5_PA_FIMD1		0x14400000
#define EXYNOS5_PA_MIXER		0x14450000
#define EXYNOS5_PA_DSIM0		0x14500000
#define EXYNOS5_PA_DP			0x145B0000
#define EXYNOS5_PA_HDMI			0x14530000

#define EXYNOS5_PA_FIMC_IS		0x13000000

#define EXYNOS5_PA_FIMC_LITE0		0x13C00000
#define EXYNOS5_PA_FIMC_LITE1		0x13C10000

#define EXYNOS5_PA_MIPI_CSIS0		0x13C20000
#define EXYNOS5_PA_MIPI_CSIS1		0x13C30000

#define EXYNOS5_PA_GSC0 		0x13E00000
#define EXYNOS5_PA_GSC1 		0x13E10000
#define EXYNOS5_PA_GSC2 		0x13E20000
#define EXYNOS5_PA_GSC3 		0x13E30000

#define EXYNOS5_PA_ROTATOR		0x11c00000

#define EXYNOS5_PA_SDRAM		0x40000000

#define EXYNOS5_PA_NS_MDMA0		0x10800000
#define EXYNOS5_PA_NS_MDMA1		0x11c10000
#define EXYNOS5_PA_PDMA0		0x121a0000
#define EXYNOS5_PA_PDMA1		0x121b0000

#define EXYNOS5_PA_AUDSS		0x03810000
#define EXYNOS5_PA_I2S0			0x03830000
#define EXYNOS5_PA_I2S1			0x12D60000
#define EXYNOS5_PA_I2S2			0x12D70000

#define EXYNOS5_PA_PCM0			0x03840000
#define EXYNOS5_PA_PCM1			0x12D80000
#define EXYNOS5_PA_PCM2			0x12D90000

#define EXYNOS5_PA_AC97			0x12DA0000

#define EXYNOS5_PA_SPDIF		0x12DB0000
#define EXYNOS4_PA_JPEG		0x11E00000
/* Compatibiltiy Defines */

#define EXYNOS_PA_DWMCI			EXYNOS5_PA_DWMCI

#define EXYNOS_PA_SPI0			EXYNOS5_PA_SPI0
#define EXYNOS_PA_SPI1			EXYNOS5_PA_SPI1
#define EXYNOS_PA_SPI2			EXYNOS5_PA_SPI2

#define S5P_PA_HDMI_CEC			EXYNOS5_PA_HDMI_CEC

#define S3C_PA_HSMMC0			EXYNOS5_PA_HSMMC(0)
#define S3C_PA_HSMMC1			EXYNOS5_PA_HSMMC(1)
#define S3C_PA_HSMMC2			EXYNOS5_PA_HSMMC(2)
#define S3C_PA_HSMMC3			EXYNOS5_PA_HSMMC(3)

#define EXYNOS_PA_AUDSS			EXYNOS5_PA_AUDSS
#define EXYNOS_PA_I2S0			EXYNOS5_PA_I2S0
#define EXYNOS_PA_I2S1			EXYNOS5_PA_I2S1
#define EXYNOS_PA_I2S2			EXYNOS5_PA_I2S2

#define EXYNOS_PA_PCM0			EXYNOS5_PA_PCM0
#define EXYNOS_PA_PCM1			EXYNOS5_PA_PCM1
#define EXYNOS_PA_PCM2			EXYNOS5_PA_PCM2

#define EXYNOS_PA_AC97			EXYNOS5_PA_AC97

#define EXYNOS_PA_SPDIF			EXYNOS5_PA_SPDIF

#define EXYNOS_PA_FIMC_LITE0		EXYNOS5_PA_FIMC_LITE0
#define EXYNOS_PA_FIMC_LITE1		EXYNOS5_PA_FIMC_LITE1

#define EXYNOS_PA_ROTATOR		EXYNOS5_PA_ROTATOR

#define EXYNOS_PA_C2C		EXYNOS5_PA_C2C
#define EXYNOS_PA_C2C_CP		EXYNOS5_PA_C2C_CP

#define S3C_PA_IIC			EXYNOS5_PA_IIC(0)
#define S3C_PA_IIC1			EXYNOS5_PA_IIC(1)
#define S3C_PA_IIC2			EXYNOS5_PA_IIC(2)
#define S3C_PA_IIC3			EXYNOS5_PA_IIC(3)
#define S3C_PA_IIC4			EXYNOS5_PA_IIC(4)
#define S3C_PA_IIC5			EXYNOS5_PA_IIC(5)
#define S3C_PA_IIC6			EXYNOS5_PA_IIC(6)
#define S3C_PA_IIC7			EXYNOS5_PA_IIC(7)
#define S5P_PA_IIC_HDMIPHY		EXYNOS5_PA_IIC_HDMIPHY
#define S3C_PA_WDT			EXYNOS5_PA_WATCHDOG
#define S3C_PA_RTC			EXYNOS5_PA_RTC
#define S5P_PA_CHIPID			EXYNOS5_PA_CHIPID
#define S5P_PA_SYSCON			EXYNOS5_PA_SYSCON
#define S5P_PA_SROMC			EXYNOS5_PA_SROMC
#define S5P_PA_TIMER			EXYNOS5_PA_TIMER
#define S5P_PA_HSOTG			EXYNOS5_PA_HSOTG
#define S5P_PA_MFC			EXYNOS5_PA_MFC
#define S5P_PA_HSPHY			EXYNOS5_PA_HSPHY
#define S5P_PA_EHCI			EXYNOS5_PA_EHCI
#define S5P_PA_OHCI			EXYNOS5_PA_OHCI
#define S5P_PA_FIMD0			EXYNOS5_PA_FIMD0
#define S5P_PA_FIMD1			EXYNOS5_PA_FIMD1
#define S5P_PA_MIXER			EXYNOS5_PA_MIXER
#define S5P_PA_DP			EXYNOS5_PA_DP
#define S5P_PA_HDMI			EXYNOS5_PA_HDMI
#define S5P_PA_SDRAM			EXYNOS5_PA_SDRAM
#define S5P_PA_FIMG2D			EXYNOS5_PA_FIMG2D

#define S5P_PA_MDMA0			EXYNOS5_PA_NS_MDMA0
#define S5P_PA_MDMA1			EXYNOS5_PA_NS_MDMA1
#define S5P_PA_PDMA0			EXYNOS5_PA_PDMA0
#define S5P_PA_PDMA1			EXYNOS5_PA_PDMA1
#define S5P_PA_DSIM0			EXYNOS5_PA_DSIM0
#define S5P_PA_JPEG			EXYNOS4_PA_JPEG
#define S5P_PA_MIPI_CSIS0		EXYNOS5_PA_MIPI_CSIS0
#define S5P_PA_MIPI_CSIS1		EXYNOS5_PA_MIPI_CSIS1

#define S5P_PA_ACE			EXYNOS5_PA_ACE
#define S5P_PA_TMU			EXYNOS5_PA_TMU
/* UART */

#define S3C_VA_UARTx(x)			(S3C_VA_UART + ((x) * S3C_UART_OFFSET))

#define S3C_PA_UART			EXYNOS5_PA_UART

#define S5P_PA_UART(x)			(S3C_PA_UART + ((x) * S3C_UART_OFFSET))
#define S5P_PA_UART0			S5P_PA_UART(0)
#define S5P_PA_UART1			S5P_PA_UART(1)
#define S5P_PA_UART2			S5P_PA_UART(2)
#define S5P_PA_UART3			S5P_PA_UART(3)
#define S5P_PA_UART4			S5P_PA_UART(4)

#define S5P_SZ_HDMI_CEC			SZ_64K

#define S5P_SZ_UART			SZ_256

#define S5P_SZ_MIXER			SZ_64K
#define S5P_SZ_HDMI			SZ_1M
#define S5P_SZ_IIC_HDMIPHY		SZ_64K

#endif /* __ASM_ARCH_MAP_EXYNOS5_H */
