/* linux/drivers/media/video/mt9m113.h
 *
 * Copyright (c) 2010 Samsung Electronics Co., Ltd.
 *	http://www.samsung.com/
 *
 * Driver for MT9M113 (SXGA camera) from Samsung Electronics
 * 1/6" 1.3Mp CMOS Image Sensor SoC with an Embedded Image Processor
 * supporting MIPI CSI-2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
  http://code.google.com/p/bricked/source/browse/drivers/media/video/msm/mt9m113_reg.c?repo=tenderloin&r=84c9f4aa0c64639fb9773094757dfd2e5591017b
 */

#define MT9M113_COMPLETE
#undef MT9M113_COMPLETE
#ifndef __MT9M113_H__
#define __MT9M113_H__

struct mt9m113_reg {
	unsigned short addr;
	unsigned short val;
};

struct mt9m113_regset_type {
	unsigned char *regset;
	int len;
};

/*
 * Macro
 */
#define REGSET_LENGTH(x)	(sizeof(x)/sizeof(mt9m113_reg))

/*
 * Host S/W Register interface (0x70000000-0x70002000)
 */
/* Initialization section */
#define MT9M113_Speed_368Mbps		0
#define MT9M113_Speed_464Mbps		1
#define MT9M113_Speed_552Mbps		2
#define MT9M113_Speed_648Mbps		3
#define MT9M113_Speed_736Mbps		4
#define MT9M113_Speed_832Mbps		5
#define MT9M113_Speed_920Mbps		6

#define MT9M1134Khz_0Mhz		0x0000
#define MT9M1134Khz_46Mhz		0x2CEC
#define MT9M1134Khz_58Mhz		0x38A4
#define MT9M1134Khz_69Mhz		0x4362
#define MT9M1134Khz_81Mhz		0x4F1A
#define MT9M1134Khz_91Mhz		0x58DE
#define MT9M1134Khz_92Mhz		0x59D8
#define MT9M1134Khz_93Mhz		0x5AD2
#define MT9M1134Khz_104Mhz		0x6590
#define MT9M1134Khz_115Mhz		0x704E

#define MT9M113FrTime_30fps		0x014D	/*  33.3ms -> 30 fps */
#define MT9M113FrTime_15fps		0x029A	/*  66.6ms -> 15 fps */
#define MT9M113FrTime_7P5fps		0x0535	/*  133.3ms -> 7.5 fps */
#define MT9M113FrTime_1P5fps		0x1964	/*  650.0ms -> 1.5 fps */
/*=====================================*/
/*========Register map for MT9M113 EVT1(Don't modify)===========*/
#define MT9M113_REG_TC_IPRM_InClockLSBs				0x0238
#define MT9M113_REG_TC_IPRM_InClockMSBs				0x023A
#define MT9M113_REG_TC_IPRM_UseNPviClocks			0x0252
#define MT9M113_REG_TC_IPRM_UseNMipiClocks			0x0254
#define MT9M113_REG_TC_IPRM_NumberOfMipiLanes			0x0256
#define MT9M113_REG_TC_IPRM_OpClk4KHz_0				0x025A
#define MT9M113_REG_TC_IPRM_MinOutRate4KHz_0			0x025C
#define MT9M113_REG_TC_IPRM_MaxOutRate4KHz_0			0x025E
#define MT9M113_REG_TC_IPRM_InitParamsUpdated			0x026E
#define MT9M113_REG_TC_GP_EnablePreview				0x0280
#define MT9M113_REG_TC_GP_EnablePreviewChanged			0x0282
#define MT9M113_REG_TC_GP_NewConfigSync				0x0290
#define MT9M113_REG_TC_GP_ActivePrevConfig			0x02A4
#define MT9M113_REG_TC_GP_PrevConfigChanged			0x02A6
#define MT9M113_REG_TC_GP_PrevOpenAfterChange			0x02A8
#define MT9M113_REG_0TC_PCFG_usWidth				0x02E2
#define MT9M113_REG_0TC_PCFG_usHeight				0x02E4
#define MT9M113_REG_0TC_PCFG_Format				0x02E6
#define MT9M113_REG_0TC_PCFG_usMaxOut4KHzRate			0x02E8
#define MT9M113_REG_0TC_PCFG_usMinOut4KHzRate			0x02EA
#define MT9M113_REG_0TC_PCFG_PVIMask				0x02F0
#define MT9M113_REG_0TC_PCFG_uClockInd				0x02F8
#define MT9M113_REG_0TC_PCFG_FrRateQualityType			0x02FC
#define MT9M113_REG_0TC_PCFG_usFrTimeType			0x02FA
#define MT9M113_REG_0TC_PCFG_usMaxFrTimeMsecMult10		0x02FE
#define MT9M113_REG_0TC_PCFG_usMinFrTimeMsecMult10		0x0300

#define MT9M113_PCLK_MIN	MT9M1134Khz_115Mhz
#define MT9M113_PCLK_MAX	MT9M1134Khz_115Mhz

#define MT9M113_FrTime_MAX	MT9M113FrTime_30fps
/*
 * User defined commands
 */
/* S/W defined features for tune */
#define REG_DELAY	0xFFFF	/* in ms */
#define REG_CMD		0xFFFF	/* Followed by command */

/* Following order should not be changed */
enum image_size_mt9m113 {
	/* This SoC supports upto SXGA (1280*1024) */
#if 0
	QQVGA, /* 160*120*/
	QCIF, /* 176*144 */
	QVGA, /* 320*240 */
	CIF, /* 352*288 */
#endif
	VGA, /* 640*480 */
#if 0
	SVGA, /* 800*600 */
	HD720P, /* 1280*720 */
	SXGA, /* 1280*1024 */
#endif
};

/*
 * Following values describe controls of camera
 * in user aspect and must be match with index of mt9m113_regset[]
 * These values indicates each controls and should be used
 * to control each control
 */
enum mt9m113_control {
	MT9M113_INIT,
	MT9M113_EV,
	MT9M113_AWB,
	MT9M113_MWB,
	MT9M113_EFFECT,
	MT9M113_CONTRAST,
	MT9M113_SATURATION,
	MT9M113_SHARPNESS,
};

#define MT9M113_REGSET(x)	{	\
	.regset = x,			\
	.len = sizeof(x)/sizeof(mt9m113_reg),}

/*
 * User tuned register setting values
 */
unsigned short mt9m113_init0[]={
//mclk : 24MHz

//pclk : 60MHz

//preview : 640 x 480 (30fps)

//capture : 1280 x 960

//

//[1. CA?稬a AAUA]

//			

 0x001c, 0x0001,//

 0x001c, 0x0000,//

 0xffff, 0x000a, // //DELAY=10



 0x0014,0x304A,//

	

// 0xffff, 0x012c,//

 0x0016, 0x40ff,//

 0x0018, 0x0028,//



 0x0014, 0x2147,//

 0x0014, 0x2143,//

 0x0014, 0x2145,//

 0x0010, 0x0114,//

 0x0012, 0x1FF1,//

 0x0014, 0x2545,//

 0x0014, 0x2547,//

 0x0014, 0x3447,//

 0xffff, 0x000a,////DELAY= 3	 

 0x0014, 0x3047,//

 0x0014, 0x3046,//



 0x0014, 0x3047,//

 0x0014, 0x3046,//

 0x001E, 0x0772,// // new 2010 0705

 0x332E, 0x0200,// // new 2010 0705

	

 0x098C, 0x2703,// output a

 0x0990, 0x0280,////640 w

 0x098C, 0x2705,// output a

 0x0990, 0x01E0,//// 480 w

 0x098C, 0x2707,//  output B

	//NvOdmImagerI2c16Write16(&pContext->I2c, 0x0990, 0x0500//

 0x0990, 0x0500, //400

 0x098C, 0x2709,// output C

	//NvOdmImagerI2c16Write16(&pContext->I2c, 0x0990, 0x03C0//

 0x0990, 0x03c0,	//300//

 0x098C, 0x270D,//

 0x0990, 0x0000,//

 0x098C, 0x270F,//

 0x0990, 0x0000,//

 0x098C, 0x2711,//

 0x0990, 0x03CD,//

 0x098C, 0x2713,//

 0x0990, 0x050D,//

 0x098C, 0x2715,//

 0x0990, 0x2111,//

 0x098C, 0x2717,//

	//NvOdmImagerI2c16Write16(&pContext->I2c, 0x0990, 0x046C//

 0x0990, 0x046C,//	// sungmin.woo 20100720 Mirrored images for preview

 0x098C, 0x2719,//

 0x0990, 0x00AC,//

 0x098C, 0x271B,//

 0x0990, 0x01F1,//

 0x098C, 0x271D,//

 0x0990, 0x013F,//

 0x098C, 0x271F,//

 0x0990, 0x0255,//

 0x098C, 0x2721,//

 0x0990, 0x0722,//

 0x098C, 0x2723,//

 0x0990, 0x0004,//

 0x098C, 0x2725,//

 0x0990, 0x0004,//

 0x098C, 0x2727,//

	//NvOdmImagerI2c16Write16(&pContext->I2c, 0x0990, 0x040B//

 0x0990, 0x03CB,//	// from aptina choi's fix

 0x098C, 0x2729,//

 0x0990, 0x050B,//

 0x098C, 0x272B,//

 0x0990, 0x2111,//

 0x098C, 0x272D,//

	//NvOdmImagerI2c16Write16(&pContext->I2c, 0x0990, 0x0024//

 0x0990, 0x0025,//	// sungmin.woo 20100720 Mirrored images for capture

 0x098C, 0x272F,//

 0x0990, 0x004C,//

 0x098C, 0x2731,//

 0x0990, 0x00F9,//

 0x098C, 0x2733,//

 0x0990, 0x00A7,//

 0x098C, 0x2735,//

 0x0990, 0x048B,//

 0x098C, 0x2737,//

 0x0990, 0x0722,//

 0x098C, 0x2739,// crop x0 a

 0x0990, 0x0000,//

 0x098C, 0x273B,// crop x1 a

 0x0990, 0x027F,//

 0x098C, 0x273D,// crop y0 a

 0x0990, 0x0000,//

 0x098C, 0x273F,//crop y1 a

 0x0990, 0x01DF,//

 0x098C, 0x2747,//crop x0 b

 0x0990, 0x0000,//

 0x098C, 0x2749,//crop x1 b

 0x0990, 0x04FF,//

 0x098C, 0x274B,//crop y0 b

 0x0990, 0x0000,//

 0x098C, 0x274D,//crop y1 b

	//NvOdmImagerI2c16Write16(&pContext->I2c, 0x0990, 0x03FF//

 0x0990, 0x03BF,//	// from aptina choi's fix

 0x098C, 0x222D,//

 0x0990, 0x0089,//

 0x098C, 0xA404,//

 0x0990, 0x0010,//

 0x098C, 0xA408,//

 0x0990, 0x0021,//

 0x098C, 0xA409,//

 0x0990, 0x0023,//

 0x098C, 0xA40A,//

 0x0990, 0x0028,//

 0x098C, 0xA40B,//

 0x0990, 0x002A,//

 0x098C, 0x2411,//

 0x0990, 0x0089,//

 0x098C, 0x2413,//

 0x0990, 0x00A4,//

 0x098C, 0x2415,//

 0x0990, 0x0089,//

 0x098C, 0x2417,//

 0x0990, 0x00A4,//

 0x098C, 0xA40D,//

 0x0990, 0x0002,//

 0x098C, 0xA40E,//

 0x0990, 0x0003,//

 0x098C, 0xA410,//

 0x0990, 0x000A,//

	//[High Power Preview Mode]

 0x098C, 0x275f,//

 0x0990, 0x0596,//

 0x098C, 0x2761,//

 0x0990, 0x0094,//

	//[pevuew 0 seq]

 0x098C, 0xa117,//

 0x0990, 0x0002,//

 0x098C, 0xa118,//

 0x0990, 0x0001,//

 0x098C, 0xa119,//

 0x0990, 0x0001,//

 0x098C, 0xa11a,//

 0x0990, 0x0001,//

	//[pevuew 1 seq]

 0x098C, 0xa11d,//

 0x0990, 0x0002,//

 0x098C, 0xa11e,//

 0x0990, 0x0001,//

 0x098C, 0xa11f,//

 0x0990, 0x0001,//

 0x098C, 0xa120,//

 0x0990, 0x0001,//

	//[Lens Correction 95%]

 0x364E, 0x0730,//

 0x3650, 0x1E4E,//

 0x3652, 0x14F1,//

 0x3654, 0x32CF,//

 0x3656, 0x734F,//

 0x3658, 0x0330,//

 0x365A, 0xF1AD,//

 0x365C, 0x2731,//

 0x365E, 0x550E,//

 0x3660, 0x6F8F,//

 0x3662, 0x0250,//

 0x3664, 0x01AE,//

 0x3666, 0x7FD0,//

 0x3668, 0x03EF,//

 0x366A, 0x442F,//

 0x366C, 0x0250,//

 0x366E, 0x82EE,//

 0x3670, 0x0591,//

 0x3672, 0x128E,//

 0x3674, 0x540F,//

 0x3676, 0x650D,//

 0x3678, 0x714C,//

 0x367A, 0x272E,//

 0x367C, 0x09CA,//

 0x367E, 0xD12E,//

 0x3680, 0x652D,//

 0x3682, 0x9C0D,//

 0x3684, 0x172F,//

 0x3686, 0xB64D,//

 0x3688, 0xB3EF,//

 0x368A, 0x1F6D,//

 0x368C, 0xAA2D,//

 0x368E, 0x68CA,//

 0x3690, 0x300D,//

 0x3692, 0x826E,//

 0x3694, 0x13CD,//

 0x3696, 0x37AB,//

 0x3698, 0x2B2D,//

 0x369A, 0xB52A,//

 0x369C, 0x874F,//

 0x369E, 0x5390,//

 0x36A0, 0x0370,//

 0x36A2, 0x3812,//

 0x36A4, 0xFAB0,//

 0x36A6, 0xBE13,//

 0x36A8, 0x7F90,//

 0x36AA, 0xA5AC,//

 0x36AC, 0x0393,//

 0x36AE, 0x1DAD,//

 0x36B0, 0xF693,//

 0x36B2, 0x3C90,//

 0x36B4, 0x5CCF,//

 0x36B6, 0x3E72,//

 0x36B8, 0x8F70,//

 0x36BA, 0xABB3,//

 0x36BC, 0x5390,//

 0x36BE, 0x06AE,//

 0x36C0, 0x23F2,//

 0x36C2, 0x9FB0,//

 0x36C4, 0x93F3,//

 0x36C6, 0xA0AA,//

 0x36C8, 0x43CD,//

 0x36CA, 0x4E0A,//

 0x36CC, 0xE750,//

 0x36CE, 0xDAF1,//

 0x36D0, 0x50EB,//

 0x36D2, 0x88CB,//

 0x36D4, 0xAE0C,//

 0x36D6, 0x256E,//

 0x36D8, 0xA36F,//

 0x36DA, 0xC06E,//

 0x36DC, 0x844D,//

 0x36DE, 0x8CED,//

 0x36E0, 0x9110,//

 0x36E2, 0xADD1,//

 0x36E4, 0xEA2D,//

 0x36E6, 0x1BAE,//

 0x36E8, 0xD86E,//

 0x36EA, 0xBF0D,//

 0x36EC, 0xED30,//

 0x36EE, 0x224F,//

 0x36F0, 0xCC10,//

 0x36F2, 0xAAB2,//

 0x36F4, 0x510E,//

 0x36F6, 0xDC54,//

 0x36F8, 0x29B0,//

 0x36FA, 0xE5ED,//

 0x36FC, 0x90F3,//

 0x36FE, 0xA811,//

 0x3700, 0xE814,//

 0x3702, 0x3810,//

 0x3704, 0xFE2F,//

 0x3706, 0xA1B2,//

 0x3708, 0x328D,//

 0x370A, 0xBC34,//

 0x370C, 0x2D4F,//

 0x370E, 0xEA70,//

 0x3710, 0xBCF1,//

 0x3712, 0x7BD1,//

 0x3714, 0xED54,//

 0x3644, 0x0280,//

 0x3642, 0x01C0,//

 0x3210, 0x01A8,//

//

//	NvOdmImagerI2cRead16(&pContext->I2c, 0x3210, &RegVAEC//

//	RegVAEC |= (1<<3//

//	

// 0x3210,RegVAEC//

	

 0x098C, 0x2306,//

 0x0990, 0x00A4,//

 0x098C, 0x2308,//

 0x0990, 0x00D4,//

 0x098C, 0x230A,//

 0x0990, 0xFFBD,//

 0x098C, 0x230C,//

 0x0990, 0xFF68,//

 0x098C, 0x230E,//

 0x0990, 0x0284,//

 0x098C, 0x2310,//

 0x0990, 0xFF70,//

 0x098C, 0x2312,//

 0x0990, 0xFFE5,//

 0x098C, 0x2314,//

 0x0990, 0xFF1B,//

 0x098C, 0x2316,//

 0x0990, 0x0259,//

 0x098C, 0x2318,// 

 0x0990, 0x002B,//              

 0x098C, 0x231A,//

 0x0990, 0x0042,//      

 0x098C, 0x231C,//

 0x0990, 0x002D,//             

 0x098C, 0x231E,//

 0x0990, 0xFF32,//          

 0x098C, 0x2320,//

 0x0990, 0x0045,//   

 0x098C, 0x2322,//

 0x0990, 0x0034,//

 0x098C, 0x2324,//

 0x0990, 0xFF52,//            

 0x098C, 0x2326,//

 0x0990, 0x002A,//   

 0x098C, 0x2328,//

 0x0990, 0xFFF8,//

 0x098C, 0x232A,//

 0x0990, 0x0052,//   

 0x098C, 0x232C,//

 0x0990, 0xFF61,//  

 0x098C, 0x232E,//

 0x0990, 0x0008,//

 0x098C, 0x2330,//

 0x0990, 0xFFE7,// 

 0x098C, 0xA348,//

 0x0990, 0x0008,//

 0x098C, 0xA349,//

 0x0990, 0x0002,//

 0x098C, 0xA34A,//

 0x0990, 0x0059,//

 0x098C, 0xA34B,//

 0x0990, 0x00A6,//

 0x098C, 0xA34C,//

 0x0990, 0x0059,//

 0x098C, 0xA34D,//

 0x0990, 0x00a6,//

 0x098C, 0xA351,//

 0x0990, 0x0000,//

 0x098C, 0xA352,//

 0x0990, 0x007F,//

 0x098C, 0xA354,//

 0x0990, 0x0043,//

 0x098C, 0xA355,//

 0x0990, 0x0002,//

 0x098C, 0xA35D,//

 0x0990, 0x0078,//

 0x098C, 0xA35E,//

 0x0990, 0x0086,//

 0x098C, 0xA35F,//

 0x0990, 0x007E,//

 0x098C, 0xA360,//

 0x0990, 0x0082,//

 0x098C, 0xA365,//

 0x0990, 0x0010,//

	//[true gray] 

 0x098C, 0xA363,//

 0x0990, 0x00C7,//

 0x098C, 0xA364,//

 0x0990, 0x00F0,//

	//[K FACTOR]

 0x098C, 0xA366,//

 0x0990, 0x007D,//

 0x098C, 0xA367,//

 0x0990, 0x0080,//

 0x098C, 0xA368,//

 0x0990, 0x0080,//

 0x098C, 0xA369,//

 0x0990, 0x0080,//

 0x098C, 0xA36A,//

 0x0990, 0x0077,//

 0x098C, 0xA36B,//

 0x0990, 0x0078,//

	//lowlight bluish

 0x35A2, 0x00A4,//

 0x3240, 0xC802,//

	//[AFD]

	////Auto flicker detection

 0x098C, 0xA11E,//

 0x0990, 0x0001,//

 0x098C, 0xA404,//

 0x0990, 0x0000,//

	//[virtgain]

 0x098C, 0xA20C,//

 0x0990, 0x000C,//

 0x098C, 0x2212,//

 0x0990, 0x01A0,//

 0x098C, 0xA20D,//

 0x0990, 0x0017,//

 0x098C, 0xA20E,//

 0x0990, 0x0080,//

 0x098C, 0xA216,//

 0x0990, 0x0060,//

 0x098C, 0xA11D,//

 0x0990, 0x0002,//



	                                       

	                                       

	//[no gain up3]                        

 0x098C, 0xAB2C,//

 0x0990, 0x0006,//

 0x098C, 0xAB2D,//

 0x0990, 0x000e,//

 0x098C, 0xAB2E,//

 0x0990, 0x0006,//

 0x098C, 0xAB2F,//

 0x0990, 0x0006,//

 0x098C, 0xAB30,//

 0x0990, 0x001e,//

 0x098C, 0xAB31,//

 0x0990, 0x000e,//

 0x098C, 0xAB32,//

 0x0990, 0x001e,//

 0x098C, 0xAB33,//

 0x0990, 0x001e,//

 0x098C, 0xAB34,//

 0x0990, 0x0008,//

 0x098C, 0xAB35,//

 0x0990, 0x0080,//

	//[AE setting]	         

 0x098C, 0xA207,//	

 0x0990, 0x0004,//

 0x098C, 0xA24F,//	

 0x0990, 0x0036,//

 0x098C, 0x2257,//	

 0x0990, 0x2710,//

 0x098C, 0x2250,//	

 0x0990, 0x1B58,//

 0x098C, 0x2252,//	

 0x0990, 0x32C8,//

//[black gamma contrast]

 0x098C, 0x2B1B,// 	// MCU_ADDRESS [HG_BRIGHTNESSMETRIC]

 0x0990, 0x0643,// 	// MCU_DATA_0

 0x098C, 0xAB37,// 	// MCU_ADDRESS [HG_GAMMA_MORPH_CTRL]

 0x0990, 0x0003,// 	// MCU_DATA_0

 0x098C, 0x2B38,// 	// MCU_ADDRESS [HG_GAMMASTARTMORPH]

 0x0990, 0x2800,//	        // MCU_DATA_0

 0x098C, 0x2B3A,// 	// MCU_ADDRESS [HG_GAMMASTOPMORPH]

 0x0990, 0x46fe,// 	// MCU_DATA_0

//black 06

 0x098C, 0xAB3C,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_0]

 0x0990, 0x0000,// 	// MCU_DATA_0

 0x098C, 0xAB3D,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_1]

 0x0990, 0x0008,// 	// MCU_DATA_0

 0x098C, 0xAB3E,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_2]

 0x0990, 0x0019,// 	// MCU_DATA_0

 0x098C, 0xAB3F,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_3]

 0x0990, 0x0035,// 	// MCU_DATA_0

 0x098C, 0xAB40,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_4]

 0x0990, 0x0056,// 	// MCU_DATA_0

 0x098C, 0xAB41,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_5]

 0x0990, 0x006F,// 	// MCU_DATA_0

 0x098C, 0xAB42,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_6]

 0x0990, 0x0085,// 	// MCU_DATA_0

 0x098C, 0xAB43,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_7]

 0x0990, 0x0098,// 	// MCU_DATA_0

 0x098C, 0xAB44,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_8]

 0x0990, 0x00A7,// 	// MCU_DATA_0

 0x098C, 0xAB45,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_9]

 0x0990, 0x00B4,// 	// MCU_DATA_0

 0x098C, 0xAB46,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_10]

 0x0990, 0x00C0,// 	// MCU_DATA_0

 0x098C, 0xAB47,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_11]

 0x0990, 0x00CA,// 	// MCU_DATA_0

 0x098C, 0xAB48,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_12]

 0x0990, 0x00D4,// 	// MCU_DATA_0

 0x098C, 0xAB49,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_13]

 0x0990, 0x00DC,// 	// MCU_DATA_0

 0x098C, 0xAB4A,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_14]

 0x0990, 0x00E4,// 	// MCU_DATA_0

 0x098C, 0xAB4B,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_15]

 0x0990, 0x00EC,// 	// MCU_DATA_0

 0x098C, 0xAB4C,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_16]

 0x0990, 0x00F3,// 	// MCU_DATA_0

 0x098C, 0xAB4D,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_17]

 0x0990, 0x00F9,// 	// MCU_DATA_0

 0x098C, 0xAB4E,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_A_18]

 0x0990, 0x00FF,// 	// MCU_DATA_0

//Black 05 contrast 1.35

 0x098C, 0xAB4F,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_0]

 0x0990, 0x0000,// 	// MCU_DATA_0

 0x098C, 0xAB50,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_1]

 0x0990, 0x0006,// 	// MCU_DATA_0

 0x098C, 0xAB51,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_2]

 0x0990, 0x0012,// 	// MCU_DATA_0

 0x098C, 0xAB52,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_3]

 0x0990, 0x002F,// 	// MCU_DATA_0

 0x098C, 0xAB53,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_4]

 0x0990, 0x0053,// 	// MCU_DATA_0

 0x098C, 0xAB54,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_5]

 0x0990, 0x006D,// 	// MCU_DATA_0

 0x098C, 0xAB55,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_6]

 0x0990, 0x0083,// 	// MCU_DATA_0

 0x098C, 0xAB56,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_7]

 0x0990, 0x0096,// 	// MCU_DATA_0

 0x098C, 0xAB57,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_8]

 0x0990, 0x00A6,// 	// MCU_DATA_0

 0x098C, 0xAB58,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_9]

 0x0990, 0x00B3,// 	// MCU_DATA_0

 0x098C, 0xAB59,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_10]

 0x0990, 0x00BF,// 	// MCU_DATA_0

 0x098C, 0xAB5A,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_11]

 0x0990, 0x00CA,// 	// MCU_DATA_0

 0x098C, 0xAB5B,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_12]

 0x0990, 0x00D3,// 	// MCU_DATA_0

 0x098C, 0xAB5C,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_13]

 0x0990, 0x00DC,// 	// MCU_DATA_0

 0x098C, 0xAB5D,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_14]

 0x0990, 0x00E4,// 	// MCU_DATA_0

 0x098C, 0xAB5E,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_15]

 0x0990, 0x00EB,// 	// MCU_DATA_0

 0x098C, 0xAB5F,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_16]

 0x0990, 0x00F2,// 	// MCU_DATA_0

 0x098C, 0xAB60,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_17]

 0x0990, 0x00F9,// 	// MCU_DATA_0

 0x098C, 0xAB61,// 	// MCU_ADDRESS [HG_GAMMA_TABLE_B_18]

 0x0990, 0x00FF,// 	// MCU_DATA_0

//[LL-mode-modified]

 0x098C, 0xAB04,// 	// MCU_ADDRESS [HG_MAX_DLEVEL]

 0x0990, 0x0040,// 	// MCU_DATA_0

 0x098C, 0xAB06,// 	// MCU_ADDRESS [HG_PERCENT]

 0x0990, 0x0005,//		// 3, //0x000A 	// MCU_DATA_0

 0x098C, 0xAB08,// 	// MCU_ADDRESS [HG_DLEVEL]

 0x0990, 0x0010,// 	// MCU_DATA_0

 0x098C, 0xAB20,// 	// MCU_ADDRESS [HG_LL_SAT1]

 0x0990, 0x0050,//   //63, 	// MCU_DATA_0

 0x098C, 0xAB21,// 	// MCU_ADDRESS [RESERVED_HG_21]

 0x0990, 0x001d,// 	// MCU_DATA_0

 0x098C, 0xAB22,// 	// MCU_ADDRESS [RESERVED_HG_22]

 0x0990, 0x0007,// 	// MCU_DATA_0

 0x098C, 0xAB23,// 	// MCU_ADDRESS [RESERVED_HG_23]

 0x0990, 0x0004,// //0x000A 	// MCU_DATA_0

 0x098C, 0xAB24,// 	// MCU_ADDRESS [HG_LL_SAT2]

 0x0990, 0x0000,// 	// MCU_DATA_0

 0x098C, 0xAB25,// 	// MCU_ADDRESS [RESERVED_HG_25]

 0x0990, 0x00a0,//     //0x0014 	// MCU_DATA_0

 0x098C, 0xAB26,// 	// MCU_ADDRESS [RESERVED_HG_26]

 0x0990, 0x0005,// 	// MCU_DATA_0

 0x098C, 0xAB27,// 	// MCU_ADDRESS [RESERVED_HG_27]

 0x0990, 0x0010,// 	// MCU_DATA_0

 0x098C, 0x2B28,// 	// MCU_ADDRESS [HG_LL_BRIGHTNESSSTART]

 0x0990, 0x157c,// //0x0a00 //0x157c  //0x0A00 	// MCU_DATA_0

 0x098C, 0x2B2A,// 	// MCU_ADDRESS [HG_LL_BRIGHTNESSSTOP]

 0x0990, 0x37ef,//     //0x7000 	// MCU_DATA_0


	//enter refresh mode

 0x098C,0xA103 ,//

 0x0990,0x0006 ,//

//POLL_FIELD=SEQ_CMD, !=0, DELAY=10, TIMEOUT=50//delay=50

//DELAY=300
0xffff,300,


//DELAY=300

//	for(k = 0; k < MT9M113_WAIT_TIMES; k ++)

//	{
//		NvOdmImagerI2c16Write16(&pContext->I2c,0x098C,0xA103//

//		NvOdmImagerI2cRead16(&pContext->I2c,0x0990, &RegVAEC//

//		if(RegVAEC == 0x0000)	break;

//		//NvOdmOsWaitUS(10000//

//	}

 0x098C,0xA103 ,//

 0x0990,0x0005 ,//

//POLL_FIELD=SEQ_CMD, !=0, DELAY=10, TIMEOUT=50//delay=50

//	for(k = 0; k < MT9M113_WAIT_TIMES; k ++)

//	{

//	 0x098C,0xA103//

//		NvOdmImagerI2cRead16(&pContext->I2c, 0x0990, &RegVAEC//

//		if(RegVAEC == 0x0000)	break;

//		//NvOdmOsWaitUS(10000//

//	}

//

//#ifdef Debug_message_on	

//		LOGD("SensorInit End!\n"//

//#endif

//};



//[2. ?a AuE?A(A?AA)]

 0x098C, 0xA115, 	// MCU_ADDRESS [SEQ_CAP_MODE]

 0x0990, 0x0002, 	// MCU_DATA_0

 0x098C, 0xA103, 	// MCU_ADDRESS [SEQ_CMD]

 0x0990, 0x0002, 	// MCU_DATA_0

//	for(k = 0; k < MT9M113_WAIT_TIMES; k ++)

//	{

 0x098C,0xA103,//

//		NvOdmImagerI2cRead16(&pContext->I2c, 0x0990, &RegVAEC//

//		if(RegVAEC == 0x0000)	break;

//	}



//[capture_command]//return the preview after 3 full resolution.

 0x098C, 0xA115, 	// MCU_ADDRESS [SEQ_CAP_MODE]

 0x0990, 0x0000, 	// MCU_DATA_0

 0x098C, 0xA116, 	// MCU_ADDRESS [SEQ_CAP_NUMFRAMES]

 0x0990, 0x0003, 	// MCU_DATA_0

 0x098C, 0xA103, 	// MCU_ADDRESS [SEQ_CMD]

 0x0990, 0x0002, 	// MCU_DATA_0
};



unsigned short Viewfinder_ON[]={
//[Viewfinder ON]

 0x098C, 0xA115, 	// MCU_ADDRESS [SEQ_CAP_MODE]

 0x0990, 0x0000, 	// MCU_DATA_0

 0x098C, 0xA103, 	// MCU_ADDRESS [SEQ_CMD]

 0x0990, 0x0001, 	// MCU_DATA_0
};

unsigned short Viewfinder_OFF[]={

//[Viewfinder OFF]

 0x098C, 0xA115, 	// MCU_ADDRESS [SEQ_CAP_MODE]

 0x0990, 0x0002, 	// MCU_DATA_0

 0x098C, 0xA103, 	// MCU_ADDRESS [SEQ_CMD]

 0x0990, 0x0002, 	// MCU_DATA_0
};

unsigned short Refresh[]={

	//enter refresh mode

 0x098C,0xA103 ,//

 0x0990,0x0006 ,//

//POLL_FIELD=SEQ_CMD, !=0, DELAY=10, TIMEOUT=50//delay=50

//DELAY=300
0xffff,300,


//DELAY=300

//	for(k = 0; k < MT9M113_WAIT_TIMES; k ++)

//	{
//		NvOdmImagerI2c16Write16(&pContext->I2c,0x098C,0xA103//

//		NvOdmImagerI2cRead16(&pContext->I2c,0x0990, &RegVAEC//

//		if(RegVAEC == 0x0000)	break;

//		//NvOdmOsWaitUS(10000//

//	}

 0x098C,0xA103 ,//

 0x0990,0x0005 ,//

};
//crop size  ۰ų 

unsigned short set_resol_640x480[]={
	
 0x098C, 0x2703,// output a
 0x0990, 0x0280,////640 w
 0x098C, 0x2705,// output a
 0x0990, 0x01E0,//// 480 w

 0x098C, 0x2739,// crop x0 a
 0x0990, 0x0000,//
 0x098C, 0x273B,// crop x1 a
 0x0990, 0x027F,//
 0x098C, 0x273D,// crop y0 a
 0x0990, 0x0000,//
 0x098C, 0x273F,//crop y1 a
 0x0990, 0x01DF,//
};

unsigned short set_resol_1280x720[]={
	
 0x098C, 0x2703,// output a
 0x0990, 1280,//
 0x098C, 0x2705,// output a
 0x0990, 720,//

 0x098C, 0x2739,// crop x0 a
 0x0990, 0x0000,//
 0x098C, 0x273B,// crop x1 a
 0x0990, 1280-1,
 0x098C, 0x273D,// crop y0 a
 0x0990, 0x0000,//
 0x098C, 0x273F,//crop y1 a
 0x0990, 720-1,
};



#define MT9M113_INIT0	\
	(sizeof(mt9m113_init0) / sizeof(mt9m113_init0[0]))
#define MT9M113_Viewfinder_ON	\
	(sizeof(Viewfinder_ON) / sizeof(Viewfinder_ON[0]))
#define MT9M113_Viewfinder_OFF	\
	(sizeof(Viewfinder_OFF) / sizeof(Viewfinder_OFF[0]))

#define MT9M113_Refresh	\
	(sizeof(Refresh) / sizeof(Refresh[0]))
	
#define MT9M113_set_resol	\
	(sizeof(set_resol_640x480) / sizeof(set_resol_640x480[0]))

unsigned char mt9m113_init_reg1[][4] = {
	{0xFC, 0xFC, 0xD0, 0x00},

	/* === Analog/APS setting === */
	/* WRITE	D000F262	0000
	 * tgr_auto_exp (shutter off=0b shutter on=1b) */
	{0x00, 0x28, 0xD0, 0x00},

	/* 002A	F468 */
	/* 0F12	0006	 For avg mode */
	{0x00, 0x2A, 0xF4, 0x04},
	{0x0F, 0x12, 0x00, 0x2A},/* ADC SAT(450mV):  by Ana 090609 */
	{0x00, 0x2A, 0xF4, 0x6E},
	{0x0F, 0x12, 0x00, 0x02},/* CDS TEST [0]SR/SS EN: by Ana 090126 */
	/*  [1]S1 H, [2]LDB H, [3]clp H */
	/*  [4]S34 P X, [5]S24 N X */
	{0x00, 0x2A, 0xF4, 0x5A},
	{0x0F, 0x12, 0x00, 0x02},/*  LD LDB EN :  by Ana 090126 */
	{0x00, 0x2A, 0xF4, 0x0E},
	{0x0F, 0x12, 0x00, 0x04},/*  RMP REG 1.8V:  by Ana 090126 */
	{0x00, 0x2A, 0xF4, 0x0C},
	{0x0F, 0x12, 0x00, 0x20}, /*  rmp_option(RMP_INIT_DAC):
					*  by Ana 090126 */
	{0x00, 0x2A, 0xF4, 0x20},
	{0x0F, 0x12, 0x00, 0x76}, /* For SHBN 76 0075
		* COMP(CDS) bias [7:4] comp2, [3:0] comp1: by Ana 090126 */

	{0x0F, 0x12, 0x00, 0x05}, /*  pix current bias */

	{0x00, 0x2A, 0xF4, 0x26},
	{0x0F, 0x12, 0x00, 0xD4}, /*  CLP level */
	{0x00, 0x2A, 0xF4, 0x60},
	{0x0F, 0x12, 0x00, 0x01}, /*  CLP on:  by Ana 090126 */

	{0x00, 0x2A, 0xE3, 0x04},
	{0x0F, 0x12, 0x00, 0x81}, /*  ADC OFFSET 128:  by Ana 090126 */
	{0x00, 0x2A, 0xE3, 0x08},
	{0x0F, 0x12, 0x00, 0x81}, /*  ADC DEFAULT 128:  by Ana 090209 */

	/*  ADLC */
	{0x00, 0x2A, 0xE5, 0x06},
	{0x0F, 0x12, 0x00, 0x93}, /*  ADLC [7]FL,[6:5]FM,: by Ana 090126 */
	/*  [4]F,[3:2]LM,[1]L,[0]CH */
	{0x00, 0x2A, 0xE4, 0x02},
	{0x0F, 0x12, 0x04, 0x0C}, /*  ADLC BPR EN[10], th 12: by Ana 090126 */
	/* WRITE D000E510 3804  adlc_frame_filter_co_reg[B][A] */

	{0x00, 0x2A, 0xF4, 0x2A},
	{0x0F, 0x12, 0x00, 0x80}, /*  ALL TX mode enable(ref_option[7]):
			*  by Ana 090130 */

	{0x00, 0x2A, 0xF4, 0x08},
	{0x0F, 0x12, 0x00, 0x0E}, /* aig_sig_mx:  by Ana 090209 */
	{0x0F, 0x12, 0x00, 0x07}, /* aig_rst_mx:  by Ana 090209 */
	{0x00, 0x2A, 0xF4, 0x00},
	{0x0F, 0x12, 0x00, 0x07}, /* 0007 aig_off_rst1: for 92MHZ HS (full) */
				/* 0006	aig_off_rst1:
				 * for 92MHz LS(full & avg)/ 46MHz LS(full) */
				/*  0005 aig_off_rst1: for 46MHz LS(avg) */
				/*  0004 aig_off_rst1: for 46MHz HS (full) */

	/*  Doubler	 */
	{0x00, 0x2A, 0xF4, 0x3C},
	{0x0F, 0x12, 0x00, 0x01}, /*  aig_pd_inrush_ctrl: by Ana 090126 */
	{0x00, 0x2A, 0xF4, 0x40},
	{0x0F, 0x12, 0x00, 0x44}, /* aig_rosc_tune_ncp[7:4],
				* aig_rosc_tune_cp[3:0]: by Ana 090126 */
	{0x00, 0x2A, 0xF4, 0x44},
	{0x0F, 0x12, 0x00, 0x08}, /*  aig_reg_tune_pix */
	{0x00, 0x2A, 0xF4, 0x48},
	{0x0F, 0x12, 0x00, 0x08}, /*  aig_reg_tune_ntg */

	{0x00, 0x2A, 0xF4, 0x5C},
	{0x0F, 0x12, 0x00, 0x01}, /*  aig_dshut_en */

	/* Multiple Sampling */
	{0x00, 0x2A, 0xF4, 0x06},
	{0x0F, 0x12, 0x00, 0x01}, /*  MS[2:0], No Multiple Sampling @92MHz,
				* :  by Ana 090130 */
	/*  1b' 2 times multiple sampling(0001h) for 46MHz or LS@92MHz */
	{0x00, 0x2A, 0xF4, 0x10},
	{0x0F, 0x12, 0x00, 0x00}, /*  MSOFF_EN=0 : no Multiple sampling
				* if gain < 2 :  by Ana 090609 */
	/* === APS Timing === */
	{0x00, 0x28, 0xD0, 0x00},
	{0x00, 0x2A, 0xF4, 0x72},
	{0x0F, 0x12, 0x00, 0x5C}, /* For 92MHz LS & HS aig_dstx_width(1us@92MHz)
				* :  by Ana 090216  */
				/* 002E	aig_dstx_width(1us@46MHz)
				 * :  by Ana 090216 */

	/* For 46MHz 7.5fps */
	/* 002A	F476 */
	/* 0F12	0045	aig_stx_width(1.5us@46MHz):  by Ana 090216 */

	{0x00, 0x28, 0xD0, 0x00},
	{0x00, 0x2A, 0xF4, 0x70},
	{0x0F, 0x12, 0x00, 0x04},

	/* == CDS Timing == */
	/*  Rom retreive address was changed from 0x70003880 to 0x7000 3C00. */
	/* 2009.03.16 */

	{0x00, 0x28, 0x70, 0x00},
	/* value       register		decription.   */
	/* 700017CC    senHal_ContPtrs_senModesDataArr[0]
		* nomal speed, normal */

	/* 700017D0    senHal_ContPtrs_senModesDataArr[1]
		* nomal speed, avg mode */
	/* 700017D4    senHal_ContPtrs_senModesDataArr[2]
		* nomal speed, weighted mode */
	/* 700017D8    senHal_ContPtrs_senHighSpeedModesDataArr[0]
		* high speed, normal        */
	/* 700017DC    senHal_ContPtrs_senHighSpeedModesDataArr[1]
		 * high speed, avg mode    */
	/* 700017E0    senHal_ContPtrs_senHighSpeedModesDataArr[2]
		* high speed, weighted mode   */

	/* HS_Normal         */
	{0x00, 0x2A, 0x17, 0xD8}, /*  High speed Normal/Dig-subsampling */
	{0x0F, 0x12, 0x3C, 0x00}, /*  senHal_ContPtrs_senModesDataArr */
	{0x0F, 0x12, 0x70, 0x00}, /*  senHal_ContPtrs_senModesDataArr */

	/* 1.15fps@92MHz,HS,Normal 2.15fps@92MHz,LS,Normal  */
	/* 3.15fps@92MHz,HS,avg    4.15fps@92MHz,LS,avg    */

	/* 1. */
	{0x00, 0x2A, 0x3C, 0x00},	/* 1.    2.    3.    4.   */
	{0x0F, 0x12, 0x00, 0x03},	/* 0003  0003  0003  0003 */
	{0x0F, 0x12, 0x05, 0xBA},	/* 05BA  098A  081E  0B92 */
	{0x0F, 0x12, 0x00, 0x01},	/* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x05, 0xBC},	/* 05BC  098C  0414  05CE */
	{0x0F, 0x12, 0x00, 0x01},	/* 0001  0001  040F  05C9 */
	{0x0F, 0x12, 0x05, 0xBC},	/* 05BC  098C  0820  0B94 */
	{0x0F, 0x12, 0x00, 0x14},	/* 0014  0014  0014  0014 */
	{0x0F, 0x12, 0x05, 0xBC},	/* 05BC  098C  040F  05C9 */
	{0x0F, 0x12, 0x00, 0x14},	/* 0014  0014  0422  05DC */
	{0x0F, 0x12, 0x05, 0xBC},	/* 05BC  098C  0820  0B94 */
	{0x0F, 0x12, 0x01, 0xAE},	/* 01AE  0286  0146  01B6 */
	{0x0F, 0x12, 0x02, 0x38},	/* 0238  0310  01D0  0240 */
	{0x0F, 0x12, 0x01, 0xAE},	/* 01AE  0286  0554  077E */
	{0x0F, 0x12, 0x02, 0x38},	/* 0238  0310  05DE  0808 */
	{0x0F, 0x12, 0x02, 0x38},	  /* 0238  0310  01D0  0240 */
	{0x0F, 0x12, 0x05, 0xBA},	  /* 05BA  098A  0410  05CA */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  05DE  0808 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  081E  0B92 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x01, 0xAC},	  /* 01AC  0284  0144  01B4 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0414  05CE */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0552  077C */
	{0x0F, 0x12, 0x01, 0xAC},	  /* 01AC  0284  0144  01B4 */
	{0x0F, 0x12, 0x02, 0x40},	  /* 0240  0318  01D8  0248 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0552  077C */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  05E6  0810 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x00, 0x8C},	  /* 008C  008C  008C  008C */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  040F  05C9 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  049A  0654 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x00, 0x9E},	  /* 009E  009E  009E  009E */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  040F  05C9 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  04AC  0666 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x01, 0xAC},	  /* 01AC  0284  0144  01B4 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  040F  05C9 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0552  077C */
	{0x0F, 0x12, 0x00, 0xA6},	  /* 00A6  00A6  00A6  00A6 */
	{0x0F, 0x12, 0x05, 0xBA},	  /* 05BA  098A  0410  05CA */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  04B4  066E */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  081E  0B92 */
	{0x0F, 0x12, 0x02, 0x92},	  /* 0292  036A  022A  029A */
	{0x0F, 0x12, 0x05, 0xBA},	  /* 05BA  098A  0410  05CA */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0638  0862 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  081E  0B92 */
	{0x0F, 0x12, 0x00, 0xD8},	  /* 00D8  00D8  00D8  00D8 */
	{0x0F, 0x12, 0x01, 0xA8},	  /* 01A8  0278  0140  01A8 */
	{0x0F, 0x12, 0x02, 0xC4},	  /* 02C4  039C  0292  02CC */
	{0x0F, 0x12, 0x05, 0xB4},	  /* 05B4  097C  040A  05BC */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  04E6  06A0 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  054E  0770 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  06A0  0894 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0818  0B84 */
	{0x0F, 0x12, 0x01, 0xAA},	  /* 01AA  0282  0142  01B2 */
	{0x0F, 0x12, 0x01, 0xD6},	  /* 01D6  02AE  016E  01DE */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  040C  05C6 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0438  05F2 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0550  077A */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  057C  07A6 */
	{0x0F, 0x12, 0x01, 0xBB},	  /* 01BB  0293  014D  01BD */
	{0x0F, 0x12, 0x01, 0xEF},	  /* 01EF  02C7  0182  01F2 */
	{0x0F, 0x12, 0x01, 0xF9},	  /* 01F9  02D1  018C  01FC */
	{0x0F, 0x12, 0x02, 0x03},	  /* 0203  02DB  0196  0206 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0417  05D1 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  044C  0606 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0456  0610 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0460  061A */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  055B  0785 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0590  07BA */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  059A  07C4 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  05A4  07CE */
	{0x0F, 0x12, 0x01, 0xCC},	  /* 01CC  02A4  0158  01C8 */
	{0x0F, 0x12, 0x01, 0xEF},	  /* 01EF  02C7  0182  01F2 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0422  05DC */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  044C  0606 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0566  0790 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0590  07BA */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x00, 0x0D},	  /* 000D  000D  000D  000D */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x00, 0x0D},	  /* 000D  000D  000D  000D */
	{0x0F, 0x12, 0x01, 0xAE},	  /* 01AE  0286  0146  01B6 */
	{0x0F, 0x12, 0x01, 0xB6},	  /* 01B6  028E  014E  01BE */
	{0x0F, 0x12, 0x05, 0xBA},	  /* 05BA  098A  0410  05CA */
	{0x0F, 0x12, 0x05, 0xC6},	  /* 05C6  0996  0418  05D2 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0554  077E */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  055C  0786 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  081E  0B92 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  082A  0B9E */
	{0x0F, 0x12, 0x00, 0xD4},	  /* 00D4  00D4  00D4  00D4 */
	{0x0F, 0x12, 0x01, 0xAC},	  /* 01AC  0284  0144  01B4 */
	{0x0F, 0x12, 0x02, 0xC0},	  /* 02C0  0398  028E  02C8 */
	{0x0F, 0x12, 0x05, 0xB8},	  /* 05B8  0988  040E  05C8 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  04E2  069C */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0552  077C */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  069C  0890 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  081C  0B90 */
	{0x0F, 0x12, 0x01, 0xAE},	  /* 01AE  0286  0146  01B6 */
	{0x0F, 0x12, 0x05, 0xC9},	  /* 05C9  0A7C  0410  05CA */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0554  077E */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0830  0BA4 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */

	/* HS_avg */
	{0x00, 0x2A, 0x17, 0xDC}, /*  High speed Normal/Dig-subsampling */
	{0x0F, 0x12, 0x3C, 0xE0}, /*  senHal_ContPtrs_senModesDataArr */
	{0x0F, 0x12, 0x70, 0x00}, /*  senHal_ContPtrs_senModesDataArr */

	/* 1.15fps@92MHz,HS,Normal 2.15fps@92MHz,LS,Normal  */
	/* 3.15fps@92MHz,HS,avg    4.15fps@92MHz,LS,avg    */

	/* 1. */
	{0x00, 0x2A, 0x3C, 0xE0}, /* 1.    2.    3.    4.   */
	{0x0F, 0x12, 0x00, 0x03}, /* 0003  0003  0003  0003 */
	{0x0F, 0x12, 0x08, 0x1E},	  /* 05BA  098A  081E  0B92 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x04, 0x14},	  /* 05BC  098C  0414  05CE */
	{0x0F, 0x12, 0x04, 0x0F},	  /* 0001  0001  040F  05C9 */
	{0x0F, 0x12, 0x08, 0x20},	  /* 05BC  098C  0820  0B94 */
	{0x0F, 0x12, 0x00, 0x14},	  /* 0014  0014  0014  0014 */
	{0x0F, 0x12, 0x04, 0x0F},	  /* 05BC  098C  040F  05C9 */
	{0x0F, 0x12, 0x04, 0x22},	  /* 0014  0014  0422  05DC */
	{0x0F, 0x12, 0x08, 0x20},	  /* 05BC  098C  0820  0B94 */
	{0x0F, 0x12, 0x01, 0x46},	  /* 01AE  0286  0146  01B6 */
	{0x0F, 0x12, 0x01, 0xD0},	  /* 0238  0310  01D0  0240 */
	{0x0F, 0x12, 0x05, 0x54},	  /* 01AE  0286  0554  077E */
	{0x0F, 0x12, 0x05, 0xDE},	  /* 0238  0310  05DE  0808 */
	{0x0F, 0x12, 0x01, 0xD0},	  /* 0238  0310  01D0  0240 */
	{0x0F, 0x12, 0x04, 0x10},	  /* 05BA  098A  0410  05CA */
	{0x0F, 0x12, 0x05, 0xDE},	  /* 0000  0000  05DE  0808 */
	{0x0F, 0x12, 0x08, 0x1E},	  /* 0000  0000  081E  0B92 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x01, 0x44},	  /* 01AC  0284  0144  01B4 */
	{0x0F, 0x12, 0x04, 0x14},	  /* 0000  0000  0414  05CE */
	{0x0F, 0x12, 0x05, 0x52},	  /* 0000  0000  0552  077C */
	{0x0F, 0x12, 0x01, 0x44},	  /* 01AC  0284  0144  01B4 */
	{0x0F, 0x12, 0x01, 0xD8},	  /* 0240  0318  01D8  0248 */
	{0x0F, 0x12, 0x05, 0x52},	  /* 0000  0000  0552  077C */
	{0x0F, 0x12, 0x05, 0xE6},	  /* 0000  0000  05E6  0810 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x00, 0x8C},	  /* 008C  008C  008C  008C */
	{0x0F, 0x12, 0x04, 0x0F},	  /* 0000  0000  040F  05C9 */
	{0x0F, 0x12, 0x04, 0x9A},	  /* 0000  0000  049A  0654 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x00, 0x9E},	  /* 009E  009E  009E  009E */
	{0x0F, 0x12, 0x04, 0x0F},	  /* 0000  0000  040F  05C9 */
	{0x0F, 0x12, 0x04, 0xAC},	  /* 0000  0000  04AC  0666 */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x01, 0x44},	  /* 01AC  0284  0144  01B4 */
	{0x0F, 0x12, 0x04, 0x0F},	  /* 0000  0000  040F  05C9 */
	{0x0F, 0x12, 0x05, 0x52},	  /* 0000  0000  0552  077C */
	{0x0F, 0x12, 0x00, 0xA6},	  /* 00A6  00A6  00A6  00A6 */
	{0x0F, 0x12, 0x04, 0x10},	  /* 05BA  098A  0410  05CA */
	{0x0F, 0x12, 0x04, 0xB4},	  /* 0000  0000  04B4  066E */
	{0x0F, 0x12, 0x08, 0x1E},	  /* 0000  0000  081E  0B92 */
	{0x0F, 0x12, 0x02, 0x2A},	  /* 0292  036A  022A  029A */
	{0x0F, 0x12, 0x04, 0x10},	  /* 05BA  098A  0410  05CA */
	{0x0F, 0x12, 0x06, 0x38},	  /* 0000  0000  0638  0862 */
	{0x0F, 0x12, 0x08, 0x1E},	  /* 0000  0000  081E  0B92 */
	{0x0F, 0x12, 0x00, 0xD8},	  /* 00D8  00D8  00D8  00D8 */
	{0x0F, 0x12, 0x01, 0x40},	  /* 01A8  0278  0140  01A8 */
	{0x0F, 0x12, 0x02, 0x92},	  /* 02C4  039C  0292  02CC */
	{0x0F, 0x12, 0x04, 0x0A},	  /* 05B4  097C  040A  05BC */
	{0x0F, 0x12, 0x04, 0xE6},	  /* 0000  0000  04E6  06A0 */
	{0x0F, 0x12, 0x05, 0x4E},	  /* 0000  0000  054E  0770 */
	{0x0F, 0x12, 0x06, 0xA0},	  /* 0000  0000  06A0  0894 */
	{0x0F, 0x12, 0x08, 0x18},	  /* 0000  0000  0818  0B84 */
	{0x0F, 0x12, 0x01, 0x42},	  /* 01AA  0282  0142  01B2 */
	{0x0F, 0x12, 0x01, 0x6E},	  /* 01D6  02AE  016E  01DE */
	{0x0F, 0x12, 0x04, 0x0C},	  /* 0000  0000  040C  05C6 */
	{0x0F, 0x12, 0x04, 0x38},	  /* 0000  0000  0438  05F2 */
	{0x0F, 0x12, 0x05, 0x50},	  /* 0000  0000  0550  077A */
	{0x0F, 0x12, 0x05, 0x7C},	  /* 0000  0000  057C  07A6 */
	{0x0F, 0x12, 0x01, 0x4D},	  /* 01BB  0293  014D  01BD */
	{0x0F, 0x12, 0x01, 0x82},	  /* 01EF  02C7  0182  01F2 */
	{0x0F, 0x12, 0x01, 0x8C},	  /* 01F9  02D1  018C  01FC */
	{0x0F, 0x12, 0x01, 0x96},	  /* 0203  02DB  0196  0206 */
	{0x0F, 0x12, 0x04, 0x17},	  /* 0000  0000  0417  05D1 */
	{0x0F, 0x12, 0x04, 0x4C},	  /* 0000  0000  044C  0606 */
	{0x0F, 0x12, 0x04, 0x56},	  /* 0000  0000  0456  0610 */
	{0x0F, 0x12, 0x04, 0x60},	  /* 0000  0000  0460  061A */
	{0x0F, 0x12, 0x05, 0x5B},	  /* 0000  0000  055B  0785 */
	{0x0F, 0x12, 0x05, 0x90},	  /* 0000  0000  0590  07BA */
	{0x0F, 0x12, 0x05, 0x9A},	  /* 0000  0000  059A  07C4 */
	{0x0F, 0x12, 0x05, 0xA4},	  /* 0000  0000  05A4  07CE */
	{0x0F, 0x12, 0x01, 0x58},	  /* 01CC  02A4  0158  01C8 */
	{0x0F, 0x12, 0x01, 0x82},	  /* 01EF  02C7  0182  01F2 */
	{0x0F, 0x12, 0x04, 0x22},	  /* 0000  0000  0422  05DC */
	{0x0F, 0x12, 0x04, 0x4C},	  /* 0000  0000  044C  0606 */
	{0x0F, 0x12, 0x05, 0x66},	  /* 0000  0000  0566  0790 */
	{0x0F, 0x12, 0x05, 0x90},	  /* 0000  0000  0590  07BA */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x00, 0x0D},	  /* 000D  000D  000D  000D */
	{0x0F, 0x12, 0x00, 0x01},	  /* 0001  0001  0001  0001 */
	{0x0F, 0x12, 0x00, 0x0D},	  /* 000D  000D  000D  000D */
	{0x0F, 0x12, 0x01, 0x46},	  /* 01AE  0286  0146  01B6 */
	{0x0F, 0x12, 0x01, 0x4E},	  /* 01B6  028E  014E  01BE */
	{0x0F, 0x12, 0x04, 0x10},	  /* 05BA  098A  0410  05CA */
	{0x0F, 0x12, 0x04, 0x18},	  /* 05C6  0996  0418  05D2 */
	{0x0F, 0x12, 0x05, 0x54},	  /* 0000  0000  0554  077E */
	{0x0F, 0x12, 0x05, 0x5C},	  /* 0000  0000  055C  0786 */
	{0x0F, 0x12, 0x08, 0x1E},	  /* 0000  0000  081E  0B92 */
	{0x0F, 0x12, 0x08, 0x2A},	  /* 0000  0000  082A  0B9E */
	{0x0F, 0x12, 0x00, 0xD4},	  /* 00D4  00D4  00D4  00D4 */
	{0x0F, 0x12, 0x01, 0x44},	  /* 01AC  0284  0144  01B4 */
	{0x0F, 0x12, 0x02, 0x8E},	  /* 02C0  0398  028E  02C8 */
	{0x0F, 0x12, 0x04, 0x0E},	  /* 05B8  0988  040E  05C8 */
	{0x0F, 0x12, 0x04, 0xE2},	  /* 0000  0000  04E2  069C */
	{0x0F, 0x12, 0x05, 0x52},	  /* 0000  0000  0552  077C */
	{0x0F, 0x12, 0x06, 0x9C},	  /* 0000  0000  069C  0890 */
	{0x0F, 0x12, 0x08, 0x1C},	  /* 0000  0000  081C  0B90 */
	{0x0F, 0x12, 0x01, 0x46},	  /* 01AE  0286  0146  01B6 */
	{0x0F, 0x12, 0x04, 0x10},	  /* 05C9  0A7C  0410  05CA */
	{0x0F, 0x12, 0x05, 0x54},	  /* 0000  0000  0554  077E */
	{0x0F, 0x12, 0x08, 0x30},	  /* 0000  0000  0830  0BA4 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */
	{0x0F, 0x12, 0x00, 0x00},	  /* 0000  0000  0000  0000 */

	{REG_DELAY, 100, 0, 0}, /*  p100 */

	/* Current(00:2mA,01:4mA,10:6mA,11:8mA) */
	{0x00, 0x28, 0xD0, 0x00},
	{0x00, 0x2A, 0x10, 0x82},
	{0x0F, 0x12, 0x01, 0x55}, /* FFFF	D0_D4_cs12 [11:0] */
	{0x0F, 0x12, 0x01, 0x55}, /* FFFF	D0_D4_cs12 [11:0] */
	{0x00, 0x2A, 0x10, 0x88},
	{0x0F, 0x12, 0x05, 0x55}, /* 05CF	0555 Sda_cd10	Scl_cd10
		PCLK_cd10	Reserved	Vsync_cd10	Hsync_cd10 */

	{REG_DELAY, 100, 0, 0}, /*  p100 */

	/*  End Analog script */

	/*  */
	/*  Start Tuning param for EVT1 */
	/*  */

	/* / AF Setting Start */
	/*  AF Interface Settings */
	{0x00, 0x28, 0x70, 0x00},
	{0x00, 0x2A, 0x02, 0x3E},
	{0x0F, 0x12, 0x00, 0x03}, /*  AFModeType - 0:NONE, 2:VCM_PWM,
				* 3:VCM_I2C */
	{0x00, 0x2A, 0x02, 0x3C},
	{0x0F, 0x12, 0x00, 0x00}, /*  No Led Gpio */
	{0x00, 0x2A, 0x02, 0x40},
	{0x0F, 0x12, 0x00, 0x00}, /*  No PWM */
	{0x00, 0x2A, 0x02, 0x42},
	{0x0F, 0x12, 0x00, 0x00},
	{0x00, 0x2A, 0x02, 0x44},
	{0x0F, 0x12, 0x00, 0x31}, /*  No GPIO Port,
				31	 Use GPIO3 for Enable Port */
	{0x00, 0x2A, 0x02, 0x46},
	{0x0F, 0x12, 0x00, 0x00},
	{0x00, 0x2A, 0x02, 0x4C},
	{0x0F, 0x12, 0x20, 0x0C}, /*  Use GPIO1 for SCL, GPIO2 for SDA */
	{0x00, 0x2A, 0x02, 0x4E},
	{0x0F, 0x12, 0x03, 0x20}, /* 0C0 0190	0320	 MI2C Speed : 400KHz */

	/*  AF Window Settings */
	{0x00, 0x2A, 0x02, 0xC6},
	{0x0F, 0x12, 0x01, 0x00},
	{0x00, 0x2A, 0x02, 0xC8},
	{0x0F, 0x12, 0x00, 0xE3},
	{0x00, 0x2A, 0x02, 0xCA},
	{0x0F, 0x12, 0x02, 0x00},
	{0x00, 0x2A, 0x02, 0xCC},
	{0x0F, 0x12, 0x02, 0x38},
	{0x00, 0x2A, 0x02, 0xCE},
	{0x0F, 0x12, 0x01, 0x8C},
	{0x00, 0x2A, 0x02, 0xD0},
	{0x0F, 0x12, 0x01, 0x66},
	{0x00, 0x2A, 0x02, 0xD2},
	{0x0F, 0x12, 0x00, 0xE6},
	{0x00, 0x2A, 0x02, 0xD4},
	{0x0F, 0x12, 0x01, 0x32},
	{0x00, 0x2A, 0x02, 0xD6},
	{0x0F, 0x12, 0x00, 0x01},

	/*  AF Setot Settings */
	{0x00, 0x2A, 0x06, 0xBE},
	{0x0F, 0x12, 0x00, 0xFF},

	/*  AF Scene Settings */
	{0x00, 0x2A, 0x15, 0xDA},
	{0x0F, 0x12, 0x00, 0x03},

	/*  AF Fine Search Settings */
	{0x00, 0x2A, 0x15, 0x50},
	{0x0F, 0x12, 0x10, 0x02},
	{0x00, 0x2A, 0x15, 0x5A},
	{0x0F, 0x12, 0x00, 0x04},
	{0x00, 0x2A, 0x14, 0xE8},
	{0x0F, 0x12, 0x03, 0x02},


	/*  AF Lens Position Table Settings */
	{0x00, 0x2A, 0x14, 0xF0},
	{0x0F, 0x12, 0x00, 0x11}, /*  18 Steps	 */
	{0x0f, 0x12, 0x00, 0x36}, /*  af_pos_usTable */
	{0x0F, 0x12, 0x00, 0x3D},
	{0x0F, 0x12, 0x00, 0x44},
	{0x0F, 0x12, 0x00, 0x4B},
	{0x0F, 0x12, 0x00, 0x52},
	{0x0F, 0x12, 0x00, 0x59},
	{0x0F, 0x12, 0x00, 0x60},
	{0x0F, 0x12, 0x00, 0x67},
	{0x0F, 0x12, 0x00, 0x6E},
	{0x0F, 0x12, 0x00, 0x75},
	{0x0F, 0x12, 0x00, 0x7C},
	{0x0F, 0x12, 0x00, 0x83},
	{0x0F, 0x12, 0x00, 0x8A},
	{0x0F, 0x12, 0x00, 0x91},
	{0x0F, 0x12, 0x00, 0x98},
	{0x0F, 0x12, 0x00, 0x9F},
	{0x0F, 0x12, 0x00, 0xA6},
	{0x0F, 0x12, 0x00, 0xAD},

	/*  AF Macro Position Setting */
	{0x00, 0x2A, 0x14, 0xE2},
	{0x0F, 0x12, 0x11, 0x04},

	/* / AF Setting End */

	/* /Jpeg/ */
	{0x00, 0x2A, 0x16, 0x90},
	{0x0F, 0x12, 0x01, 0x8E}, /* jpeg_BrcMaxQuality */
	{0x00, 0x2A, 0x16, 0xD6},
	{0x0F, 0x12, 0x00, 0x01}, /* jpeg_MinQtblValue */
	{0x00, 0x2A, 0x04, 0xC0},
	{0x0F, 0x12, 0x00, 0x5D}, /* 005F 005D
				* 4EA_REG_TC_BRC_usCaptureQuality(4~99_dec) */

};

unsigned short mt9m113_init_reg2[][2] = {
	/* clk Settings */
	{0x002A, MT9M113_REG_TC_IPRM_InClockLSBs}, /* input=24MHz */
	{0x0F12, 0xBB80}, /*  input=48MHz : source clk is mpll */
	{0x002A, MT9M113_REG_TC_IPRM_InClockMSBs},
	{0x0F12, 0x0000},
	{0x002A, MT9M113_REG_TC_IPRM_UseNPviClocks}, /* 0 PVI configurations */
	{0x0F12, 0x0000},
	{0x002A, MT9M113_REG_TC_IPRM_UseNMipiClocks}, /* 1 MIPI configurations */
	{0x0F12, 0x0001},
	{0x002A, MT9M113_REG_TC_IPRM_NumberOfMipiLanes}, /*  Num of lane MIPI  */
	{0x0F12, 2},
	{0x002A, MT9M113_REG_TC_IPRM_OpClk4KHz_0}, /*  1st system CLK 92MHz
						* for parallel */
	{0x0F12, MT9M1134Khz_92Mhz}, /*  2CEC */
	{0x002A, MT9M113_REG_TC_IPRM_MinOutRate4KHz_0},	/* Pclk : 92Mhz */
	{0x0F12, MT9M113_PCLK_MIN},
	{0x002A, MT9M113_REG_TC_IPRM_MaxOutRate4KHz_0},
	{0x0F12, MT9M113_PCLK_MAX},
	{0x002A, MT9M113_REG_TC_IPRM_InitParamsUpdated},
	{0x0F12, 0x0001},
	{REG_DELAY, 100}, /*  p100 */
};

unsigned char mt9m113_init_reg3[][4] = {
	/* AE Setting */
	{0x00, 0x2A, 0x13, 0xC8},
	{0x0F, 0x12, 0x00, 0x30}, /* 3C	002D 003C 003A 0030 003A 0038 003C 0035
				TVAR_ae_BrAve	  AE target	 */
	{0x00, 0x2A, 0x13, 0xCE},
	{0x0F, 0x12, 0x00, 0x0F}, /* 0011  ae_StatMode */
	{0x00, 0x2A, 0x05, 0x90},
	{0x0F, 0x12, 0x35, 0x20}, /* lt_uMaxExp1 (x4 8000/ 80ms) */
	{0x0F, 0x12, 0x00, 0x00},
	{0x00, 0x2A, 0x05, 0x94},
	{0x0F, 0x12, 0xC3, 0x50},
	{0x0F, 0x12, 0x00, 0x00}, /* lt_uMaxExp2 (x4 25000/ 250ms) */
	{0x00, 0x2A, 0x05, 0x98},
	{0x0F, 0x12, 0x35, 0x20},
	{0x0F, 0x12, 0x00, 0x00}, /* lt_uCapMaxExp1 (x4 8000/ 80ms) */
	{0x00, 0x2A, 0x05, 0x9C},
	{0x0F, 0x12, 0xC3, 0x50}, /* C350	86A0	 */
	{0x0F, 0x12, 0x00, 0x00}, /* lt_uCapMaxExp2 (x4 25000/ 250ms) */
	{0x00, 0x2A, 0x05, 0xA0},
	{0x0F, 0x12, 0x04, 0x70}, /* (1/12) 0350 (1/8) 0200 lt_uMaxAnGain1 */
	{0x00, 0x2A, 0x05, 0xA2},
	{0x0F, 0x12, 0x10, 0x00}, /* lt_uMaxAnGain2 */
	{0x00, 0x2A, 0x05, 0xA4},
	{0x0F, 0x12, 0x01, 0x00},
	{0x00, 0x2A, 0x05, 0xA6},
	{0x0F, 0x12, 0x10, 0x00}, /* lt_uMaxTotGain (Limit Gain) */

	{0x00, 0x2A, 0x05, 0x74},
	{0x0F, 0x12, 0x01, 0x11}, /* lt_uLimitHigh */
	{0x00, 0x2A, 0x05, 0x76},
	{0x0F, 0x12, 0x00, 0xEF}, /* lt_uLimitLow */
};

unsigned short mt9m113_init_reg4[][2] = {
	/* / */
	/* PREVIEW CONFIGURATION 0 (FullHD, YUV, 20fps) */
	{0x002A, MT9M113_REG_0TC_PCFG_usWidth},
	{0x0F12, 1920},	/* 1920 */
	{0x0F12, 1080}, /* 1080 */
	{0x002A, 0x02E6},
};

unsigned char mt9m113_init_reg5[][4] = {
	{0x0F, 0x12, 0x00, 0x05}, /* YUV */
	{0x00, 0x2A, 0x02, 0xF8}, /* PLL config */
	{0x0F, 0x12, 0x00, 0x00},
	{0x00, 0x2A, 0x02, 0xE8}, /* PCLK max */
};

unsigned char mt9m113_init_jpeg[][4] = {
	{0x0F, 0x12, 0x00, 0x09},	/* YUV */
	{0x00, 0x2A, 0x02, 0xF8},	/* PLL config */
	{0x0F, 0x12, 0x00, 0x00},
	{0x00, 0x2A, 0x02, 0xE8},	/* PCLK max */
};

unsigned short mt9m113_init_reg6[][2] = {
	{0x0F12, MT9M113_PCLK_MAX},
};

unsigned char mt9m113_init_reg7[][4] = {
	{0x00, 0x2A, 0x02, 0xEA}, /* PCLK min */
};

unsigned short mt9m113_init_reg8[][2] = {
	{0x0F12, MT9M113_PCLK_MIN},
};

unsigned char mt9m113_init_reg9[][4] = {
	{0x00, 0x2A, 0x02, 0xF0}, /*  KJ_090802 : Non-continuous clock */
	{0x0F, 0x12, 0x00, 0x12}, /*  [4]UY0VY1	0002 */
	{0x00, 0x2A, 0x02, 0xFC}, /*  1b: FR (bin) 2b: Quality (no-bin) */
	{0x0F, 0x12, 0x00, 0x00},
	{0x00, 0x2A, 0x02, 0xFA},
	{0x0F, 0x12, 0x00, 0x02},
	{0x00, 0x2A, 0x02, 0xFE}, /* max frame time  */
	{0x0F, 0x12, 0x05, 0x35},/*  7.5fps */
	{0x00, 0x2A, 0x03, 0x00},
	{0x0F, 0x12, 0x00, 0x00},

	{REG_DELAY, 100, 0, 0}, /*  p100 */

	/* 002A	17A0 */
	/* 0F12	0000 [0]:dig [1]:avg */
	/* 002A	17A2 1/2 sub-sampling */
	/* 0F12	0002 */
	{0x00, 0x2A, 0x05, 0x40}, /*  use high speed analog */
	{0x0F, 0x12, 0x00, 0x01},
	{0x00, 0x2A, 0x05, 0x3A},
	{0x0F, 0x12, 0x00, 0x01},
	/* 002A	17B2 17B2 */
	/* 0F12	0549 */
	/* 002A	17B6 17B6 */
	/* 0F12	0549 */
	/* 002A	17BA 17BA */
	/* 0F12	005B */

	/* For C100 -  jpeg output data  type control
	 * 0028	 D000 002A	B032  0F12	 002A */
	/*  JPEG data type (RAW8 type) */

	{0x00, 0x28, 0x70, 0x00},

	/* Capture Configuratio 0 (2592x1944,  MJPEG, 15fps) */
	{0x00, 0x2A, 0x03, 0xD6},
	{0x0F, 0x12, 0x0A, 0x20}, /* 2592 */
	{0x00, 0x2A, 0x03, 0xD8},
	{0x0F, 0x12, 0x07, 0x98}, /* 1944 */
	{0x00, 0x2A, 0x03, 0xDA},
	{0x0F, 0x12, 0x00, 0x09}, /* YUV */
	{0x00, 0x2A, 0x03, 0xEC}, /* PLL config */
	{0x0F, 0x12, 0x00, 0x00},
	{0x00, 0x2A, 0x03, 0xDC}, /* PCLK max */
	{0x0F, 0x12, 0x5A, 0xD2},
	{0x00, 0x2A, 0x03, 0xDE}, /* PCLK min */
	{0x0F, 0x12, 0x58, 0xDE},
	{0x00, 0x2A, 0x03, 0xE4},
	{0x0F, 0x12, 0x00, 0x42},
	{0x00, 0x2A, 0x03, 0xF0}, /*  1b: FR (bin) 2b: Quality (no-bin) */
	{0x0F, 0x12, 0x00, 0x02},
	{0x00, 0x2A, 0x03, 0xEE},
	{0x0F, 0x12, 0x00, 0x02},
	{0x00, 0x2A, 0x03, 0xF2}, /* max frame time : 15fps 029a */
	{0x0F, 0x12, 0x05, 0x35}, /*  7.5 fps */
	{0x00, 0x2A, 0x03, 0xF4},
	{0x0F, 0x12, 0x00, 0x00},

	/*  */
	/* PREVIEW */
	{0x00, 0x2A, 0x02, 0xA4},
	{0x0F, 0x12, 0x00, 0x00},

	{0x00, 0x2A, 0x02, 0xA8},
	{0x0F, 0x12, 0x00, 0x01},

	{0x00, 0x2A, 0x02, 0x90},
	{0x0F, 0x12, 0x00, 0x01},

	{0x00, 0x2A, 0x02, 0xA6},
	{0x0F, 0x12, 0x00, 0x01},

	{0x00, 0x2A, 0x02, 0x80},
	{0x0F, 0x12, 0x00, 0x01},

	{0x00, 0x2A, 0x02, 0x82},
	{0x0F, 0x12, 0x00, 0x01},

	/*  */

	{0x00, 0x2A, 0x02, 0x92},
	{0x0F, 0x12, 0x07, 0x80}, /* input width  */
	{0x0F, 0x12, 0x04, 0x38}, /* input height */
	{0x0F, 0x12, 0x01, 0x50}, /* input w-offset */
	{0x0F, 0x12, 0x01, 0xB0}, /* input h-offset */

	{0x00, 0x2A, 0x04, 0xDA},
	{0x0F, 0x12, 0x07, 0x80}, /* crop width  */
	{0x0F, 0x12, 0x04, 0x38}, /* crop height */
	/* 0F12	0150	w-offset */
	/* 0F12	01B0	h-offset */

	{0x00, 0x2A, 0x02, 0xA2}, /* 4EA_REG_TC_GP_InputsChangeRequest */
	{0x0F, 0x12, 0x00, 0x01},
	{0x00, 0x2A, 0x02, 0x90}, /* 4EA_REG_TC_GP_NewConfigSync */
	{0x0F, 0x12, 0x00, 0x01},

	{REG_DELAY, 200, 0, 0}, /*  p200 */
};

unsigned short mt9m113_init_reg10[][2] = {
	{0x002A, MT9M113_REG_0TC_PCFG_usMaxFrTimeMsecMult10},/* max frame time */
	{0x0F12, MT9M113_FrTime_MAX}, /* 30fps */
};

unsigned char mt9m113_init_reg11[][4] = {
	/*  */
	/* PREVIEW */
	{0x00, 0x2A, 0x02, 0xA4},
	{0x0F, 0x12, 0x00, 0x00},

	{0x00, 0x2A, 0x02, 0xA8},
	{0x0F, 0x12, 0x00, 0x01},

	{0x00, 0x2A, 0x02, 0x90},
	{0x0F, 0x12, 0x00, 0x01},

	{0x00, 0x2A, 0x02, 0xA6},
	{0x0F, 0x12, 0x00, 0x01},

	{0x00, 0x2A, 0x02, 0x80},
	{0x0F, 0x12, 0x00, 0x01},

	{0x00, 0x2A, 0x02, 0x82},
	{0x0F, 0x12, 0x00, 0x01},

	/*  */

	/*  AF CMD */
	{0x00, 0x2A, 0x02, 0xBE}, /* #4EA_REG_TC_AF	 */
	{0x0F, 0x12, 0x00, 0x03}, /* 4EA_REG_TC_AF_AfCmd */

	{REG_DELAY, 200, 0, 0}, /*  p300 */

	{0x00, 0x2A, 0x02, 0xBE}, /* #4EA_REG_TC_AF	 */
	{0x0F, 0x12, 0x00, 0x05}, /* 5:single AF, 6:continus AF */
};

#define MT9M113_INIT_REGS1	\
	(sizeof(mt9m113_init_reg1) / sizeof(mt9m113_init_reg1[0]))
#define MT9M113_INIT_REGS2	\
	(sizeof(mt9m113_init_reg2) / sizeof(mt9m113_init_reg2[0]))
#define MT9M113_INIT_REGS3	\
	(sizeof(mt9m113_init_reg3) / sizeof(mt9m113_init_reg3[0]))
#define MT9M113_INIT_REGS4	\
	(sizeof(mt9m113_init_reg4) / sizeof(mt9m113_init_reg4[0]))
#define MT9M113_INIT_JPEG	\
	(sizeof(mt9m113_init_jpeg) / sizeof(mt9m113_init_jpeg[0]))
#define MT9M113_INIT_REGS5\
	(sizeof(mt9m113_init_reg5) / sizeof(mt9m113_init_reg5[0]))
#define MT9M113_INIT_REGS6	\
	(sizeof(mt9m113_init_reg6) / sizeof(mt9m113_init_reg6[0]))
#define MT9M113_INIT_REGS7	\
	(sizeof(mt9m113_init_reg7) / sizeof(mt9m113_init_reg7[0]))
#define MT9M113_INIT_REGS8	\
	(sizeof(mt9m113_init_reg8) / sizeof(mt9m113_init_reg8[0]))
#define MT9M113_INIT_REGS9	\
	(sizeof(mt9m113_init_reg9) / sizeof(mt9m113_init_reg9[0]))
#define MT9M113_INIT_REGS10	\
	(sizeof(mt9m113_init_reg10) / sizeof(mt9m113_init_reg10[0]))
#define MT9M113_INIT_REGS11	\
	(sizeof(mt9m113_init_reg11) / sizeof(mt9m113_init_reg11[0]))

unsigned short mt9m113_sleep_reg[][2] = {
	{0x002A, MT9M113_REG_TC_GP_EnablePreview},
	{0x0F12, 0x0000},
	{0x002A, MT9M113_REG_TC_GP_EnablePreviewChanged},
	{0x0F12, 0x0001},
	{REG_DELAY, 100},
};

#define MT9M113_SLEEP_REGS	\
	(sizeof(mt9m113_sleep_reg) / sizeof(mt9m113_sleep_reg[0]))

unsigned short mt9m113_wakeup_reg[][2] = {
	{0x002A, 0x02F0},
	{0x0F12, 0x0052},
	{0x002A, MT9M113_REG_TC_GP_PrevConfigChanged},
	{0x0F12, 0x0001},
};

#define MT9M113_WAKEUP_REGS	\
	(sizeof(mt9m113_wakeup_reg) / sizeof(mt9m113_wakeup_reg[0]))

/* Preview configuration preset #1 */
/* Preview configuration preset #2 */
/* Preview configuration preset #3 */
/* Preview configuration preset #4 */

/* Capture configuration preset #0 */
/* Capture configuration preset #1 */
/* Capture configuration preset #2 */
/* Capture configuration preset #3 */
/* Capture configuration preset #4 */

/*
 * EV bias
 */

static const struct mt9m113_reg mt9m113_ev_m6[] = {
};

static const struct mt9m113_reg mt9m113_ev_m5[] = {
};

static const struct mt9m113_reg mt9m113_ev_m4[] = {
};

static const struct mt9m113_reg mt9m113_ev_m3[] = {
};

static const struct mt9m113_reg mt9m113_ev_m2[] = {
};

static const struct mt9m113_reg mt9m113_ev_m1[] = {
};

static const struct mt9m113_reg mt9m113_ev_default[] = {
};

static const struct mt9m113_reg mt9m113_ev_p1[] = {
};

static const struct mt9m113_reg mt9m113_ev_p2[] = {
};

static const struct mt9m113_reg mt9m113_ev_p3[] = {
};

static const struct mt9m113_reg mt9m113_ev_p4[] = {
};

static const struct mt9m113_reg mt9m113_ev_p5[] = {
};

static const struct mt9m113_reg mt9m113_ev_p6[] = {
};

#ifdef MT9M113_COMPLETE
/* Order of this array should be following the querymenu data */
static const unsigned char *mt9m113_regs_ev_bias[] = {
	(unsigned char *)mt9m113_ev_m6, (unsigned char *)mt9m113_ev_m5,
	(unsigned char *)mt9m113_ev_m4, (unsigned char *)mt9m113_ev_m3,
	(unsigned char *)mt9m113_ev_m2, (unsigned char *)mt9m113_ev_m1,
	(unsigned char *)mt9m113_ev_default, (unsigned char *)mt9m113_ev_p1,
	(unsigned char *)mt9m113_ev_p2, (unsigned char *)mt9m113_ev_p3,
	(unsigned char *)mt9m113_ev_p4, (unsigned char *)mt9m113_ev_p5,
	(unsigned char *)mt9m113_ev_p6,
};

/*
 * Auto White Balance configure
 */
static const struct mt9m113_reg mt9m113_awb_off[] = {
};

static const struct mt9m113_reg mt9m113_awb_on[] = {
};

static const unsigned char *mt9m113_regs_awb_enable[] = {
	(unsigned char *)mt9m113_awb_off,
	(unsigned char *)mt9m113_awb_on,
};

/*
 * Manual White Balance (presets)
 */
static const struct mt9m113_reg mt9m113_wb_tungsten[] = {

};

static const struct mt9m113_reg mt9m113_wb_fluorescent[] = {

};

static const struct mt9m113_reg mt9m113_wb_sunny[] = {

};

static const struct mt9m113_reg mt9m113_wb_cloudy[] = {

};

/* Order of this array should be following the querymenu data */
static const unsigned char *mt9m113_regs_wb_preset[] = {
	(unsigned char *)mt9m113_wb_tungsten,
	(unsigned char *)mt9m113_wb_fluorescent,
	(unsigned char *)mt9m113_wb_sunny,
	(unsigned char *)mt9m113_wb_cloudy,
};

/*
 * Color Effect (COLORFX)
 */
static const struct mt9m113_reg mt9m113_color_sepia[] = {
};

static const struct mt9m113_reg mt9m113_color_aqua[] = {
};

static const struct mt9m113_reg mt9m113_color_monochrome[] = {
};

static const struct mt9m113_reg mt9m113_color_negative[] = {
};

static const struct mt9m113_reg mt9m113_color_sketch[] = {
};

/* Order of this array should be following the querymenu data */
static const unsigned char *mt9m113_regs_color_effect[] = {
	(unsigned char *)mt9m113_color_sepia,
	(unsigned char *)mt9m113_color_aqua,
	(unsigned char *)mt9m113_color_monochrome,
	(unsigned char *)mt9m113_color_negative,
	(unsigned char *)mt9m113_color_sketch,
};

/*
 * Contrast bias
 */
static const struct mt9m113_reg mt9m113_contrast_m2[] = {
};

static const struct mt9m113_reg mt9m113_contrast_m1[] = {
};

static const struct mt9m113_reg mt9m113_contrast_default[] = {
};

static const struct mt9m113_reg mt9m113_contrast_p1[] = {
};

static const struct mt9m113_reg mt9m113_contrast_p2[] = {
};

static const unsigned char *mt9m113_regs_contrast_bias[] = {
	(unsigned char *)mt9m113_contrast_m2,
	(unsigned char *)mt9m113_contrast_m1,
	(unsigned char *)mt9m113_contrast_default,
	(unsigned char *)mt9m113_contrast_p1,
	(unsigned char *)mt9m113_contrast_p2,
};

/*
 * Saturation bias
 */
static const struct mt9m113_reg mt9m113_saturation_m2[] = {
};

static const struct mt9m113_reg mt9m113_saturation_m1[] = {
};

static const struct mt9m113_reg mt9m113_saturation_default[] = {
};

static const struct mt9m113_reg mt9m113_saturation_p1[] = {
};

static const struct mt9m113_reg mt9m113_saturation_p2[] = {
};

static const unsigned char *mt9m113_regs_saturation_bias[] = {
	(unsigned char *)mt9m113_saturation_m2,
	(unsigned char *)mt9m113_saturation_m1,
	(unsigned char *)mt9m113_saturation_default,
	(unsigned char *)mt9m113_saturation_p1,
	(unsigned char *)mt9m113_saturation_p2,
};

/*
 * Sharpness bias
 */
static const struct mt9m113_reg mt9m113_sharpness_m2[] = {
};

static const struct mt9m113_reg mt9m113_sharpness_m1[] = {
};

static const struct mt9m113_reg mt9m113_sharpness_default[] = {
};

static const struct mt9m113_reg mt9m113_sharpness_p1[] = {
};

static const struct mt9m113_reg mt9m113_sharpness_p2[] = {
};

static const unsigned char *mt9m113_regs_sharpness_bias[] = {
	(unsigned char *)mt9m113_sharpness_m2,
	(unsigned char *)mt9m113_sharpness_m1,
	(unsigned char *)mt9m113_sharpness_default,
	(unsigned char *)mt9m113_sharpness_p1,
	(unsigned char *)mt9m113_sharpness_p2,
};
#endif /* MT9M113_COMPLETE */

#endif
