/* linux/drivers/video/samsung/s6evr01_param.h
 *
 * MIPI-DSI based s6evr01 lcd panel driver.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
*/
//---------------------------------------------------------------------------------------------------
#ifndef __S6EVR01_PARAM__
#define __S6EVR01_PARAM__

const unsigned char TEST_KEY1_ON[] = { 
    0xf0, 
    0x5a, 0x5a 
};
const unsigned char TEST_KEY2_ON[] = { 
    0xf1, 
    0x5a, 0x5a 
};
const unsigned char TEST_KEY3_ON[] = { 
    0xfc, 
    0x5a, 0x5a 
};

const unsigned char SLEEP_OUT[] = {
	0x11,
	0x00, 0x00
};

const unsigned char SLEEP_IN[] = {
	0x10,
	0x00, 0x00
};

const unsigned char GAMMA_2_2_SET[] = {
    0xca,
    0x01, 0x27, 0x01, 0x3d, 0x01, 0x47, 0xd1, 0xd1, 0xca, 0xce,
    0xcc, 0xc4, 0xb3, 0xb1, 0xa1, 0xb9, 0xb8, 0xa2, 0xce, 0xce,
    0xba, 0xc8, 0xc9, 0xad, 0x9b, 0x85, 0x53, 0x6a, 0x7e, 0xe3,
	0x09, 0x09, 0x0b
};

const unsigned char GAMMA_UPDATE[] = {
    0xf7,
    0x03
};

const unsigned char BRIGHTNESS_CONTROL[] = {
    0x53,
    0x20
};

const unsigned char AOR_SET[] = {
    0x51,
    0xff
};

const unsigned char ELVSS_CONTROL[] = {
    0xb6,
	0x08, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xAA, 0x64,
	0x2A, 0x03, 0xE8, 0x07, 0xD0, 0x0A, 0x00, 0x10, 0x00 
};

const unsigned char ACL_SET[] = {
    0x55,
    0x00, 0x01, 0x02, 0x03
};

const unsigned char REFRESH_CON[] = {
    0xB8,
    0x38, 0x0B, 0x00, 0x00, 0x28, 0x00, 0x01
};

const unsigned char LTPSCTL_SET[] = {
	0xCB,
	0x0E, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x02, 0x34, 0x00,
	0x03, 0x97, 0x68, 0x10, 0x3A, 0x8D, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x7D, 0x08, 0x27, 0x00, 0x00, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x6D, 0x08, 0x6D, 0x06, 0x05, 0x24, 0x24,
	0x24, 0x24, 0x08, 0x24, 0xF0, 0x8C, 0xFF, 0x00 
};

static const unsigned char DISPLAY_ON[] = {
	0x29,
	0x00, 0x00
};

static const unsigned char DISPLAY_OFF[] = {
	0x28,
	0x00, 0x00
};

//---------------------------------------------------------------------------------------------------
MODULE_DESCRIPTION("MIPI-DSI s6evr01 (720x1280) Panel Driver");
MODULE_LICENSE("GPL");

//---------------------------------------------------------------------------------------------------
#endif  //#ifndef __S6EVR01_PARAM__

//---------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------
