/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Warning
implements Comparable<Warning> {
    public final Issue issue;
    public final String message;
    public final Severity severity;
    public final Object data;
    public final Project project;
    public Location location;
    public File file;
    public String path;
    public int line = -1;
    public int offset = -1;
    public String errorLine;
    public String fileContents;

    public Warning(Issue issue, String string, Severity severity, Project project, Object object) {
        this.issue = issue;
        this.message = string;
        this.severity = severity;
        this.project = project;
        this.data = object;
    }

    @Override
    public int compareTo(Warning warning) {
        int n;
        int n2 = this.issue.getCategory().compareTo(warning.issue.getCategory());
        if (n2 != 0) {
            return n2;
        }
        int n3 = warning.issue.getPriority() - this.issue.getPriority();
        if (n3 != 0) {
            return n3;
        }
        String string = this.issue.getId();
        String string2 = warning.issue.getId();
        if (string == null || string2 == null) {
            return this.file.getName().compareTo(warning.file.getName());
        }
        int n4 = string.compareTo(string2);
        if (n4 != 0) {
            return n4;
        }
        if (this.file != null && warning.file != null && (n = this.file.getName().compareTo(warning.file.getName())) != 0) {
            return n;
        }
        if (this.line != warning.line) {
            return this.line - warning.line;
        }
        return this.message.compareTo(warning.message);
    }
}

