/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.JavaContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.AnnotationValueArray;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.Assert;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.Block;
import lombok.ast.BooleanLiteral;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Cast;
import lombok.ast.Catch;
import lombok.ast.CharLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Continue;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EmptyStatement;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceInitializer;
import lombok.ast.InstanceOf;
import lombok.ast.IntegralLiteral;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.Return;
import lombok.ast.Select;
import lombok.ast.StaticInitializer;
import lombok.ast.StringLiteral;
import lombok.ast.Super;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.UnaryExpression;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import lombok.ast.While;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaVisitor {
    private static final int SAME_TYPE_COUNT = 8;
    private final Map<String, List<VisitingDetector>> mMethodDetectors = new HashMap<String, List<VisitingDetector>>();
    private final List<VisitingDetector> mResourceFieldDetectors = new ArrayList<VisitingDetector>();
    private final List<VisitingDetector> mAllDetectors;
    private final List<VisitingDetector> mFullTreeDetectors;
    private Map<Class<? extends Node>, List<VisitingDetector>> mNodeTypeDetectors = new HashMap<Class<? extends Node>, List<VisitingDetector>>();
    private final IJavaParser mParser;

    JavaVisitor(IJavaParser iJavaParser, List<Detector> list) {
        this.mParser = iJavaParser;
        this.mAllDetectors = new ArrayList<VisitingDetector>(list.size());
        this.mFullTreeDetectors = new ArrayList<VisitingDetector>(list.size());
        for (Detector detector : list) {
            Object object;
            Object object2;
            Object object3;
            VisitingDetector visitingDetector = new VisitingDetector(detector, (Detector.JavaScanner)((Object)detector));
            this.mAllDetectors.add(visitingDetector);
            List<Class<? extends Node>> list2 = detector.getApplicableNodeTypes();
            if (list2 != null) {
                object3 = list2.iterator();
                while (object3.hasNext()) {
                    object2 = (Class)object3.next();
                    object = this.mNodeTypeDetectors.get(object2);
                    if (object == null) {
                        object = new ArrayList<VisitingDetector>(8);
                        this.mNodeTypeDetectors.put((Class<? extends Node>)object2, (List<VisitingDetector>)object);
                    }
                    object.add(visitingDetector);
                }
            }
            if ((object3 = detector.getApplicableMethodNames()) != null) {
                assert (object3 != Detector.XmlScanner.ALL);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    List<VisitingDetector> list3 = this.mMethodDetectors.get(object);
                    if (list3 == null) {
                        list3 = new ArrayList<VisitingDetector>(8);
                        this.mMethodDetectors.put((String)object, list3);
                    }
                    list3.add(visitingDetector);
                }
            }
            if (detector.appliesToResourceRefs()) {
                this.mResourceFieldDetectors.add(visitingDetector);
                continue;
            }
            if (object3 != null && object3.size() != 0 || list2 != null && list2.size() != 0) continue;
            this.mFullTreeDetectors.add(visitingDetector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitFile(JavaContext javaContext, File file) {
        javaContext.parser = this.mParser;
        Node node = null;
        try {
            Object object;
            node = this.mParser.parseJava(javaContext);
            if (node == null) {
                return;
            }
            javaContext.compilationUnit = node;
            for (VisitingDetector visitingDetector : this.mAllDetectors) {
                visitingDetector.setContext(javaContext);
                visitingDetector.getDetector().beforeCheckFile(javaContext);
            }
            for (VisitingDetector visitingDetector : this.mFullTreeDetectors) {
                AstVisitor astVisitor = visitingDetector.getVisitor();
                if (astVisitor != null) {
                    node.accept(astVisitor);
                    continue;
                }
                assert (false) : visitingDetector.getDetector().getClass().getName();
            }
            if (this.mMethodDetectors.size() > 0 || this.mResourceFieldDetectors.size() > 0) {
                object = new DelegatingJavaVisitor(javaContext);
                node.accept(object);
            } else if (this.mNodeTypeDetectors.size() > 0) {
                object = new DispatchVisitor();
                node.accept(object);
            }
            for (VisitingDetector visitingDetector : this.mAllDetectors) {
                visitingDetector.getDetector().afterCheckFile(javaContext);
            }
        }
        finally {
            if (node != null) {
                this.mParser.dispose(javaContext, node);
            }
        }
    }

    private class DelegatingJavaVisitor
    extends DispatchVisitor {
        private final JavaContext mContext;
        private final boolean mVisitResources;
        private final boolean mVisitMethods;

        public DelegatingJavaVisitor(JavaContext javaContext) {
            this.mContext = javaContext;
            this.mVisitMethods = JavaVisitor.this.mMethodDetectors.size() > 0;
            this.mVisitResources = JavaVisitor.this.mResourceFieldDetectors.size() > 0;
        }

        public boolean visitVariableReference(VariableReference variableReference) {
            block2: {
                Select select;
                String string;
                block3: {
                    if (!this.mVisitResources) break block2;
                    string = variableReference.astIdentifier().getDescription();
                    if (!string.equals("R") || !(variableReference.getParent() instanceof Select) || !(variableReference.getParent().getParent() instanceof Select)) break block3;
                    Select select2 = (Select)variableReference.getParent();
                    Select select3 = (Select)select2.getParent();
                    String string2 = select2.astIdentifier().astValue();
                    String string3 = select3.astIdentifier().astValue();
                    for (VisitingDetector visitingDetector : JavaVisitor.this.mResourceFieldDetectors) {
                        Detector.JavaScanner javaScanner = visitingDetector.getJavaScanner();
                        javaScanner.visitResourceReference(this.mContext, visitingDetector.getVisitor(), variableReference, string2, string3, false);
                    }
                    break block2;
                }
                if (!string.equals("android") || !(variableReference.getParent() instanceof Select) || !(select = (Select)variableReference.getParent()).astIdentifier().astValue().equals("R") || !(select.getParent() instanceof Select) || !(select.getParent().getParent() instanceof Select)) break block2;
                Select select4 = (Select)select.getParent();
                Select select5 = (Select)select4.getParent();
                String string4 = select4.astIdentifier().astValue();
                String string5 = select5.astIdentifier().astValue();
                for (VisitingDetector visitingDetector : JavaVisitor.this.mResourceFieldDetectors) {
                    Detector.JavaScanner javaScanner = visitingDetector.getJavaScanner();
                    javaScanner.visitResourceReference(this.mContext, visitingDetector.getVisitor(), variableReference, string4, string5, true);
                }
            }
            return super.visitVariableReference(variableReference);
        }

        public boolean visitMethodInvocation(MethodInvocation methodInvocation) {
            if (this.mVisitMethods) {
                String string = methodInvocation.astName().getDescription();
                List list = (List)JavaVisitor.this.mMethodDetectors.get(string);
                if (list != null) {
                    for (VisitingDetector visitingDetector : list) {
                        visitingDetector.getJavaScanner().visitMethod(this.mContext, visitingDetector.getVisitor(), methodInvocation);
                    }
                }
            }
            return super.visitMethodInvocation(methodInvocation);
        }
    }

    private class DispatchVisitor
    extends AstVisitor {
        private DispatchVisitor() {
        }

        public void endVisit(Node node) {
        }

        public boolean visitAlternateConstructorInvocation(AlternateConstructorInvocation alternateConstructorInvocation) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AlternateConstructorInvocation.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitAlternateConstructorInvocation(alternateConstructorInvocation);
                }
            }
            return false;
        }

        public boolean visitAnnotation(Annotation annotation) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Annotation.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitAnnotation(annotation);
                }
            }
            return false;
        }

        public boolean visitAnnotationDeclaration(AnnotationDeclaration annotationDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AnnotationDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitAnnotationDeclaration(annotationDeclaration);
                }
            }
            return false;
        }

        public boolean visitAnnotationElement(AnnotationElement annotationElement) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AnnotationElement.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitAnnotationElement(annotationElement);
                }
            }
            return false;
        }

        public boolean visitAnnotationMethodDeclaration(AnnotationMethodDeclaration annotationMethodDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AnnotationMethodDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitAnnotationMethodDeclaration(annotationMethodDeclaration);
                }
            }
            return false;
        }

        public boolean visitAnnotationValueArray(AnnotationValueArray annotationValueArray) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AnnotationValueArray.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitAnnotationValueArray(annotationValueArray);
                }
            }
            return false;
        }

        public boolean visitArrayAccess(ArrayAccess arrayAccess) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ArrayAccess.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitArrayAccess(arrayAccess);
                }
            }
            return false;
        }

        public boolean visitArrayCreation(ArrayCreation arrayCreation) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ArrayCreation.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitArrayCreation(arrayCreation);
                }
            }
            return false;
        }

        public boolean visitArrayDimension(ArrayDimension arrayDimension) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ArrayDimension.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitArrayDimension(arrayDimension);
                }
            }
            return false;
        }

        public boolean visitArrayInitializer(ArrayInitializer arrayInitializer) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ArrayInitializer.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitArrayInitializer(arrayInitializer);
                }
            }
            return false;
        }

        public boolean visitAssert(Assert assert_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Assert.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitAssert(assert_);
                }
            }
            return false;
        }

        public boolean visitBinaryExpression(BinaryExpression binaryExpression) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(BinaryExpression.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitBinaryExpression(binaryExpression);
                }
            }
            return false;
        }

        public boolean visitBlock(Block block) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Block.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitBlock(block);
                }
            }
            return false;
        }

        public boolean visitBooleanLiteral(BooleanLiteral booleanLiteral) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(BooleanLiteral.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitBooleanLiteral(booleanLiteral);
                }
            }
            return false;
        }

        public boolean visitBreak(Break break_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Break.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitBreak(break_);
                }
            }
            return false;
        }

        public boolean visitCase(Case case_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Case.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitCase(case_);
                }
            }
            return false;
        }

        public boolean visitCast(Cast cast) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Cast.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitCast(cast);
                }
            }
            return false;
        }

        public boolean visitCatch(Catch catch_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Catch.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitCatch(catch_);
                }
            }
            return false;
        }

        public boolean visitCharLiteral(CharLiteral charLiteral) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(CharLiteral.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitCharLiteral(charLiteral);
                }
            }
            return false;
        }

        public boolean visitClassDeclaration(ClassDeclaration classDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ClassDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitClassDeclaration(classDeclaration);
                }
            }
            return false;
        }

        public boolean visitClassLiteral(ClassLiteral classLiteral) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ClassLiteral.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitClassLiteral(classLiteral);
                }
            }
            return false;
        }

        public boolean visitComment(Comment comment) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Comment.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitComment(comment);
                }
            }
            return false;
        }

        public boolean visitCompilationUnit(CompilationUnit compilationUnit) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(CompilationUnit.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitCompilationUnit(compilationUnit);
                }
            }
            return false;
        }

        public boolean visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ConstructorDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitConstructorDeclaration(constructorDeclaration);
                }
            }
            return false;
        }

        public boolean visitConstructorInvocation(ConstructorInvocation constructorInvocation) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ConstructorInvocation.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitConstructorInvocation(constructorInvocation);
                }
            }
            return false;
        }

        public boolean visitContinue(Continue continue_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Continue.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitContinue(continue_);
                }
            }
            return false;
        }

        public boolean visitDefault(Default default_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Default.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitDefault(default_);
                }
            }
            return false;
        }

        public boolean visitDoWhile(DoWhile doWhile) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(DoWhile.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitDoWhile(doWhile);
                }
            }
            return false;
        }

        public boolean visitEmptyDeclaration(EmptyDeclaration emptyDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EmptyDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitEmptyDeclaration(emptyDeclaration);
                }
            }
            return false;
        }

        public boolean visitEmptyStatement(EmptyStatement emptyStatement) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EmptyStatement.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitEmptyStatement(emptyStatement);
                }
            }
            return false;
        }

        public boolean visitEnumConstant(EnumConstant enumConstant) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EnumConstant.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitEnumConstant(enumConstant);
                }
            }
            return false;
        }

        public boolean visitEnumDeclaration(EnumDeclaration enumDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EnumDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitEnumDeclaration(enumDeclaration);
                }
            }
            return false;
        }

        public boolean visitEnumTypeBody(EnumTypeBody enumTypeBody) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EnumTypeBody.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitEnumTypeBody(enumTypeBody);
                }
            }
            return false;
        }

        public boolean visitExpressionStatement(ExpressionStatement expressionStatement) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ExpressionStatement.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitExpressionStatement(expressionStatement);
                }
            }
            return false;
        }

        public boolean visitFloatingPointLiteral(FloatingPointLiteral floatingPointLiteral) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(FloatingPointLiteral.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitFloatingPointLiteral(floatingPointLiteral);
                }
            }
            return false;
        }

        public boolean visitFor(For for_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(For.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitFor(for_);
                }
            }
            return false;
        }

        public boolean visitForEach(ForEach forEach) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ForEach.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitForEach(forEach);
                }
            }
            return false;
        }

        public boolean visitIdentifier(Identifier identifier) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Identifier.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitIdentifier(identifier);
                }
            }
            return false;
        }

        public boolean visitIf(If if_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(If.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitIf(if_);
                }
            }
            return false;
        }

        public boolean visitImportDeclaration(ImportDeclaration importDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ImportDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitImportDeclaration(importDeclaration);
                }
            }
            return false;
        }

        public boolean visitInlineIfExpression(InlineIfExpression inlineIfExpression) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(InlineIfExpression.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitInlineIfExpression(inlineIfExpression);
                }
            }
            return false;
        }

        public boolean visitInstanceInitializer(InstanceInitializer instanceInitializer) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(InstanceInitializer.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitInstanceInitializer(instanceInitializer);
                }
            }
            return false;
        }

        public boolean visitInstanceOf(InstanceOf instanceOf) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(InstanceOf.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitInstanceOf(instanceOf);
                }
            }
            return false;
        }

        public boolean visitIntegralLiteral(IntegralLiteral integralLiteral) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(IntegralLiteral.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitIntegralLiteral(integralLiteral);
                }
            }
            return false;
        }

        public boolean visitInterfaceDeclaration(InterfaceDeclaration interfaceDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(InterfaceDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitInterfaceDeclaration(interfaceDeclaration);
                }
            }
            return false;
        }

        public boolean visitKeywordModifier(KeywordModifier keywordModifier) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(KeywordModifier.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitKeywordModifier(keywordModifier);
                }
            }
            return false;
        }

        public boolean visitLabelledStatement(LabelledStatement labelledStatement) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(LabelledStatement.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitLabelledStatement(labelledStatement);
                }
            }
            return false;
        }

        public boolean visitMethodDeclaration(MethodDeclaration methodDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(MethodDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitMethodDeclaration(methodDeclaration);
                }
            }
            return false;
        }

        public boolean visitMethodInvocation(MethodInvocation methodInvocation) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(MethodInvocation.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitMethodInvocation(methodInvocation);
                }
            }
            return false;
        }

        public boolean visitModifiers(Modifiers modifiers) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Modifiers.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitModifiers(modifiers);
                }
            }
            return false;
        }

        public boolean visitNormalTypeBody(NormalTypeBody normalTypeBody) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(NormalTypeBody.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitNormalTypeBody(normalTypeBody);
                }
            }
            return false;
        }

        public boolean visitNullLiteral(NullLiteral nullLiteral) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(NullLiteral.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitNullLiteral(nullLiteral);
                }
            }
            return false;
        }

        public boolean visitPackageDeclaration(PackageDeclaration packageDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(PackageDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitPackageDeclaration(packageDeclaration);
                }
            }
            return false;
        }

        public boolean visitParseArtefact(Node node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Node.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitParseArtefact(node);
                }
            }
            return false;
        }

        public boolean visitReturn(Return return_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Return.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitReturn(return_);
                }
            }
            return false;
        }

        public boolean visitSelect(Select select) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Select.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitSelect(select);
                }
            }
            return false;
        }

        public boolean visitStaticInitializer(StaticInitializer staticInitializer) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(StaticInitializer.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitStaticInitializer(staticInitializer);
                }
            }
            return false;
        }

        public boolean visitStringLiteral(StringLiteral stringLiteral) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(StringLiteral.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitStringLiteral(stringLiteral);
                }
            }
            return false;
        }

        public boolean visitSuper(Super super_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Super.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitSuper(super_);
                }
            }
            return false;
        }

        public boolean visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(SuperConstructorInvocation.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitSuperConstructorInvocation(superConstructorInvocation);
                }
            }
            return false;
        }

        public boolean visitSwitch(Switch switch_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Switch.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitSwitch(switch_);
                }
            }
            return false;
        }

        public boolean visitSynchronized(Synchronized synchronized_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Synchronized.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitSynchronized(synchronized_);
                }
            }
            return false;
        }

        public boolean visitThis(This this_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(This.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitThis(this_);
                }
            }
            return false;
        }

        public boolean visitThrow(Throw throw_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Throw.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitThrow(throw_);
                }
            }
            return false;
        }

        public boolean visitTry(Try try_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Try.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitTry(try_);
                }
            }
            return false;
        }

        public boolean visitTypeReference(TypeReference typeReference) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(TypeReference.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitTypeReference(typeReference);
                }
            }
            return false;
        }

        public boolean visitTypeReferencePart(TypeReferencePart typeReferencePart) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(TypeReferencePart.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitTypeReferencePart(typeReferencePart);
                }
            }
            return false;
        }

        public boolean visitTypeVariable(TypeVariable typeVariable) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(TypeVariable.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitTypeVariable(typeVariable);
                }
            }
            return false;
        }

        public boolean visitUnaryExpression(UnaryExpression unaryExpression) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(UnaryExpression.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitUnaryExpression(unaryExpression);
                }
            }
            return false;
        }

        public boolean visitVariableDeclaration(VariableDeclaration variableDeclaration) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(VariableDeclaration.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitVariableDeclaration(variableDeclaration);
                }
            }
            return false;
        }

        public boolean visitVariableDefinition(VariableDefinition variableDefinition) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(VariableDefinition.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitVariableDefinition(variableDefinition);
                }
            }
            return false;
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry variableDefinitionEntry) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(VariableDefinitionEntry.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitVariableDefinitionEntry(variableDefinitionEntry);
                }
            }
            return false;
        }

        public boolean visitVariableReference(VariableReference variableReference) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(VariableReference.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitVariableReference(variableReference);
                }
            }
            return false;
        }

        public boolean visitWhile(While while_) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(While.class);
            if (list != null) {
                for (VisitingDetector visitingDetector : list) {
                    visitingDetector.getVisitor().visitWhile(while_);
                }
            }
            return false;
        }
    }

    private static class VisitingDetector {
        private AstVisitor mVisitor;
        private JavaContext mContext;
        public final Detector mDetector;
        public final Detector.JavaScanner mJavaScanner;

        public VisitingDetector(Detector detector, Detector.JavaScanner javaScanner) {
            this.mDetector = detector;
            this.mJavaScanner = javaScanner;
        }

        public Detector getDetector() {
            return this.mDetector;
        }

        public Detector.JavaScanner getJavaScanner() {
            return this.mJavaScanner;
        }

        public void setContext(JavaContext javaContext) {
            this.mContext = javaContext;
            this.mVisitor = null;
        }

        AstVisitor getVisitor() {
            if (this.mVisitor == null) {
                this.mVisitor = this.mDetector.createJavaVisitor(this.mContext);
            }
            return this.mVisitor;
        }
    }
}

