/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.DefaultSdkInfo;
import com.android.tools.lint.client.api.IDomParser;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class LintClient {
    private static final String PROP_BIN_DIR = "com.android.tools.lint.bindir";
    private Map<File, Project> mDirToProject;

    public Configuration getConfiguration(Project project) {
        return DefaultConfiguration.create(this, project, null);
    }

    public abstract void report(Context var1, Issue var2, Severity var3, Location var4, String var5, Object var6);

    public void log(Throwable throwable, String string, Object ... objectArray) {
        this.log(Severity.WARNING, throwable, string, objectArray);
    }

    public abstract void log(Severity var1, Throwable var2, String var3, Object ... var4);

    public abstract IDomParser getDomParser();

    public abstract IJavaParser getJavaParser();

    public Class<? extends Detector> replaceDetector(Class<? extends Detector> clazz) {
        return clazz;
    }

    public abstract String readFile(File var1);

    public List<File> getJavaSourceFolders(Project project) {
        return this.getEclipseClasspath(project, "src", "src", "gen");
    }

    public List<File> getJavaClassFolders(Project project) {
        return this.getEclipseClasspath(project, "output", "bin");
    }

    public List<File> getJavaLibraries(Project project) {
        return this.getEclipseClasspath(project, "lib", new String[0]);
    }

    public SdkInfo getSdkInfo(Project project) {
        return new DefaultSdkInfo();
    }

    public File getCacheDir(boolean bl) {
        String string = System.getProperty("user.home");
        String string2 = ".android" + File.separator + "cache";
        File file = new File(string, string2);
        if (bl && !file.exists() && !file.mkdirs()) {
            return null;
        }
        return file;
    }

    private File getLintBinDir() {
        String string = System.getProperty(PROP_BIN_DIR);
        if (string == null || string.length() == 0) {
            string = System.getenv(PROP_BIN_DIR);
        }
        if (string != null && string.length() > 0) {
            return new File(string);
        }
        return null;
    }

    public File findResource(String string) {
        File file = this.getLintBinDir();
        if (file == null) {
            throw new IllegalArgumentException("Lint must be invoked with the System property com.android.tools.lint.bindir pointing to the ANDROID_SDK tools directory");
        }
        File file2 = file.getParentFile();
        File file3 = new File(file2, string);
        if (file3.exists()) {
            return file3;
        }
        return null;
    }

    private List<File> getEclipseClasspath(Project project, String string, String ... stringArray) {
        Object object;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = project.getDir();
        File file2 = new File(file, ".classpath");
        if (file2.exists()) {
            String[] stringArray2 = this.readFile(file2);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            InputSource inputSource = new InputSource(new StringReader((String)stringArray2));
            documentBuilderFactory.setNamespaceAware(false);
            documentBuilderFactory.setValidating(false);
            try {
                DocumentBuilder object2 = documentBuilderFactory.newDocumentBuilder();
                object = object2.parse(inputSource);
                NodeList nodeList = object.getElementsByTagName("classpathentry");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    String string2;
                    File file3;
                    Element element = (Element)nodeList.item(i);
                    String string3 = element.getAttribute("kind");
                    if (!string3.equals(string) || !(file3 = new File(file, string2 = element.getAttribute("path"))).exists()) continue;
                    arrayList.add(file3);
                }
            }
            catch (Exception exception) {
                this.log(null, null, new Object[0]);
            }
        }
        if (arrayList.size() == 0) {
            for (String string4 : stringArray) {
                object = new File(file, string4);
                if (!((File)object).exists()) continue;
                arrayList.add((File)object);
            }
        }
        return arrayList;
    }

    public Project getProject(File file, File file2) {
        if (this.mDirToProject == null) {
            this.mDirToProject = new HashMap<File, Project>();
        }
        File file3 = file;
        try {
            file3 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Project project = this.mDirToProject.get(file3);
        if (project != null) {
            return project;
        }
        project = Project.create(this, file, file2);
        this.mDirToProject.put(file3, project);
        return project;
    }
}

