/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IDomParser;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaVisitor;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.XmlVisitor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.ast.Annotation;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationValue;
import lombok.ast.ArrayInitializer;
import lombok.ast.ClassDeclaration;
import lombok.ast.Expression;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.TypeReference;
import lombok.ast.VariableDefinition;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class LintDriver {
    private static final int MAX_PHASES = 3;
    private static final String SUPPRESS_LINT_VMSIG = "/SuppressLint;";
    private final LintClient mClient;
    private volatile boolean mCanceled;
    private IssueRegistry mRegistry;
    private EnumSet<Scope> mScope;
    private List<? extends Detector> mApplicableDetectors;
    private Map<Scope, List<Detector>> mScopeDetectors;
    private List<LintListener> mListeners;
    private int mPhase;
    private List<Detector> mRepeatingDetectors;
    private EnumSet<Scope> mRepeatScope;
    private Project[] mCurrentProjects;
    private boolean mAbbreviating = true;
    private Map<String, String> mSuperClassMap;
    private Deque<ClassNode> mOuterClasses;
    private ResourceFolderType mCurrentFolderType;
    private List<ResourceXmlDetector> mCurrentXmlDetectors;
    private XmlVisitor mCurrentVisitor;

    public LintDriver(IssueRegistry issueRegistry, LintClient lintClient) {
        this.mRegistry = issueRegistry;
        this.mClient = new LintClientWrapper(lintClient);
    }

    public void cancel() {
        this.mCanceled = true;
    }

    public EnumSet<Scope> getScope() {
        return this.mScope;
    }

    public LintClient getClient() {
        return this.mClient;
    }

    public int getPhase() {
        return this.mPhase;
    }

    public Project findProjectFor(File file) {
        if (this.mCurrentProjects != null) {
            if (this.mCurrentProjects.length == 1) {
                return this.mCurrentProjects[0];
            }
            String string = file.getPath();
            for (Project project : this.mCurrentProjects) {
                if (!string.startsWith(project.getDir().getPath())) continue;
                return project;
            }
        }
        return null;
    }

    public void setAbbreviating(boolean bl) {
        this.mAbbreviating = bl;
    }

    public boolean isAbbreviating() {
        return this.mAbbreviating;
    }

    public void analyze(List<File> list, EnumSet<Scope> enumSet) {
        this.mCanceled = false;
        this.mScope = enumSet;
        Collection<Project> collection = this.computeProjects(list);
        if (collection.size() == 0) {
            this.mClient.log(null, "No projects found for %1$s", list.toString());
            return;
        }
        if (this.mCanceled) {
            return;
        }
        if (this.mScope == null) {
            this.mScope = EnumSet.noneOf(Scope.class);
            for (Project project : collection) {
                if (project.getSubset() != null) {
                    for (File file : project.getSubset()) {
                        String string = file.getName();
                        if (string.equals("AndroidManifest.xml")) {
                            this.mScope.add(Scope.MANIFEST);
                            continue;
                        }
                        if (string.endsWith(".xml")) {
                            this.mScope.add(Scope.RESOURCE_FILE);
                            continue;
                        }
                        if (string.equals("proguard-project.txt") || string.equals("proguard.cfg")) {
                            this.mScope.add(Scope.PROGUARD_FILE);
                            continue;
                        }
                        if (string.equals("res") || file.getParent().equals("res")) {
                            this.mScope.add(Scope.ALL_RESOURCE_FILES);
                            this.mScope.add(Scope.RESOURCE_FILE);
                            continue;
                        }
                        if (string.endsWith(".java")) {
                            this.mScope.add(Scope.JAVA_FILE);
                            continue;
                        }
                        if (string.endsWith(".class")) {
                            this.mScope.add(Scope.CLASS_FILE);
                            continue;
                        }
                        if (!string.equals("proguard.cfg") && !string.equals("proguard-project.txt")) continue;
                        this.mScope.add(Scope.PROGUARD_FILE);
                    }
                    continue;
                }
                this.mScope = Scope.ALL;
                break;
            }
        }
        this.fireEvent(LintListener.EventType.STARTING, null);
        for (Project project : collection) {
            this.mPhase = 1;
            this.computeDetectors(project);
            if (this.mApplicableDetectors.size() == 0) continue;
            this.checkProject(project);
            if (this.mCanceled) break;
            this.runExtraPhases(project);
        }
        this.fireEvent(this.mCanceled ? LintListener.EventType.CANCELED : LintListener.EventType.COMPLETED, null);
    }

    private void runExtraPhases(Project project) {
        if (this.mRepeatingDetectors != null) {
            EnumSet<Scope> enumSet = this.mScope;
            do {
                ++this.mPhase;
                this.fireEvent(LintListener.EventType.NEW_PHASE, new Context(this, project, null, project.getDir()));
                if (this.mRepeatScope == null) {
                    this.mRepeatScope = Scope.ALL;
                }
                this.mScope = Scope.intersect(this.mScope, this.mRepeatScope);
                if (this.mScope.isEmpty()) break;
                this.computeRepeatingDetectors(this.mRepeatingDetectors, project);
                if (this.mApplicableDetectors.size() == 0) continue;
                this.checkProject(project);
                if (this.mCanceled) break;
            } while (this.mPhase < 3 && this.mRepeatingDetectors != null);
            this.mScope = enumSet;
        }
    }

    private void computeRepeatingDetectors(List<Detector> list, Project project) {
        this.mCurrentFolderType = null;
        this.mCurrentVisitor = null;
        List<Issue> list2 = this.mRegistry.getIssues();
        ArrayListMultimap<Class<?>, Issue> arrayListMultimap = ArrayListMultimap.create(list2.size(), 3);
        for (Issue object2 : list2) {
            arrayListMultimap.put(object2.getDetectorClass(), object2);
        }
        HashMap hashMap = new HashMap();
        HashMap<Scope, List<Detector>> hashMap2 = new HashMap<Scope, List<Detector>>();
        ArrayList<? extends Detector> arrayList = new ArrayList<Detector>();
        Configuration configuration = project.getConfiguration();
        for (Detector detector : list) {
            Collection<Scope> collection;
            Object object;
            Object object22;
            Class<?> clazz = detector.getClass();
            Collection collection2 = arrayListMultimap.get(clazz);
            if (list2 == null) continue;
            boolean bl = false;
            for (Object object22 : collection2) {
                if (!configuration.isEnabled((Issue)object22)) continue;
                bl = true;
                object = (EnumSet)hashMap.get(clazz);
                collection = ((Issue)object22).getScope();
                if (object == null) {
                    hashMap.put(clazz, collection);
                    continue;
                }
                if (object.containsAll(collection)) continue;
                EnumSet<Scope> enumSet = EnumSet.copyOf(object);
                enumSet.addAll(collection);
                hashMap.put(clazz, enumSet);
            }
            if (!bl) continue;
            arrayList.add(detector);
            EnumSet enumSet = (EnumSet)hashMap.get(detector.getClass());
            object22 = enumSet.iterator();
            while (object22.hasNext()) {
                object = (Scope)((Object)object22.next());
                collection = (List)hashMap2.get(object);
                if (collection == null) {
                    collection = new ArrayList();
                    hashMap2.put((Scope)((Object)object), (List<Detector>)collection);
                }
                collection.add((Scope)((Object)detector));
            }
        }
        this.mApplicableDetectors = arrayList;
        this.mScopeDetectors = hashMap2;
        this.mRepeatingDetectors = null;
        this.mRepeatScope = null;
        this.validateScopeList();
    }

    private void computeDetectors(Project project) {
        this.mCurrentFolderType = null;
        this.mCurrentVisitor = null;
        Configuration configuration = project.getConfiguration();
        this.mScopeDetectors = new HashMap<Scope, List<Detector>>();
        this.mApplicableDetectors = this.mRegistry.createDetectors(this.mClient, configuration, this.mScope, this.mScopeDetectors);
        this.validateScopeList();
    }

    private void validateScopeList() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            List<Detector> list;
            List<Detector> list2;
            List<Detector> list3;
            Object object;
            List<Detector> list4 = this.mScopeDetectors.get((Object)Scope.RESOURCE_FILE);
            if (list4 != null) {
                object = list4.iterator();
                while (object.hasNext()) {
                    list3 = (Detector)object.next();
                    assert (list3 instanceof ResourceXmlDetector) : list3;
                }
            }
            if ((object = this.mScopeDetectors.get((Object)Scope.MANIFEST)) != null) {
                list3 = object.iterator();
                while (list3.hasNext()) {
                    list2 = (Detector)list3.next();
                    assert (list2 instanceof Detector.XmlScanner) : list2;
                }
            }
            if ((list3 = this.mScopeDetectors.get((Object)Scope.ALL_JAVA_FILES)) != null) {
                list2 = list3.iterator();
                while (list2.hasNext()) {
                    list = (Detector)list2.next();
                    assert (list instanceof Detector.JavaScanner) : list;
                }
            }
            if ((list2 = this.mScopeDetectors.get((Object)Scope.JAVA_FILE)) != null) {
                list = list2.iterator();
                while (list.hasNext()) {
                    Detector detector = (Detector)list.next();
                    assert (detector instanceof Detector.JavaScanner) : detector;
                }
            }
            if ((list = this.mScopeDetectors.get((Object)Scope.CLASS_FILE)) != null) {
                for (Detector detector : list) {
                    assert (detector instanceof Detector.ClassScanner) : detector;
                }
            }
        }
    }

    private void registerProjectFile(Map<File, Project> map, File file, File file2, File file3) {
        map.put(file, this.mClient.getProject(file2, file3));
    }

    private Collection<Project> computeProjects(List<File> object) {
        Iterator iterator;
        Object object2;
        Serializable serializable;
        Map.Entry entry2;
        Object object3;
        HashMap<File, Project> hashMap = new HashMap<File, Project>();
        File file = null;
        if (object.size() > 1) {
            object3 = new ArrayList(object.size());
            entry2 = object.iterator();
            while (entry2.hasNext()) {
                serializable = (File)entry2.next();
                object3.add(((File)serializable).getAbsoluteFile());
            }
            object = object3;
            file = LintUtils.getCommonParent((List<File>)object);
            if (file != null && file.getParentFile() == null) {
                file = null;
            }
        }
        object3 = object.iterator();
        while (object3.hasNext()) {
            entry2 = (File)object3.next();
            if (((File)((Object)entry2)).isDirectory()) {
                serializable = file;
                if (serializable == null) {
                    serializable = entry2;
                    if (object.size() > 1 && (serializable = ((File)((Object)entry2)).getParentFile()) == null) {
                        serializable = entry2;
                    }
                }
                if (this.isProjectDir((File)((Object)entry2))) {
                    this.registerProjectFile(hashMap, (File)((Object)entry2), (File)((Object)entry2), (File)serializable);
                    continue;
                }
                object2 = ((File)((Object)entry2)).getParentFile();
                if (object2 != null) {
                    if (this.isProjectDir((File)object2)) {
                        this.registerProjectFile(hashMap, (File)((Object)entry2), (File)object2, (File)object2);
                        continue;
                    }
                    if (this.isProjectDir((File)(object2 = ((File)object2).getParentFile()))) {
                        this.registerProjectFile((Map<File, Project>)hashMap, (File)((Object)entry2), (File)object2, (File)object2);
                        continue;
                    }
                }
                this.addProjects((File)((Object)entry2), hashMap, (File)serializable);
            } else {
                for (serializable = ((File)((Object)entry2)).getParentFile(); serializable != null; serializable = ((File)serializable).getParentFile()) {
                    if (!this.isProjectDir((File)serializable)) continue;
                    this.registerProjectFile(hashMap, (File)((Object)entry2), (File)serializable, (File)serializable);
                    break;
                }
            }
            if (!this.mCanceled) continue;
            return Collections.emptySet();
        }
        for (Map.Entry entry2 : hashMap.entrySet()) {
            serializable = (File)entry2.getKey();
            if (((File)serializable).equals(((Project)(object2 = (Project)entry2.getValue())).getDir())) continue;
            if (((File)serializable).isDirectory()) {
                try {
                    iterator = ((File)serializable).getCanonicalFile();
                    if (((File)((Object)iterator)).equals(((Project)object2).getDir())) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ((Project)object2).addFile((File)serializable);
        }
        object3 = hashMap.values();
        entry2 = new HashSet(object3);
        serializable = object3.iterator();
        while (serializable.hasNext()) {
            object2 = (Project)serializable.next();
            entry2.removeAll(((Project)object2).getAllLibraries());
        }
        if (LintUtils.assertionsEnabled()) {
            serializable = new IdentityHashMap<Object, Object>();
            object2 = entry2.iterator();
            while (object2.hasNext()) {
                iterator = (Project)object2.next();
                serializable.put(iterator, iterator);
                for (Project project : ((Project)((Object)iterator)).getAllLibraries()) {
                    serializable.put(project, project);
                }
            }
            object2 = new HashSet();
            for (Object object4 : serializable.keySet()) {
                assert (!object2.contains(((Project)object4).getDir()));
                object2.add(((Project)object4).getDir());
            }
        }
        return entry2;
    }

    private void addProjects(File file, Map<File, Project> map, File file2) {
        if (this.mCanceled) {
            return;
        }
        if (this.isProjectDir(file)) {
            this.registerProjectFile(map, file, file, file2);
        } else {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    if (!file3.isDirectory()) continue;
                    this.addProjects(file3, map, file2);
                }
            }
        }
    }

    private boolean isProjectDir(File file) {
        return new File(file, "AndroidManifest.xml").exists();
    }

    private void checkProject(Project project) {
        File file = project.getDir();
        Context context = new Context(this, project, null, file);
        this.fireEvent(LintListener.EventType.SCANNING_PROJECT, context);
        List<Project> list = project.getAllLibraries();
        HashSet<Project> hashSet = new HashSet<Project>(list.size() + 1);
        hashSet.add(project);
        hashSet.addAll(list);
        this.mCurrentProjects = hashSet.toArray(new Project[hashSet.size()]);
        for (Detector object : this.mApplicableDetectors) {
            object.beforeCheckProject(context);
            if (!this.mCanceled) continue;
            return;
        }
        this.runFileDetectors(project, project);
        if (!Scope.checkSingleFile(this.mScope)) {
            Iterator<? extends Detector> iterator = project.getDirectLibraries();
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                Project project2 = (Project)iterator2.next();
                Context context2 = new Context(this, project2, project, file);
                this.fireEvent(LintListener.EventType.SCANNING_LIBRARY_PROJECT, context2);
                for (Detector detector : this.mApplicableDetectors) {
                    detector.beforeCheckLibraryProject(context2);
                    if (!this.mCanceled) continue;
                    return;
                }
                this.runFileDetectors(project2, project);
                if (this.mCanceled) {
                    return;
                }
                for (Detector detector : this.mApplicableDetectors) {
                    detector.afterCheckLibraryProject(context2);
                    if (!this.mCanceled) continue;
                    return;
                }
            }
        }
        for (Detector detector : this.mApplicableDetectors) {
            detector.afterCheckProject(context);
            if (!this.mCanceled) continue;
            return;
        }
        if (this.mCanceled) {
            this.mClient.report(context, Issue.create("Lint", "", "", Category.PERFORMANCE, 0, Severity.INFORMATIONAL, null, EnumSet.noneOf(Scope.class)), Severity.INFORMATIONAL, null, "Lint canceled by user", null);
        }
        this.mCurrentProjects = null;
    }

    private void runFileDetectors(Project project, Project project2) {
        Object object;
        List<File> list;
        List<Detector> list2;
        File file = project.getManifestFile();
        if (file != null) {
            list2 = new XmlContext(this, project, project2, file, null);
            list = this.mClient.getDomParser();
            ((XmlContext)((Object)list2)).document = list.parseXml((XmlContext)((Object)list2));
            if (((XmlContext)((Object)list2)).document != null) {
                project.readManifest(((XmlContext)((Object)list2)).document);
                if (!project.isLibrary() && this.mScope.contains((Object)Scope.MANIFEST) && (object = this.mScopeDetectors.get((Object)Scope.MANIFEST)) != null) {
                    XmlVisitor object2 = new XmlVisitor((IDomParser)((Object)list), (List<? extends Detector>)object);
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, (Context)((Object)list2));
                    object2.visitFile((XmlContext)((Object)list2), file);
                }
            }
        }
        if ((this.mScope.contains((Object)Scope.ALL_RESOURCE_FILES) || this.mScope.contains((Object)Scope.RESOURCE_FILE)) && (list2 = LintDriver.union(this.mScopeDetectors.get((Object)Scope.RESOURCE_FILE), this.mScopeDetectors.get((Object)Scope.ALL_RESOURCE_FILES))) != null && list2.size() > 0) {
            list = new ArrayList(list2.size());
            for (Detector detector : list2) {
                if (!(detector instanceof ResourceXmlDetector)) continue;
                list.add((File)((Object)((ResourceXmlDetector)detector)));
            }
            if (list.size() > 0) {
                if (project.getSubset() != null) {
                    this.checkIndividualResources(project, project2, list, project.getSubset());
                } else {
                    object = new File(project.getDir(), "res");
                    if (((File)object).exists() && list.size() > 0) {
                        this.checkResFolder(project, project2, (File)object, list);
                    }
                }
            }
        }
        if (this.mCanceled) {
            return;
        }
        if ((this.mScope.contains((Object)Scope.JAVA_FILE) || this.mScope.contains((Object)Scope.ALL_JAVA_FILES)) && (list2 = LintDriver.union(this.mScopeDetectors.get((Object)Scope.JAVA_FILE), this.mScopeDetectors.get((Object)Scope.ALL_JAVA_FILES))) != null && list2.size() > 0) {
            list = project.getJavaSourceFolders();
            this.checkJava(project, project2, list, list2);
        }
        if (this.mCanceled) {
            return;
        }
        this.checkClasses(project, project2);
        if (this.mCanceled) {
            return;
        }
        if (project == project2 && this.mScope.contains((Object)Scope.PROGUARD_FILE)) {
            this.checkProGuard(project, project2);
        }
    }

    private void checkProGuard(Project project, Project project2) {
        List<Detector> list = this.mScopeDetectors.get((Object)Scope.PROGUARD_FILE);
        if (list != null) {
            Object object;
            Project project3 = project2 != null ? project2 : project;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string = project3.getProguardPath();
            if (string != null) {
                object = Splitter.on(CharMatcher.anyOf(":;"));
                for (String object2 : ((Splitter)object).split(string)) {
                    if (object2.contains("${")) continue;
                    Object object3 = new File(object2);
                    if (!((File)object3).isAbsolute()) {
                        object3 = new File(project.getDir(), object2);
                    }
                    if (!((File)object3).exists()) continue;
                    arrayList.add(object3);
                }
            }
            if (arrayList.isEmpty()) {
                object = new File(project.getDir(), "proguard.cfg");
                if (((File)object).exists()) {
                    arrayList.add(object);
                }
                if (((File)(object = new File(project.getDir(), "proguard-project.txt"))).exists()) {
                    arrayList.add(object);
                }
            }
            for (Object object4 : arrayList) {
                Context context = new Context(this, project, project2, (File)object4);
                this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                for (Detector detector : list) {
                    if (!detector.appliesTo(context, (File)object4)) continue;
                    detector.beforeCheckFile(context);
                    detector.run(context);
                    detector.afterCheckFile(context);
                }
            }
        }
    }

    public String getSuperClass(String string) {
        if (this.mSuperClassMap == null) {
            throw new IllegalStateException("Only callable during ClassScanner#checkClass");
        }
        assert (string.indexOf(46) == -1) : "Use VM signatures, e.g. java/lang/Integer";
        return this.mSuperClassMap.get(string);
    }

    private static List<Detector> union(List<Detector> list, List<Detector> list2) {
        if (list == null) {
            return list2;
        }
        if (list2 == null) {
            return list;
        }
        HashSet<Detector> hashSet = new HashSet<Detector>(list.size() + list2.size());
        if (list != null) {
            hashSet.addAll(list);
        }
        if (list2 != null) {
            hashSet.addAll(list2);
        }
        return new ArrayList<Detector>(hashSet);
    }

    private void checkClasses(Project project, Project project2) {
        List<ClassEntry> list;
        List<ClassEntry> list2;
        if (!this.mScope.contains((Object)Scope.CLASS_FILE) && !this.mScope.contains((Object)Scope.JAVA_LIBRARIES)) {
            return;
        }
        List<File> list3 = project.getJavaLibraries();
        if (list3.size() > 0) {
            list2 = new ArrayList(64);
            this.findClasses(list2, list3);
            Collections.sort(list2);
        } else {
            list2 = Collections.emptyList();
        }
        List<File> list4 = project.getJavaClassFolders();
        if (list4.size() == 0) {
            String string = String.format("No .class files were found in project \"%1$s\", so none of the classfile based checks could be run. Does the project need to be built first?", project.getName());
            Location location = Location.create(project.getDir());
            this.mClient.report(new Context(this, project, project2, project.getDir()), IssueRegistry.LINT_ERROR, project.getConfiguration().getSeverity(IssueRegistry.LINT_ERROR), location, string, null);
            list = Collections.emptyList();
        } else {
            list = new ArrayList<ClassEntry>(64);
            this.findClasses(list, list4);
            Collections.sort(list);
        }
        if (this.getPhase() == 1) {
            this.mSuperClassMap = this.getSuperMap(list2, list);
        }
        this.runClassDetectors(Scope.JAVA_LIBRARIES, list2, project, project2);
        if (this.mCanceled) {
            return;
        }
        this.runClassDetectors(Scope.CLASS_FILE, list, project, project2);
    }

    private void runClassDetectors(Scope scope, List<ClassEntry> list, Project project, Project project2) {
        List<Detector> list2;
        if (this.mScope.contains((Object)scope) && (list2 = this.mScopeDetectors.get((Object)scope)) != null && list2.size() > 0 && list.size() > 0) {
            this.mOuterClasses = new ArrayDeque<ClassNode>();
            for (ClassEntry classEntry : list) {
                ClassNode classNode;
                ClassReader classReader = new ClassReader(classEntry.bytes);
                ClassNode classNode2 = new ClassNode();
                classReader.accept(classNode2, 0);
                while ((classNode = this.mOuterClasses.peek()) != null && !classNode2.name.startsWith(classNode.name)) {
                    this.mOuterClasses.pop();
                }
                this.mOuterClasses.push(classNode2);
                if (this.isSuppressed(null, classNode2)) continue;
                ClassContext classContext = new ClassContext(this, project, project2, classEntry.file, classEntry.jarFile, classEntry.binDir, classEntry.bytes, classNode2, scope == Scope.JAVA_LIBRARIES);
                this.runClassDetectors(classContext, list2);
                if (!this.mCanceled) continue;
                return;
            }
            this.mOuterClasses = null;
        }
    }

    public ClassNode getOuterClassNode(ClassNode classNode) {
        String string = classNode.outerClass;
        Iterator<ClassNode> iterator = this.mOuterClasses.iterator();
        while (iterator.hasNext()) {
            ClassNode classNode2 = iterator.next();
            if (string != null) {
                if (!classNode2.name.equals(string)) continue;
                return classNode2;
            }
            if (classNode2 != classNode) continue;
            return iterator.hasNext() ? iterator.next() : null;
        }
        return null;
    }

    private Map<String, String> getSuperMap(List<ClassEntry> list, List<ClassEntry> list2) {
        int n = list.size() + list2.size();
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        SuperclassVisitor superclassVisitor = new SuperclassVisitor(hashMap);
        this.addSuperClasses(superclassVisitor, list);
        this.addSuperClasses(superclassVisitor, list2);
        return hashMap;
    }

    private void addSuperClasses(SuperclassVisitor superclassVisitor, List<ClassEntry> list) {
        for (ClassEntry classEntry : list) {
            ClassReader classReader = new ClassReader(classEntry.bytes);
            int n = 7;
            classReader.accept(superclassVisitor, n);
        }
    }

    private void findClasses(List<ClassEntry> list, List<File> list2) {
        for (File file : list2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            File file2;
            if (file.getName().endsWith(".jar")) {
                file2 = file;
                try {
                    object4 = new FileInputStream(file2);
                    object3 = new ZipInputStream((InputStream)object4);
                    object2 = ((ZipInputStream)object3).getNextEntry();
                    while (object2 != null) {
                        block13: {
                            object = ((ZipEntry)object2).getName();
                            if (((String)object).endsWith(".class")) {
                                try {
                                    byte[] byArray = ByteStreams.toByteArray((InputStream)object3);
                                    if (byArray == null) break block13;
                                    File file3 = new File(((ZipEntry)object2).getName());
                                    list.add(new ClassEntry(file3, file2, file2, byArray));
                                }
                                catch (Exception exception) {
                                    this.mClient.log(exception, null, new Object[0]);
                                    continue;
                                }
                            }
                        }
                        if (this.mCanceled) {
                            return;
                        }
                        object2 = ((ZipInputStream)object3).getNextEntry();
                    }
                    continue;
                }
                catch (IOException iOException) {
                    this.mClient.log(iOException, "Could not read jar file contents from %1$s", file2);
                    continue;
                }
            }
            if (file.isDirectory()) {
                file2 = file;
                object4 = new ArrayList();
                this.addClassFiles(file2, (List<File>)object4);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    block14: {
                        object2 = (File)object3.next();
                        try {
                            object = Files.toByteArray((File)object2);
                            if (object == null) break block14;
                            list.add(new ClassEntry((File)object2, null, file2, (byte[])object));
                        }
                        catch (IOException iOException) {
                            this.mClient.log(iOException, null, new Object[0]);
                            continue;
                        }
                    }
                    if (!this.mCanceled) continue;
                    return;
                }
                continue;
            }
            this.mClient.log(null, "Ignoring class path entry %1$s", file);
        }
    }

    private void runClassDetectors(ClassContext classContext, List<Detector> list) {
        try {
            File file = classContext.file;
            ClassNode classNode = classContext.getClassNode();
            for (Detector detector : list) {
                if (detector.appliesTo(classContext, file)) {
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, classContext);
                    detector.beforeCheckFile(classContext);
                    Detector.ClassScanner classScanner = (Detector.ClassScanner)((Object)detector);
                    classScanner.checkClass(classContext, classNode);
                    detector.afterCheckFile(classContext);
                }
                if (!this.mCanceled) continue;
                return;
            }
        }
        catch (Exception exception) {
            this.mClient.log(exception, null, new Object[0]);
        }
    }

    private void addClassFiles(File file, List<File> list) {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (file2.isFile() && file2.getName().endsWith(".class")) {
                    list.add(file2);
                    continue;
                }
                if (!file2.isDirectory()) continue;
                this.addClassFiles(file2, list);
            }
        }
    }

    private void checkJava(Project project, Project project2, List<File> list, List<Detector> list2) {
        IJavaParser iJavaParser = this.mClient.getJavaParser();
        if (iJavaParser == null) {
            this.mClient.log(null, "No java parser provided to lint: not running Java checks", new Object[0]);
            return;
        }
        assert (list2.size() > 0);
        ArrayList<File> arrayList = new ArrayList<File>(100);
        for (File object : list) {
            this.gatherJavaFiles(object, arrayList);
        }
        if (arrayList.size() > 0) {
            JavaVisitor javaVisitor = new JavaVisitor(iJavaParser, list2);
            for (File file : arrayList) {
                JavaContext javaContext = new JavaContext(this, project, project2, file);
                this.fireEvent(LintListener.EventType.SCANNING_FILE, javaContext);
                javaVisitor.visitFile(javaContext, file);
                if (!this.mCanceled) continue;
                return;
            }
        }
    }

    private void gatherJavaFiles(File file, List<File> list) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isFile() && file2.getName().endsWith(".java")) {
                    list.add(file2);
                    continue;
                }
                if (!file2.isDirectory()) continue;
                this.gatherJavaFiles(file2, list);
            }
        }
    }

    private XmlVisitor getVisitor(ResourceFolderType resourceFolderType, List<ResourceXmlDetector> list) {
        if (resourceFolderType != this.mCurrentFolderType) {
            this.mCurrentFolderType = resourceFolderType;
            ArrayList<ResourceXmlDetector> arrayList = new ArrayList<ResourceXmlDetector>(list.size());
            for (ResourceXmlDetector resourceXmlDetector : list) {
                if (!resourceXmlDetector.appliesTo(resourceFolderType)) continue;
                arrayList.add(resourceXmlDetector);
            }
            if (this.mCurrentXmlDetectors != null && ((Object)this.mCurrentXmlDetectors).equals(arrayList)) {
                return this.mCurrentVisitor;
            }
            if (arrayList.size() == 0) {
                this.mCurrentVisitor = null;
                return null;
            }
            this.mCurrentVisitor = new XmlVisitor(this.mClient.getDomParser(), arrayList);
        }
        return this.mCurrentVisitor;
    }

    private void checkResFolder(Project project, Project project2, File file, List<ResourceXmlDetector> list) {
        assert (file.isDirectory());
        Object[] objectArray = file.listFiles();
        if (objectArray == null) {
            return;
        }
        Arrays.sort(objectArray);
        ResourceFolderType resourceFolderType = null;
        for (Object object : objectArray) {
            resourceFolderType = ResourceFolderType.getFolderType((String)((File)object).getName());
            if (resourceFolderType != null) {
                this.checkResourceFolder(project, project2, (File)object, resourceFolderType, list);
            }
            if (!this.mCanceled) continue;
            return;
        }
    }

    private void checkResourceFolder(Project project, Project project2, File file, ResourceFolderType resourceFolderType, List<ResourceXmlDetector> list) {
        XmlVisitor xmlVisitor;
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0 && (xmlVisitor = this.getVisitor(resourceFolderType, list)) != null) {
            for (File file2 : fileArray) {
                if (!LintUtils.isXmlFile(file2)) continue;
                XmlContext xmlContext = new XmlContext(this, project, project2, file2, resourceFolderType);
                this.fireEvent(LintListener.EventType.SCANNING_FILE, xmlContext);
                xmlVisitor.visitFile(xmlContext, file2);
                if (!this.mCanceled) continue;
                return;
            }
        }
    }

    private void checkIndividualResources(Project project, Project project2, List<ResourceXmlDetector> list, List<File> list2) {
        for (File file : list2) {
            XmlVisitor xmlVisitor;
            ResourceFolderType resourceFolderType;
            Object object;
            if (file.isDirectory()) {
                object = ResourceFolderType.getFolderType((String)file.getName());
                if (object != null && new File(file.getParentFile(), "res").exists()) {
                    this.checkResourceFolder(project, project2, file, (ResourceFolderType)object, list);
                    continue;
                }
                if (file.getName().equals("res")) {
                    this.checkResFolder(project, project2, file, list);
                    continue;
                }
                this.mClient.log(null, "Unexpected folder %1$s; should be project, \"res\" folder or resource folder", file.getPath());
                continue;
            }
            if (!file.isFile() || !LintUtils.isXmlFile(file) || (resourceFolderType = ResourceFolderType.getFolderType((String)(object = file.getParentFile().getName()))) == null || (xmlVisitor = this.getVisitor(resourceFolderType, list)) == null) continue;
            XmlContext xmlContext = new XmlContext(this, project, project2, file, resourceFolderType);
            this.fireEvent(LintListener.EventType.SCANNING_FILE, xmlContext);
            xmlVisitor.visitFile(xmlContext, file);
        }
    }

    public void addLintListener(LintListener lintListener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<LintListener>(1);
        }
        this.mListeners.add(lintListener);
    }

    public void removeLintListener(LintListener lintListener) {
        this.mListeners.remove(lintListener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
    }

    private void fireEvent(LintListener.EventType eventType, Context context) {
        if (this.mListeners != null) {
            int n = this.mListeners.size();
            for (int i = 0; i < n; ++i) {
                LintListener lintListener = this.mListeners.get(i);
                lintListener.update(this, eventType, context);
            }
        }
    }

    public void requestRepeat(Detector detector, EnumSet<Scope> enumSet) {
        if (this.mRepeatingDetectors == null) {
            this.mRepeatingDetectors = new ArrayList<Detector>();
        }
        this.mRepeatingDetectors.add(detector);
        if (enumSet != null) {
            if (this.mRepeatScope == null) {
                this.mRepeatScope = enumSet;
            } else {
                this.mRepeatScope = EnumSet.copyOf(this.mRepeatScope);
                this.mRepeatScope.addAll(enumSet);
            }
        } else {
            this.mRepeatScope = Scope.ALL;
        }
    }

    public boolean isSuppressed(Issue issue, MethodNode methodNode) {
        if (methodNode.invisibleAnnotations != null) {
            List list = methodNode.invisibleAnnotations;
            return this.isSuppressed(issue, list);
        }
        return false;
    }

    public boolean isSuppressed(Issue issue, FieldNode fieldNode) {
        if (fieldNode.invisibleAnnotations != null) {
            List list = fieldNode.invisibleAnnotations;
            return this.isSuppressed(issue, list);
        }
        return false;
    }

    public boolean isSuppressed(Issue issue, ClassNode classNode) {
        if (classNode.invisibleAnnotations != null) {
            List list = classNode.invisibleAnnotations;
            return this.isSuppressed(issue, list);
        }
        return false;
    }

    private boolean isSuppressed(Issue issue, List<AnnotationNode> list) {
        for (AnnotationNode annotationNode : list) {
            String string = annotationNode.desc;
            if (!string.endsWith(SUPPRESS_LINT_VMSIG) || annotationNode.values == null) continue;
            int n = annotationNode.values.size();
            for (int i = 0; i < n; i += 2) {
                Object object;
                String string2 = (String)annotationNode.values.get(i);
                if (!string2.equals("value")) continue;
                Object e = annotationNode.values.get(i + 1);
                if (e instanceof String) {
                    object = (String)e;
                    if (!((String)object).equalsIgnoreCase("all") && (issue == null || !((String)object).equalsIgnoreCase(issue.getId()))) continue;
                    return true;
                }
                if (!(e instanceof List)) continue;
                object = (List)e;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    Object e2 = iterator.next();
                    if (!(e2 instanceof String) || !(string3 = (String)e2).equalsIgnoreCase("all") && (issue == null || !string3.equalsIgnoreCase(issue.getId()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSuppressed(Issue issue, Node node) {
        while (node != null) {
            VariableDefinition variableDefinition;
            Class<?> clazz = node.getClass();
            if (clazz == VariableDefinition.class ? LintDriver.isSuppressed(issue, (variableDefinition = (VariableDefinition)node).astModifiers()) : (clazz == MethodDeclaration.class ? LintDriver.isSuppressed(issue, (variableDefinition = (MethodDeclaration)node).astModifiers()) : clazz == ClassDeclaration.class && LintDriver.isSuppressed(issue, (variableDefinition = (ClassDeclaration)node).astModifiers()))) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static boolean isSuppressed(Issue issue, Modifiers modifiers) {
        if (modifiers == null) {
            return false;
        }
        StrictListAccessor strictListAccessor = modifiers.astAnnotations();
        if (strictListAccessor == null) {
            return false;
        }
        for (Annotation annotation : strictListAccessor) {
            StrictListAccessor strictListAccessor2;
            TypeReference typeReference = annotation.astAnnotationTypeReference();
            String string = typeReference.getTypeName();
            if (!string.endsWith("SuppressLint") && !string.endsWith("SuppressWarnings") || (strictListAccessor2 = annotation.astElements()) == null) continue;
            for (AnnotationElement annotationElement : strictListAccessor2) {
                String string2;
                StringLiteral stringLiteral;
                AnnotationValue annotationValue = annotationElement.astValue();
                if (annotationValue == null) continue;
                if (annotationValue instanceof StringLiteral) {
                    stringLiteral = (StringLiteral)annotationValue;
                    string2 = stringLiteral.astValue();
                    if (!string2.equalsIgnoreCase("all") && (issue == null || !issue.getId().equalsIgnoreCase(string2))) continue;
                    return true;
                }
                if (!(annotationValue instanceof ArrayInitializer) || (string2 = (stringLiteral = (ArrayInitializer)annotationValue).astExpressions()) == null) continue;
                Iterator iterator = string2.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    Expression expression = (Expression)iterator.next();
                    if (!(expression instanceof StringLiteral) || !(string3 = ((StringLiteral)expression).astValue()).equalsIgnoreCase("all") && (issue == null || !issue.getId().equalsIgnoreCase(string3))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSuppressed(Issue issue, org.w3c.dom.Node node) {
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        while (node != null) {
            Element element;
            if (node.getNodeType() == 1 && (element = (Element)node).hasAttributeNS("http://schemas.android.com/tools", "ignore")) {
                String string = element.getAttributeNS("http://schemas.android.com/tools", "ignore");
                if (string.indexOf(44) == -1) {
                    if (string.equalsIgnoreCase("all") || issue != null && issue.getId().equalsIgnoreCase(string)) {
                        return true;
                    }
                } else {
                    for (String string2 : string.split(",")) {
                        if (!string2.equalsIgnoreCase("all") && (issue == null || !issue.getId().equalsIgnoreCase(string2))) continue;
                        return true;
                    }
                }
            }
            node = node.getParentNode();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassEntry
    implements Comparable<ClassEntry> {
        public final File file;
        public final File jarFile;
        public final File binDir;
        public final byte[] bytes;

        public ClassEntry(File file, File file2, File file3, byte[] byArray) {
            this.file = file;
            this.jarFile = file2;
            this.binDir = file3;
            this.bytes = byArray;
        }

        @Override
        public int compareTo(ClassEntry classEntry) {
            String string = this.file.getPath();
            String string2 = classEntry.file.getPath();
            int n = string.length();
            int n2 = string2.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = string.charAt(i);
                if (c2 == (c = string2.charAt(i))) continue;
                if (c2 == '.' && c == '$') {
                    return -1;
                }
                if (c2 == '$' && c == '.') {
                    return 1;
                }
                return c2 - c;
            }
            return n3 == n ? -1 : 1;
        }

        public String toString() {
            return this.file.getPath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LintClientWrapper
    extends LintClient {
        private final LintClient mDelegate;

        public LintClientWrapper(LintClient lintClient) {
            this.mDelegate = lintClient;
        }

        @Override
        public void report(Context context, Issue issue, Severity severity, Location location, String string, Object object) {
            Configuration configuration = context.getConfiguration();
            if (!configuration.isEnabled(issue)) {
                if (issue != IssueRegistry.PARSER_ERROR && issue != IssueRegistry.LINT_ERROR) {
                    this.mDelegate.log(null, "Incorrect detector reported disabled issue %1$s", issue.toString());
                }
                return;
            }
            if (configuration.isIgnored(context, issue, location, string, object)) {
                return;
            }
            if (severity == Severity.IGNORE) {
                return;
            }
            this.mDelegate.report(context, issue, severity, location, string, object);
        }

        @Override
        public Configuration getConfiguration(Project project) {
            return this.mDelegate.getConfiguration(project);
        }

        @Override
        public void log(Severity severity, Throwable throwable, String string, Object ... objectArray) {
            this.mDelegate.log(throwable, string, objectArray);
        }

        @Override
        public String readFile(File file) {
            return this.mDelegate.readFile(file);
        }

        @Override
        public List<File> getJavaSourceFolders(Project project) {
            return this.mDelegate.getJavaSourceFolders(project);
        }

        @Override
        public List<File> getJavaClassFolders(Project project) {
            return this.mDelegate.getJavaClassFolders(project);
        }

        @Override
        public List<File> getJavaLibraries(Project project) {
            return this.mDelegate.getJavaLibraries(project);
        }

        @Override
        public IDomParser getDomParser() {
            return this.mDelegate.getDomParser();
        }

        @Override
        public Class<? extends Detector> replaceDetector(Class<? extends Detector> clazz) {
            return this.mDelegate.replaceDetector(clazz);
        }

        @Override
        public SdkInfo getSdkInfo(Project project) {
            return this.mDelegate.getSdkInfo(project);
        }

        @Override
        public Project getProject(File file, File file2) {
            return this.mDelegate.getProject(file, file2);
        }

        @Override
        public IJavaParser getJavaParser() {
            return this.mDelegate.getJavaParser();
        }

        @Override
        public File findResource(String string) {
            return this.mDelegate.findResource(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuperclassVisitor
    extends ClassVisitor {
        private final Map<String, String> mMap;

        public SuperclassVisitor(Map<String, String> map) {
            super(262144);
            this.mMap = map;
        }

        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            if (string3 != null) {
                this.mMap.put(string, string3);
            }
        }
    }
}

