/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

@Beta
public class ClassContext
extends Context {
    private final File mBinDir;
    private ClassNode mClassNode;
    private byte[] mBytes;
    private File mSourceFile;
    private String mSourceContents;
    private boolean mSearchedForSource;
    private final File mJarFile;
    private final boolean mFromLibrary;

    public ClassContext(LintDriver lintDriver, Project project, Project project2, File file, File file2, File file3, byte[] byArray, ClassNode classNode, boolean bl) {
        super(lintDriver, project, project2, file);
        this.mJarFile = file2;
        this.mBinDir = file3;
        this.mBytes = byArray;
        this.mClassNode = classNode;
        this.mFromLibrary = bl;
    }

    public byte[] getBytecode() {
        return this.mBytes;
    }

    public ClassNode getClassNode() {
        return this.mClassNode;
    }

    public File getJarFile() {
        return this.mJarFile;
    }

    public boolean isFromClassLibrary() {
        return this.mFromLibrary;
    }

    public File getSourceFile() {
        block9: {
            if (this.mSourceFile != null || this.mSearchedForSource) break block9;
            this.mSearchedForSource = true;
            String string = this.mClassNode.sourceFile;
            if (string == null) {
                int n;
                string = this.file.getName();
                if (string.endsWith(".class")) {
                    string = string.substring(0, string.length() - ".class".length()) + ".java";
                }
                if ((n = string.indexOf(36)) != -1) {
                    string = string.substring(0, n) + ".java";
                }
            }
            if (string != null) {
                if (this.mJarFile != null) {
                    String string2 = this.file.getParent() + File.separator + string;
                    List<File> list = this.getProject().getJavaSourceFolders();
                    for (File file : list) {
                        File file2 = new File(file, string2);
                        if (!file2.exists()) continue;
                        this.mSourceFile = file2;
                        break;
                    }
                } else {
                    String string3 = this.mBinDir.getPath();
                    String string4 = this.file.getParentFile().getPath();
                    if (string4.startsWith(string3)) {
                        String string5 = string4.substring(string3.length() + 1);
                        List<File> list = this.getProject().getJavaSourceFolders();
                        for (File file : list) {
                            File file3 = new File(file, string5 + File.separator + string);
                            if (!file3.exists()) continue;
                            this.mSourceFile = file3;
                            break;
                        }
                    }
                }
            }
        }
        return this.mSourceFile;
    }

    public String getSourceContents() {
        if (this.mSourceContents == null) {
            File file = this.getSourceFile();
            if (file != null) {
                this.mSourceContents = this.getClient().readFile(this.mSourceFile);
            }
            if (this.mSourceContents == null) {
                this.mSourceContents = "";
            }
        }
        return this.mSourceContents;
    }

    public Location getLocationForLine(int n, String string, String string2) {
        File file = this.getSourceFile();
        if (file != null) {
            if (n != -1) {
                return Location.create(file, this.getSourceContents(), n - 1, string, string2);
            }
            return Location.create(file);
        }
        return Location.create(this.file);
    }

    public void report(Issue issue, Location location, String string, Object object) {
        if (this.mDriver.isSuppressed(issue, this.mClassNode)) {
            return;
        }
        ClassNode classNode = this.mClassNode;
        while (classNode != null) {
            ClassNode classNode2 = classNode;
            if ((classNode = this.mDriver.getOuterClassNode(classNode)) == null) continue;
            if (classNode2.outerMethod != null) {
                List list = classNode.methods;
                for (Object e : list) {
                    MethodNode methodNode = (MethodNode)e;
                    if (!methodNode.name.equals(classNode2.outerMethod) || !methodNode.desc.equals(classNode2.outerMethodDesc)) continue;
                    if (methodNode == null || !this.mDriver.isSuppressed(issue, methodNode)) break;
                    return;
                }
            }
            if (!this.mDriver.isSuppressed(issue, classNode)) continue;
            return;
        }
        super.report(issue, location, string, object);
    }

    public void report(Issue issue, MethodNode methodNode, Location location, String string, Object object) {
        if (methodNode != null && this.mDriver.isSuppressed(issue, methodNode)) {
            return;
        }
        this.report(issue, location, string, object);
    }

    public void report(Issue issue, FieldNode fieldNode, Location location, String string, Object object) {
        if (fieldNode != null && this.mDriver.isSuppressed(issue, fieldNode)) {
            return;
        }
        this.report(issue, location, string, object);
    }

    public static int findLineNumber(AbstractInsnNode abstractInsnNode) {
        AbstractInsnNode abstractInsnNode2;
        for (abstractInsnNode2 = abstractInsnNode; abstractInsnNode2 != null; abstractInsnNode2 = abstractInsnNode2.getPrevious()) {
            if (abstractInsnNode2.getType() != 15) continue;
            return ((LineNumberNode)abstractInsnNode2).line;
        }
        for (abstractInsnNode2 = abstractInsnNode; abstractInsnNode2 != null; abstractInsnNode2 = abstractInsnNode2.getNext()) {
            if (abstractInsnNode2.getType() != 15) continue;
            return ((LineNumberNode)abstractInsnNode2).line;
        }
        return -1;
    }

    public static int findLineNumber(MethodNode methodNode) {
        if (methodNode.instructions != null && methodNode.instructions.size() > 0) {
            return ClassContext.findLineNumber(methodNode.instructions.get(0));
        }
        return -1;
    }

    public static String createSignature(String string, String string2, String string3) {
        Type[] typeArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (string3 != null) {
            typeArray = Type.getReturnType(string3);
            stringBuilder.append(ClassContext.getTypeString((Type)typeArray));
            stringBuilder.append(' ');
        }
        if (string != null) {
            stringBuilder.append(string.replace('/', '.').replace('$', '.'));
        }
        if (string2 != null) {
            stringBuilder.append('#');
            stringBuilder.append(string2);
            if (string3 != null && (typeArray = Type.getArgumentTypes(string3)) != null && typeArray.length > 0) {
                stringBuilder.append('(');
                boolean bl = true;
                for (Type type : typeArray) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(ClassContext.getTypeString(type));
                }
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    private static String getTypeString(Type type) {
        String string = type.getClassName();
        if (string.startsWith("java.lang.")) {
            string = string.substring("java.lang.".length());
        }
        return string;
    }

    public static String getInternalName(String string) {
        String[] stringArray = string.split("\\.");
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 != null) {
                if (Character.isUpperCase(string2.charAt(0))) {
                    stringBuilder.append('$');
                } else {
                    stringBuilder.append('/');
                }
            }
            stringBuilder.append(string3);
            string2 = string3;
        }
        return stringBuilder.toString();
    }
}

