/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class Context {
    public final File file;
    protected final LintDriver mDriver;
    private final Project mProject;
    private final Project mMainProject;
    private final Configuration mConfiguration;
    private String mContents;
    public final AtomicBoolean canceled = new AtomicBoolean();
    private Map<String, Object> mProperties;

    public Context(LintDriver lintDriver, Project project, Project project2, File file) {
        this.file = file;
        this.mDriver = lintDriver;
        this.mProject = project;
        this.mMainProject = project2;
        this.mConfiguration = project.getConfiguration();
    }

    public EnumSet<Scope> getScope() {
        return this.mDriver.getScope();
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public Project getProject() {
        return this.mProject;
    }

    public Project getMainProject() {
        return this.mMainProject != null ? this.mMainProject : this.mProject;
    }

    public LintClient getClient() {
        return this.mDriver.getClient();
    }

    public LintDriver getDriver() {
        return this.mDriver;
    }

    public String getContents() {
        if (this.mContents == null) {
            this.mContents = this.mDriver.getClient().readFile(this.file);
        }
        return this.mContents;
    }

    public Object getProperty(String string) {
        if (this.mProperties == null) {
            return null;
        }
        return this.mProperties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            if (this.mProperties != null) {
                this.mProperties.remove(string);
            }
        } else {
            if (this.mProperties == null) {
                this.mProperties = new HashMap<String, Object>();
            }
            this.mProperties.put(string, object);
        }
    }

    public SdkInfo getSdkInfo() {
        return this.mProject.getSdkInfo();
    }

    public boolean isEnabled(Issue issue) {
        return this.mConfiguration.isEnabled(issue);
    }

    public void report(Issue issue, Location location, String string, Object object) {
        Object object2;
        Configuration configuration = this.mConfiguration;
        if (location != null && location.getFile() != null && (object2 = this.mDriver.findProjectFor(location.getFile())) != null) {
            configuration = ((Project)object2).getConfiguration();
        }
        if (configuration != this.mConfiguration && this.mConfiguration.getSeverity(issue) == Severity.IGNORE) {
            return;
        }
        object2 = configuration.getSeverity(issue);
        if (object2 == Severity.IGNORE) {
            return;
        }
        this.mDriver.getClient().report(this, issue, (Severity)((Object)object2), location, string, object);
    }

    public void log(Throwable throwable, String string, Object ... objectArray) {
        this.mDriver.getClient().log(throwable, string, objectArray);
    }

    public int getPhase() {
        return this.mDriver.getPhase();
    }

    public void requestRepeat(Detector detector, EnumSet<Scope> enumSet) {
        this.mDriver.requestRepeat(detector, enumSet);
    }
}

