/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.util.PositionXmlParser;
import com.google.common.annotations.Beta;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class LintUtils {
    private static final String UTF_8 = "UTF-8";
    private static final String UTF_16 = "UTF_16";
    private static final String UTF_16LE = "UTF_16LE";

    public static String formatList(List<String> list, int n) {
        StringBuilder stringBuilder = new StringBuilder(20 * list.size());
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(list.get(i));
            if (n <= 0 || i != n - 1 || n2 <= n) continue;
            stringBuilder.append(String.format("... (%1$d more)", n2 - i - 1));
            break;
        }
        return stringBuilder.toString();
    }

    public static boolean isFileBasedResourceType(ResourceType resourceType) {
        List list = FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType);
        for (ResourceFolderType resourceFolderType : list) {
            if (resourceFolderType == ResourceFolderType.VALUES) continue;
            return resourceType != ResourceType.ID;
        }
        return false;
    }

    public static boolean isXmlFile(File file) {
        String string = file.getName();
        return string.regionMatches(true, string.length() - ".xml".length(), ".xml", 0, ".xml".length());
    }

    public static boolean endsWith(String string, String string2) {
        return string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
    }

    public static boolean startsWith(String string, String string2, int n) {
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    public static String getBaseName(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static List<Element> getChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            arrayList.add((Element)node2);
        }
        return arrayList;
    }

    public static int getChildCount(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            ++n;
        }
        return n;
    }

    public static boolean isRootElement(Element element) {
        return element == element.getOwnerDocument().getDocumentElement();
    }

    public static String stripIdPrefix(String string) {
        if (string == null) {
            return "";
        }
        if (string.startsWith("@+id/")) {
            return string.substring("@+id/".length());
        }
        if (string.startsWith("@id/")) {
            return string.substring("@id/".length());
        }
        return string;
    }

    public static boolean idReferencesMatch(String string, String string2) {
        if (string.startsWith("@+id/")) {
            if (string2.startsWith("@+id/")) {
                return string.equals(string2);
            }
            assert (string2.startsWith("@id/"));
            return string.length() - string2.length() == "@+id/".length() - "@id/".length() && string.regionMatches("@+id/".length(), string2, "@id/".length(), string2.length() - "@id/".length());
        }
        assert (string.startsWith("@id/"));
        if (string2.startsWith("@id/")) {
            return string.equals(string2);
        }
        assert (string2.startsWith("@+id/"));
        return string2.length() - string.length() == "@+id/".length() - "@id/".length() && string2.regionMatches("@+id/".length(), string, "@id/".length(), string.length() - "@id/".length());
    }

    public static int editDistance(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        int[][] nArray = new int[n2 + 1][n3 + 1];
        for (n = 0; n <= n2; ++n) {
            nArray[n][0] = n;
        }
        for (n = 0; n <= n3; ++n) {
            nArray[0][n] = n;
        }
        for (n = 1; n <= n3; ++n) {
            for (int i = 1; i <= n2; ++i) {
                if (string.charAt(i - 1) == string2.charAt(n - 1)) {
                    nArray[i][n] = nArray[i - 1][n - 1];
                    continue;
                }
                int n4 = nArray[i - 1][n] + 1;
                int n5 = nArray[i][n - 1] + 1;
                int n6 = nArray[i - 1][n - 1] + 1;
                nArray[i][n] = Math.min(n4, Math.min(n5, n6));
            }
        }
        return nArray[n2][n3];
    }

    public static boolean assertionsEnabled() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return bl;
    }

    public static String getLayoutName(File file) {
        String string = file.getName();
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static File getCommonParent(List<File> list) {
        int n = list.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return list.get(0);
        }
        if (n == 2) {
            return LintUtils.getCommonParent(list.get(0), list.get(1));
        }
        File file = list.get(0);
        for (int i = 1; i < n; ++i) {
            if ((file = LintUtils.getCommonParent(file, list.get(i))) != null) continue;
            return null;
        }
        return file;
    }

    public static File getCommonParent(File file, File file2) {
        if (file.equals(file2)) {
            return file;
        }
        if (file.getPath().startsWith(file2.getPath())) {
            return file2;
        }
        if (file2.getPath().startsWith(file.getPath())) {
            return file;
        }
        for (File file3 = file.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            for (File file4 = file2.getParentFile(); file4 != null; file4 = file4.getParentFile()) {
                if (!file3.equals(file4)) continue;
                return file3;
            }
        }
        return null;
    }

    public static String getEncodedString(File file) throws IOException {
        byte[] byArray = Files.toByteArray(file);
        if (LintUtils.endsWith(file.getName(), ".xml")) {
            return PositionXmlParser.getXmlString((byte[])byArray);
        }
        return LintUtils.getEncodedString(byArray);
    }

    public static String getEncodedString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        int n = 0;
        String string = UTF_8;
        String string2 = null;
        if (byArray.length > 4) {
            if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                string2 = UTF_8;
                string = UTF_8;
                n += 3;
            } else if (byArray[0] == -2 && byArray[1] == -1) {
                string2 = UTF_16;
                string = UTF_16;
                n += 2;
            } else if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
                string2 = "UTF_32";
                string = "UTF_32";
                n += 4;
            } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
                string2 = "UTF_32LE";
                string = "UTF_32LE";
                n += 4;
            } else if (byArray[0] == -1 && byArray[1] == -2) {
                string2 = UTF_16LE;
                string = UTF_16LE;
                n += 2;
            }
        }
        int n2 = byArray.length - n;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n; i < byArray.length; ++i) {
            if (byArray[i] == 0) {
                if ((i - n) % 1 == 0) {
                    bl2 = true;
                    continue;
                }
                bl = true;
                continue;
            }
            if (byArray[i] == 10 || byArray[i] == 13) break;
        }
        if (string2 == null) {
            string2 = bl ? UTF_16 : (bl2 ? UTF_16LE : UTF_8);
        }
        String string3 = null;
        try {
            string3 = new String(byArray, n, n2, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                if (string2 != string) {
                    string3 = new String(byArray, n, n2, string);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                // empty catch block
            }
        }
        if (string3 == null) {
            string3 = new String(byArray, n, n2);
        }
        return string3;
    }
}

