/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.code.BaseMachine;
import com.android.dx.cf.code.ByteBlock;
import com.android.dx.cf.code.BytecodeArray;
import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.ExecutionStack;
import com.android.dx.cf.code.Frame;
import com.android.dx.cf.code.LocalVariableList;
import com.android.dx.cf.code.Machine;
import com.android.dx.cf.code.Merger;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.code.SwitchList;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstInterfaceMethodRef;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.Type;
import com.android.dx.util.Hex;
import java.util.ArrayList;

public class Simulator {
    private static final String LOCAL_MISMATCH_ERROR = "This is symptomatic of .class transformation tools that ignore local variable information.";
    private final Machine machine;
    private final BytecodeArray code;
    private final LocalVariableList localVariables;
    private final SimVisitor visitor;

    public Simulator(Machine machine, ConcreteMethod concreteMethod) {
        if (machine == null) {
            throw new NullPointerException("machine == null");
        }
        if (concreteMethod == null) {
            throw new NullPointerException("method == null");
        }
        this.machine = machine;
        this.code = concreteMethod.getCode();
        this.localVariables = concreteMethod.getLocalVariables();
        this.visitor = new SimVisitor();
    }

    public void simulate(ByteBlock byteBlock, Frame frame) {
        int n = byteBlock.getEnd();
        this.visitor.setFrame(frame);
        try {
            int n2;
            for (int i = byteBlock.getStart(); i < n; i += n2) {
                n2 = this.code.parseInstruction(i, this.visitor);
                this.visitor.setPreviousOffset(i);
            }
        }
        catch (SimException simException) {
            frame.annotate(simException);
            throw simException;
        }
    }

    public int simulate(int n, Frame frame) {
        this.visitor.setFrame(frame);
        return this.code.parseInstruction(n, this.visitor);
    }

    private static SimException illegalTos() {
        return new SimException("stack mismatch: illegal top-of-stack for opcode");
    }

    private static Type requiredArrayTypeFor(Type type, Type type2) {
        if (type2 == Type.KNOWN_NULL) {
            return type.getArrayType();
        }
        if (type == Type.OBJECT && type2.isArray() && type2.getComponentType().isReference()) {
            return type2;
        }
        if (type == Type.BYTE && type2 == Type.BOOLEAN_ARRAY) {
            return Type.BOOLEAN_ARRAY;
        }
        return type.getArrayType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimVisitor
    implements BytecodeArray.Visitor {
        private final Machine machine;
        private Frame frame;
        private int previousOffset;

        public SimVisitor() {
            this.machine = Simulator.this.machine;
            this.frame = null;
        }

        public void setFrame(Frame frame) {
            if (frame == null) {
                throw new NullPointerException("frame == null");
            }
            this.frame = frame;
        }

        @Override
        public void visitInvalid(int n, int n2, int n3) {
            throw new SimException("invalid opcode " + Hex.u1(n));
        }

        @Override
        public void visitNoArgs(int n, int n2, int n3, Type type) {
            switch (n) {
                case 0: {
                    this.machine.clearArgs();
                    break;
                }
                case 116: {
                    this.machine.popArgs(this.frame, type);
                    break;
                }
                case 133: 
                case 134: 
                case 135: 
                case 145: 
                case 146: 
                case 147: {
                    this.machine.popArgs(this.frame, Type.INT);
                    break;
                }
                case 136: 
                case 137: 
                case 138: {
                    this.machine.popArgs(this.frame, Type.LONG);
                    break;
                }
                case 139: 
                case 140: 
                case 141: {
                    this.machine.popArgs(this.frame, Type.FLOAT);
                    break;
                }
                case 142: 
                case 143: 
                case 144: {
                    this.machine.popArgs(this.frame, Type.DOUBLE);
                    break;
                }
                case 177: {
                    this.machine.clearArgs();
                    this.checkReturnType(Type.VOID);
                    break;
                }
                case 172: {
                    Type type2 = type;
                    if (type == Type.OBJECT) {
                        type2 = this.frame.getStack().peekType(0);
                    }
                    this.machine.popArgs(this.frame, type);
                    this.checkReturnType(type2);
                    break;
                }
                case 87: {
                    Type type3 = this.frame.getStack().peekType(0);
                    if (type3.isCategory2()) {
                        throw Simulator.illegalTos();
                    }
                    this.machine.popArgs(this.frame, 1);
                    break;
                }
                case 190: {
                    Type type4 = this.frame.getStack().peekType(0);
                    if (!type4.isArrayOrKnownNull()) {
                        throw new SimException("type mismatch: expected array type but encountered " + type4.toHuman());
                    }
                    this.machine.popArgs(this.frame, Type.OBJECT);
                    break;
                }
                case 191: 
                case 194: 
                case 195: {
                    this.machine.popArgs(this.frame, Type.OBJECT);
                    break;
                }
                case 46: {
                    Type type5 = this.frame.getStack().peekType(1);
                    Type type6 = Simulator.requiredArrayTypeFor(type, type5);
                    type = type6.getComponentType();
                    this.machine.popArgs(this.frame, type6, Type.INT);
                    break;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 126: 
                case 128: 
                case 130: {
                    this.machine.popArgs(this.frame, type, type);
                    break;
                }
                case 120: 
                case 122: 
                case 124: {
                    this.machine.popArgs(this.frame, type, Type.INT);
                    break;
                }
                case 148: {
                    this.machine.popArgs(this.frame, Type.LONG, Type.LONG);
                    break;
                }
                case 149: 
                case 150: {
                    this.machine.popArgs(this.frame, Type.FLOAT, Type.FLOAT);
                    break;
                }
                case 151: 
                case 152: {
                    this.machine.popArgs(this.frame, Type.DOUBLE, Type.DOUBLE);
                    break;
                }
                case 79: {
                    ExecutionStack executionStack = this.frame.getStack();
                    int n4 = type.isCategory1() ? 2 : 3;
                    Type type7 = executionStack.peekType(n4);
                    boolean bl = executionStack.peekLocal(n4);
                    Type type8 = Simulator.requiredArrayTypeFor(type, type7);
                    if (bl) {
                        type = type8.getComponentType();
                    }
                    this.machine.popArgs(this.frame, type8, Type.INT, type);
                    break;
                }
                case 88: 
                case 92: {
                    int n5;
                    ExecutionStack executionStack = this.frame.getStack();
                    if (executionStack.peekType(0).isCategory2()) {
                        this.machine.popArgs(this.frame, 1);
                        n5 = 17;
                    } else if (executionStack.peekType(1).isCategory1()) {
                        this.machine.popArgs(this.frame, 2);
                        n5 = 8481;
                    } else {
                        throw Simulator.illegalTos();
                    }
                    if (n != 92) break;
                    this.machine.auxIntArg(n5);
                    break;
                }
                case 89: {
                    Type type9 = this.frame.getStack().peekType(0);
                    if (type9.isCategory2()) {
                        throw Simulator.illegalTos();
                    }
                    this.machine.popArgs(this.frame, 1);
                    this.machine.auxIntArg(17);
                    break;
                }
                case 90: {
                    ExecutionStack executionStack = this.frame.getStack();
                    if (!executionStack.peekType(0).isCategory1() || !executionStack.peekType(1).isCategory1()) {
                        throw Simulator.illegalTos();
                    }
                    this.machine.popArgs(this.frame, 2);
                    this.machine.auxIntArg(530);
                    break;
                }
                case 91: {
                    ExecutionStack executionStack = this.frame.getStack();
                    if (executionStack.peekType(0).isCategory2()) {
                        throw Simulator.illegalTos();
                    }
                    if (executionStack.peekType(1).isCategory2()) {
                        this.machine.popArgs(this.frame, 2);
                        this.machine.auxIntArg(530);
                        break;
                    }
                    if (executionStack.peekType(2).isCategory1()) {
                        this.machine.popArgs(this.frame, 3);
                        this.machine.auxIntArg(12819);
                        break;
                    }
                    throw Simulator.illegalTos();
                }
                case 93: {
                    ExecutionStack executionStack = this.frame.getStack();
                    if (executionStack.peekType(0).isCategory2()) {
                        if (executionStack.peekType(2).isCategory2()) {
                            throw Simulator.illegalTos();
                        }
                        this.machine.popArgs(this.frame, 2);
                        this.machine.auxIntArg(530);
                        break;
                    }
                    if (executionStack.peekType(1).isCategory2() || executionStack.peekType(2).isCategory2()) {
                        throw Simulator.illegalTos();
                    }
                    this.machine.popArgs(this.frame, 3);
                    this.machine.auxIntArg(205106);
                    break;
                }
                case 94: {
                    ExecutionStack executionStack = this.frame.getStack();
                    if (executionStack.peekType(0).isCategory2()) {
                        if (executionStack.peekType(2).isCategory2()) {
                            this.machine.popArgs(this.frame, 2);
                            this.machine.auxIntArg(530);
                            break;
                        }
                        if (executionStack.peekType(3).isCategory1()) {
                            this.machine.popArgs(this.frame, 3);
                            this.machine.auxIntArg(12819);
                            break;
                        }
                        throw Simulator.illegalTos();
                    }
                    if (executionStack.peekType(1).isCategory1()) {
                        if (executionStack.peekType(2).isCategory2()) {
                            this.machine.popArgs(this.frame, 3);
                            this.machine.auxIntArg(205106);
                            break;
                        }
                        if (executionStack.peekType(3).isCategory1()) {
                            this.machine.popArgs(this.frame, 4);
                            this.machine.auxIntArg(4399427);
                            break;
                        }
                        throw Simulator.illegalTos();
                    }
                    throw Simulator.illegalTos();
                }
                case 95: {
                    ExecutionStack executionStack = this.frame.getStack();
                    if (!executionStack.peekType(0).isCategory1() || !executionStack.peekType(1).isCategory1()) {
                        throw Simulator.illegalTos();
                    }
                    this.machine.popArgs(this.frame, 2);
                    this.machine.auxIntArg(18);
                    break;
                }
                default: {
                    this.visitInvalid(n, n2, n3);
                    return;
                }
            }
            this.machine.auxType(type);
            this.machine.run(this.frame, n2, n);
        }

        private void checkReturnType(Type type) {
            Type type2 = this.machine.getPrototype().getReturnType();
            if (!Merger.isPossiblyAssignableFrom(type2, type)) {
                throw new SimException("return type mismatch: prototype indicates " + type2.toHuman() + ", but encountered type " + type.toHuman());
            }
        }

        @Override
        public void visitLocal(int n, int n2, int n3, int n4, Type type, int n5) {
            Type type2;
            int n6 = n == 54 ? n2 + n3 : n2;
            LocalVariableList.Item item = Simulator.this.localVariables.pcAndIndexToLocal(n6, n4);
            if (item != null) {
                type2 = item.getType();
                if (type2.getBasicFrameType() != type.getBasicFrameType()) {
                    BaseMachine.throwLocalMismatch(type, type2);
                    return;
                }
            } else {
                type2 = type;
            }
            switch (n) {
                case 21: 
                case 169: {
                    this.machine.localArg(this.frame, n4);
                    this.machine.localInfo(item != null);
                    this.machine.auxType(type);
                    break;
                }
                case 54: {
                    LocalItem localItem = item == null ? null : item.getLocalItem();
                    this.machine.popArgs(this.frame, type);
                    this.machine.auxType(type);
                    this.machine.localTarget(n4, type2, localItem);
                    break;
                }
                case 132: {
                    LocalItem localItem = item == null ? null : item.getLocalItem();
                    this.machine.localArg(this.frame, n4);
                    this.machine.localTarget(n4, type2, localItem);
                    this.machine.auxType(type);
                    this.machine.auxIntArg(n5);
                    this.machine.auxCstArg(CstInteger.make(n5));
                    break;
                }
                default: {
                    this.visitInvalid(n, n2, n3);
                    return;
                }
            }
            this.machine.run(this.frame, n2, n);
        }

        @Override
        public void visitConstant(int n, int n2, int n3, Constant constant, int n4) {
            switch (n) {
                case 189: {
                    this.machine.popArgs(this.frame, Type.INT);
                    break;
                }
                case 179: {
                    Type type = ((CstFieldRef)constant).getType();
                    this.machine.popArgs(this.frame, type);
                    break;
                }
                case 180: 
                case 192: 
                case 193: {
                    this.machine.popArgs(this.frame, Type.OBJECT);
                    break;
                }
                case 181: {
                    Type type = ((CstFieldRef)constant).getType();
                    this.machine.popArgs(this.frame, Type.OBJECT, type);
                    break;
                }
                case 185: {
                    constant = ((CstInterfaceMethodRef)constant).toMethodRef();
                }
                case 182: 
                case 183: {
                    Prototype prototype = ((CstMethodRef)constant).getPrototype(false);
                    this.machine.popArgs(this.frame, prototype);
                    break;
                }
                case 184: {
                    Prototype prototype = ((CstMethodRef)constant).getPrototype(true);
                    this.machine.popArgs(this.frame, prototype);
                    break;
                }
                case 197: {
                    Prototype prototype = Prototype.internInts(Type.VOID, n4);
                    this.machine.popArgs(this.frame, prototype);
                    break;
                }
                default: {
                    this.machine.clearArgs();
                }
            }
            this.machine.auxIntArg(n4);
            this.machine.auxCstArg(constant);
            this.machine.run(this.frame, n2, n);
        }

        @Override
        public void visitBranch(int n, int n2, int n3, int n4) {
            switch (n) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    this.machine.popArgs(this.frame, Type.INT);
                    break;
                }
                case 198: 
                case 199: {
                    this.machine.popArgs(this.frame, Type.OBJECT);
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    this.machine.popArgs(this.frame, Type.INT, Type.INT);
                    break;
                }
                case 165: 
                case 166: {
                    this.machine.popArgs(this.frame, Type.OBJECT, Type.OBJECT);
                    break;
                }
                case 167: 
                case 168: 
                case 200: 
                case 201: {
                    this.machine.clearArgs();
                    break;
                }
                default: {
                    this.visitInvalid(n, n2, n3);
                    return;
                }
            }
            this.machine.auxTargetArg(n4);
            this.machine.run(this.frame, n2, n);
        }

        @Override
        public void visitSwitch(int n, int n2, int n3, SwitchList switchList, int n4) {
            this.machine.popArgs(this.frame, Type.INT);
            this.machine.auxIntArg(n4);
            this.machine.auxSwitchArg(switchList);
            this.machine.run(this.frame, n2, n);
        }

        @Override
        public void visitNewarray(int n, int n2, CstType cstType, ArrayList<Constant> arrayList) {
            this.machine.popArgs(this.frame, Type.INT);
            this.machine.auxInitValues(arrayList);
            this.machine.auxCstArg(cstType);
            this.machine.run(this.frame, n, 188);
        }

        @Override
        public void setPreviousOffset(int n) {
            this.previousOffset = n;
        }

        @Override
        public int getPreviousOffset() {
            return this.previousOffset;
        }
    }
}

