/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.cst;

import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstInterfaceMethodRef;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.StdConstantPool;
import com.android.dx.rop.type.Type;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import java.util.BitSet;

public final class ConstantPoolParser {
    private final ByteArray bytes;
    private final StdConstantPool pool;
    private final int[] offsets;
    private int endOffset;
    private ParseObserver observer;

    public ConstantPoolParser(ByteArray byteArray) {
        int n = byteArray.getUnsignedShort(8);
        this.bytes = byteArray;
        this.pool = new StdConstantPool(n);
        this.offsets = new int[n];
        this.endOffset = -1;
    }

    public void setObserver(ParseObserver parseObserver) {
        this.observer = parseObserver;
    }

    public int getEndOffset() {
        this.parseIfNecessary();
        return this.endOffset;
    }

    public StdConstantPool getPool() {
        this.parseIfNecessary();
        return this.pool;
    }

    private void parseIfNecessary() {
        if (this.endOffset < 0) {
            this.parse();
        }
    }

    private void parse() {
        int n;
        this.determineOffsets();
        if (this.observer != null) {
            this.observer.parsed(this.bytes, 8, 2, "constant_pool_count: " + Hex.u2(this.offsets.length));
            this.observer.parsed(this.bytes, 10, 0, "\nconstant_pool:");
            this.observer.changeIndent(1);
        }
        BitSet bitSet = new BitSet(this.offsets.length);
        for (n = 1; n < this.offsets.length; ++n) {
            int n2 = this.offsets[n];
            if (n2 == 0 || this.pool.getOrNull(n) != null) continue;
            this.parse0(n, bitSet);
        }
        if (this.observer != null) {
            for (n = 1; n < this.offsets.length; ++n) {
                Constant constant = this.pool.getOrNull(n);
                if (constant == null) continue;
                int n3 = this.offsets[n];
                int n4 = this.endOffset;
                for (int i = n + 1; i < this.offsets.length; ++i) {
                    int n5 = this.offsets[i];
                    if (n5 == 0) continue;
                    n4 = n5;
                    break;
                }
                String string = bitSet.get(n) ? Hex.u2(n) + ": utf8{\"" + constant.toHuman() + "\"}" : Hex.u2(n) + ": " + constant.toString();
                this.observer.parsed(this.bytes, n3, n4 - n3, string);
            }
            this.observer.changeIndent(-1);
            this.observer.parsed(this.bytes, this.endOffset, 0, "end constant_pool");
        }
    }

    private void determineOffsets() {
        int n;
        int n2 = 10;
        block6: for (int i = 1; i < this.offsets.length; i += n) {
            this.offsets[i] = n2;
            int n3 = this.bytes.getUnsignedByte(n2);
            switch (n3) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n = 1;
                    n2 += 5;
                    continue block6;
                }
                case 5: 
                case 6: {
                    n = 2;
                    n2 += 9;
                    continue block6;
                }
                case 7: 
                case 8: {
                    n = 1;
                    n2 += 3;
                    continue block6;
                }
                case 1: {
                    n = 1;
                    n2 += this.bytes.getUnsignedShort(n2 + 1) + 3;
                    continue block6;
                }
                default: {
                    ParseException parseException = new ParseException("unknown tag byte: " + Hex.u1(n3));
                    parseException.addContext("...while preparsing cst " + Hex.u2(i) + " at offset " + Hex.u4(n2));
                    throw parseException;
                }
            }
        }
        this.endOffset = n2;
    }

    private Constant parse0(int n, BitSet bitSet) {
        Constant constant = this.pool.getOrNull(n);
        if (constant != null) {
            return constant;
        }
        int n2 = this.offsets[n];
        try {
            int n3 = this.bytes.getUnsignedByte(n2);
            switch (n3) {
                case 1: {
                    constant = this.parseUtf8(n2);
                    bitSet.set(n);
                    break;
                }
                case 3: {
                    int n4 = this.bytes.getInt(n2 + 1);
                    constant = CstInteger.make(n4);
                    break;
                }
                case 4: {
                    int n5 = this.bytes.getInt(n2 + 1);
                    constant = CstFloat.make(n5);
                    break;
                }
                case 5: {
                    long l = this.bytes.getLong(n2 + 1);
                    constant = CstLong.make(l);
                    break;
                }
                case 6: {
                    long l = this.bytes.getLong(n2 + 1);
                    constant = CstDouble.make(l);
                    break;
                }
                case 7: {
                    int n6 = this.bytes.getUnsignedShort(n2 + 1);
                    CstString cstString = (CstString)this.parse0(n6, bitSet);
                    constant = new CstType(Type.internClassName(cstString.getString()));
                    break;
                }
                case 8: {
                    int n7 = this.bytes.getUnsignedShort(n2 + 1);
                    constant = this.parse0(n7, bitSet);
                    break;
                }
                case 9: {
                    int n8 = this.bytes.getUnsignedShort(n2 + 1);
                    CstType cstType = (CstType)this.parse0(n8, bitSet);
                    int n9 = this.bytes.getUnsignedShort(n2 + 3);
                    CstNat cstNat = (CstNat)this.parse0(n9, bitSet);
                    constant = new CstFieldRef(cstType, cstNat);
                    break;
                }
                case 10: {
                    int n10 = this.bytes.getUnsignedShort(n2 + 1);
                    CstType cstType = (CstType)this.parse0(n10, bitSet);
                    int n11 = this.bytes.getUnsignedShort(n2 + 3);
                    CstNat cstNat = (CstNat)this.parse0(n11, bitSet);
                    constant = new CstMethodRef(cstType, cstNat);
                    break;
                }
                case 11: {
                    int n12 = this.bytes.getUnsignedShort(n2 + 1);
                    CstType cstType = (CstType)this.parse0(n12, bitSet);
                    int n13 = this.bytes.getUnsignedShort(n2 + 3);
                    CstNat cstNat = (CstNat)this.parse0(n13, bitSet);
                    constant = new CstInterfaceMethodRef(cstType, cstNat);
                    break;
                }
                case 12: {
                    int n14 = this.bytes.getUnsignedShort(n2 + 1);
                    CstString cstString = (CstString)this.parse0(n14, bitSet);
                    int n15 = this.bytes.getUnsignedShort(n2 + 3);
                    CstString cstString2 = (CstString)this.parse0(n15, bitSet);
                    constant = new CstNat(cstString, cstString2);
                    break;
                }
            }
        }
        catch (ParseException parseException) {
            parseException.addContext("...while parsing cst " + Hex.u2(n) + " at offset " + Hex.u4(n2));
            throw parseException;
        }
        catch (RuntimeException runtimeException) {
            ParseException parseException = new ParseException(runtimeException);
            parseException.addContext("...while parsing cst " + Hex.u2(n) + " at offset " + Hex.u4(n2));
            throw parseException;
        }
        this.pool.set(n, constant);
        return constant;
    }

    private CstString parseUtf8(int n) {
        int n2 = this.bytes.getUnsignedShort(n + 1);
        ByteArray byteArray = this.bytes.slice(n += 3, n + n2);
        try {
            return new CstString(byteArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException);
        }
    }
}

