/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dump;

import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Ropper;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.Member;
import com.android.dx.cf.iface.Method;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.command.dump.Args;
import com.android.dx.command.dump.BaseDumper;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.DexTranslationAdvice;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.ssa.Optimizer;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;

public class DotDumper
implements ParseObserver {
    private DirectClassFile classFile;
    private final byte[] bytes;
    private final String filePath;
    private final boolean strictParse;
    private final boolean optimize;
    private final Args args;

    static void dump(byte[] byArray, String string, Args args) {
        new DotDumper(byArray, string, args).run();
    }

    DotDumper(byte[] byArray, String string, Args args) {
        this.bytes = byArray;
        this.filePath = string;
        this.strictParse = args.strictParse;
        this.optimize = args.optimize;
        this.args = args;
    }

    private void run() {
        ByteArray byteArray = new ByteArray(this.bytes);
        this.classFile = new DirectClassFile(byteArray, this.filePath, this.strictParse);
        this.classFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
        this.classFile.getMagic();
        DirectClassFile directClassFile = new DirectClassFile(byteArray, this.filePath, this.strictParse);
        directClassFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
        directClassFile.setObserver(this);
        directClassFile.getMagic();
    }

    protected boolean shouldDumpMethod(String string) {
        return this.args.method == null || this.args.method.equals(string);
    }

    public void changeIndent(int n) {
    }

    public void parsed(ByteArray byteArray, int n, int n2, String string) {
    }

    public void startParsingMember(ByteArray byteArray, int n, String string, String string2) {
    }

    public void endParsingMember(ByteArray byteArray, int n, String string, String string2, Member member) {
        if (!(member instanceof Method)) {
            return;
        }
        if (!this.shouldDumpMethod(string)) {
            return;
        }
        ConcreteMethod concreteMethod = new ConcreteMethod((Method)member, this.classFile, true, true);
        DexTranslationAdvice dexTranslationAdvice = DexTranslationAdvice.THE_ONE;
        RopMethod ropMethod = Ropper.convert(concreteMethod, dexTranslationAdvice);
        if (this.optimize) {
            boolean bl = AccessFlags.isStatic(concreteMethod.getAccessFlags());
            ropMethod = Optimizer.optimize(ropMethod, BaseDumper.computeParamWidth(concreteMethod, bl), bl, true, dexTranslationAdvice);
        }
        System.out.println("digraph " + string + "{");
        System.out.println("\tfirst -> n" + Hex.u2(ropMethod.getFirstLabel()) + ";");
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        int n2 = basicBlockList.size();
        for (int i = 0; i < n2; ++i) {
            BasicBlock basicBlock = basicBlockList.get(i);
            int n3 = basicBlock.getLabel();
            IntList intList = basicBlock.getSuccessors();
            if (intList.size() == 0) {
                System.out.println("\tn" + Hex.u2(n3) + " -> returns;");
                continue;
            }
            if (intList.size() == 1) {
                System.out.println("\tn" + Hex.u2(n3) + " -> n" + Hex.u2(intList.get(0)) + ";");
                continue;
            }
            System.out.print("\tn" + Hex.u2(n3) + " -> {");
            for (int j = 0; j < intList.size(); ++j) {
                int n4 = intList.get(j);
                if (n4 == basicBlock.getPrimarySuccessor()) continue;
                System.out.print(" n" + Hex.u2(n4) + " ");
            }
            System.out.println("};");
            System.out.println("\tn" + Hex.u2(n3) + " -> n" + Hex.u2(basicBlock.getPrimarySuccessor()) + " [label=\"primary\"];");
        }
        System.out.println("}");
    }
}

