/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.grep;

import com.android.dx.io.ClassData;
import com.android.dx.io.ClassDef;
import com.android.dx.io.CodeReader;
import com.android.dx.io.DexBuffer;
import com.android.dx.io.EncodedValueReader;
import com.android.dx.io.MethodId;
import com.android.dx.io.instructions.DecodedInstruction;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Grep {
    private final DexBuffer dex;
    private final CodeReader codeReader = new CodeReader();
    private final Set<Integer> stringIds;
    private final PrintWriter out;
    private int count = 0;
    private ClassDef currentClass;
    private ClassData.Method currentMethod;

    public Grep(DexBuffer dexBuffer, Pattern pattern, PrintWriter printWriter) {
        this.dex = dexBuffer;
        this.out = printWriter;
        this.stringIds = this.getStringIds(dexBuffer, pattern);
        this.codeReader.setStringVisitor(new CodeReader.Visitor(){

            public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
                Grep.this.encounterString(decodedInstruction.getIndex());
            }
        });
    }

    private EncodedValueReader newEncodedValueReader(DexBuffer.Section section) {
        return new EncodedValueReader(section){

            protected void visitString(int n, int n2) {
                Grep.this.encounterString(n2);
            }
        };
    }

    private void encounterString(int n) {
        if (this.stringIds.contains(n)) {
            this.out.println(this.location() + " " + this.dex.strings().get(n));
            ++this.count;
        }
    }

    private String location() {
        String string = this.dex.typeNames().get(this.currentClass.getTypeIndex());
        if (this.currentMethod != null) {
            MethodId methodId = this.dex.methodIds().get(this.currentMethod.getMethodIndex());
            return string + "." + this.dex.strings().get(methodId.getNameIndex());
        }
        return string;
    }

    public int grep() {
        Iterator<ClassDef> iterator = this.dex.classDefs().iterator();
        while (iterator.hasNext()) {
            ClassDef classDef;
            this.currentClass = classDef = iterator.next();
            this.currentMethod = null;
            if (classDef.getClassDataOffset() == 0) continue;
            ClassData classData = this.dex.readClassData(classDef);
            int n = classDef.getStaticValuesOffset();
            if (n != 0) {
                this.newEncodedValueReader(this.dex.open(n)).readArray();
            }
            ClassData.Method[] methodArray = classData.allMethods();
            int n2 = methodArray.length;
            for (int i = 0; i < n2; ++i) {
                ClassData.Method method;
                this.currentMethod = method = methodArray[i];
                if (method.getCodeOffset() == 0) continue;
                this.codeReader.visitAll(this.dex.readCode(method).getInstructions());
            }
        }
        this.currentClass = null;
        this.currentMethod = null;
        return this.count;
    }

    private Set<Integer> getStringIds(DexBuffer dexBuffer, Pattern pattern) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        for (String string : dexBuffer.strings()) {
            if (pattern.matcher(string).find()) {
                hashSet.add(n);
            }
            ++n;
        }
        return hashSet;
    }
}

