/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.DexOptions;
import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.dex.code.Dop;
import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.LocalSnapshot;
import com.android.dx.dex.code.LocalStart;
import com.android.dx.dex.code.TargetInsn;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.RegisterSpecSet;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstMemberRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutputFinisher {
    private final DexOptions dexOptions;
    private final int unreservedRegCount;
    private ArrayList<DalvInsn> insns;
    private boolean hasAnyPositionInfo;
    private boolean hasAnyLocalInfo;
    private int reservedCount;

    public OutputFinisher(DexOptions dexOptions, int n, int n2) {
        this.dexOptions = dexOptions;
        this.unreservedRegCount = n2;
        this.insns = new ArrayList(n);
        this.reservedCount = -1;
        this.hasAnyPositionInfo = false;
        this.hasAnyLocalInfo = false;
    }

    public boolean hasAnyPositionInfo() {
        return this.hasAnyPositionInfo;
    }

    public boolean hasAnyLocalInfo() {
        return this.hasAnyLocalInfo;
    }

    private static boolean hasLocalInfo(DalvInsn dalvInsn) {
        RegisterSpec registerSpec;
        if (dalvInsn instanceof LocalSnapshot) {
            RegisterSpecSet registerSpecSet = ((LocalSnapshot)dalvInsn).getLocals();
            int n = registerSpecSet.size();
            for (int i = 0; i < n; ++i) {
                if (!OutputFinisher.hasLocalInfo(registerSpecSet.get(i))) continue;
                return true;
            }
        } else if (dalvInsn instanceof LocalStart && OutputFinisher.hasLocalInfo(registerSpec = ((LocalStart)dalvInsn).getLocal())) {
            return true;
        }
        return false;
    }

    private static boolean hasLocalInfo(RegisterSpec registerSpec) {
        return registerSpec != null && registerSpec.getLocalItem().getName() != null;
    }

    public HashSet<Constant> getAllConstants() {
        HashSet<Constant> hashSet = new HashSet<Constant>(20);
        for (DalvInsn dalvInsn : this.insns) {
            OutputFinisher.addConstants(hashSet, dalvInsn);
        }
        return hashSet;
    }

    private static void addConstants(HashSet<Constant> hashSet, DalvInsn dalvInsn) {
        if (dalvInsn instanceof CstInsn) {
            Constant constant = ((CstInsn)dalvInsn).getConstant();
            hashSet.add(constant);
        } else if (dalvInsn instanceof LocalSnapshot) {
            RegisterSpecSet registerSpecSet = ((LocalSnapshot)dalvInsn).getLocals();
            int n = registerSpecSet.size();
            for (int i = 0; i < n; ++i) {
                OutputFinisher.addConstants(hashSet, registerSpecSet.get(i));
            }
        } else if (dalvInsn instanceof LocalStart) {
            RegisterSpec registerSpec = ((LocalStart)dalvInsn).getLocal();
            OutputFinisher.addConstants(hashSet, registerSpec);
        }
    }

    private static void addConstants(HashSet<Constant> hashSet, RegisterSpec registerSpec) {
        if (registerSpec == null) {
            return;
        }
        LocalItem localItem = registerSpec.getLocalItem();
        CstString cstString = localItem.getName();
        CstString cstString2 = localItem.getSignature();
        Type type = registerSpec.getType();
        if (type != Type.KNOWN_NULL) {
            hashSet.add(CstType.intern(type));
        }
        if (cstString != null) {
            hashSet.add(cstString);
        }
        if (cstString2 != null) {
            hashSet.add(cstString2);
        }
    }

    public void add(DalvInsn dalvInsn) {
        this.insns.add(dalvInsn);
        this.updateInfo(dalvInsn);
    }

    public void insert(int n, DalvInsn dalvInsn) {
        this.insns.add(n, dalvInsn);
        this.updateInfo(dalvInsn);
    }

    private void updateInfo(DalvInsn dalvInsn) {
        SourcePosition sourcePosition;
        if (!this.hasAnyPositionInfo && (sourcePosition = dalvInsn.getPosition()).getLine() >= 0) {
            this.hasAnyPositionInfo = true;
        }
        if (!this.hasAnyLocalInfo && OutputFinisher.hasLocalInfo(dalvInsn)) {
            this.hasAnyLocalInfo = true;
        }
    }

    public void reverseBranch(int n, CodeAddress codeAddress) {
        TargetInsn targetInsn;
        int n2 = this.insns.size();
        int n3 = n2 - n - 1;
        try {
            targetInsn = (TargetInsn)this.insns.get(n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("too few instructions");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("non-reversible instruction");
        }
        this.insns.set(n3, targetInsn.withNewTargetAndReversed(codeAddress));
    }

    public void assignIndices(DalvCode.AssignIndicesCallback assignIndicesCallback) {
        for (DalvInsn dalvInsn : this.insns) {
            if (!(dalvInsn instanceof CstInsn)) continue;
            OutputFinisher.assignIndices((CstInsn)dalvInsn, assignIndicesCallback);
        }
    }

    private static void assignIndices(CstInsn cstInsn, DalvCode.AssignIndicesCallback assignIndicesCallback) {
        CstMemberRef cstMemberRef;
        CstType cstType;
        Constant constant = cstInsn.getConstant();
        int n = assignIndicesCallback.getIndex(constant);
        if (n >= 0) {
            cstInsn.setIndex(n);
        }
        if (constant instanceof CstMemberRef && (n = assignIndicesCallback.getIndex(cstType = (cstMemberRef = (CstMemberRef)constant).getDefiningClass())) >= 0) {
            cstInsn.setClassIndex(n);
        }
    }

    public DalvInsnList finishProcessingAndGetList() {
        if (this.reservedCount >= 0) {
            throw new UnsupportedOperationException("already processed");
        }
        Dop[] dopArray = this.makeOpcodesArray();
        this.reserveRegisters(dopArray);
        this.massageInstructions(dopArray);
        this.assignAddressesAndFixBranches();
        return DalvInsnList.makeImmutable(this.insns, this.reservedCount + this.unreservedRegCount);
    }

    private Dop[] makeOpcodesArray() {
        int n = this.insns.size();
        Dop[] dopArray = new Dop[n];
        for (int i = 0; i < n; ++i) {
            dopArray[i] = this.insns.get(i).getOpcode();
        }
        return dopArray;
    }

    private void reserveRegisters(Dop[] dopArray) {
        int n;
        int n2;
        int n3 = n2 = this.reservedCount < 0 ? 0 : this.reservedCount;
        while (n2 < (n = this.calculateReservedCount(dopArray))) {
            int n4 = n - n2;
            int n5 = this.insns.size();
            for (int i = 0; i < n5; ++i) {
                DalvInsn dalvInsn = this.insns.get(i);
                if (dalvInsn instanceof CodeAddress) continue;
                this.insns.set(i, dalvInsn.withRegisterOffset(n4));
            }
            n2 = n;
        }
        this.reservedCount = n2;
    }

    private int calculateReservedCount(Dop[] dopArray) {
        int n = this.insns.size();
        int n2 = this.reservedCount;
        for (int i = 0; i < n; ++i) {
            Dop dop;
            DalvInsn dalvInsn = this.insns.get(i);
            Dop dop2 = this.findOpcodeForInsn(dalvInsn, dop = dopArray[i]);
            if (dop2 == null) {
                Dop dop3 = this.findExpandedOpcodeForInsn(dalvInsn);
                BitSet bitSet = dop3.getFormat().compatibleRegs(dalvInsn);
                int n3 = dalvInsn.getMinimumRegisterRequirement(bitSet);
                if (n3 > n2) {
                    n2 = n3;
                }
            } else if (dop == dop2) continue;
            dopArray[i] = dop2;
        }
        return n2;
    }

    private Dop findOpcodeForInsn(DalvInsn dalvInsn, Dop dop) {
        while (dop != null && !dop.getFormat().isCompatible(dalvInsn)) {
            dop = Dops.getNextOrNull(dop, this.dexOptions);
        }
        return dop;
    }

    private Dop findExpandedOpcodeForInsn(DalvInsn dalvInsn) {
        Dop dop = this.findOpcodeForInsn(dalvInsn.getLowRegVersion(), dalvInsn.getOpcode());
        if (dop == null) {
            throw new AssertionError();
        }
        return dop;
    }

    private void massageInstructions(Dop[] dopArray) {
        if (this.reservedCount == 0) {
            int n = this.insns.size();
            for (int i = 0; i < n; ++i) {
                Dop dop;
                DalvInsn dalvInsn = this.insns.get(i);
                Dop dop2 = dalvInsn.getOpcode();
                if (dop2 == (dop = dopArray[i])) continue;
                this.insns.set(i, dalvInsn.withOpcode(dop));
            }
        } else {
            this.insns = this.performExpansion(dopArray);
        }
    }

    private ArrayList<DalvInsn> performExpansion(Dop[] dopArray) {
        int n = this.insns.size();
        ArrayList<DalvInsn> arrayList = new ArrayList<DalvInsn>(n * 2);
        for (int i = 0; i < n; ++i) {
            DalvInsn dalvInsn;
            DalvInsn dalvInsn2;
            DalvInsn dalvInsn3 = this.insns.get(i);
            Dop dop = dalvInsn3.getOpcode();
            Dop dop2 = dopArray[i];
            if (dop2 != null) {
                dalvInsn2 = null;
                dalvInsn = null;
            } else {
                dop2 = this.findExpandedOpcodeForInsn(dalvInsn3);
                BitSet bitSet = dop2.getFormat().compatibleRegs(dalvInsn3);
                dalvInsn2 = dalvInsn3.expandedPrefix(bitSet);
                dalvInsn = dalvInsn3.expandedSuffix(bitSet);
                dalvInsn3 = dalvInsn3.expandedVersion(bitSet);
            }
            if (dalvInsn2 != null) {
                arrayList.add(dalvInsn2);
            }
            if (dop2 != dop) {
                dalvInsn3 = dalvInsn3.withOpcode(dop2);
            }
            arrayList.add(dalvInsn3);
            if (dalvInsn == null) continue;
            arrayList.add(dalvInsn);
        }
        return arrayList;
    }

    private void assignAddressesAndFixBranches() {
        do {
            this.assignAddresses();
        } while (this.fixBranches());
    }

    private void assignAddresses() {
        int n = 0;
        int n2 = this.insns.size();
        for (int i = 0; i < n2; ++i) {
            DalvInsn dalvInsn = this.insns.get(i);
            dalvInsn.setAddress(n);
            n += dalvInsn.codeSize();
        }
    }

    private boolean fixBranches() {
        int n = this.insns.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            DalvInsn dalvInsn = this.insns.get(i);
            if (!(dalvInsn instanceof TargetInsn)) continue;
            Dop dop = dalvInsn.getOpcode();
            TargetInsn targetInsn = (TargetInsn)dalvInsn;
            if (dop.getFormat().branchFits(targetInsn)) continue;
            if (dop.getFamily() == 40) {
                if ((dop = this.findOpcodeForInsn(dalvInsn, dop)) == null) {
                    throw new UnsupportedOperationException("method too long");
                }
                this.insns.set(i, dalvInsn.withOpcode(dop));
            } else {
                CodeAddress codeAddress;
                try {
                    codeAddress = (CodeAddress)this.insns.get(i + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalStateException("unpaired TargetInsn (dangling)");
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("unpaired TargetInsn");
                }
                TargetInsn targetInsn2 = new TargetInsn(Dops.GOTO, targetInsn.getPosition(), RegisterSpecList.EMPTY, targetInsn.getTarget());
                this.insns.set(i, targetInsn2);
                this.insns.add(i, targetInsn.withNewTargetAndReversed(codeAddress));
                ++n;
                ++i;
            }
            bl = true;
        }
        return bl;
    }
}

