/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.DexOptions;
import com.android.dx.dex.code.ArrayData;
import com.android.dx.dex.code.BlockAddresses;
import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.Dop;
import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.FixedSizeInsn;
import com.android.dx.dex.code.LocalSnapshot;
import com.android.dx.dex.code.LocalStart;
import com.android.dx.dex.code.OddSpacer;
import com.android.dx.dex.code.OutputCollector;
import com.android.dx.dex.code.RopToDop;
import com.android.dx.dex.code.SimpleInsn;
import com.android.dx.dex.code.StdCatchBuilder;
import com.android.dx.dex.code.SwitchData;
import com.android.dx.dex.code.TargetInsn;
import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.FillArrayDataInsn;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.LocalVariableInfo;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.RegisterSpecSet;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.code.SwitchInsn;
import com.android.dx.rop.code.ThrowingCstInsn;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.util.Bits;
import com.android.dx.util.IntList;
import java.util.ArrayList;

public final class RopTranslator {
    private final DexOptions dexOptions;
    private final RopMethod method;
    private final int positionInfo;
    private final LocalVariableInfo locals;
    private final BlockAddresses addresses;
    private final OutputCollector output;
    private final TranslationVisitor translationVisitor;
    private final int regCount;
    private int[] order;
    private final int paramSize;
    private boolean paramsAreInOrder;

    public static DalvCode translate(RopMethod ropMethod, int n, LocalVariableInfo localVariableInfo, int n2, DexOptions dexOptions) {
        RopTranslator ropTranslator = new RopTranslator(ropMethod, n, localVariableInfo, n2, dexOptions);
        return ropTranslator.translateAndGetResult();
    }

    private RopTranslator(RopMethod ropMethod, int n, LocalVariableInfo localVariableInfo, int n2, DexOptions dexOptions) {
        this.dexOptions = dexOptions;
        this.method = ropMethod;
        this.positionInfo = n;
        this.locals = localVariableInfo;
        this.addresses = new BlockAddresses(ropMethod);
        this.paramSize = n2;
        this.order = null;
        this.paramsAreInOrder = RopTranslator.calculateParamsAreInOrder(ropMethod, n2);
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        int n3 = basicBlockList.size();
        int n4 = n3 * 3 + basicBlockList.getInstructionCount();
        if (localVariableInfo != null) {
            n4 += n3 + localVariableInfo.getAssignmentCount();
        }
        this.regCount = basicBlockList.getRegCount() + (this.paramsAreInOrder ? 0 : this.paramSize);
        this.output = new OutputCollector(dexOptions, n4, n3 * 3, this.regCount);
        this.translationVisitor = localVariableInfo != null ? new LocalVariableAwareTranslationVisitor(this.output, localVariableInfo) : new TranslationVisitor(this.output);
    }

    private static boolean calculateParamsAreInOrder(RopMethod ropMethod, final int n) {
        final boolean[] blArray = new boolean[]{true};
        final int n2 = ropMethod.getBlocks().getRegCount();
        ropMethod.getBlocks().forEachInsn(new Insn.BaseVisitor(){

            public void visitPlainCstInsn(PlainCstInsn plainCstInsn) {
                if (plainCstInsn.getOpcode().getOpcode() == 3) {
                    int n3 = ((CstInteger)plainCstInsn.getConstant()).getValue();
                    blArray[0] = blArray[0] && n2 - n + n3 == plainCstInsn.getResult().getReg();
                }
            }
        });
        return blArray[0];
    }

    private DalvCode translateAndGetResult() {
        this.pickOrder();
        this.outputInstructions();
        StdCatchBuilder stdCatchBuilder = new StdCatchBuilder(this.method, this.order, this.addresses);
        return new DalvCode(this.positionInfo, this.output.getFinisher(), stdCatchBuilder);
    }

    private void outputInstructions() {
        BasicBlockList basicBlockList = this.method.getBlocks();
        int[] nArray = this.order;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            int n3 = n2 == nArray.length ? -1 : nArray[n2];
            this.outputBlock(basicBlockList.labelToBlock(nArray[i]), n3);
        }
    }

    private void outputBlock(BasicBlock basicBlock, int n) {
        CodeAddress codeAddress = this.addresses.getStart(basicBlock);
        this.output.add(codeAddress);
        if (this.locals != null) {
            RegisterSpecSet registerSpecSet = this.locals.getStarts(basicBlock);
            this.output.add(new LocalSnapshot(codeAddress.getPosition(), registerSpecSet));
        }
        this.translationVisitor.setBlock(basicBlock, this.addresses.getLast(basicBlock));
        basicBlock.getInsns().forEach(this.translationVisitor);
        this.output.add(this.addresses.getEnd(basicBlock));
        int n2 = basicBlock.getPrimarySuccessor();
        Insn insn = basicBlock.getLastInsn();
        if (n2 >= 0 && n2 != n) {
            Rop rop = insn.getOpcode();
            if (rop.getBranchingness() == 4 && basicBlock.getSecondarySuccessor() == n) {
                this.output.reverseBranch(1, this.addresses.getStart(n2));
            } else {
                TargetInsn targetInsn = new TargetInsn(Dops.GOTO, insn.getPosition(), RegisterSpecList.EMPTY, this.addresses.getStart(n2));
                this.output.add(targetInsn);
            }
        }
    }

    private void pickOrder() {
        BasicBlockList basicBlockList = this.method.getBlocks();
        int n = basicBlockList.size();
        int n2 = basicBlockList.getMaxLabel();
        int[] nArray = Bits.makeBitSet(n2);
        int[] nArray2 = Bits.makeBitSet(n2);
        for (int i = 0; i < n; ++i) {
            BasicBlock basicBlock = basicBlockList.get(i);
            Bits.set(nArray, basicBlock.getLabel());
        }
        int[] nArray3 = new int[n];
        int n3 = 0;
        int n4 = this.method.getFirstLabel();
        while (n4 != -1) {
            Object object;
            int n5;
            int n6;
            Object object2;
            block2: while (true) {
                object2 = this.method.labelToPredecessors(n4);
                int n7 = ((IntList)object2).size();
                for (n6 = 0; n6 < n7 && !Bits.get(nArray2, n5 = ((IntList)object2).get(n6)); ++n6) {
                    if (!Bits.get(nArray, n5) || ((BasicBlock)(object = basicBlockList.labelToBlock(n5))).getPrimarySuccessor() != n4) continue;
                    n4 = n5;
                    Bits.set(nArray2, n4);
                    continue block2;
                }
                break;
            }
            block4: while (n4 != -1) {
                Bits.clear(nArray, n4);
                Bits.clear(nArray2, n4);
                nArray3[n3] = n4;
                ++n3;
                object2 = basicBlockList.labelToBlock(n4);
                BasicBlock basicBlock = basicBlockList.preferredSuccessorOf((BasicBlock)object2);
                if (basicBlock == null) break;
                n6 = basicBlock.getLabel();
                n5 = ((BasicBlock)object2).getPrimarySuccessor();
                if (Bits.get(nArray, n6)) {
                    n4 = n6;
                    continue;
                }
                if (n5 != n6 && n5 >= 0 && Bits.get(nArray, n5)) {
                    n4 = n5;
                    continue;
                }
                object = ((BasicBlock)object2).getSuccessors();
                int n8 = ((IntList)object).size();
                n4 = -1;
                for (int i = 0; i < n8; ++i) {
                    int n9 = ((IntList)object).get(i);
                    if (!Bits.get(nArray, n9)) continue;
                    n4 = n9;
                    continue block4;
                }
            }
            n4 = Bits.findFirst(nArray, 0);
        }
        if (n3 != n) {
            throw new RuntimeException("shouldn't happen");
        }
        this.order = nArray3;
    }

    private static RegisterSpecList getRegs(Insn insn) {
        return RopTranslator.getRegs(insn, insn.getResult());
    }

    private static RegisterSpecList getRegs(Insn insn, RegisterSpec registerSpec) {
        RegisterSpecList registerSpecList = insn.getSources();
        if (insn.getOpcode().isCommutative() && registerSpecList.size() == 2 && registerSpec.getReg() == registerSpecList.get(1).getReg()) {
            registerSpecList = RegisterSpecList.make(registerSpecList.get(1), registerSpecList.get(0));
        }
        if (registerSpec == null) {
            return registerSpecList;
        }
        return registerSpecList.withFirst(registerSpec);
    }

    private class LocalVariableAwareTranslationVisitor
    extends TranslationVisitor {
        private LocalVariableInfo locals;

        public LocalVariableAwareTranslationVisitor(OutputCollector outputCollector, LocalVariableInfo localVariableInfo) {
            super(outputCollector);
            this.locals = localVariableInfo;
        }

        public void visitPlainInsn(PlainInsn plainInsn) {
            super.visitPlainInsn(plainInsn);
            this.addIntroductionIfNecessary(plainInsn);
        }

        public void visitPlainCstInsn(PlainCstInsn plainCstInsn) {
            super.visitPlainCstInsn(plainCstInsn);
            this.addIntroductionIfNecessary(plainCstInsn);
        }

        public void visitSwitchInsn(SwitchInsn switchInsn) {
            super.visitSwitchInsn(switchInsn);
            this.addIntroductionIfNecessary(switchInsn);
        }

        public void visitThrowingCstInsn(ThrowingCstInsn throwingCstInsn) {
            super.visitThrowingCstInsn(throwingCstInsn);
            this.addIntroductionIfNecessary(throwingCstInsn);
        }

        public void visitThrowingInsn(ThrowingInsn throwingInsn) {
            super.visitThrowingInsn(throwingInsn);
            this.addIntroductionIfNecessary(throwingInsn);
        }

        public void addIntroductionIfNecessary(Insn insn) {
            RegisterSpec registerSpec = this.locals.getAssignment(insn);
            if (registerSpec != null) {
                this.addOutput(new LocalStart(insn.getPosition(), registerSpec));
            }
        }
    }

    private class TranslationVisitor
    implements Insn.Visitor {
        private final OutputCollector output;
        private BasicBlock block;
        private CodeAddress lastAddress;

        public TranslationVisitor(OutputCollector outputCollector) {
            this.output = outputCollector;
        }

        public void setBlock(BasicBlock basicBlock, CodeAddress codeAddress) {
            this.block = basicBlock;
            this.lastAddress = codeAddress;
        }

        public void visitPlainInsn(PlainInsn plainInsn) {
            FixedSizeInsn fixedSizeInsn;
            Rop rop = plainInsn.getOpcode();
            if (rop.getOpcode() == 54) {
                return;
            }
            if (rop.getOpcode() == 56) {
                return;
            }
            SourcePosition sourcePosition = plainInsn.getPosition();
            Dop dop = RopToDop.dopFor(plainInsn);
            switch (rop.getBranchingness()) {
                case 1: 
                case 2: 
                case 6: {
                    fixedSizeInsn = new SimpleInsn(dop, sourcePosition, RopTranslator.getRegs(plainInsn));
                    break;
                }
                case 3: {
                    return;
                }
                case 4: {
                    int n = this.block.getSuccessors().get(1);
                    fixedSizeInsn = new TargetInsn(dop, sourcePosition, RopTranslator.getRegs(plainInsn), RopTranslator.this.addresses.getStart(n));
                    break;
                }
                default: {
                    throw new RuntimeException("shouldn't happen");
                }
            }
            this.addOutput(fixedSizeInsn);
        }

        public void visitPlainCstInsn(PlainCstInsn plainCstInsn) {
            SourcePosition sourcePosition = plainCstInsn.getPosition();
            Dop dop = RopToDop.dopFor(plainCstInsn);
            Rop rop = plainCstInsn.getOpcode();
            int n = rop.getOpcode();
            if (rop.getBranchingness() != 1) {
                throw new RuntimeException("shouldn't happen");
            }
            if (n == 3) {
                if (!RopTranslator.this.paramsAreInOrder) {
                    RegisterSpec registerSpec = plainCstInsn.getResult();
                    int n2 = ((CstInteger)plainCstInsn.getConstant()).getValue();
                    RegisterSpec registerSpec2 = RegisterSpec.make(RopTranslator.this.regCount - RopTranslator.this.paramSize + n2, registerSpec.getType());
                    SimpleInsn simpleInsn = new SimpleInsn(dop, sourcePosition, RegisterSpecList.make(registerSpec, registerSpec2));
                    this.addOutput(simpleInsn);
                }
            } else {
                RegisterSpecList registerSpecList = RopTranslator.getRegs(plainCstInsn);
                CstInsn cstInsn = new CstInsn(dop, sourcePosition, registerSpecList, plainCstInsn.getConstant());
                this.addOutput(cstInsn);
            }
        }

        public void visitSwitchInsn(SwitchInsn switchInsn) {
            SourcePosition sourcePosition = switchInsn.getPosition();
            IntList intList = switchInsn.getCases();
            IntList intList2 = this.block.getSuccessors();
            int n = intList.size();
            int n2 = intList2.size();
            int n3 = this.block.getPrimarySuccessor();
            if (n != n2 - 1 || n3 != intList2.get(n)) {
                throw new RuntimeException("shouldn't happen");
            }
            CodeAddress[] codeAddressArray = new CodeAddress[n];
            for (int i = 0; i < n; ++i) {
                int n4 = intList2.get(i);
                codeAddressArray[i] = RopTranslator.this.addresses.getStart(n4);
            }
            CodeAddress codeAddress = new CodeAddress(sourcePosition);
            SwitchData switchData = new SwitchData(sourcePosition, this.lastAddress, intList, codeAddressArray);
            Dop dop = switchData.isPacked() ? Dops.PACKED_SWITCH : Dops.SPARSE_SWITCH;
            TargetInsn targetInsn = new TargetInsn(dop, sourcePosition, RopTranslator.getRegs(switchInsn), codeAddress);
            this.addOutput(this.lastAddress);
            this.addOutput(targetInsn);
            this.addOutputSuffix(new OddSpacer(sourcePosition));
            this.addOutputSuffix(codeAddress);
            this.addOutputSuffix(switchData);
        }

        private RegisterSpec getNextMoveResultPseudo() {
            int n = this.block.getPrimarySuccessor();
            if (n < 0) {
                return null;
            }
            Insn insn = RopTranslator.this.method.getBlocks().labelToBlock(n).getInsns().get(0);
            if (insn.getOpcode().getOpcode() != 56) {
                return null;
            }
            return insn.getResult();
        }

        public void visitThrowingCstInsn(ThrowingCstInsn throwingCstInsn) {
            SourcePosition sourcePosition = throwingCstInsn.getPosition();
            Dop dop = RopToDop.dopFor(throwingCstInsn);
            Rop rop = throwingCstInsn.getOpcode();
            Constant constant = throwingCstInsn.getConstant();
            if (rop.getBranchingness() != 6) {
                throw new RuntimeException("shouldn't happen");
            }
            this.addOutput(this.lastAddress);
            if (rop.isCallLike()) {
                RegisterSpecList registerSpecList = throwingCstInsn.getSources();
                CstInsn cstInsn = new CstInsn(dop, sourcePosition, registerSpecList, constant);
                this.addOutput(cstInsn);
            } else {
                RegisterSpec registerSpec = this.getNextMoveResultPseudo();
                RegisterSpecList registerSpecList = RopTranslator.getRegs(throwingCstInsn, registerSpec);
                boolean bl = dop.hasResult() || rop.getOpcode() == 43;
                if (bl != (registerSpec != null)) {
                    throw new RuntimeException("Insn with result/move-result-pseudo mismatch " + throwingCstInsn);
                }
                FixedSizeInsn fixedSizeInsn = rop.getOpcode() == 41 && dop.getOpcode() != 35 ? new SimpleInsn(dop, sourcePosition, registerSpecList) : new CstInsn(dop, sourcePosition, registerSpecList, constant);
                this.addOutput(fixedSizeInsn);
            }
        }

        public void visitThrowingInsn(ThrowingInsn throwingInsn) {
            SourcePosition sourcePosition = throwingInsn.getPosition();
            Dop dop = RopToDop.dopFor(throwingInsn);
            Rop rop = throwingInsn.getOpcode();
            if (rop.getBranchingness() != 6) {
                throw new RuntimeException("shouldn't happen");
            }
            RegisterSpec registerSpec = this.getNextMoveResultPseudo();
            if (dop.hasResult() != (registerSpec != null)) {
                throw new RuntimeException("Insn with result/move-result-pseudo mismatch" + throwingInsn);
            }
            this.addOutput(this.lastAddress);
            SimpleInsn simpleInsn = new SimpleInsn(dop, sourcePosition, RopTranslator.getRegs(throwingInsn, registerSpec));
            this.addOutput(simpleInsn);
        }

        public void visitFillArrayDataInsn(FillArrayDataInsn fillArrayDataInsn) {
            SourcePosition sourcePosition = fillArrayDataInsn.getPosition();
            Constant constant = fillArrayDataInsn.getConstant();
            ArrayList<Constant> arrayList = fillArrayDataInsn.getInitValues();
            Rop rop = fillArrayDataInsn.getOpcode();
            if (rop.getBranchingness() != 1) {
                throw new RuntimeException("shouldn't happen");
            }
            CodeAddress codeAddress = new CodeAddress(sourcePosition);
            ArrayData arrayData = new ArrayData(sourcePosition, this.lastAddress, arrayList, constant);
            TargetInsn targetInsn = new TargetInsn(Dops.FILL_ARRAY_DATA, sourcePosition, RopTranslator.getRegs(fillArrayDataInsn), codeAddress);
            this.addOutput(this.lastAddress);
            this.addOutput(targetInsn);
            this.addOutputSuffix(new OddSpacer(sourcePosition));
            this.addOutputSuffix(codeAddress);
            this.addOutputSuffix(arrayData);
        }

        protected void addOutput(DalvInsn dalvInsn) {
            this.output.add(dalvInsn);
        }

        protected void addOutputSuffix(DalvInsn dalvInsn) {
            this.output.addSuffix(dalvInsn);
        }
    }
}

