/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.Dop;
import com.android.dx.dex.code.FixedSizeInsn;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SourcePosition;

public final class TargetInsn
extends FixedSizeInsn {
    private CodeAddress target;

    public TargetInsn(Dop dop, SourcePosition sourcePosition, RegisterSpecList registerSpecList, CodeAddress codeAddress) {
        super(dop, sourcePosition, registerSpecList);
        if (codeAddress == null) {
            throw new NullPointerException("target == null");
        }
        this.target = codeAddress;
    }

    public DalvInsn withOpcode(Dop dop) {
        return new TargetInsn(dop, this.getPosition(), this.getRegisters(), this.target);
    }

    public DalvInsn withRegisters(RegisterSpecList registerSpecList) {
        return new TargetInsn(this.getOpcode(), this.getPosition(), registerSpecList, this.target);
    }

    public TargetInsn withNewTargetAndReversed(CodeAddress codeAddress) {
        Dop dop = this.getOpcode().getOppositeTest();
        return new TargetInsn(dop, this.getPosition(), this.getRegisters(), codeAddress);
    }

    public CodeAddress getTarget() {
        return this.target;
    }

    public int getTargetAddress() {
        return this.target.getAddress();
    }

    public int getTargetOffset() {
        return this.target.getAddress() - this.getAddress();
    }

    public boolean hasTargetOffset() {
        return this.hasAddress() && this.target.hasAddress();
    }

    protected String argString() {
        if (this.target == null) {
            return "????";
        }
        return this.target.identifierString();
    }
}

