/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.AnnotationSetItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.FieldAnnotationStruct;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MethodAnnotationStruct;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.ParameterAnnotationStruct;
import com.android.dx.dex.file.Section;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationsDirectoryItem
extends OffsettedItem {
    private static final int ALIGNMENT = 4;
    private static final int HEADER_SIZE = 16;
    private static final int ELEMENT_SIZE = 8;
    private AnnotationSetItem classAnnotations = null;
    private ArrayList<FieldAnnotationStruct> fieldAnnotations = null;
    private ArrayList<MethodAnnotationStruct> methodAnnotations = null;
    private ArrayList<ParameterAnnotationStruct> parameterAnnotations = null;

    public AnnotationsDirectoryItem() {
        super(4, -1);
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_ANNOTATIONS_DIRECTORY_ITEM;
    }

    public boolean isEmpty() {
        return this.classAnnotations == null && this.fieldAnnotations == null && this.methodAnnotations == null && this.parameterAnnotations == null;
    }

    public boolean isInternable() {
        return this.classAnnotations != null && this.fieldAnnotations == null && this.methodAnnotations == null && this.parameterAnnotations == null;
    }

    public int hashCode() {
        if (this.classAnnotations == null) {
            return 0;
        }
        return this.classAnnotations.hashCode();
    }

    @Override
    public int compareTo0(OffsettedItem offsettedItem) {
        if (!this.isInternable()) {
            throw new UnsupportedOperationException("uninternable instance");
        }
        AnnotationsDirectoryItem annotationsDirectoryItem = (AnnotationsDirectoryItem)offsettedItem;
        return this.classAnnotations.compareTo(annotationsDirectoryItem.classAnnotations);
    }

    public void setClassAnnotations(Annotations annotations) {
        if (annotations == null) {
            throw new NullPointerException("annotations == null");
        }
        if (this.classAnnotations != null) {
            throw new UnsupportedOperationException("class annotations already set");
        }
        this.classAnnotations = new AnnotationSetItem(annotations);
    }

    public void addFieldAnnotations(CstFieldRef cstFieldRef, Annotations annotations) {
        if (this.fieldAnnotations == null) {
            this.fieldAnnotations = new ArrayList();
        }
        this.fieldAnnotations.add(new FieldAnnotationStruct(cstFieldRef, new AnnotationSetItem(annotations)));
    }

    public void addMethodAnnotations(CstMethodRef cstMethodRef, Annotations annotations) {
        if (this.methodAnnotations == null) {
            this.methodAnnotations = new ArrayList();
        }
        this.methodAnnotations.add(new MethodAnnotationStruct(cstMethodRef, new AnnotationSetItem(annotations)));
    }

    public void addParameterAnnotations(CstMethodRef cstMethodRef, AnnotationsList annotationsList) {
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = new ArrayList();
        }
        this.parameterAnnotations.add(new ParameterAnnotationStruct(cstMethodRef, annotationsList));
    }

    public Annotations getMethodAnnotations(CstMethodRef cstMethodRef) {
        if (this.methodAnnotations == null) {
            return null;
        }
        for (MethodAnnotationStruct methodAnnotationStruct : this.methodAnnotations) {
            if (!methodAnnotationStruct.getMethod().equals(cstMethodRef)) continue;
            return methodAnnotationStruct.getAnnotations();
        }
        return null;
    }

    public AnnotationsList getParameterAnnotations(CstMethodRef cstMethodRef) {
        if (this.parameterAnnotations == null) {
            return null;
        }
        for (ParameterAnnotationStruct parameterAnnotationStruct : this.parameterAnnotations) {
            if (!parameterAnnotationStruct.getMethod().equals(cstMethodRef)) continue;
            return parameterAnnotationStruct.getAnnotationsList();
        }
        return null;
    }

    @Override
    public void addContents(DexFile dexFile) {
        MixedItemSection mixedItemSection = dexFile.getWordData();
        if (this.classAnnotations != null) {
            this.classAnnotations = mixedItemSection.intern(this.classAnnotations);
        }
        if (this.fieldAnnotations != null) {
            for (FieldAnnotationStruct comparable : this.fieldAnnotations) {
                comparable.addContents(dexFile);
            }
        }
        if (this.methodAnnotations != null) {
            for (MethodAnnotationStruct methodAnnotationStruct : this.methodAnnotations) {
                methodAnnotationStruct.addContents(dexFile);
            }
        }
        if (this.parameterAnnotations != null) {
            for (ParameterAnnotationStruct parameterAnnotationStruct : this.parameterAnnotations) {
                parameterAnnotationStruct.addContents(dexFile);
            }
        }
    }

    @Override
    public String toHuman() {
        throw new RuntimeException("unsupported");
    }

    @Override
    protected void place0(Section section, int n) {
        int n2 = AnnotationsDirectoryItem.listSize(this.fieldAnnotations) + AnnotationsDirectoryItem.listSize(this.methodAnnotations) + AnnotationsDirectoryItem.listSize(this.parameterAnnotations);
        this.setWriteSize(16 + n2 * 8);
    }

    @Override
    protected void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        boolean bl = annotatedOutput.annotates();
        int n = OffsettedItem.getAbsoluteOffsetOr0(this.classAnnotations);
        int n2 = AnnotationsDirectoryItem.listSize(this.fieldAnnotations);
        int n3 = AnnotationsDirectoryItem.listSize(this.methodAnnotations);
        int n4 = AnnotationsDirectoryItem.listSize(this.parameterAnnotations);
        if (bl) {
            annotatedOutput.annotate(0, this.offsetString() + " annotations directory");
            annotatedOutput.annotate(4, "  class_annotations_off: " + Hex.u4(n));
            annotatedOutput.annotate(4, "  fields_size:           " + Hex.u4(n2));
            annotatedOutput.annotate(4, "  methods_size:          " + Hex.u4(n3));
            annotatedOutput.annotate(4, "  parameters_size:       " + Hex.u4(n4));
        }
        annotatedOutput.writeInt(n);
        annotatedOutput.writeInt(n2);
        annotatedOutput.writeInt(n3);
        annotatedOutput.writeInt(n4);
        if (n2 != 0) {
            Collections.sort(this.fieldAnnotations);
            if (bl) {
                annotatedOutput.annotate(0, "  fields:");
            }
            for (FieldAnnotationStruct comparable : this.fieldAnnotations) {
                comparable.writeTo(dexFile, annotatedOutput);
            }
        }
        if (n3 != 0) {
            Collections.sort(this.methodAnnotations);
            if (bl) {
                annotatedOutput.annotate(0, "  methods:");
            }
            for (MethodAnnotationStruct methodAnnotationStruct : this.methodAnnotations) {
                methodAnnotationStruct.writeTo(dexFile, annotatedOutput);
            }
        }
        if (n4 != 0) {
            Collections.sort(this.parameterAnnotations);
            if (bl) {
                annotatedOutput.annotate(0, "  parameters:");
            }
            for (ParameterAnnotationStruct parameterAnnotationStruct : this.parameterAnnotations) {
                parameterAnnotationStruct.writeTo(dexFile, annotatedOutput);
            }
        }
    }

    private static int listSize(ArrayList<?> arrayList) {
        if (arrayList == null) {
            return 0;
        }
        return arrayList.size();
    }

    void debugPrint(PrintWriter printWriter) {
        if (this.classAnnotations != null) {
            printWriter.println("  class annotations: " + this.classAnnotations);
        }
        if (this.fieldAnnotations != null) {
            printWriter.println("  field annotations:");
            for (FieldAnnotationStruct comparable : this.fieldAnnotations) {
                printWriter.println("    " + comparable.toHuman());
            }
        }
        if (this.methodAnnotations != null) {
            printWriter.println("  method annotations:");
            for (MethodAnnotationStruct methodAnnotationStruct : this.methodAnnotations) {
                printWriter.println("    " + methodAnnotationStruct.toHuman());
            }
        }
        if (this.parameterAnnotations != null) {
            printWriter.println("  parameter annotations:");
            for (ParameterAnnotationStruct parameterAnnotationStruct : this.parameterAnnotations) {
                printWriter.println("    " + parameterAnnotationStruct.toHuman());
            }
        }
    }
}

