/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.AnnotationSetItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.FieldIdsSection;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import com.android.dx.util.ToHuman;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldAnnotationStruct
implements ToHuman,
Comparable<FieldAnnotationStruct> {
    private final CstFieldRef field;
    private AnnotationSetItem annotations;

    public FieldAnnotationStruct(CstFieldRef cstFieldRef, AnnotationSetItem annotationSetItem) {
        if (cstFieldRef == null) {
            throw new NullPointerException("field == null");
        }
        if (annotationSetItem == null) {
            throw new NullPointerException("annotations == null");
        }
        this.field = cstFieldRef;
        this.annotations = annotationSetItem;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FieldAnnotationStruct)) {
            return false;
        }
        return this.field.equals(((FieldAnnotationStruct)object).field);
    }

    @Override
    public int compareTo(FieldAnnotationStruct fieldAnnotationStruct) {
        return this.field.compareTo(fieldAnnotationStruct.field);
    }

    public void addContents(DexFile dexFile) {
        FieldIdsSection fieldIdsSection = dexFile.getFieldIds();
        MixedItemSection mixedItemSection = dexFile.getWordData();
        fieldIdsSection.intern(this.field);
        this.annotations = mixedItemSection.intern(this.annotations);
    }

    public void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n = dexFile.getFieldIds().indexOf(this.field);
        int n2 = this.annotations.getAbsoluteOffset();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, "    " + this.field.toHuman());
            annotatedOutput.annotate(4, "      field_idx:       " + Hex.u4(n));
            annotatedOutput.annotate(4, "      annotations_off: " + Hex.u4(n2));
        }
        annotatedOutput.writeInt(n);
        annotatedOutput.writeInt(n2);
    }

    @Override
    public String toHuman() {
        return this.field.toHuman() + ": " + this.annotations;
    }

    public CstFieldRef getField() {
        return this.field;
    }

    public Annotations getAnnotations() {
        return this.annotations.getAnnotations();
    }
}

