/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;

public final class TypeListItem
extends OffsettedItem {
    private static final int ALIGNMENT = 4;
    private static final int ELEMENT_SIZE = 2;
    private static final int HEADER_SIZE = 4;
    private final TypeList list;

    public TypeListItem(TypeList typeList) {
        super(4, typeList.size() * 2 + 4);
        this.list = typeList;
    }

    public int hashCode() {
        return StdTypeList.hashContents(this.list);
    }

    public ItemType itemType() {
        return ItemType.TYPE_TYPE_LIST;
    }

    public void addContents(DexFile dexFile) {
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            typeIdsSection.intern(this.list.getType(i));
        }
    }

    public String toHuman() {
        throw new RuntimeException("unsupported");
    }

    public TypeList getList() {
        return this.list;
    }

    protected void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n;
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        int n2 = this.list.size();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, this.offsetString() + " type_list");
            annotatedOutput.annotate(4, "  size: " + Hex.u4(n2));
            for (n = 0; n < n2; ++n) {
                Type type = this.list.getType(n);
                int n3 = typeIdsSection.indexOf(type);
                annotatedOutput.annotate(2, "  " + Hex.u2(n3) + " // " + type.toHuman());
            }
        }
        annotatedOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            annotatedOutput.writeShort(typeIdsSection.indexOf(this.list.getType(n)));
        }
    }

    protected int compareTo0(OffsettedItem offsettedItem) {
        TypeList typeList = this.list;
        TypeList typeList2 = ((TypeListItem)offsettedItem).list;
        return StdTypeList.compareContents(typeList, typeList2);
    }
}

