/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.gen.BinaryOp;
import com.android.dx.gen.Comparison;
import com.android.dx.gen.Constants;
import com.android.dx.gen.DexGenerator;
import com.android.dx.gen.FieldId;
import com.android.dx.gen.Label;
import com.android.dx.gen.Local;
import com.android.dx.gen.MethodId;
import com.android.dx.gen.Type;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.code.ThrowingCstInsn;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.type.StdTypeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Code {
    private final MethodId<?, ?> method;
    private final List<Label> labels = new ArrayList<Label>();
    private Label currentLabel;
    private boolean localsInitialized;
    private final Local<?> thisLocal;
    private final List<Local<?>> parameters = new ArrayList();
    private final List<Local<?>> locals = new ArrayList();
    private SourcePosition sourcePosition = SourcePosition.NO_INFO;
    private final List<Type<?>> catchTypes = new ArrayList();
    private final List<Label> catchLabels = new ArrayList<Label>();
    private StdTypeList catches = StdTypeList.EMPTY;

    Code(DexGenerator.MethodDeclaration methodDeclaration) {
        this.method = methodDeclaration.method;
        this.thisLocal = methodDeclaration.isStatic() ? null : Local.get(this, this.method.declaringType);
        for (Type<?> type : this.method.parameters.types) {
            this.parameters.add(Local.get(this, type));
        }
        this.currentLabel = this.newLabel();
        this.currentLabel.marked = true;
    }

    public <T> Local<T> newLocal(Type<T> type) {
        if (this.localsInitialized) {
            throw new IllegalStateException("Cannot allocate locals after adding instructions");
        }
        Local<T> local = Local.get(this, type);
        this.locals.add(local);
        return local;
    }

    public <T> Local<T> getParameter(int n, Type<T> type) {
        return this.coerce(this.parameters.get(n), type);
    }

    public <T> Local<T> getThis(Type<T> type) {
        if (this.thisLocal == null) {
            throw new IllegalStateException("static methods cannot access 'this'");
        }
        return this.coerce(this.thisLocal, type);
    }

    private <T> Local<T> coerce(Local<?> local, Type<T> type) {
        if (!local.type.equals(type)) {
            throw new IllegalArgumentException("requested " + type + " but was " + local.type);
        }
        return local;
    }

    void initializeLocals() {
        if (this.localsInitialized) {
            throw new AssertionError();
        }
        this.localsInitialized = true;
        int n = 0;
        for (Local<?> object2 : this.locals) {
            n += object2.initialize(n);
        }
        if (this.thisLocal != null) {
            n += this.thisLocal.initialize(n);
        }
        int n2 = n;
        ArrayList<PlainCstInsn> arrayList = new ArrayList<PlainCstInsn>();
        for (Local<?> local : this.parameters) {
            CstInteger cstInteger = CstInteger.make(n - n2);
            n += local.initialize(n);
            arrayList.add(new PlainCstInsn(Rops.opMoveParam(local.type.ropType), this.sourcePosition, local.spec(), RegisterSpecList.EMPTY, cstInteger));
        }
        this.labels.get((int)0).instructions.addAll(0, arrayList);
    }

    int paramSize() {
        int n = 0;
        for (Local<?> local : this.parameters) {
            n += local.size();
        }
        return n;
    }

    public Label newLabel() {
        Label label = new Label();
        this.labels.add(label);
        return label;
    }

    public void mark(Label label) {
        if (label.marked) {
            throw new IllegalStateException("already marked");
        }
        label.marked = true;
        if (this.currentLabel != null) {
            this.jump(label);
        }
        this.currentLabel = label;
    }

    public void jump(Label label) {
        this.addInstruction(new PlainInsn(Rops.GOTO, this.sourcePosition, null, RegisterSpecList.EMPTY), label);
    }

    public void addCatchClause(Type<?> type, Label label) {
        if (this.catchTypes.contains(type)) {
            throw new IllegalArgumentException("Already caught: " + type);
        }
        this.catchTypes.add(type);
        this.catches = this.toTypeList(this.catchTypes);
        this.catchLabels.add(label);
    }

    public Label removeCatchClause(Type<?> type) {
        int n = this.catchTypes.indexOf(type);
        if (n == -1) {
            throw new IllegalArgumentException("No catch clause: " + type);
        }
        this.catchTypes.remove(n);
        this.catches = this.toTypeList(this.catchTypes);
        return this.catchLabels.remove(n);
    }

    public void throwValue(Local<?> local) {
        this.addInstruction(new ThrowingInsn(Rops.THROW, this.sourcePosition, RegisterSpecList.make(local.spec()), this.catches));
    }

    private StdTypeList toTypeList(List<Type<?>> list) {
        StdTypeList stdTypeList = new StdTypeList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            stdTypeList.set(i, list.get((int)i).ropType);
        }
        return stdTypeList;
    }

    private void addInstruction(Insn insn) {
        this.addInstruction(insn, null);
    }

    private void addInstruction(Insn insn, Label label) {
        if (this.currentLabel == null || !this.currentLabel.marked) {
            throw new IllegalStateException("no current label");
        }
        this.currentLabel.instructions.add(insn);
        switch (insn.getOpcode().getBranchingness()) {
            case 1: {
                if (label != null) {
                    throw new IllegalArgumentException("unexpected branch: " + label);
                }
                return;
            }
            case 2: {
                if (label != null) {
                    throw new IllegalArgumentException("unexpected branch: " + label);
                }
                this.currentLabel = null;
                break;
            }
            case 3: {
                if (label == null) {
                    throw new IllegalArgumentException("branch == null");
                }
                this.currentLabel.primarySuccessor = label;
                this.currentLabel = null;
                break;
            }
            case 4: {
                if (label == null) {
                    throw new IllegalArgumentException("branch == null");
                }
                this.splitCurrentLabel(label, Collections.<Label>emptyList());
                break;
            }
            case 6: {
                if (label != null) {
                    throw new IllegalArgumentException("unexpected branch: " + label);
                }
                this.splitCurrentLabel(null, new ArrayList<Label>(this.catchLabels));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void splitCurrentLabel(Label label, List<Label> list) {
        Label label2;
        this.currentLabel.primarySuccessor = label2 = this.newLabel();
        this.currentLabel.alternateSuccessor = label;
        this.currentLabel.catchLabels = list;
        this.currentLabel = label2;
        this.currentLabel.marked = true;
    }

    public <T> void loadConstant(Local<T> local, T t) {
        Rop rop = Rops.opConst(local.type.ropType);
        if (rop.getBranchingness() == 1) {
            this.addInstruction(new PlainCstInsn(rop, this.sourcePosition, local.spec(), RegisterSpecList.EMPTY, Constants.getConstant(t)));
        } else {
            this.addInstruction(new ThrowingCstInsn(rop, this.sourcePosition, RegisterSpecList.EMPTY, this.catches, (Constant)Constants.getConstant(t)));
            this.moveResult(local, true);
        }
    }

    public <T> void negate(Local<T> local, Local<T> local2) {
        this.unary(Rops.opNeg(local.type.ropType), local, local2);
    }

    public <T> void not(Local<T> local, Local<T> local2) {
        this.unary(Rops.opNot(local.type.ropType), local, local2);
    }

    public void numericCast(Local<?> local, Local<?> local2) {
        this.unary(this.getCastRop(local.type.ropType, local2.type.ropType), local, local2);
    }

    private Rop getCastRop(com.android.dx.rop.type.Type type, com.android.dx.rop.type.Type type2) {
        if (type.getBasicType() == 6) {
            switch (type2.getBasicType()) {
                case 8: {
                    return Rops.TO_SHORT;
                }
                case 3: {
                    return Rops.TO_CHAR;
                }
                case 2: {
                    return Rops.TO_BYTE;
                }
            }
        }
        return Rops.opConv(type2, type);
    }

    private void unary(Rop rop, Local<?> local, Local<?> local2) {
        this.addInstruction(new PlainInsn(rop, this.sourcePosition, local2.spec(), local.spec()));
    }

    public <T> void op(BinaryOp binaryOp, Local<T> local, Local<T> local2, Local<T> local3) {
        Rop rop = binaryOp.rop(StdTypeList.make(local2.type.ropType, local3.type.ropType));
        RegisterSpecList registerSpecList = RegisterSpecList.make(local2.spec(), local3.spec());
        if (rop.getBranchingness() == 1) {
            this.addInstruction(new PlainInsn(rop, this.sourcePosition, local.spec(), registerSpecList));
        } else {
            this.addInstruction(new ThrowingInsn(rop, this.sourcePosition, registerSpecList, this.catches));
            this.moveResult(local, true);
        }
    }

    public <T> void compare(Comparison comparison, Local<T> local, Local<T> local2, Label label) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        Rop rop = comparison.rop(StdTypeList.make(local.type.ropType, local2.type.ropType));
        this.addInstruction(new PlainInsn(rop, this.sourcePosition, null, RegisterSpecList.make(local.spec(), local2.spec())), label);
    }

    public <T extends Number> void compare(Local<T> local, Local<T> local2, Local<Integer> local3, int n) {
        Rop rop;
        if (n == 1) {
            rop = Rops.opCmpg(local.type.ropType);
        } else if (n == -1) {
            rop = Rops.opCmpl(local.type.ropType);
        } else {
            throw new IllegalArgumentException("expected 1 or -1 but was " + n);
        }
        this.addInstruction(new PlainInsn(rop, this.sourcePosition, local3.spec(), RegisterSpecList.make(local.spec(), local2.spec())));
    }

    public <T> void compare(Local<T> local, Local<T> local2, Local<?> local3) {
        this.addInstruction(new PlainInsn(Rops.CMPL_LONG, this.sourcePosition, local3.spec(), RegisterSpecList.make(local.spec(), local2.spec())));
    }

    public <D, V> void iget(FieldId<D, V> fieldId, Local<D> local, Local<V> local2) {
        this.addInstruction(new ThrowingCstInsn(Rops.opGetField(local2.type.ropType), this.sourcePosition, RegisterSpecList.make(local.spec()), this.catches, (Constant)fieldId.constant));
        this.moveResult(local2, true);
    }

    public <D, V> void iput(FieldId<D, V> fieldId, Local<D> local, Local<V> local2) {
        this.addInstruction(new ThrowingCstInsn(Rops.opPutField(local2.type.ropType), this.sourcePosition, RegisterSpecList.make(local2.spec(), local.spec()), this.catches, (Constant)fieldId.constant));
    }

    public <V> void sget(FieldId<?, V> fieldId, Local<V> local) {
        this.addInstruction(new ThrowingCstInsn(Rops.opGetStatic(local.type.ropType), this.sourcePosition, RegisterSpecList.EMPTY, this.catches, (Constant)fieldId.constant));
        this.moveResult(local, true);
    }

    public <V> void sput(FieldId<?, V> fieldId, Local<V> local) {
        this.addInstruction(new ThrowingCstInsn(Rops.opPutStatic(local.type.ropType), this.sourcePosition, RegisterSpecList.make(local.spec()), this.catches, (Constant)fieldId.constant));
    }

    public <T> void newInstance(Local<T> local, MethodId<T, Void> methodId, Local<?> ... localArray) {
        if (local == null) {
            throw new IllegalArgumentException();
        }
        this.addInstruction(new ThrowingCstInsn(Rops.NEW_INSTANCE, this.sourcePosition, RegisterSpecList.EMPTY, this.catches, (Constant)methodId.declaringType.constant));
        this.moveResult(local, true);
        this.invokeDirect(methodId, null, local, localArray);
    }

    public <R> void invokeStatic(MethodId<?, R> methodId, Local<? super R> local, Local<?> ... localArray) {
        this.invoke(Rops.opInvokeStatic(methodId.prototype(true)), methodId, local, null, localArray);
    }

    public <D, R> void invokeVirtual(MethodId<D, R> methodId, Local<? super R> local, Local<? extends D> local2, Local<?> ... localArray) {
        this.invoke(Rops.opInvokeVirtual(methodId.prototype(true)), methodId, local, local2, localArray);
    }

    public <D, R> void invokeDirect(MethodId<D, R> methodId, Local<? super R> local, Local<? extends D> local2, Local<?> ... localArray) {
        this.invoke(Rops.opInvokeDirect(methodId.prototype(true)), methodId, local, local2, localArray);
    }

    public <D, R> void invokeSuper(MethodId<D, R> methodId, Local<? super R> local, Local<? extends D> local2, Local<?> ... localArray) {
        this.invoke(Rops.opInvokeSuper(methodId.prototype(true)), methodId, local, local2, localArray);
    }

    public <D, R> void invokeInterface(MethodId<D, R> methodId, Local<? super R> local, Local<? extends D> local2, Local<?> ... localArray) {
        this.invoke(Rops.opInvokeInterface(methodId.prototype(true)), methodId, local, local2, localArray);
    }

    private <D, R> void invoke(Rop rop, MethodId<D, R> methodId, Local<? super R> local, Local<? extends D> local2, Local<?> ... localArray) {
        this.addInstruction(new ThrowingCstInsn(rop, this.sourcePosition, Code.concatenate(local2, localArray), this.catches, (Constant)methodId.constant));
        if (local != null) {
            this.moveResult(local, false);
        }
    }

    public void instanceOfType(Local<?> local, Local<?> local2, Type<?> type) {
        this.addInstruction(new ThrowingCstInsn(Rops.INSTANCE_OF, this.sourcePosition, RegisterSpecList.make(local2.spec()), this.catches, (Constant)type.constant));
        this.moveResult(local, true);
    }

    public void typeCast(Local<?> local, Local<?> local2) {
        this.addInstruction(new ThrowingCstInsn(Rops.CHECK_CAST, this.sourcePosition, RegisterSpecList.make(local.spec()), this.catches, (Constant)local2.type.constant));
        this.moveResult(local2, true);
    }

    public <T> void arrayLength(Local<T> local, Local<Integer> local2) {
        this.addInstruction(new ThrowingInsn(Rops.ARRAY_LENGTH, this.sourcePosition, RegisterSpecList.make(local.spec()), this.catches));
        this.moveResult(local2, true);
    }

    public <T> void newArray(Local<Integer> local, Local<T> local2) {
        this.addInstruction(new ThrowingCstInsn(Rops.opNewArray(local2.type.ropType), this.sourcePosition, RegisterSpecList.make(local.spec()), this.catches, (Constant)local2.type.constant));
        this.moveResult(local2, true);
    }

    public void aget(Local<?> local, Local<Integer> local2, Local<?> local3) {
        this.addInstruction(new ThrowingInsn(Rops.opAget(local3.type.ropType), this.sourcePosition, RegisterSpecList.make(local.spec(), local2.spec()), this.catches));
        this.moveResult(local3, true);
    }

    public void aput(Local<?> local, Local<Integer> local2, Local<?> local3) {
        this.addInstruction(new ThrowingInsn(Rops.opAput(local3.type.ropType), this.sourcePosition, RegisterSpecList.make(local3.spec(), local.spec(), local2.spec()), this.catches));
    }

    public void returnVoid() {
        if (!this.method.returnType.equals(Type.VOID)) {
            throw new IllegalArgumentException("declared " + this.method.returnType + " but returned void");
        }
        this.addInstruction(new PlainInsn(Rops.RETURN_VOID, this.sourcePosition, null, RegisterSpecList.EMPTY));
    }

    public void returnValue(Local<?> local) {
        if (!local.type.equals(this.method.returnType)) {
            throw new IllegalArgumentException("declared " + this.method.returnType + " but returned " + local.type);
        }
        this.addInstruction(new PlainInsn(Rops.opReturn(local.type.ropType), this.sourcePosition, null, RegisterSpecList.make(local.spec())));
    }

    private void moveResult(Local<?> local, boolean bl) {
        Rop rop = bl ? Rops.opMoveResultPseudo(local.type.ropType) : Rops.opMoveResult(local.type.ropType);
        this.addInstruction(new PlainInsn(rop, this.sourcePosition, local.spec(), RegisterSpecList.EMPTY));
    }

    BasicBlockList toBasicBlocks() {
        if (!this.localsInitialized) {
            this.initializeLocals();
        }
        this.cleanUpLabels();
        BasicBlockList basicBlockList = new BasicBlockList(this.labels.size());
        for (int i = 0; i < this.labels.size(); ++i) {
            basicBlockList.set(i, this.labels.get(i).toBasicBlock());
        }
        return basicBlockList;
    }

    private void cleanUpLabels() {
        int n = 0;
        Iterator<Label> iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            Label label = iterator.next();
            if (label.isEmpty()) {
                iterator.remove();
                continue;
            }
            label.compact();
            label.id = n++;
        }
    }

    private static RegisterSpecList concatenate(Local<?> local, Local<?>[] localArray) {
        int n = local != null ? 1 : 0;
        RegisterSpecList registerSpecList = new RegisterSpecList(n + localArray.length);
        if (local != null) {
            registerSpecList.set(0, local.spec());
        }
        for (int i = 0; i < localArray.length; ++i) {
            registerSpecList.set(i + n, localArray[i].spec());
        }
        return registerSpecList;
    }
}

