/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.gen.Type;
import com.android.dx.rop.cst.CstBoolean;
import com.android.dx.rop.cst.CstByte;
import com.android.dx.rop.cst.CstChar;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstKnownNull;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstShort;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.TypedConstant;

final class Constants {
    private Constants() {
    }

    static TypedConstant getConstant(Object object) {
        if (object == null) {
            return CstKnownNull.THE_ONE;
        }
        if (object instanceof Boolean) {
            return CstBoolean.make((Boolean)object);
        }
        if (object instanceof Byte) {
            return CstByte.make((Byte)object);
        }
        if (object instanceof Character) {
            return CstChar.make(((Character)object).charValue());
        }
        if (object instanceof Double) {
            return CstDouble.make(Double.doubleToLongBits((Double)object));
        }
        if (object instanceof Float) {
            return CstFloat.make(Float.floatToIntBits(((Float)object).floatValue()));
        }
        if (object instanceof Integer) {
            return CstInteger.make((Integer)object);
        }
        if (object instanceof Long) {
            return CstLong.make((Long)object);
        }
        if (object instanceof Short) {
            return CstShort.make((Short)object);
        }
        if (object instanceof String) {
            return new CstString((String)object);
        }
        if (object instanceof Class) {
            return new CstType(Type.get((Class)object).ropType);
        }
        if (object instanceof Type) {
            return new CstType(((Type)object).ropType);
        }
        throw new UnsupportedOperationException("Not a constant: " + object);
    }
}

