/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.dex.DexOptions;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.RopTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedField;
import com.android.dx.dex.file.EncodedMember;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.gen.Code;
import com.android.dx.gen.Constants;
import com.android.dx.gen.FieldId;
import com.android.dx.gen.MethodId;
import com.android.dx.gen.Type;
import com.android.dx.gen.TypeList;
import com.android.dx.rop.code.LocalVariableInfo;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.StdTypeList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DexGenerator {
    private final Map<Type<?>, TypeDeclaration> types = new LinkedHashMap();

    private TypeDeclaration getTypeDeclaration(Type<?> type) {
        TypeDeclaration typeDeclaration = this.types.get(type);
        if (typeDeclaration == null) {
            typeDeclaration = new TypeDeclaration(type);
            this.types.put(type, typeDeclaration);
        }
        return typeDeclaration;
    }

    public void declare(Type<?> type, String string, int n, Type<?> type2, Type<?> ... typeArray) {
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(type);
        if (typeDeclaration.declared) {
            throw new IllegalStateException("already declared: " + type);
        }
        typeDeclaration.declared = true;
        typeDeclaration.flags = n;
        typeDeclaration.supertype = type2;
        typeDeclaration.sourceFile = string;
        typeDeclaration.interfaces = new TypeList(typeArray);
    }

    public Code declare(MethodId<?, ?> methodId, int n) {
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(methodId.declaringType);
        if (typeDeclaration.methods.containsKey(methodId)) {
            throw new IllegalStateException("already declared: " + methodId);
        }
        MethodDeclaration methodDeclaration = new MethodDeclaration(methodId, n);
        typeDeclaration.methods.put(methodId, methodDeclaration);
        return methodDeclaration.code;
    }

    public void declare(FieldId<?, ?> fieldId, int n, Object object) {
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(fieldId.declaringType);
        if (typeDeclaration.fields.containsKey(fieldId)) {
            throw new IllegalStateException("already declared: " + fieldId);
        }
        FieldDeclaration fieldDeclaration = new FieldDeclaration(fieldId, n, object);
        typeDeclaration.fields.put(fieldId, fieldDeclaration);
    }

    public byte[] generate() {
        DexFile dexFile = new DexFile(new DexOptions());
        for (TypeDeclaration typeDeclaration : this.types.values()) {
            dexFile.add(typeDeclaration.toClassDefItem());
        }
        try {
            return dexFile.toDex(null, false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public ClassLoader load(ClassLoader classLoader) throws IOException {
        byte[] byArray = this.generate();
        File file = File.createTempFile("Generated", ".jar");
        file.deleteOnExit();
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
        jarOutputStream.putNextEntry(new JarEntry("classes.dex"));
        jarOutputStream.write(byArray);
        jarOutputStream.closeEntry();
        jarOutputStream.close();
        try {
            Class<?> clazz = Class.forName("dalvik.system.PathClassLoader");
            return (ClassLoader)clazz.getConstructor(String.class, ClassLoader.class).newInstance(file.getPath(), classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("load() requires a Dalvik VM", classNotFoundException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getCause());
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodDeclaration {
        final MethodId<?, ?> method;
        private final int flags;
        private final Code code;

        public MethodDeclaration(MethodId<?, ?> methodId, int n) {
            this.method = methodId;
            this.flags = n;
            this.code = new Code(this);
        }

        boolean isStatic() {
            return (this.flags & 8) != 0;
        }

        boolean isDirect() {
            return (this.flags & 0x1000A) != 0;
        }

        EncodedMethod toEncodedMethod(DexOptions dexOptions) {
            RopMethod ropMethod = new RopMethod(this.code.toBasicBlocks(), 0);
            LocalVariableInfo localVariableInfo = null;
            DalvCode dalvCode = RopTranslator.translate(ropMethod, 1, localVariableInfo, this.code.paramSize(), dexOptions);
            return new EncodedMethod(this.method.constant, this.flags, dalvCode, StdTypeList.EMPTY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldDeclaration {
        final FieldId<?, ?> fieldId;
        private final int accessFlags;
        private final Object staticValue;

        FieldDeclaration(FieldId<?, ?> fieldId, int n, Object object) {
            if ((n & 8) == 0 && object != null) {
                throw new IllegalArgumentException("instance fields may not have a value");
            }
            this.fieldId = fieldId;
            this.accessFlags = n;
            this.staticValue = object;
        }

        EncodedField toEncodedField() {
            return new EncodedField(this.fieldId.constant, this.accessFlags);
        }

        public boolean isStatic() {
            return (this.accessFlags & 8) != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDeclaration {
        private final Type<?> type;
        private boolean declared;
        private int flags;
        private Type<?> supertype;
        private String sourceFile;
        private TypeList interfaces;
        private final Map<FieldId, FieldDeclaration> fields = new LinkedHashMap<FieldId, FieldDeclaration>();
        private final Map<MethodId, MethodDeclaration> methods = new LinkedHashMap<MethodId, MethodDeclaration>();

        TypeDeclaration(Type<?> type) {
            this.type = type;
        }

        ClassDefItem toClassDefItem() {
            EncodedMember encodedMember;
            if (!this.declared) {
                throw new IllegalStateException("Undeclared type " + this.type + " declares members: " + this.fields.keySet() + " " + this.methods.keySet());
            }
            DexOptions dexOptions = new DexOptions();
            dexOptions.targetApiLevel = 13;
            CstType cstType = this.type.constant;
            ClassDefItem classDefItem = new ClassDefItem(cstType, this.flags, this.supertype.constant, this.interfaces.ropTypes, new CstString(this.sourceFile));
            for (MethodDeclaration object : this.methods.values()) {
                encodedMember = object.toEncodedMethod(dexOptions);
                if (object.isDirect()) {
                    classDefItem.addDirectMethod((EncodedMethod)encodedMember);
                    continue;
                }
                classDefItem.addVirtualMethod((EncodedMethod)encodedMember);
            }
            for (FieldDeclaration fieldDeclaration : this.fields.values()) {
                encodedMember = fieldDeclaration.toEncodedField();
                if (fieldDeclaration.isStatic()) {
                    classDefItem.addStaticField((EncodedField)encodedMember, Constants.getConstant(fieldDeclaration.staticValue));
                    continue;
                }
                classDefItem.addInstanceField((EncodedField)encodedMember);
            }
            return classDefItem;
        }
    }
}

