/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.InsnList;
import com.android.dx.util.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Label {
    final List<Insn> instructions = new ArrayList<Insn>();
    boolean marked = false;
    List<Label> catchLabels = Collections.emptyList();
    Label primarySuccessor;
    Label alternateSuccessor;
    int id = -1;

    Label() {
    }

    boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    void compact() {
        for (int i = 0; i < this.catchLabels.size(); ++i) {
            while (this.catchLabels.get(i).isEmpty()) {
                this.catchLabels.set(i, this.catchLabels.get((int)i).primarySuccessor);
            }
        }
        while (this.primarySuccessor != null && this.primarySuccessor.isEmpty()) {
            this.primarySuccessor = this.primarySuccessor.primarySuccessor;
        }
        while (this.alternateSuccessor != null && this.alternateSuccessor.isEmpty()) {
            this.alternateSuccessor = this.alternateSuccessor.primarySuccessor;
        }
    }

    BasicBlock toBasicBlock() {
        int n;
        InsnList insnList = new InsnList(this.instructions.size());
        for (n = 0; n < this.instructions.size(); ++n) {
            insnList.set(n, this.instructions.get(n));
        }
        insnList.setImmutable();
        n = -1;
        IntList intList = new IntList();
        for (Label label : this.catchLabels) {
            intList.add(label.id);
        }
        if (this.primarySuccessor != null) {
            n = this.primarySuccessor.id;
            intList.add(n);
        }
        if (this.alternateSuccessor != null) {
            intList.add(this.alternateSuccessor.id);
        }
        intList.setImmutable();
        return new BasicBlock(this.id, insnList, intList, n);
    }
}

