/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.gen.Type;
import com.android.dx.gen.TypeList;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Prototype;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodId<D, R> {
    final Type<D> declaringType;
    final Type<R> returnType;
    final String name;
    final TypeList parameters;
    final CstNat nat;
    final CstMethodRef constant;

    MethodId(Type<D> type, Type<R> type2, String string, TypeList typeList) {
        if (type == null || type2 == null || string == null || typeList == null) {
            throw new NullPointerException();
        }
        this.declaringType = type;
        this.returnType = type2;
        this.name = string;
        this.parameters = typeList;
        this.nat = new CstNat(new CstString(string), new CstString(this.descriptor(false)));
        this.constant = new CstMethodRef(type.constant, this.nat);
    }

    public Type<D> getDeclaringType() {
        return this.declaringType;
    }

    public Type<R> getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public List<Type<?>> getParameters() {
        return this.parameters.asList();
    }

    String descriptor(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        if (bl) {
            stringBuilder.append(this.declaringType.name);
        }
        for (Type<?> type : this.parameters.types) {
            stringBuilder.append(type.name);
        }
        stringBuilder.append(")");
        stringBuilder.append(this.returnType.name);
        return stringBuilder.toString();
    }

    Prototype prototype(boolean bl) {
        return Prototype.intern(this.descriptor(bl));
    }

    public boolean equals(Object object) {
        return object instanceof MethodId && ((MethodId)object).declaringType.equals(this.declaringType) && ((MethodId)object).name.equals(this.name) && ((MethodId)object).parameters.equals(this.parameters) && ((MethodId)object).returnType.equals(this.returnType);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.declaringType.hashCode();
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.parameters.hashCode();
        n = 31 * n + this.returnType.hashCode();
        return n;
    }

    public String toString() {
        return this.declaringType + "." + this.name + "(" + this.parameters + ")";
    }
}

