/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.gen.FieldId;
import com.android.dx.gen.MethodId;
import com.android.dx.gen.TypeList;
import com.android.dx.rop.cst.CstType;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Type<T> {
    public static final Type<Boolean> BOOLEAN = new Type(com.android.dx.rop.type.Type.BOOLEAN);
    public static final Type<Byte> BYTE = new Type(com.android.dx.rop.type.Type.BYTE);
    public static final Type<Character> CHAR = new Type(com.android.dx.rop.type.Type.CHAR);
    public static final Type<Double> DOUBLE = new Type(com.android.dx.rop.type.Type.DOUBLE);
    public static final Type<Float> FLOAT = new Type(com.android.dx.rop.type.Type.FLOAT);
    public static final Type<Integer> INT = new Type(com.android.dx.rop.type.Type.INT);
    public static final Type<Long> LONG = new Type(com.android.dx.rop.type.Type.LONG);
    public static final Type<Short> SHORT = new Type(com.android.dx.rop.type.Type.SHORT);
    public static final Type<Void> VOID = new Type(com.android.dx.rop.type.Type.VOID);
    public static final Type<Object> OBJECT = new Type(com.android.dx.rop.type.Type.OBJECT);
    public static final Type<String> STRING = new Type(com.android.dx.rop.type.Type.STRING);
    private static final Map<Class<?>, Type<?>> PRIMITIVE_TO_TYPE = new HashMap();
    final String name;
    final com.android.dx.rop.type.Type ropType;
    final CstType constant;

    Type(com.android.dx.rop.type.Type type) {
        this(type.getDescriptor(), type);
    }

    Type(String string, com.android.dx.rop.type.Type type) {
        if (string == null || type == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.ropType = type;
        this.constant = CstType.intern(type);
    }

    public static <T> Type<T> get(String string) {
        return new Type<T>(string, com.android.dx.rop.type.Type.internReturnType(string));
    }

    public static <T> Type<T> get(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            Type<?> type = PRIMITIVE_TO_TYPE.get(clazz);
            return type;
        }
        String string = clazz.getName().replace('.', '/');
        return Type.get(clazz.isArray() ? string : 'L' + string + ';');
    }

    public <V> FieldId<T, V> getField(Type<V> type, String string) {
        return new FieldId(this, type, string);
    }

    public MethodId<T, Void> getConstructor(Type<?> ... typeArray) {
        return new MethodId(this, VOID, "<init>", new TypeList(typeArray));
    }

    public <R> MethodId<T, R> getMethod(Type<R> type, String string, Type<?> ... typeArray) {
        return new MethodId(this, type, string, new TypeList(typeArray));
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        return object instanceof Type && ((Type)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    static {
        PRIMITIVE_TO_TYPE.put(Boolean.TYPE, BOOLEAN);
        PRIMITIVE_TO_TYPE.put(Byte.TYPE, BYTE);
        PRIMITIVE_TO_TYPE.put(Character.TYPE, CHAR);
        PRIMITIVE_TO_TYPE.put(Double.TYPE, DOUBLE);
        PRIMITIVE_TO_TYPE.put(Float.TYPE, FLOAT);
        PRIMITIVE_TO_TYPE.put(Integer.TYPE, INT);
        PRIMITIVE_TO_TYPE.put(Long.TYPE, LONG);
        PRIMITIVE_TO_TYPE.put(Short.TYPE, SHORT);
        PRIMITIVE_TO_TYPE.put(Void.TYPE, VOID);
    }
}

