/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.DexBuffer;
import com.android.dx.util.Unsigned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldId
implements Comparable<FieldId> {
    private final DexBuffer buffer;
    private final int declaringClassIndex;
    private final int typeIndex;
    private final int nameIndex;

    public FieldId(DexBuffer dexBuffer, int n, int n2, int n3) {
        this.buffer = dexBuffer;
        this.declaringClassIndex = n;
        this.typeIndex = n2;
        this.nameIndex = n3;
    }

    public int getDeclaringClassIndex() {
        return this.declaringClassIndex;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public int compareTo(FieldId fieldId) {
        if (this.declaringClassIndex != fieldId.declaringClassIndex) {
            return Unsigned.compare(this.declaringClassIndex, fieldId.declaringClassIndex);
        }
        if (this.nameIndex != fieldId.nameIndex) {
            return Unsigned.compare(this.nameIndex, fieldId.nameIndex);
        }
        return Unsigned.compare(this.typeIndex, fieldId.typeIndex);
    }

    public void writeTo(DexBuffer.Section section) {
        section.writeUnsignedShort(this.declaringClassIndex);
        section.writeUnsignedShort(this.typeIndex);
        section.writeInt(this.nameIndex);
    }

    public String toString() {
        if (this.buffer == null) {
            return this.declaringClassIndex + " " + this.typeIndex + " " + this.nameIndex;
        }
        return this.buffer.typeNames().get(this.typeIndex) + "." + this.buffer.strings().get(this.nameIndex);
    }
}

