/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dx.dex.TableOfContents;
import com.android.dx.io.Annotation;
import com.android.dx.io.ClassData;
import com.android.dx.io.ClassDef;
import com.android.dx.io.Code;
import com.android.dx.io.DexBuffer;
import com.android.dx.io.DexHasher;
import com.android.dx.io.FieldId;
import com.android.dx.io.MethodId;
import com.android.dx.io.ProtoId;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.IndexMap;
import com.android.dx.merge.InstructionTransformer;
import com.android.dx.merge.SortableType;
import com.android.dx.merge.TypeList;
import com.android.dx.util.DexException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DexMerger {
    private final DexBuffer dexA;
    private final DexBuffer dexB;
    private final CollisionPolicy collisionPolicy;
    private final WriterSizes writerSizes;
    private final DexBuffer dexOut = new DexBuffer();
    private final DexBuffer.Section headerOut;
    private final DexBuffer.Section idsDefsOut;
    private final DexBuffer.Section mapListOut;
    private final DexBuffer.Section typeListOut;
    private final DexBuffer.Section classDataOut;
    private final DexBuffer.Section codeOut;
    private final DexBuffer.Section stringDataOut;
    private final DexBuffer.Section debugInfoOut;
    private final DexBuffer.Section encodedArrayOut;
    private final DexBuffer.Section annotationsDirectoryOut;
    private final DexBuffer.Section annotationSetOut;
    private final DexBuffer.Section annotationSetRefListOut;
    private final DexBuffer.Section annotationOut;
    private final TableOfContents contentsOut;
    private final IndexMap aIndexMap;
    private final IndexMap bIndexMap;
    private final InstructionTransformer aInstructionTransformer;
    private final InstructionTransformer bInstructionTransformer;
    private int compactWasteThreshold = 0x100000;

    public DexMerger(DexBuffer dexBuffer, DexBuffer dexBuffer2, CollisionPolicy collisionPolicy) throws IOException {
        this(dexBuffer, dexBuffer2, collisionPolicy, new WriterSizes(dexBuffer, dexBuffer2));
    }

    private DexMerger(DexBuffer dexBuffer, DexBuffer dexBuffer2, CollisionPolicy collisionPolicy, WriterSizes writerSizes) throws IOException {
        this.dexA = dexBuffer;
        this.dexB = dexBuffer2;
        this.collisionPolicy = collisionPolicy;
        this.writerSizes = writerSizes;
        TableOfContents tableOfContents = dexBuffer.getTableOfContents();
        TableOfContents tableOfContents2 = dexBuffer2.getTableOfContents();
        this.aIndexMap = new IndexMap(this.dexOut, tableOfContents);
        this.bIndexMap = new IndexMap(this.dexOut, tableOfContents2);
        this.aInstructionTransformer = new InstructionTransformer(this.aIndexMap);
        this.bInstructionTransformer = new InstructionTransformer(this.bIndexMap);
        this.headerOut = this.dexOut.appendSection(writerSizes.header, "header");
        this.idsDefsOut = this.dexOut.appendSection(writerSizes.idsDefs, "ids defs");
        this.contentsOut = this.dexOut.getTableOfContents();
        this.contentsOut.dataOff = this.dexOut.getLength();
        this.contentsOut.mapList.off = this.dexOut.getLength();
        this.contentsOut.mapList.size = 1;
        this.mapListOut = this.dexOut.appendSection(writerSizes.mapList, "map list");
        this.contentsOut.typeLists.off = this.dexOut.getLength();
        this.typeListOut = this.dexOut.appendSection(writerSizes.typeList, "type list");
        this.contentsOut.annotationSetRefLists.off = this.dexOut.getLength();
        this.annotationSetRefListOut = this.dexOut.appendSection(writerSizes.annotationsSetRefList, "annotation set ref list");
        this.contentsOut.annotationSets.off = this.dexOut.getLength();
        this.annotationSetOut = this.dexOut.appendSection(writerSizes.annotationsSet, "annotation sets");
        this.contentsOut.classDatas.off = this.dexOut.getLength();
        this.classDataOut = this.dexOut.appendSection(writerSizes.classData, "class data");
        this.contentsOut.codes.off = this.dexOut.getLength();
        this.codeOut = this.dexOut.appendSection(writerSizes.code, "code");
        this.contentsOut.stringDatas.off = this.dexOut.getLength();
        this.stringDataOut = this.dexOut.appendSection(writerSizes.stringData, "string data");
        this.contentsOut.debugInfos.off = this.dexOut.getLength();
        this.debugInfoOut = this.dexOut.appendSection(writerSizes.debugInfo, "debug info");
        this.contentsOut.annotations.off = this.dexOut.getLength();
        this.annotationOut = this.dexOut.appendSection(writerSizes.annotation, "annotation");
        this.contentsOut.encodedArrays.off = this.dexOut.getLength();
        this.encodedArrayOut = this.dexOut.appendSection(writerSizes.encodedArray, "encoded array");
        this.contentsOut.annotationsDirectories.off = this.dexOut.getLength();
        this.annotationsDirectoryOut = this.dexOut.appendSection(writerSizes.annotationsDirectory, "annotations directory");
        this.dexOut.noMoreSections();
        this.contentsOut.dataSize = this.dexOut.getLength() - this.contentsOut.dataOff;
    }

    public void setCompactWasteThreshold(int n) {
        this.compactWasteThreshold = n;
    }

    private DexBuffer mergeDexBuffers() throws IOException {
        this.mergeStringIds();
        this.mergeTypeIds();
        this.mergeTypeLists();
        this.mergeProtoIds();
        this.mergeFieldIds();
        this.mergeMethodIds();
        this.mergeAnnotations();
        this.unionAnnotationSetsAndDirectories();
        this.mergeClassDefs();
        this.contentsOut.header.off = 0;
        this.contentsOut.header.size = 1;
        this.contentsOut.fileSize = this.dexOut.getLength();
        this.contentsOut.computeSizesFromOffsets();
        this.contentsOut.writeHeader(this.headerOut);
        this.contentsOut.writeMap(this.mapListOut);
        new DexHasher().writeHashes(this.dexOut);
        return this.dexOut;
    }

    public DexBuffer merge() throws IOException {
        long l = System.nanoTime();
        DexBuffer dexBuffer = this.mergeDexBuffers();
        WriterSizes writerSizes = this.writerSizes.clone();
        writerSizes.minusWaste(this);
        int n = this.writerSizes.size() - writerSizes.size();
        if (n > this.compactWasteThreshold) {
            DexMerger dexMerger = new DexMerger(this.dexOut, new DexBuffer(), CollisionPolicy.FAIL, writerSizes);
            dexBuffer = dexMerger.mergeDexBuffers();
            System.out.printf("Result compacted from %.1fKiB to %.1fKiB to save %.1fKiB%n", Float.valueOf((float)this.dexOut.getLength() / 1024.0f), Float.valueOf((float)dexBuffer.getLength() / 1024.0f), Float.valueOf((float)n / 1024.0f));
        }
        long l2 = System.nanoTime() - l;
        System.out.printf("Merged dex A (%d defs/%.1fKiB) with dex B (%d defs/%.1fKiB). Result is %d defs/%.1fKiB. Took %.1fs%n", this.dexA.getTableOfContents().classDefs.size, Float.valueOf((float)this.dexA.getLength() / 1024.0f), this.dexB.getTableOfContents().classDefs.size, Float.valueOf((float)this.dexB.getLength() / 1024.0f), dexBuffer.getTableOfContents().classDefs.size, Float.valueOf((float)dexBuffer.getLength() / 1024.0f), Float.valueOf((float)l2 / 1.0E9f));
        return dexBuffer;
    }

    private IndexMap getIndexMap(DexBuffer dexBuffer) {
        if (dexBuffer == this.dexA) {
            return this.aIndexMap;
        }
        if (dexBuffer == this.dexB) {
            return this.bIndexMap;
        }
        throw new IllegalArgumentException();
    }

    private void mergeStringIds() {
        new IdMerger<String>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.stringIds;
            }

            @Override
            String read(DexBuffer.Section section, IndexMap indexMap, int n) {
                return section.readString();
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.stringIds[n2] = n3;
            }

            @Override
            void write(String string) {
                ++((DexMerger)DexMerger.this).contentsOut.stringDatas.size;
                DexMerger.this.idsDefsOut.writeInt(DexMerger.this.stringDataOut.getPosition());
                DexMerger.this.stringDataOut.writeStringData(string);
            }
        }.mergeSorted();
    }

    private void mergeTypeIds() {
        new IdMerger<Integer>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.typeIds;
            }

            @Override
            Integer read(DexBuffer.Section section, IndexMap indexMap, int n) {
                int n2 = section.readInt();
                return indexMap.adjustString(n2);
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.typeIds[n2] = (short)n3;
            }

            @Override
            void write(Integer n) {
                DexMerger.this.idsDefsOut.writeInt(n);
            }
        }.mergeSorted();
    }

    private void mergeTypeLists() {
        new IdMerger<TypeList>(this.typeListOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.typeLists;
            }

            @Override
            TypeList read(DexBuffer.Section section, IndexMap indexMap, int n) {
                return indexMap.adjustTypeList(section.readTypeList());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.putTypeListOffset(n, DexMerger.this.typeListOut.getPosition());
            }

            @Override
            void write(TypeList typeList) {
                DexMerger.this.typeListOut.writeTypeList(typeList);
            }
        }.mergeUnsorted();
    }

    private void mergeProtoIds() {
        new IdMerger<ProtoId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.protoIds;
            }

            @Override
            ProtoId read(DexBuffer.Section section, IndexMap indexMap, int n) {
                return indexMap.adjust(section.readProtoId());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.protoIds[n2] = (short)n3;
            }

            @Override
            void write(ProtoId protoId) {
                protoId.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeFieldIds() {
        new IdMerger<FieldId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.fieldIds;
            }

            @Override
            FieldId read(DexBuffer.Section section, IndexMap indexMap, int n) {
                return indexMap.adjust(section.readFieldId());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.fieldIds[n2] = (short)n3;
            }

            @Override
            void write(FieldId fieldId) {
                fieldId.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeMethodIds() {
        new IdMerger<MethodId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.methodIds;
            }

            @Override
            MethodId read(DexBuffer.Section section, IndexMap indexMap, int n) {
                return indexMap.adjust(section.readMethodId());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.methodIds[n2] = (short)n3;
            }

            @Override
            void write(MethodId methodId) {
                methodId.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeAnnotations() {
        new IdMerger<Annotation>(this.annotationOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.annotations;
            }

            @Override
            Annotation read(DexBuffer.Section section, IndexMap indexMap, int n) {
                return indexMap.adjust(section.readAnnotation());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.putAnnotationOffset(n, DexMerger.this.annotationOut.getPosition());
            }

            @Override
            void write(Annotation annotation) {
                annotation.writeTo(DexMerger.this.annotationOut);
            }
        }.mergeUnsorted();
    }

    private void mergeClassDefs() {
        SortableType[] sortableTypeArray = this.getSortedTypes();
        this.contentsOut.classDefs.off = this.idsDefsOut.getPosition();
        this.contentsOut.classDefs.size = sortableTypeArray.length;
        for (SortableType sortableType : sortableTypeArray) {
            DexBuffer dexBuffer = sortableType.getBuffer();
            IndexMap indexMap = dexBuffer == this.dexA ? this.aIndexMap : this.bIndexMap;
            this.transformClassDef(dexBuffer, sortableType.getClassDef(), indexMap);
        }
    }

    private SortableType[] getSortedTypes() {
        int n;
        SortableType[] sortableTypeArray = new SortableType[this.contentsOut.typeIds.size];
        this.readSortableTypes(sortableTypeArray, this.dexA, this.aIndexMap);
        this.readSortableTypes(sortableTypeArray, this.dexB, this.bIndexMap);
        do {
            n = 1;
            for (SortableType sortableType : sortableTypeArray) {
                if (sortableType == null || sortableType.isDepthAssigned()) continue;
                n &= sortableType.tryAssignDepth(sortableTypeArray);
            }
        } while (n == 0);
        Arrays.sort(sortableTypeArray, SortableType.NULLS_LAST_ORDER);
        n = Arrays.asList(sortableTypeArray).indexOf(null);
        return n != -1 ? Arrays.copyOfRange(sortableTypeArray, 0, n) : sortableTypeArray;
    }

    private void readSortableTypes(SortableType[] sortableTypeArray, DexBuffer dexBuffer, IndexMap indexMap) {
        for (ClassDef classDef : dexBuffer.classDefs()) {
            SortableType sortableType = indexMap.adjust(new SortableType(dexBuffer, classDef));
            int n = sortableType.getTypeIndex();
            if (sortableTypeArray[n] == null) {
                sortableTypeArray[n] = sortableType;
                continue;
            }
            if (this.collisionPolicy == CollisionPolicy.KEEP_FIRST) continue;
            throw new DexException("Multiple dex files define " + dexBuffer.typeNames().get(classDef.getTypeIndex()));
        }
    }

    private void unionAnnotationSetsAndDirectories() {
        this.transformAnnotationSets(this.dexA, this.aIndexMap);
        this.transformAnnotationSets(this.dexB, this.bIndexMap);
        this.transformAnnotationDirectories(this.dexA, this.aIndexMap);
        this.transformAnnotationDirectories(this.dexB, this.bIndexMap);
    }

    private void transformAnnotationSets(DexBuffer dexBuffer, IndexMap indexMap) {
        TableOfContents.Section section = dexBuffer.getTableOfContents().annotationSets;
        if (section.exists()) {
            DexBuffer.Section section2 = dexBuffer.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                this.transformAnnotationSet(indexMap, section2);
            }
        }
    }

    private void transformAnnotationDirectories(DexBuffer dexBuffer, IndexMap indexMap) {
        TableOfContents.Section section = dexBuffer.getTableOfContents().annotationsDirectories;
        if (section.exists()) {
            DexBuffer.Section section2 = dexBuffer.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                this.transformAnnotationDirectory(dexBuffer, section2, indexMap);
            }
        }
    }

    private void transformClassDef(DexBuffer dexBuffer, ClassDef classDef, IndexMap indexMap) {
        this.idsDefsOut.assertFourByteAligned();
        this.idsDefsOut.writeInt(classDef.getTypeIndex());
        this.idsDefsOut.writeInt(classDef.getAccessFlags());
        this.idsDefsOut.writeInt(classDef.getSupertypeIndex());
        this.idsDefsOut.writeInt(classDef.getInterfacesOffset());
        int n = indexMap.adjustString(classDef.getSourceFileIndex());
        this.idsDefsOut.writeInt(n);
        int n2 = classDef.getAnnotationsOffset();
        this.idsDefsOut.writeInt(indexMap.adjustAnnotationDirectory(n2));
        int n3 = classDef.getClassDataOffset();
        if (n3 == 0) {
            this.idsDefsOut.writeInt(0);
        } else {
            this.idsDefsOut.writeInt(this.classDataOut.getPosition());
            ClassData classData = dexBuffer.readClassData(classDef);
            this.transformClassData(dexBuffer, classData, indexMap);
        }
        int n4 = classDef.getStaticValuesOffset();
        if (n4 == 0) {
            this.idsDefsOut.writeInt(0);
        } else {
            DexBuffer.Section section = dexBuffer.open(n4);
            this.idsDefsOut.writeInt(this.encodedArrayOut.getPosition());
            this.transformStaticValues(section, indexMap);
        }
    }

    private void transformAnnotationDirectory(DexBuffer dexBuffer, DexBuffer.Section section, IndexMap indexMap) {
        int n;
        ++this.contentsOut.annotationsDirectories.size;
        this.annotationsDirectoryOut.assertFourByteAligned();
        indexMap.putAnnotationDirectoryOffset(section.getPosition(), this.annotationsDirectoryOut.getPosition());
        int n2 = indexMap.adjustAnnotationSet(section.readInt());
        this.annotationsDirectoryOut.writeInt(n2);
        int n3 = section.readInt();
        this.annotationsDirectoryOut.writeInt(n3);
        int n4 = section.readInt();
        this.annotationsDirectoryOut.writeInt(n4);
        int n5 = section.readInt();
        this.annotationsDirectoryOut.writeInt(n5);
        for (n = 0; n < n3; ++n) {
            this.annotationsDirectoryOut.writeInt(indexMap.adjustField(section.readInt()));
            this.annotationsDirectoryOut.writeInt(indexMap.adjustAnnotationSet(section.readInt()));
        }
        for (n = 0; n < n4; ++n) {
            this.annotationsDirectoryOut.writeInt(indexMap.adjustMethod(section.readInt()));
            this.annotationsDirectoryOut.writeInt(indexMap.adjustAnnotationSet(section.readInt()));
        }
        for (n = 0; n < n5; ++n) {
            ++this.contentsOut.annotationSetRefLists.size;
            this.annotationSetRefListOut.assertFourByteAligned();
            this.annotationsDirectoryOut.writeInt(indexMap.adjustMethod(section.readInt()));
            this.annotationsDirectoryOut.writeInt(this.annotationSetRefListOut.getPosition());
            DexBuffer.Section section2 = dexBuffer.open(section.readInt());
            int n6 = section2.readInt();
            this.annotationSetRefListOut.writeInt(n6);
            for (int i = 0; i < n6; ++i) {
                this.annotationSetRefListOut.writeInt(indexMap.adjustAnnotationSet(section2.readInt()));
            }
        }
    }

    private void transformAnnotationSet(IndexMap indexMap, DexBuffer.Section section) {
        ++this.contentsOut.annotationSets.size;
        this.annotationSetOut.assertFourByteAligned();
        indexMap.putAnnotationSetOffset(section.getPosition(), this.annotationSetOut.getPosition());
        int n = section.readInt();
        this.annotationSetOut.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.annotationSetOut.writeInt(indexMap.adjustAnnotation(section.readInt()));
        }
    }

    private void transformClassData(DexBuffer dexBuffer, ClassData classData, IndexMap indexMap) {
        ++this.contentsOut.classDatas.size;
        ClassData.Field[] fieldArray = classData.getStaticFields();
        ClassData.Field[] fieldArray2 = classData.getInstanceFields();
        ClassData.Method[] methodArray = classData.getDirectMethods();
        ClassData.Method[] methodArray2 = classData.getVirtualMethods();
        this.classDataOut.writeUleb128(fieldArray.length);
        this.classDataOut.writeUleb128(fieldArray2.length);
        this.classDataOut.writeUleb128(methodArray.length);
        this.classDataOut.writeUleb128(methodArray2.length);
        this.transformFields(indexMap, fieldArray);
        this.transformFields(indexMap, fieldArray2);
        this.transformMethods(dexBuffer, indexMap, methodArray);
        this.transformMethods(dexBuffer, indexMap, methodArray2);
    }

    private void transformFields(IndexMap indexMap, ClassData.Field[] fieldArray) {
        int n = 0;
        for (ClassData.Field field : fieldArray) {
            int n2 = indexMap.adjustField(field.getFieldIndex());
            this.classDataOut.writeUleb128(n2 - n);
            n = n2;
            this.classDataOut.writeUleb128(field.getAccessFlags());
        }
    }

    private void transformMethods(DexBuffer dexBuffer, IndexMap indexMap, ClassData.Method[] methodArray) {
        int n = 0;
        for (ClassData.Method method : methodArray) {
            int n2 = indexMap.adjustMethod(method.getMethodIndex());
            this.classDataOut.writeUleb128(n2 - n);
            n = n2;
            this.classDataOut.writeUleb128(method.getAccessFlags());
            if (method.getCodeOffset() == 0) {
                this.classDataOut.writeUleb128(0);
                continue;
            }
            this.codeOut.alignToFourBytes();
            this.classDataOut.writeUleb128(this.codeOut.getPosition());
            this.transformCode(dexBuffer, dexBuffer.readCode(method), indexMap);
        }
    }

    private void transformCode(DexBuffer dexBuffer, Code code, IndexMap indexMap) {
        ++this.contentsOut.codes.size;
        this.codeOut.assertFourByteAligned();
        this.codeOut.writeUnsignedShort(code.getRegistersSize());
        this.codeOut.writeUnsignedShort(code.getInsSize());
        this.codeOut.writeUnsignedShort(code.getOutsSize());
        Code.Try[] tryArray = code.getTries();
        this.codeOut.writeUnsignedShort(tryArray.length);
        this.codeOut.writeInt(0);
        short[] sArray = code.getInstructions();
        InstructionTransformer instructionTransformer = dexBuffer == this.dexA ? this.aInstructionTransformer : this.bInstructionTransformer;
        short[] sArray2 = instructionTransformer.transform(sArray);
        this.codeOut.writeInt(sArray2.length);
        this.codeOut.write(sArray2);
        if (tryArray.length > 0) {
            if (sArray2.length % 2 == 1) {
                this.codeOut.writeShort((short)0);
            }
            for (Code.Try try_ : tryArray) {
                this.codeOut.writeInt(try_.getStartAddress());
                this.codeOut.writeUnsignedShort(try_.getInstructionCount());
                this.codeOut.writeUnsignedShort(try_.getHandlerOffset());
            }
            Object[] objectArray = code.getCatchHandlers();
            this.codeOut.writeUleb128(objectArray.length);
            for (Object object : objectArray) {
                this.transformEncodedCatchHandler((Code.CatchHandler)object, indexMap);
            }
        }
    }

    private void transformEncodedCatchHandler(Code.CatchHandler catchHandler, IndexMap indexMap) {
        int n = catchHandler.getCatchAllAddress();
        int[] nArray = catchHandler.getTypeIndexes();
        int[] nArray2 = catchHandler.getAddresses();
        if (n != -1) {
            this.codeOut.writeSleb128(-nArray.length);
        } else {
            this.codeOut.writeSleb128(nArray.length);
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.codeOut.writeUleb128(indexMap.adjustType(nArray[i]));
            this.codeOut.writeUleb128(nArray2[i]);
        }
        if (n != -1) {
            this.codeOut.writeUleb128(n);
        }
    }

    private void transformStaticValues(DexBuffer.Section section, IndexMap indexMap) {
        ++this.contentsOut.encodedArrays.size;
        indexMap.adjustEncodedArray(section.readEncodedArray()).writeTo(this.encodedArrayOut);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            DexMerger.printUsage();
            return;
        }
        DexBuffer dexBuffer = new DexBuffer(new File(stringArray[1]));
        DexBuffer dexBuffer2 = new DexBuffer(new File(stringArray[2]));
        DexBuffer dexBuffer3 = new DexMerger(dexBuffer, dexBuffer2, CollisionPolicy.KEEP_FIRST).merge();
        dexBuffer3.writeTo(new File(stringArray[0]));
    }

    private static void printUsage() {
        System.out.println("Usage: DexMerger <out.dex> <a.dex> <b.dex>");
        System.out.println();
        System.out.println("If both a and b define the same classes, a's copy will be used.");
    }

    private static class WriterSizes
    implements Cloneable {
        private int header = 112;
        private int idsDefs;
        private int mapList;
        private int typeList;
        private int classData;
        private int code;
        private int stringData;
        private int debugInfo;
        private int encodedArray;
        private int annotationsDirectory;
        private int annotationsSet;
        private int annotationsSetRefList;
        private int annotation;

        public WriterSizes(DexBuffer dexBuffer, DexBuffer dexBuffer2) {
            this.plus(dexBuffer.getTableOfContents(), false);
            this.plus(dexBuffer2.getTableOfContents(), false);
        }

        public WriterSizes clone() {
            try {
                return (WriterSizes)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }

        public void plus(TableOfContents tableOfContents, boolean bl) {
            this.idsDefs += tableOfContents.stringIds.size * 4 + tableOfContents.typeIds.size * 4 + tableOfContents.protoIds.size * 12 + tableOfContents.fieldIds.size * 8 + tableOfContents.methodIds.size * 8 + tableOfContents.classDefs.size * 32;
            this.mapList = 4 + tableOfContents.sections.length * 12;
            this.typeList += tableOfContents.typeLists.byteCount;
            this.code += tableOfContents.codes.byteCount;
            this.stringData += tableOfContents.stringDatas.byteCount;
            this.debugInfo += tableOfContents.debugInfos.byteCount;
            this.annotationsDirectory += tableOfContents.annotationsDirectories.byteCount;
            this.annotationsSet += tableOfContents.annotationSets.byteCount;
            this.annotationsSetRefList += tableOfContents.annotationSetRefLists.byteCount;
            if (bl) {
                this.classData += tableOfContents.classDatas.byteCount;
                this.encodedArray += tableOfContents.encodedArrays.byteCount;
                this.annotation += tableOfContents.annotations.byteCount;
            } else {
                this.classData += (int)Math.ceil((double)tableOfContents.classDatas.byteCount * 1.34);
                this.encodedArray += tableOfContents.encodedArrays.byteCount * 2;
                this.annotation += (int)Math.ceil((double)tableOfContents.annotations.byteCount * 1.34);
            }
        }

        public void minusWaste(DexMerger dexMerger) {
            this.header -= dexMerger.headerOut.remaining();
            this.idsDefs -= dexMerger.idsDefsOut.remaining();
            this.mapList -= dexMerger.mapListOut.remaining();
            this.typeList -= dexMerger.typeListOut.remaining();
            this.classData -= dexMerger.classDataOut.remaining();
            this.code -= dexMerger.codeOut.remaining();
            this.stringData -= dexMerger.stringDataOut.remaining();
            this.debugInfo -= dexMerger.debugInfoOut.remaining();
            this.encodedArray -= dexMerger.encodedArrayOut.remaining();
            this.annotationsDirectory -= dexMerger.annotationsDirectoryOut.remaining();
            this.annotationsSet -= dexMerger.annotationSetOut.remaining();
            this.annotationsSetRefList -= dexMerger.annotationSetRefListOut.remaining();
            this.annotation -= dexMerger.annotationOut.remaining();
        }

        public int size() {
            return this.header + this.idsDefs + this.mapList + this.typeList + this.classData + this.code + this.stringData + this.debugInfo + this.encodedArray + this.annotationsDirectory + this.annotationsSet + this.annotationsSetRefList + this.annotation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class IdMerger<T extends Comparable<T>> {
        private final DexBuffer.Section out;

        protected IdMerger(DexBuffer.Section section) {
            this.out = section;
        }

        public final void mergeSorted() {
            TableOfContents.Section section = this.getSection(DexMerger.this.dexA.getTableOfContents());
            TableOfContents.Section section2 = this.getSection(DexMerger.this.dexB.getTableOfContents());
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).off = this.out.getPosition();
            DexBuffer.Section section3 = section.exists() ? DexMerger.this.dexA.open(section.off) : null;
            DexBuffer.Section section4 = section2.exists() ? DexMerger.this.dexB.open(section2.off) : null;
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Comparable comparable = null;
            Object var11_11 = null;
            while (true) {
                boolean bl;
                boolean bl2;
                if (comparable == null && n3 < section.size) {
                    n = section3.getPosition();
                    comparable = this.read(section3, DexMerger.this.aIndexMap, n3);
                }
                if (var11_11 == null && n4 < section2.size) {
                    n2 = section4.getPosition();
                    var11_11 = this.read(section4, DexMerger.this.bIndexMap, n4);
                }
                if (comparable != null && var11_11 != null) {
                    int n6 = comparable.compareTo(var11_11);
                    bl2 = n6 <= 0;
                    bl = n6 >= 0;
                } else {
                    bl2 = comparable != null;
                    bl = var11_11 != null;
                }
                Comparable comparable2 = null;
                if (bl2) {
                    comparable2 = comparable;
                    this.updateIndex(n, DexMerger.this.aIndexMap, n3++, n5);
                    comparable = null;
                    n = -1;
                }
                if (bl) {
                    comparable2 = var11_11;
                    this.updateIndex(n2, DexMerger.this.bIndexMap, n4++, n5);
                    var11_11 = null;
                    n2 = -1;
                }
                if (comparable2 == null) break;
                this.write(comparable2);
                ++n5;
            }
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).size = n5;
        }

        public final void mergeUnsorted() {
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).off = this.out.getPosition();
            ArrayList<UnsortedValue> arrayList = new ArrayList<UnsortedValue>();
            arrayList.addAll(this.readUnsortedValues(DexMerger.this.dexA, DexMerger.this.aIndexMap));
            arrayList.addAll(this.readUnsortedValues(DexMerger.this.dexB, DexMerger.this.bIndexMap));
            Collections.sort(arrayList);
            int n = 0;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                UnsortedValue unsortedValue = (UnsortedValue)arrayList.get(n2++);
                this.updateIndex(unsortedValue.offset, DexMerger.this.getIndexMap(unsortedValue.source), unsortedValue.index, n - 1);
                while (n2 < arrayList.size() && unsortedValue.compareTo((UnsortedValue)arrayList.get(n2)) == 0) {
                    UnsortedValue unsortedValue2 = (UnsortedValue)arrayList.get(n2++);
                    this.updateIndex(unsortedValue2.offset, DexMerger.this.getIndexMap(unsortedValue2.source), unsortedValue2.index, n - 1);
                }
                this.write(unsortedValue.value);
                ++n;
            }
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).size = n;
        }

        private List<UnsortedValue> readUnsortedValues(DexBuffer dexBuffer, IndexMap indexMap) {
            TableOfContents.Section section = this.getSection(dexBuffer.getTableOfContents());
            if (!section.exists()) {
                return Collections.emptyList();
            }
            ArrayList<UnsortedValue> arrayList = new ArrayList<UnsortedValue>();
            DexBuffer.Section section2 = dexBuffer.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                int n = section2.getPosition();
                T t = this.read(section2, indexMap, 0);
                arrayList.add(new UnsortedValue(this, dexBuffer, indexMap, t, i, n));
            }
            return arrayList;
        }

        abstract TableOfContents.Section getSection(TableOfContents var1);

        abstract T read(DexBuffer.Section var1, IndexMap var2, int var3);

        abstract void updateIndex(int var1, IndexMap var2, int var3, int var4);

        abstract void write(T var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UnsortedValue
        implements Comparable<UnsortedValue> {
            final DexBuffer source;
            final IndexMap indexMap;
            final T value;
            final int index;
            final int offset;
            final /* synthetic */ IdMerger this$1;

            /*
             * WARNING - Possible parameter corruption
             */
            UnsortedValue(DexBuffer dexBuffer, IndexMap indexMap, T t, int n2, int n3) {
                this.this$1 = (IdMerger)n;
                this.source = dexBuffer;
                this.indexMap = indexMap;
                this.value = t;
                this.index = n2;
                this.offset = n3;
            }

            @Override
            public int compareTo(UnsortedValue unsortedValue) {
                return this.value.compareTo(unsortedValue.value);
            }
        }
    }
}

