/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import com.android.dx.util.LabeledItem;

public final class BasicBlock
implements LabeledItem {
    private final int label;
    private final InsnList insns;
    private final IntList successors;
    private final int primarySuccessor;

    public BasicBlock(int n, InsnList insnList, IntList intList, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("label < 0");
        }
        try {
            insnList.throwIfMutable();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("insns == null");
        }
        int n3 = insnList.size();
        if (n3 == 0) {
            throw new IllegalArgumentException("insns.size() == 0");
        }
        for (int i = n3 - 2; i >= 0; --i) {
            Rop rop = insnList.get(i).getOpcode();
            if (rop.getBranchingness() == 1) continue;
            throw new IllegalArgumentException("insns[" + i + "] is a " + "branch or can throw");
        }
        Insn insn = insnList.get(n3 - 1);
        if (insn.getOpcode().getBranchingness() == 1) {
            throw new IllegalArgumentException("insns does not end with a branch or throwing instruction");
        }
        try {
            intList.throwIfMutable();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("successors == null");
        }
        if (n2 < -1) {
            throw new IllegalArgumentException("primarySuccessor < -1");
        }
        if (n2 >= 0 && !intList.contains(n2)) {
            throw new IllegalArgumentException("primarySuccessor " + n2 + " not in successors " + intList);
        }
        this.label = n;
        this.insns = insnList;
        this.successors = intList;
        this.primarySuccessor = n2;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public int getLabel() {
        return this.label;
    }

    public InsnList getInsns() {
        return this.insns;
    }

    public IntList getSuccessors() {
        return this.successors;
    }

    public int getPrimarySuccessor() {
        return this.primarySuccessor;
    }

    public int getSecondarySuccessor() {
        if (this.successors.size() != 2) {
            throw new UnsupportedOperationException("block doesn't have exactly two successors");
        }
        int n = this.successors.get(0);
        if (n == this.primarySuccessor) {
            n = this.successors.get(1);
        }
        return n;
    }

    public Insn getFirstInsn() {
        return this.insns.get(0);
    }

    public Insn getLastInsn() {
        return this.insns.getLast();
    }

    public boolean canThrow() {
        return this.insns.getLast().canThrow();
    }

    public boolean hasExceptionHandlers() {
        Insn insn = this.insns.getLast();
        return insn.getCatches().size() != 0;
    }

    public TypeList getExceptionHandlerTypes() {
        Insn insn = this.insns.getLast();
        return insn.getCatches();
    }

    public BasicBlock withRegisterOffset(int n) {
        return new BasicBlock(this.label, this.insns.withRegisterOffset(n), this.successors, this.primarySuccessor);
    }

    public String toString() {
        return '{' + Hex.u2(this.label) + '}';
    }

    public static interface Visitor {
        public void visitBlock(BasicBlock var1);
    }
}

