/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.rop.type.TypeList;

public final class PlainInsn
extends Insn {
    public PlainInsn(Rop rop, SourcePosition sourcePosition, RegisterSpec registerSpec, RegisterSpecList registerSpecList) {
        super(rop, sourcePosition, registerSpec, registerSpecList);
        switch (rop.getBranchingness()) {
            case 5: 
            case 6: {
                throw new IllegalArgumentException("bogus branchingness");
            }
        }
        if (registerSpec != null && rop.getBranchingness() != 1) {
            throw new IllegalArgumentException("can't mix branchingness with result");
        }
    }

    public PlainInsn(Rop rop, SourcePosition sourcePosition, RegisterSpec registerSpec, RegisterSpec registerSpec2) {
        this(rop, sourcePosition, registerSpec, RegisterSpecList.make(registerSpec2));
    }

    public TypeList getCatches() {
        return StdTypeList.EMPTY;
    }

    public void accept(Insn.Visitor visitor) {
        visitor.visitPlainInsn(this);
    }

    public Insn withAddedCatch(Type type) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Insn withRegisterOffset(int n) {
        return new PlainInsn(this.getOpcode(), this.getPosition(), this.getResult().withOffset(n), this.getSources().withOffset(n));
    }

    public Insn withSourceLiteral() {
        Rop rop;
        RegisterSpecList registerSpecList = this.getSources();
        int n = registerSpecList.size();
        if (n == 0) {
            return this;
        }
        TypeBearer typeBearer = registerSpecList.get(n - 1).getTypeBearer();
        if (!typeBearer.isConstant()) {
            TypeBearer typeBearer2 = registerSpecList.get(0).getTypeBearer();
            if (n == 2 && typeBearer2.isConstant()) {
                Constant constant = (Constant)((Object)typeBearer2);
                RegisterSpecList registerSpecList2 = registerSpecList.withoutFirst();
                Rop rop2 = Rops.ropFor(this.getOpcode().getOpcode(), this.getResult(), registerSpecList2, constant);
                return new PlainCstInsn(rop2, this.getPosition(), this.getResult(), registerSpecList2, constant);
            }
            return this;
        }
        Constant constant = (Constant)((Object)typeBearer);
        RegisterSpecList registerSpecList3 = registerSpecList.withoutLast();
        try {
            int n2 = this.getOpcode().getOpcode();
            if (n2 == 15 && constant instanceof CstInteger) {
                n2 = 14;
                constant = CstInteger.make(-((CstInteger)constant).getValue());
            }
            rop = Rops.ropFor(n2, this.getResult(), registerSpecList3, constant);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this;
        }
        return new PlainCstInsn(rop, this.getPosition(), this.getResult(), registerSpecList3, constant);
    }

    public Insn withNewRegisters(RegisterSpec registerSpec, RegisterSpecList registerSpecList) {
        return new PlainInsn(this.getOpcode(), this.getPosition(), registerSpec, registerSpecList);
    }
}

