/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.util.ToHuman;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegisterSpec
implements TypeBearer,
ToHuman,
Comparable<RegisterSpec> {
    public static final String PREFIX = "v";
    private static final HashMap<Object, RegisterSpec> theInterns = new HashMap(1000);
    private static final ForComparison theInterningItem = new ForComparison();
    private final int reg;
    private final TypeBearer type;
    private final LocalItem local;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RegisterSpec intern(int n, TypeBearer typeBearer, LocalItem localItem) {
        HashMap<Object, RegisterSpec> hashMap = theInterns;
        synchronized (hashMap) {
            theInterningItem.set(n, typeBearer, localItem);
            RegisterSpec registerSpec = theInterns.get(theInterningItem);
            if (registerSpec != null) {
                return registerSpec;
            }
            registerSpec = theInterningItem.toRegisterSpec();
            theInterns.put(registerSpec, registerSpec);
            return registerSpec;
        }
    }

    public static RegisterSpec make(int n, TypeBearer typeBearer) {
        return RegisterSpec.intern(n, typeBearer, null);
    }

    public static RegisterSpec make(int n, TypeBearer typeBearer, LocalItem localItem) {
        if (localItem == null) {
            throw new NullPointerException("local  == null");
        }
        return RegisterSpec.intern(n, typeBearer, localItem);
    }

    public static RegisterSpec makeLocalOptional(int n, TypeBearer typeBearer, LocalItem localItem) {
        return RegisterSpec.intern(n, typeBearer, localItem);
    }

    public static String regString(int n) {
        return PREFIX + n;
    }

    private RegisterSpec(int n, TypeBearer typeBearer, LocalItem localItem) {
        if (n < 0) {
            throw new IllegalArgumentException("reg < 0");
        }
        if (typeBearer == null) {
            throw new NullPointerException("type == null");
        }
        this.reg = n;
        this.type = typeBearer;
        this.local = localItem;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RegisterSpec)) {
            if (object instanceof ForComparison) {
                ForComparison forComparison = (ForComparison)object;
                return this.equals(forComparison.reg, forComparison.type, forComparison.local);
            }
            return false;
        }
        RegisterSpec registerSpec = (RegisterSpec)object;
        return this.equals(registerSpec.reg, registerSpec.type, registerSpec.local);
    }

    public boolean equalsUsingSimpleType(RegisterSpec registerSpec) {
        if (!this.matchesVariable(registerSpec)) {
            return false;
        }
        return this.reg == registerSpec.reg;
    }

    public boolean matchesVariable(RegisterSpec registerSpec) {
        if (registerSpec == null) {
            return false;
        }
        return this.type.getType().equals(registerSpec.type.getType()) && (this.local == registerSpec.local || this.local != null && this.local.equals(registerSpec.local));
    }

    private boolean equals(int n, TypeBearer typeBearer, LocalItem localItem) {
        return this.reg == n && this.type.equals(typeBearer) && (this.local == localItem || this.local != null && this.local.equals(localItem));
    }

    @Override
    public int compareTo(RegisterSpec registerSpec) {
        if (this.reg < registerSpec.reg) {
            return -1;
        }
        if (this.reg > registerSpec.reg) {
            return 1;
        }
        int n = this.type.getType().compareTo(registerSpec.type.getType());
        if (n != 0) {
            return n;
        }
        if (this.local == null) {
            return registerSpec.local == null ? 0 : -1;
        }
        if (registerSpec.local == null) {
            return 1;
        }
        return this.local.compareTo(registerSpec.local);
    }

    public int hashCode() {
        return RegisterSpec.hashCodeOf(this.reg, this.type, this.local);
    }

    private static int hashCodeOf(int n, TypeBearer typeBearer, LocalItem localItem) {
        int n2 = localItem != null ? localItem.hashCode() : 0;
        n2 = (n2 * 31 + typeBearer.hashCode()) * 31 + n;
        return n2;
    }

    public String toString() {
        return this.toString0(false);
    }

    @Override
    public String toHuman() {
        return this.toString0(true);
    }

    @Override
    public Type getType() {
        return this.type.getType();
    }

    @Override
    public TypeBearer getFrameType() {
        return this.type.getFrameType();
    }

    @Override
    public final int getBasicType() {
        return this.type.getBasicType();
    }

    @Override
    public final int getBasicFrameType() {
        return this.type.getBasicFrameType();
    }

    @Override
    public final boolean isConstant() {
        return false;
    }

    public int getReg() {
        return this.reg;
    }

    public TypeBearer getTypeBearer() {
        return this.type;
    }

    public LocalItem getLocalItem() {
        return this.local;
    }

    public int getNextReg() {
        return this.reg + this.getCategory();
    }

    public int getCategory() {
        return this.type.getType().getCategory();
    }

    public boolean isCategory1() {
        return this.type.getType().isCategory1();
    }

    public boolean isCategory2() {
        return this.type.getType().isCategory2();
    }

    public String regString() {
        return RegisterSpec.regString(this.reg);
    }

    public RegisterSpec intersect(RegisterSpec registerSpec, boolean bl) {
        TypeBearer typeBearer;
        Type type;
        boolean bl2;
        if (this == registerSpec) {
            return this;
        }
        if (registerSpec == null || this.reg != registerSpec.getReg()) {
            return null;
        }
        LocalItem localItem = this.local == null || !this.local.equals(registerSpec.getLocalItem()) ? null : this.local;
        boolean bl3 = bl2 = localItem == this.local;
        if (bl && !bl2) {
            return null;
        }
        Type type2 = this.getType();
        if (type2 != (type = registerSpec.getType())) {
            return null;
        }
        TypeBearer typeBearer2 = typeBearer = this.type.equals(registerSpec.getTypeBearer()) ? this.type : type2;
        if (typeBearer == this.type && bl2) {
            return this;
        }
        return localItem == null ? RegisterSpec.make(this.reg, typeBearer) : RegisterSpec.make(this.reg, typeBearer, localItem);
    }

    public RegisterSpec withReg(int n) {
        if (this.reg == n) {
            return this;
        }
        return RegisterSpec.makeLocalOptional(n, this.type, this.local);
    }

    public RegisterSpec withType(TypeBearer typeBearer) {
        return RegisterSpec.makeLocalOptional(this.reg, typeBearer, this.local);
    }

    public RegisterSpec withOffset(int n) {
        if (n == 0) {
            return this;
        }
        return this.withReg(this.reg + n);
    }

    public RegisterSpec withSimpleType() {
        TypeBearer typeBearer = this.type;
        Type type = typeBearer instanceof Type ? (Type)typeBearer : typeBearer.getType();
        if (type.isUninitialized()) {
            type = type.getInitializedType();
        }
        if (type == typeBearer) {
            return this;
        }
        return RegisterSpec.makeLocalOptional(this.reg, type, this.local);
    }

    public RegisterSpec withLocalItem(LocalItem localItem) {
        if (this.local == localItem || this.local != null && this.local.equals(localItem)) {
            return this;
        }
        return RegisterSpec.makeLocalOptional(this.reg, this.type, localItem);
    }

    private String toString0(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.regString());
        stringBuffer.append(":");
        if (this.local != null) {
            stringBuffer.append(this.local.toString());
        }
        Type type = this.type.getType();
        stringBuffer.append(type);
        if (type != this.type) {
            stringBuffer.append("=");
            if (bl && this.type instanceof CstString) {
                stringBuffer.append(((CstString)this.type).toQuoted());
            } else if (bl && this.type instanceof Constant) {
                stringBuffer.append(this.type.toHuman());
            } else {
                stringBuffer.append(this.type);
            }
        }
        return stringBuffer.toString();
    }

    private static class ForComparison {
        private int reg;
        private TypeBearer type;
        private LocalItem local;

        private ForComparison() {
        }

        public void set(int n, TypeBearer typeBearer, LocalItem localItem) {
            this.reg = n;
            this.type = typeBearer;
            this.local = localItem;
        }

        public RegisterSpec toRegisterSpec() {
            return new RegisterSpec(this.reg, this.type, this.local);
        }

        public boolean equals(Object object) {
            if (!(object instanceof RegisterSpec)) {
                return false;
            }
            RegisterSpec registerSpec = (RegisterSpec)object;
            return registerSpec.equals(this.reg, this.type, this.local);
        }

        public int hashCode() {
            return RegisterSpec.hashCodeOf(this.reg, this.type, this.local);
        }
    }
}

