/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.CstLiteral32;
import com.android.dx.rop.type.Type;
import com.android.dx.util.Hex;

public final class CstInteger
extends CstLiteral32 {
    private static final CstInteger[] cache = new CstInteger[511];
    public static final CstInteger VALUE_M1 = CstInteger.make(-1);
    public static final CstInteger VALUE_0 = CstInteger.make(0);
    public static final CstInteger VALUE_1 = CstInteger.make(1);
    public static final CstInteger VALUE_2 = CstInteger.make(2);
    public static final CstInteger VALUE_3 = CstInteger.make(3);
    public static final CstInteger VALUE_4 = CstInteger.make(4);
    public static final CstInteger VALUE_5 = CstInteger.make(5);

    public static CstInteger make(int n) {
        int n2 = (n & Integer.MAX_VALUE) % cache.length;
        CstInteger cstInteger = cache[n2];
        if (cstInteger != null && cstInteger.getValue() == n) {
            return cstInteger;
        }
        CstInteger.cache[n2] = cstInteger = new CstInteger(n);
        return cstInteger;
    }

    private CstInteger(int n) {
        super(n);
    }

    public String toString() {
        int n = this.getIntBits();
        return "int{0x" + Hex.u4(n) + " / " + n + '}';
    }

    public Type getType() {
        return Type.INT;
    }

    public String typeName() {
        return "int";
    }

    public String toHuman() {
        return Integer.toString(this.getIntBits());
    }

    public int getValue() {
        return this.getIntBits();
    }
}

