/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.util.ExceptionWithContext;
import com.android.dx.util.Hex;
import com.android.dx.util.MutabilityControl;

public final class StdConstantPool
extends MutabilityControl
implements ConstantPool {
    private final Constant[] entries;

    public StdConstantPool(int n) {
        super(n > 1);
        if (n < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.entries = new Constant[n];
    }

    public int size() {
        return this.entries.length;
    }

    public Constant getOrNull(int n) {
        try {
            return this.entries[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return StdConstantPool.throwInvalid(n);
        }
    }

    public Constant get0Ok(int n) {
        if (n == 0) {
            return null;
        }
        return this.get(n);
    }

    public Constant get(int n) {
        try {
            Constant constant = this.entries[n];
            if (constant == null) {
                StdConstantPool.throwInvalid(n);
            }
            return constant;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return StdConstantPool.throwInvalid(n);
        }
    }

    public void set(int n, Constant constant) {
        Constant constant2;
        boolean bl;
        this.throwIfImmutable();
        boolean bl2 = bl = constant != null && constant.isCategory2();
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        if (bl) {
            if (n == this.entries.length - 1) {
                throw new IllegalArgumentException("(n == size - 1) && cst.isCategory2()");
            }
            this.entries[n + 1] = null;
        }
        if (constant != null && this.entries[n] == null && (constant2 = this.entries[n - 1]) != null && constant2.isCategory2()) {
            this.entries[n - 1] = null;
        }
        this.entries[n] = constant;
    }

    private static Constant throwInvalid(int n) {
        throw new ExceptionWithContext("invalid constant pool index " + Hex.u2(n));
    }
}

