/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegOps;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.TranslationAdvice;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstLiteralBits;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.Optimizer;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;

public class LiteralOpUpgrader {
    private final SsaMethod ssaMeth;

    public static void process(SsaMethod ssaMethod) {
        LiteralOpUpgrader literalOpUpgrader = new LiteralOpUpgrader(ssaMethod);
        literalOpUpgrader.run();
    }

    private LiteralOpUpgrader(SsaMethod ssaMethod) {
        this.ssaMeth = ssaMethod;
    }

    private static boolean isConstIntZeroOrKnownNull(RegisterSpec registerSpec) {
        TypeBearer typeBearer = registerSpec.getTypeBearer();
        if (typeBearer instanceof CstLiteralBits) {
            CstLiteralBits cstLiteralBits = (CstLiteralBits)typeBearer;
            return cstLiteralBits.getLongBits() == 0L;
        }
        return false;
    }

    private void run() {
        final TranslationAdvice translationAdvice = Optimizer.getAdvice();
        this.ssaMeth.forEachInsn(new SsaInsn.Visitor(){

            public void visitMoveInsn(NormalSsaInsn normalSsaInsn) {
            }

            public void visitPhiInsn(PhiInsn phiInsn) {
            }

            public void visitNonMoveInsn(NormalSsaInsn normalSsaInsn) {
                Insn insn = normalSsaInsn.getOriginalRopInsn();
                Rop rop = insn.getOpcode();
                RegisterSpecList registerSpecList = normalSsaInsn.getSources();
                if (LiteralOpUpgrader.this.tryReplacingWithConstant(normalSsaInsn)) {
                    return;
                }
                if (registerSpecList.size() != 2) {
                    return;
                }
                if (rop.getBranchingness() == 4) {
                    if (LiteralOpUpgrader.isConstIntZeroOrKnownNull(registerSpecList.get(0))) {
                        LiteralOpUpgrader.this.replacePlainInsn(normalSsaInsn, registerSpecList.withoutFirst(), RegOps.flippedIfOpcode(rop.getOpcode()), null);
                    } else if (LiteralOpUpgrader.isConstIntZeroOrKnownNull(registerSpecList.get(1))) {
                        LiteralOpUpgrader.this.replacePlainInsn(normalSsaInsn, registerSpecList.withoutLast(), rop.getOpcode(), null);
                    }
                } else if (translationAdvice.hasConstantOperation(rop, registerSpecList.get(0), registerSpecList.get(1))) {
                    normalSsaInsn.upgradeToLiteral();
                } else if (rop.isCommutative() && translationAdvice.hasConstantOperation(rop, registerSpecList.get(1), registerSpecList.get(0))) {
                    normalSsaInsn.setNewSources(RegisterSpecList.make(registerSpecList.get(1), registerSpecList.get(0)));
                    normalSsaInsn.upgradeToLiteral();
                }
            }
        });
    }

    private boolean tryReplacingWithConstant(NormalSsaInsn normalSsaInsn) {
        TypeBearer typeBearer;
        Insn insn = normalSsaInsn.getOriginalRopInsn();
        Rop rop = insn.getOpcode();
        RegisterSpec registerSpec = normalSsaInsn.getResult();
        if (registerSpec != null && !this.ssaMeth.isRegALocal(registerSpec) && rop.getOpcode() != 5 && (typeBearer = normalSsaInsn.getResult().getTypeBearer()).isConstant() && typeBearer.getBasicType() == 6) {
            this.replacePlainInsn(normalSsaInsn, RegisterSpecList.EMPTY, 5, (Constant)((Object)typeBearer));
            if (rop.getOpcode() == 56) {
                int n = normalSsaInsn.getBlock().getPredecessors().nextSetBit(0);
                ArrayList<SsaInsn> arrayList = this.ssaMeth.getBlocks().get(n).getInsns();
                NormalSsaInsn normalSsaInsn2 = (NormalSsaInsn)arrayList.get(arrayList.size() - 1);
                this.replacePlainInsn(normalSsaInsn2, RegisterSpecList.EMPTY, 6, null);
            }
            return true;
        }
        return false;
    }

    private void replacePlainInsn(NormalSsaInsn normalSsaInsn, RegisterSpecList registerSpecList, int n, Constant constant) {
        Insn insn = normalSsaInsn.getOriginalRopInsn();
        Rop rop = Rops.ropFor(n, normalSsaInsn.getResult(), registerSpecList, constant);
        Insn insn2 = constant == null ? new PlainInsn(rop, insn.getPosition(), normalSsaInsn.getResult(), registerSpecList) : new PlainCstInsn(rop, insn.getPosition(), normalSsaInsn.getResult(), registerSpecList, constant);
        NormalSsaInsn normalSsaInsn2 = new NormalSsaInsn(insn2, normalSsaInsn.getBlock());
        ArrayList<SsaInsn> arrayList = normalSsaInsn.getBlock().getInsns();
        this.ssaMeth.onInsnRemoved(normalSsaInsn);
        arrayList.set(arrayList.lastIndexOf(normalSsaInsn), normalSsaInsn2);
        this.ssaMeth.onInsnAdded(normalSsaInsn2);
    }
}

