/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SetFactory;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import com.android.dx.util.IntSet;
import com.android.dx.util.ToHuman;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SsaBasicBlock {
    public static final Comparator<SsaBasicBlock> LABEL_COMPARATOR = new LabelComparator();
    private ArrayList<SsaInsn> insns;
    private BitSet predecessors;
    private BitSet successors;
    private IntList successorList;
    private int primarySuccessor = -1;
    private int ropLabel;
    private SsaMethod parent;
    private int index;
    private final ArrayList<SsaBasicBlock> domChildren;
    private int movesFromPhisAtEnd = 0;
    private int movesFromPhisAtBeginning = 0;
    private int reachable = -1;
    private IntSet liveIn;
    private IntSet liveOut;

    public SsaBasicBlock(int n, int n2, SsaMethod ssaMethod) {
        this.parent = ssaMethod;
        this.index = n;
        this.insns = new ArrayList();
        this.ropLabel = n2;
        this.predecessors = new BitSet(ssaMethod.getBlocks().size());
        this.successors = new BitSet(ssaMethod.getBlocks().size());
        this.successorList = new IntList();
        this.domChildren = new ArrayList();
    }

    public static SsaBasicBlock newFromRop(RopMethod ropMethod, int n, SsaMethod ssaMethod) {
        int n2;
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        BasicBlock basicBlock = basicBlockList.get(n);
        SsaBasicBlock ssaBasicBlock = new SsaBasicBlock(n, basicBlock.getLabel(), ssaMethod);
        InsnList insnList = basicBlock.getInsns();
        ssaBasicBlock.insns.ensureCapacity(insnList.size());
        int n3 = insnList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            ssaBasicBlock.insns.add(new NormalSsaInsn(insnList.get(n2), ssaBasicBlock));
        }
        ssaBasicBlock.predecessors = SsaMethod.bitSetFromLabelList(basicBlockList, ropMethod.labelToPredecessors(basicBlock.getLabel()));
        ssaBasicBlock.successors = SsaMethod.bitSetFromLabelList(basicBlockList, basicBlock.getSuccessors());
        ssaBasicBlock.successorList = SsaMethod.indexListFromLabelList(basicBlockList, basicBlock.getSuccessors());
        if (ssaBasicBlock.successorList.size() != 0) {
            n2 = basicBlock.getPrimarySuccessor();
            ssaBasicBlock.primarySuccessor = n2 < 0 ? -1 : basicBlockList.indexOfLabel(n2);
        }
        return ssaBasicBlock;
    }

    public void addDomChild(SsaBasicBlock ssaBasicBlock) {
        this.domChildren.add(ssaBasicBlock);
    }

    public ArrayList<SsaBasicBlock> getDomChildren() {
        return this.domChildren;
    }

    public void addPhiInsnForReg(int n) {
        this.insns.add(0, new PhiInsn(n, this));
    }

    public void addPhiInsnForReg(RegisterSpec registerSpec) {
        this.insns.add(0, new PhiInsn(registerSpec, this));
    }

    public void addInsnToHead(Insn insn) {
        SsaInsn ssaInsn = SsaInsn.makeFromRop(insn, this);
        this.insns.add(this.getCountPhiInsns(), ssaInsn);
        this.parent.onInsnAdded(ssaInsn);
    }

    public void replaceLastInsn(Insn insn) {
        if (insn.getOpcode().getBranchingness() == 1) {
            throw new IllegalArgumentException("last insn must branch");
        }
        SsaInsn ssaInsn = this.insns.get(this.insns.size() - 1);
        SsaInsn ssaInsn2 = SsaInsn.makeFromRop(insn, this);
        this.insns.set(this.insns.size() - 1, ssaInsn2);
        this.parent.onInsnRemoved(ssaInsn);
        this.parent.onInsnAdded(ssaInsn2);
    }

    public void forEachPhiInsn(PhiInsn.Visitor visitor) {
        SsaInsn ssaInsn;
        int n = this.insns.size();
        for (int i = 0; i < n && (ssaInsn = this.insns.get(i)) instanceof PhiInsn; ++i) {
            visitor.visitPhiInsn((PhiInsn)ssaInsn);
        }
    }

    public void removeAllPhiInsns() {
        this.insns.subList(0, this.getCountPhiInsns()).clear();
    }

    private int getCountPhiInsns() {
        SsaInsn ssaInsn;
        int n;
        int n2 = this.insns.size();
        for (n = 0; n < n2 && (ssaInsn = this.insns.get(n)) instanceof PhiInsn; ++n) {
        }
        return n;
    }

    public ArrayList<SsaInsn> getInsns() {
        return this.insns;
    }

    public List<SsaInsn> getPhiInsns() {
        return this.insns.subList(0, this.getCountPhiInsns());
    }

    public int getIndex() {
        return this.index;
    }

    public int getRopLabel() {
        return this.ropLabel;
    }

    public String getRopLabelString() {
        return Hex.u2(this.ropLabel);
    }

    public BitSet getPredecessors() {
        return this.predecessors;
    }

    public BitSet getSuccessors() {
        return this.successors;
    }

    public IntList getSuccessorList() {
        return this.successorList;
    }

    public int getPrimarySuccessorIndex() {
        return this.primarySuccessor;
    }

    public int getPrimarySuccessorRopLabel() {
        return this.parent.blockIndexToRopLabel(this.primarySuccessor);
    }

    public SsaBasicBlock getPrimarySuccessor() {
        if (this.primarySuccessor < 0) {
            return null;
        }
        return this.parent.getBlocks().get(this.primarySuccessor);
    }

    public IntList getRopLabelSuccessorList() {
        IntList intList = new IntList(this.successorList.size());
        int n = this.successorList.size();
        for (int i = 0; i < n; ++i) {
            intList.add(this.parent.blockIndexToRopLabel(this.successorList.get(i)));
        }
        return intList;
    }

    public SsaMethod getParent() {
        return this.parent;
    }

    public SsaBasicBlock insertNewPredecessor() {
        SsaBasicBlock ssaBasicBlock = this.parent.makeNewGotoBlock();
        ssaBasicBlock.predecessors = this.predecessors;
        ssaBasicBlock.successors.set(this.index);
        ssaBasicBlock.successorList.add(this.index);
        ssaBasicBlock.primarySuccessor = this.index;
        this.predecessors = new BitSet(this.parent.getBlocks().size());
        this.predecessors.set(ssaBasicBlock.index);
        int n = ssaBasicBlock.predecessors.nextSetBit(0);
        while (n >= 0) {
            SsaBasicBlock ssaBasicBlock2 = this.parent.getBlocks().get(n);
            ssaBasicBlock2.replaceSuccessor(this.index, ssaBasicBlock.index);
            n = ssaBasicBlock.predecessors.nextSetBit(n + 1);
        }
        return ssaBasicBlock;
    }

    public SsaBasicBlock insertNewSuccessor(SsaBasicBlock ssaBasicBlock) {
        SsaBasicBlock ssaBasicBlock2 = this.parent.makeNewGotoBlock();
        if (!this.successors.get(ssaBasicBlock.index)) {
            throw new RuntimeException("Block " + ssaBasicBlock.getRopLabelString() + " not successor of " + this.getRopLabelString());
        }
        ssaBasicBlock2.predecessors.set(this.index);
        ssaBasicBlock2.successors.set(ssaBasicBlock.index);
        ssaBasicBlock2.successorList.add(ssaBasicBlock.index);
        ssaBasicBlock2.primarySuccessor = ssaBasicBlock.index;
        for (int i = this.successorList.size() - 1; i >= 0; --i) {
            if (this.successorList.get(i) != ssaBasicBlock.index) continue;
            this.successorList.set(i, ssaBasicBlock2.index);
        }
        if (this.primarySuccessor == ssaBasicBlock.index) {
            this.primarySuccessor = ssaBasicBlock2.index;
        }
        this.successors.clear(ssaBasicBlock.index);
        this.successors.set(ssaBasicBlock2.index);
        ssaBasicBlock.predecessors.set(ssaBasicBlock2.index);
        ssaBasicBlock.predecessors.set(this.index, this.successors.get(ssaBasicBlock.index));
        return ssaBasicBlock2;
    }

    public void replaceSuccessor(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.successors.set(n2);
        if (this.primarySuccessor == n) {
            this.primarySuccessor = n2;
        }
        for (int i = this.successorList.size() - 1; i >= 0; --i) {
            if (this.successorList.get(i) != n) continue;
            this.successorList.set(i, n2);
        }
        this.successors.clear(n);
        this.parent.getBlocks().get((int)n2).predecessors.set(this.index);
        this.parent.getBlocks().get((int)n).predecessors.clear(this.index);
    }

    public void removeSuccessor(int n) {
        int n2 = 0;
        for (int i = this.successorList.size() - 1; i >= 0; --i) {
            if (this.successorList.get(i) == n) {
                n2 = i;
                continue;
            }
            this.primarySuccessor = this.successorList.get(i);
        }
        this.successorList.removeIndex(n2);
        this.successors.clear(n);
        this.parent.getBlocks().get((int)n).predecessors.clear(this.index);
    }

    public void exitBlockFixup(SsaBasicBlock ssaBasicBlock) {
        if (this == ssaBasicBlock) {
            return;
        }
        if (this.successorList.size() == 0) {
            this.successors.set(ssaBasicBlock.index);
            this.successorList.add(ssaBasicBlock.index);
            this.primarySuccessor = ssaBasicBlock.index;
            ssaBasicBlock.predecessors.set(this.index);
        }
    }

    public void addMoveToEnd(RegisterSpec registerSpec, RegisterSpec registerSpec2) {
        if (registerSpec.getReg() == registerSpec2.getReg()) {
            return;
        }
        NormalSsaInsn normalSsaInsn = (NormalSsaInsn)this.insns.get(this.insns.size() - 1);
        if (normalSsaInsn.getResult() != null || normalSsaInsn.getSources().size() > 0) {
            int n = this.successors.nextSetBit(0);
            while (n >= 0) {
                SsaBasicBlock ssaBasicBlock = this.parent.getBlocks().get(n);
                ssaBasicBlock.addMoveToBeginning(registerSpec, registerSpec2);
                n = this.successors.nextSetBit(n + 1);
            }
        } else {
            RegisterSpecList registerSpecList = RegisterSpecList.make(registerSpec2);
            NormalSsaInsn normalSsaInsn2 = new NormalSsaInsn(new PlainInsn(Rops.opMove(registerSpec.getType()), SourcePosition.NO_INFO, registerSpec, registerSpecList), this);
            this.insns.add(this.insns.size() - 1, normalSsaInsn2);
            ++this.movesFromPhisAtEnd;
        }
    }

    public void addMoveToBeginning(RegisterSpec registerSpec, RegisterSpec registerSpec2) {
        if (registerSpec.getReg() == registerSpec2.getReg()) {
            return;
        }
        RegisterSpecList registerSpecList = RegisterSpecList.make(registerSpec2);
        NormalSsaInsn normalSsaInsn = new NormalSsaInsn(new PlainInsn(Rops.opMove(registerSpec.getType()), SourcePosition.NO_INFO, registerSpec, registerSpecList), this);
        this.insns.add(this.getCountPhiInsns(), normalSsaInsn);
        ++this.movesFromPhisAtBeginning;
    }

    private static void setRegsUsed(BitSet bitSet, RegisterSpec registerSpec) {
        bitSet.set(registerSpec.getReg());
        if (registerSpec.getCategory() > 1) {
            bitSet.set(registerSpec.getReg() + 1);
        }
    }

    private static boolean checkRegUsed(BitSet bitSet, RegisterSpec registerSpec) {
        int n = registerSpec.getReg();
        int n2 = registerSpec.getCategory();
        return bitSet.get(n) || n2 == 2 && bitSet.get(n + 1);
    }

    private void scheduleUseBeforeAssigned(List<SsaInsn> list) {
        BitSet bitSet = new BitSet(this.parent.getRegCount());
        BitSet bitSet2 = new BitSet(this.parent.getRegCount());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ToHuman toHuman;
            int n3;
            int n4 = n2;
            for (n3 = n2; n3 < n; ++n3) {
                SsaBasicBlock.setRegsUsed(bitSet, list.get(n3).getSources().get(0));
                SsaBasicBlock.setRegsUsed(bitSet2, list.get(n3).getResult());
            }
            for (n3 = n2; n3 < n; ++n3) {
                toHuman = list.get(n3);
                if (SsaBasicBlock.checkRegUsed(bitSet, ((SsaInsn)toHuman).getResult())) continue;
                Collections.swap(list, n3, n2++);
            }
            if (n4 == n2) {
                ToHuman toHuman2;
                ToHuman toHuman3 = null;
                for (int i = n2; i < n; ++i) {
                    toHuman2 = list.get(i);
                    if (!SsaBasicBlock.checkRegUsed(bitSet, ((SsaInsn)toHuman2).getResult()) || !SsaBasicBlock.checkRegUsed(bitSet2, ((SsaInsn)toHuman2).getSources().get(0))) continue;
                    toHuman3 = toHuman2;
                    Collections.swap(list, n2, i);
                    break;
                }
                toHuman = ((SsaInsn)toHuman3).getResult();
                toHuman2 = ((RegisterSpec)toHuman).withReg(this.parent.borrowSpareRegister(((RegisterSpec)toHuman).getCategory()));
                NormalSsaInsn normalSsaInsn = new NormalSsaInsn(new PlainInsn(Rops.opMove(((RegisterSpec)toHuman).getType()), SourcePosition.NO_INFO, (RegisterSpec)toHuman2, ((SsaInsn)toHuman3).getSources()), this);
                list.add(n2++, normalSsaInsn);
                RegisterSpecList registerSpecList = RegisterSpecList.make((RegisterSpec)toHuman2);
                NormalSsaInsn normalSsaInsn2 = new NormalSsaInsn(new PlainInsn(Rops.opMove(((RegisterSpec)toHuman).getType()), SourcePosition.NO_INFO, (RegisterSpec)toHuman, registerSpecList), this);
                list.set(n2, normalSsaInsn2);
                n = list.size();
            }
            bitSet.clear();
            bitSet2.clear();
        }
    }

    public void addLiveOut(int n) {
        if (this.liveOut == null) {
            this.liveOut = SetFactory.makeLivenessSet(this.parent.getRegCount());
        }
        this.liveOut.add(n);
    }

    public void addLiveIn(int n) {
        if (this.liveIn == null) {
            this.liveIn = SetFactory.makeLivenessSet(this.parent.getRegCount());
        }
        this.liveIn.add(n);
    }

    public IntSet getLiveInRegs() {
        if (this.liveIn == null) {
            this.liveIn = SetFactory.makeLivenessSet(this.parent.getRegCount());
        }
        return this.liveIn;
    }

    public IntSet getLiveOutRegs() {
        if (this.liveOut == null) {
            this.liveOut = SetFactory.makeLivenessSet(this.parent.getRegCount());
        }
        return this.liveOut;
    }

    public boolean isExitBlock() {
        return this.index == this.parent.getExitBlockIndex();
    }

    public boolean isReachable() {
        if (this.reachable == -1) {
            this.parent.computeReachability();
        }
        return this.reachable == 1;
    }

    public void setReachable(int n) {
        this.reachable = n;
    }

    public void scheduleMovesFromPhis() {
        if (this.movesFromPhisAtBeginning > 1) {
            List<SsaInsn> list = this.insns.subList(0, this.movesFromPhisAtBeginning);
            this.scheduleUseBeforeAssigned(list);
            SsaInsn ssaInsn = this.insns.get(this.movesFromPhisAtBeginning);
            if (ssaInsn.isMoveException()) {
                throw new RuntimeException("Unexpected: moves from phis before move-exception");
            }
        }
        if (this.movesFromPhisAtEnd > 1) {
            this.scheduleUseBeforeAssigned(this.insns.subList(this.insns.size() - this.movesFromPhisAtEnd - 1, this.insns.size() - 1));
        }
        this.parent.returnSpareRegisters();
    }

    public void forEachInsn(SsaInsn.Visitor visitor) {
        int n = this.insns.size();
        for (int i = 0; i < n; ++i) {
            this.insns.get(i).accept(visitor);
        }
    }

    public String toString() {
        return "{" + this.index + ":" + Hex.u2(this.ropLabel) + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LabelComparator
    implements Comparator<SsaBasicBlock> {
        @Override
        public int compare(SsaBasicBlock ssaBasicBlock, SsaBasicBlock ssaBasicBlock2) {
            int n;
            int n2 = ssaBasicBlock.ropLabel;
            if (n2 < (n = ssaBasicBlock2.ropLabel)) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    }

    public static interface Visitor {
        public void visitBlock(SsaBasicBlock var1, SsaBasicBlock var2);
    }
}

