/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.Bits;
import com.android.dx.util.IntIterator;
import com.android.dx.util.IntList;
import com.android.dx.util.IntSet;
import java.util.NoSuchElementException;

public class ListIntSet
implements IntSet {
    final IntList ints = new IntList();

    public ListIntSet() {
        this.ints.sort();
    }

    public void add(int n) {
        int n2 = this.ints.binarysearch(n);
        if (n2 < 0) {
            this.ints.insert(-(n2 + 1), n);
        }
    }

    public void remove(int n) {
        int n2 = this.ints.indexOf(n);
        if (n2 >= 0) {
            this.ints.removeIndex(n2);
        }
    }

    public boolean has(int n) {
        return this.ints.indexOf(n) >= 0;
    }

    public void merge(IntSet intSet) {
        if (intSet instanceof ListIntSet) {
            ListIntSet listIntSet = (ListIntSet)intSet;
            int n = this.ints.size();
            int n2 = listIntSet.ints.size();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2 && n3 < n) {
                while (n4 < n2 && listIntSet.ints.get(n4) < this.ints.get(n3)) {
                    this.add(listIntSet.ints.get(n4++));
                }
                if (n4 == n2) break;
                while (n3 < n && listIntSet.ints.get(n4) >= this.ints.get(n3)) {
                    ++n3;
                }
            }
            while (n4 < n2) {
                this.add(listIntSet.ints.get(n4++));
            }
            this.ints.sort();
        } else if (intSet instanceof BitIntSet) {
            BitIntSet bitIntSet = (BitIntSet)intSet;
            int n = 0;
            while (n >= 0) {
                this.ints.add(n);
                n = Bits.findFirst(bitIntSet.bits, n + 1);
            }
            this.ints.sort();
        } else {
            IntIterator intIterator = intSet.iterator();
            while (intIterator.hasNext()) {
                this.add(intIterator.next());
            }
        }
    }

    public int elements() {
        return this.ints.size();
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int idx = 0;

            public boolean hasNext() {
                return this.idx < ListIntSet.this.ints.size();
            }

            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ListIntSet.this.ints.get(this.idx++);
            }
        };
    }

    public String toString() {
        return this.ints.toString();
    }
}

