/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.ByteInput;
import java.io.UTFDataFormatException;

public final class Mutf8 {
    private Mutf8() {
    }

    public static String decode(ByteInput byteInput, char[] cArray) throws UTFDataFormatException {
        int n = 0;
        while (true) {
            int n2;
            char c;
            if ((c = (char)(byteInput.readByte() & 0xFF)) == '\u0000') {
                return new String(cArray, 0, n);
            }
            cArray[n] = c;
            if (c < '\u0080') {
                ++n;
                continue;
            }
            if ((c & 0xE0) == 192) {
                n2 = byteInput.readByte() & 0xFF;
                if ((n2 & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                cArray[n++] = (char)((c & 0x1F) << 6 | n2 & 0x3F);
                continue;
            }
            if ((c & 0xF0) != 224) break;
            n2 = byteInput.readByte() & 0xFF;
            int n3 = byteInput.readByte() & 0xFF;
            if ((n2 & 0xC0) != 128 || (n3 & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            cArray[n++] = (char)((c & 0xF) << 12 | (n2 & 0x3F) << 6 | n3 & 0x3F);
        }
        throw new UTFDataFormatException("bad byte");
    }

    private static long countBytes(String string, boolean bl) throws UTFDataFormatException {
        long l = 0L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            l = c != '\u0000' && c <= '\u007f' ? ++l : (c <= '\u07ff' ? (l += 2L) : (l += 3L));
            if (!bl || l <= 65535L) continue;
            throw new UTFDataFormatException("String more than 65535 UTF bytes long");
        }
        return l;
    }

    public static void encode(byte[] byArray, int n, String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n++] = (byte)(0xC0 | 0x1F & c >> 6);
                byArray[n++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            byArray[n++] = (byte)(0xE0 | 0xF & c >> 12);
            byArray[n++] = (byte)(0x80 | 0x3F & c >> 6);
            byArray[n++] = (byte)(0x80 | 0x3F & c);
        }
    }

    public static byte[] encode(String string) throws UTFDataFormatException {
        int n = (int)Mutf8.countBytes(string, true);
        byte[] byArray = new byte[n];
        Mutf8.encode(byArray, 0, string);
        return byArray;
    }
}

