/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util._tests;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.IntIterator;
import com.android.dx.util.ListIntSet;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class _BitIntSet
extends TestCase {
    public void test_basic() {
        BitIntSet bitIntSet = new BitIntSet(32);
        _BitIntSet.assertEquals(0, bitIntSet.elements());
        bitIntSet.add(0);
        bitIntSet.add(1);
        bitIntSet.add(31);
        _BitIntSet.assertTrue(bitIntSet.has(0));
        _BitIntSet.assertTrue(bitIntSet.has(1));
        _BitIntSet.assertTrue(bitIntSet.has(31));
        _BitIntSet.assertEquals(3, bitIntSet.elements());
        _BitIntSet.assertFalse(bitIntSet.has(2));
        _BitIntSet.assertFalse(bitIntSet.has(7));
        _BitIntSet.assertFalse(bitIntSet.has(30));
    }

    public void test_iterator() {
        BitIntSet bitIntSet = new BitIntSet(32);
        bitIntSet.add(0);
        bitIntSet.add(0);
        bitIntSet.add(1);
        bitIntSet.add(1);
        bitIntSet.add(31);
        bitIntSet.add(31);
        IntIterator intIterator = bitIntSet.iterator();
        _BitIntSet.assertTrue(intIterator.hasNext());
        _BitIntSet.assertEquals(intIterator.next(), 0);
        _BitIntSet.assertTrue(intIterator.hasNext());
        _BitIntSet.assertEquals(intIterator.next(), 1);
        _BitIntSet.assertTrue(intIterator.hasNext());
        _BitIntSet.assertEquals(intIterator.next(), 31);
        _BitIntSet.assertFalse(intIterator.hasNext());
        try {
            intIterator.next();
            _BitIntSet.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void test_remove() {
        BitIntSet bitIntSet = new BitIntSet(32);
        bitIntSet.add(0);
        bitIntSet.add(1);
        bitIntSet.add(31);
        _BitIntSet.assertTrue(bitIntSet.has(0));
        _BitIntSet.assertTrue(bitIntSet.has(1));
        _BitIntSet.assertTrue(bitIntSet.has(31));
        _BitIntSet.assertFalse(bitIntSet.has(2));
        _BitIntSet.assertFalse(bitIntSet.has(7));
        _BitIntSet.assertFalse(bitIntSet.has(30));
        bitIntSet.remove(0);
        _BitIntSet.assertFalse(bitIntSet.has(0));
        _BitIntSet.assertTrue(bitIntSet.has(1));
        _BitIntSet.assertTrue(bitIntSet.has(31));
    }

    public void test_expand() {
        BitIntSet bitIntSet = new BitIntSet(32);
        int[] nArray = new int[]{0, 1, 31, 32, 128};
        for (int i = 0; i < nArray.length; ++i) {
            bitIntSet.add(nArray[i]);
        }
        IntIterator intIterator = bitIntSet.iterator();
        for (int i = 0; i < nArray.length; ++i) {
            _BitIntSet.assertTrue(intIterator.hasNext());
            _BitIntSet.assertEquals(nArray[i], intIterator.next());
        }
        _BitIntSet.assertFalse(intIterator.hasNext());
    }

    public void test_merge() {
        int n;
        BitIntSet bitIntSet = new BitIntSet(32);
        int[] nArray = new int[]{0, 1, 31};
        for (int i = 0; i < nArray.length; ++i) {
            bitIntSet.add(nArray[i]);
        }
        BitIntSet bitIntSet2 = new BitIntSet(32);
        int[] nArray2 = new int[]{0, 5, 6, 8, 31};
        for (n = 0; n < nArray2.length; ++n) {
            bitIntSet2.add(nArray2[n]);
        }
        bitIntSet.merge(bitIntSet2);
        for (n = 0; n < nArray.length; ++n) {
            _BitIntSet.assertTrue(bitIntSet.has(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            _BitIntSet.assertTrue(bitIntSet.has(nArray2[n]));
        }
    }

    public void test_mergeWithListIntSet() {
        int n;
        BitIntSet bitIntSet = new BitIntSet(32);
        int[] nArray = new int[]{0, 1, 31};
        for (int i = 0; i < nArray.length; ++i) {
            bitIntSet.add(nArray[i]);
        }
        ListIntSet listIntSet = new ListIntSet();
        int[] nArray2 = new int[]{0, 5, 6, 8, 31};
        for (n = 0; n < nArray2.length; ++n) {
            listIntSet.add(nArray2[n]);
        }
        bitIntSet.merge(listIntSet);
        for (n = 0; n < nArray.length; ++n) {
            _BitIntSet.assertTrue(bitIntSet.has(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            _BitIntSet.assertTrue(bitIntSet.has(nArray2[n]));
        }
    }

    public void test_mergeAndExpand() {
        int n;
        BitIntSet bitIntSet = new BitIntSet(32);
        int[] nArray = new int[]{0, 1, 31};
        for (int i = 0; i < nArray.length; ++i) {
            bitIntSet.add(nArray[i]);
        }
        BitIntSet bitIntSet2 = new BitIntSet(32);
        int[] nArray2 = new int[]{0, 5, 6, 32, 127};
        for (n = 0; n < nArray2.length; ++n) {
            bitIntSet2.add(nArray2[n]);
        }
        bitIntSet.merge(bitIntSet2);
        for (n = 0; n < nArray.length; ++n) {
            _BitIntSet.assertTrue(bitIntSet.has(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            _BitIntSet.assertTrue(bitIntSet.has(nArray2[n]));
        }
    }

    public void test_toString() {
        BitIntSet bitIntSet = new BitIntSet(32);
        _BitIntSet.assertEquals(bitIntSet.toString(), "{}");
        bitIntSet.add(1);
        _BitIntSet.assertEquals(bitIntSet.toString(), "{1}");
        bitIntSet.add(2);
        _BitIntSet.assertEquals(bitIntSet.toString(), "{1, 2}");
    }
}

