/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util._tests;

import com.android.dx.util.Bits;
import junit.framework.TestCase;

public class _Bits
extends TestCase {
    public void test_makeBitSet() {
        int n;
        _Bits.assertEquals(_Bits.label(0), 0, Bits.makeBitSet(0).length);
        for (n = 1; n <= 32; ++n) {
            _Bits.assertEquals(_Bits.label(n), 1, Bits.makeBitSet(n).length);
        }
        for (n = 33; n <= 64; ++n) {
            _Bits.assertEquals(_Bits.label(n), 2, Bits.makeBitSet(n).length);
        }
        for (n = 65; n < 4000; n += 101) {
            int n2 = n >> 5;
            if (n2 * 32 < n) {
                ++n2;
            }
            _Bits.assertEquals(_Bits.label(n), n2, Bits.makeBitSet(n).length);
        }
    }

    public void test_getMax() {
        for (int i = 0; i < 4000; i += 59) {
            int n = i >> 5;
            if (n * 32 < i) {
                ++n;
            }
            _Bits.assertEquals(_Bits.label(i), n * 32, Bits.getMax(new int[n]));
        }
    }

    public void test1_get() {
        int[] nArray = Bits.makeBitSet(100);
        for (int i = 0; i < 100; ++i) {
            _Bits.assertFalse(_Bits.label(i), Bits.get(nArray, i));
        }
    }

    public void test2_get() {
        int n;
        int[] nArray = Bits.makeBitSet(100);
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < 100; ++n) {
            _Bits.assertTrue(_Bits.label(n), Bits.get(nArray, n));
        }
    }

    public void test3_get() {
        int n;
        int[] nArray = Bits.makeBitSet(100);
        for (n = 0; n < 100; ++n) {
            Bits.set(nArray, n, n % 5 == 0);
        }
        for (n = 0; n < 100; ++n) {
            boolean bl = n % 5 == 0;
            _Bits.assertTrue(_Bits.label(n), Bits.get(nArray, n) == bl);
        }
    }

    public void test1_set1() {
        int[] nArray = Bits.makeBitSet(50);
        nArray[1] = -1;
        Bits.set(nArray, 0, true);
        Bits.set(nArray, 3, true);
        Bits.set(nArray, 6, true);
        Bits.set(nArray, 3, false);
        Bits.set(nArray, 35, false);
        Bits.set(nArray, 38, false);
        Bits.set(nArray, 42, false);
        Bits.set(nArray, 38, true);
        _Bits.assertEquals(_Bits.label(1), 65, nArray[0]);
        _Bits.assertEquals(_Bits.label(2), -1033, nArray[1]);
    }

    public void test2_set1() {
        int n;
        int[] nArray = Bits.makeBitSet(100);
        for (n = 0; n < 100; ++n) {
            if (n % 3 != 0) continue;
            Bits.set(nArray, n, true);
        }
        for (n = 0; n < 100; ++n) {
            if (n % 5 != 0) continue;
            Bits.set(nArray, n, false);
        }
        for (n = 0; n < 100; ++n) {
            if (n % 7 != 0) continue;
            Bits.set(nArray, n, true);
        }
        for (n = 0; n < 100; ++n) {
            boolean bl = n % 7 == 0 || n % 3 == 0 && n % 5 != 0;
            _Bits.assertTrue(_Bits.label(n), Bits.get(nArray, n) == bl);
        }
    }

    public void test_set2() {
        int n;
        int[] nArray = Bits.makeBitSet(100);
        for (n = 0; n < 100; ++n) {
            if (n % 11 != 0) continue;
            Bits.set(nArray, n);
        }
        for (n = 0; n < 100; ++n) {
            boolean bl = n % 11 == 0;
            _Bits.assertTrue(_Bits.label(n), Bits.get(nArray, n) == bl);
        }
    }

    public void test_clear() {
        int n;
        int[] nArray = Bits.makeBitSet(100);
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < 100; ++n) {
            if (n % 5 != 0) continue;
            Bits.clear(nArray, n);
        }
        for (n = 0; n < 100; ++n) {
            boolean bl = n % 5 != 0;
            _Bits.assertTrue(_Bits.label(n), Bits.get(nArray, n) == bl);
        }
    }

    public void test1_isEmpty() {
        for (int i = 0; i < 10; ++i) {
            _Bits.assertTrue(_Bits.label(i), Bits.isEmpty(new int[i]));
        }
    }

    public void test2_isEmpty() {
        for (int i = 1; i < 1000; i += 11) {
            int[] nArray = Bits.makeBitSet(i);
            for (int j = i % 11; j >= 0; --j) {
                int n = i - 1 - j * 13;
                if (n < 0) continue;
                Bits.set(nArray, n);
            }
            _Bits.assertFalse(_Bits.label(i), Bits.isEmpty(nArray));
        }
    }

    public void test1_bitCount() {
        for (int i = 0; i < 10; ++i) {
            _Bits.assertEquals(_Bits.label(i), 0, Bits.bitCount(new int[i]));
        }
    }

    public void test2_bitCount() {
        for (int i = 1; i < 1000; i += 13) {
            int n;
            int[] nArray = Bits.makeBitSet(i);
            int n2 = 0;
            for (n = 0; n < i; n += 20) {
                Bits.set(nArray, n);
                ++n2;
            }
            for (n = 7; n < i; n += 11) {
                if (Bits.get(nArray, n)) continue;
                Bits.set(nArray, n);
                ++n2;
            }
            for (n = 3; n < i; n += 17) {
                if (Bits.get(nArray, n)) continue;
                Bits.set(nArray, n);
                ++n2;
            }
            _Bits.assertEquals(_Bits.label(i), n2, Bits.bitCount(nArray));
        }
    }

    public void test1_anyInRange() {
        int[] nArray = new int[100];
        for (int i = 0; i < 100; i += 11) {
            _Bits.assertFalse(_Bits.label(i), Bits.anyInRange(nArray, 0, i));
        }
    }

    public void test2_anyInRange() {
        int[] nArray = new int[100];
        for (int i = 0; i < 100; i += 11) {
            _Bits.assertFalse(_Bits.label(i), Bits.anyInRange(nArray, i, 100));
        }
    }

    public void test3_anyInRange() {
        int[] nArray = new int[100];
        for (int i = 0; i < 50; i += 7) {
            _Bits.assertFalse(_Bits.label(i), Bits.anyInRange(nArray, i, 100 - i));
        }
    }

    public void test4_anyInRange() {
        int n;
        int[] nArray = new int[100];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 1; n < 100; n += 11) {
            _Bits.assertTrue(_Bits.label(n), Bits.anyInRange(nArray, 0, n));
        }
    }

    public void test5_anyInRange() {
        int n;
        int[] nArray = new int[100];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 1; n < 100; n += 11) {
            _Bits.assertTrue(_Bits.label(n), Bits.anyInRange(nArray, n, 100));
        }
    }

    public void test6_anyInRange() {
        int n;
        int[] nArray = new int[100];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < 50; n += 7) {
            _Bits.assertTrue(_Bits.label(n), Bits.anyInRange(nArray, n, 100 - n));
        }
    }

    public void test1_findFirst1() {
        int[] nArray = new int[100];
        for (int i = 0; i < 100; ++i) {
            _Bits.assertEquals(_Bits.label(i), -1, Bits.findFirst(nArray, i));
        }
    }

    public void test2_findFirst1() {
        int n;
        int[] nArray = new int[100];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < 100; ++n) {
            _Bits.assertEquals(_Bits.label(n), n, Bits.findFirst(nArray, n));
        }
    }

    public void test3_findFirst1() {
        int[] nArray = new int[100];
        for (int i = 25; i < 80; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = 0;
            }
            Bits.set(nArray, i - 5);
            Bits.set(nArray, i + 5);
            Bits.set(nArray, i + 10);
            Bits.set(nArray, i + 20);
            _Bits.assertEquals(_Bits.label(i), i + 5, Bits.findFirst(nArray, i));
        }
    }

    public void test1_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            _Bits.assertEquals(_Bits.label(i), -1, Bits.findFirst(0, i));
        }
    }

    public void test2_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            _Bits.assertEquals(_Bits.label(i), i, Bits.findFirst(-1, i));
        }
    }

    public void test3_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            _Bits.assertEquals(_Bits.label(i), -1, Bits.findFirst(1 << i >>> 1, i));
        }
    }

    public void test4_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            _Bits.assertEquals(_Bits.label(i), i, Bits.findFirst(1 << i, i));
        }
    }

    public void test5_findFirst2() {
        for (int i = 0; i < 31; ++i) {
            _Bits.assertEquals(_Bits.label(i), i + 1, Bits.findFirst(1 << i + 1, i));
        }
    }

    public void test6_findFirst2() {
        for (int i = 0; i < 32; ++i) {
            int n = 1 << i;
            n |= n >>> 1;
            _Bits.assertEquals(_Bits.label(i), i, Bits.findFirst(n, i));
        }
    }

    private static String label(int n) {
        return "(" + n + ")";
    }
}

