/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util._tests;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.IntIterator;
import com.android.dx.util.ListIntSet;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class _ListIntSet
extends TestCase {
    public void test_basic() {
        ListIntSet listIntSet = new ListIntSet();
        _ListIntSet.assertEquals(0, listIntSet.elements());
        listIntSet.add(31);
        listIntSet.add(0);
        listIntSet.add(1);
        _ListIntSet.assertTrue(listIntSet.has(0));
        _ListIntSet.assertTrue(listIntSet.has(1));
        _ListIntSet.assertTrue(listIntSet.has(31));
        _ListIntSet.assertEquals(3, listIntSet.elements());
        _ListIntSet.assertFalse(listIntSet.has(2));
        _ListIntSet.assertFalse(listIntSet.has(7));
        _ListIntSet.assertFalse(listIntSet.has(30));
    }

    public void test_iterator() {
        ListIntSet listIntSet = new ListIntSet();
        listIntSet.add(0);
        listIntSet.add(0);
        listIntSet.add(1);
        listIntSet.add(1);
        listIntSet.add(31);
        listIntSet.add(31);
        IntIterator intIterator = listIntSet.iterator();
        _ListIntSet.assertTrue(intIterator.hasNext());
        _ListIntSet.assertEquals(intIterator.next(), 0);
        _ListIntSet.assertTrue(intIterator.hasNext());
        _ListIntSet.assertEquals(intIterator.next(), 1);
        _ListIntSet.assertTrue(intIterator.hasNext());
        _ListIntSet.assertEquals(intIterator.next(), 31);
        _ListIntSet.assertFalse(intIterator.hasNext());
        try {
            intIterator.next();
            _ListIntSet.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void test_empty() {
        ListIntSet listIntSet = new ListIntSet();
        IntIterator intIterator = listIntSet.iterator();
        _ListIntSet.assertFalse(intIterator.hasNext());
    }

    public void test_remove() {
        ListIntSet listIntSet = new ListIntSet();
        listIntSet.add(0);
        listIntSet.add(1);
        listIntSet.add(31);
        _ListIntSet.assertTrue(listIntSet.has(0));
        _ListIntSet.assertTrue(listIntSet.has(1));
        _ListIntSet.assertTrue(listIntSet.has(31));
        _ListIntSet.assertFalse(listIntSet.has(2));
        _ListIntSet.assertFalse(listIntSet.has(7));
        _ListIntSet.assertFalse(listIntSet.has(30));
        listIntSet.remove(0);
        _ListIntSet.assertFalse(listIntSet.has(0));
        _ListIntSet.assertTrue(listIntSet.has(1));
        _ListIntSet.assertTrue(listIntSet.has(31));
    }

    public void test_mergeA() {
        int n;
        ListIntSet listIntSet = new ListIntSet();
        int[] nArray = new int[]{0, 1, 31};
        for (int i = 0; i < nArray.length; ++i) {
            listIntSet.add(nArray[i]);
        }
        ListIntSet listIntSet2 = new ListIntSet();
        int[] nArray2 = new int[]{0, 5, 6, 32, 127, 128};
        for (n = 0; n < nArray2.length; ++n) {
            listIntSet2.add(nArray2[n]);
        }
        listIntSet.merge(listIntSet2);
        for (n = 0; n < nArray.length; ++n) {
            _ListIntSet.assertTrue(listIntSet.has(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            _ListIntSet.assertTrue(listIntSet.has(nArray2[n]));
        }
    }

    public void test_mergeB() {
        int n;
        ListIntSet listIntSet = new ListIntSet();
        int[] nArray = new int[]{0, 1, 31, 129, 130};
        for (int i = 0; i < nArray.length; ++i) {
            listIntSet.add(nArray[i]);
        }
        ListIntSet listIntSet2 = new ListIntSet();
        int[] nArray2 = new int[]{0, 5, 6, 32, 127, 128};
        for (n = 0; n < nArray2.length; ++n) {
            listIntSet2.add(nArray2[n]);
        }
        listIntSet.merge(listIntSet2);
        for (n = 0; n < nArray.length; ++n) {
            _ListIntSet.assertTrue(listIntSet.has(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            _ListIntSet.assertTrue(listIntSet.has(nArray2[n]));
        }
    }

    public void test_mergeWithBitIntSet() {
        int n;
        ListIntSet listIntSet = new ListIntSet();
        int[] nArray = new int[]{0, 1, 31, 129, 130};
        for (int i = 0; i < nArray.length; ++i) {
            listIntSet.add(nArray[i]);
        }
        BitIntSet bitIntSet = new BitIntSet(129);
        int[] nArray2 = new int[]{0, 5, 6, 32, 127, 128};
        for (n = 0; n < nArray2.length; ++n) {
            bitIntSet.add(nArray2[n]);
        }
        listIntSet.merge(bitIntSet);
        for (n = 0; n < nArray.length; ++n) {
            _ListIntSet.assertTrue(listIntSet.has(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            _ListIntSet.assertTrue(listIntSet.has(nArray2[n]));
        }
    }

    public void test_toString() {
        ListIntSet listIntSet = new ListIntSet();
        _ListIntSet.assertEquals(listIntSet.toString(), "{}");
        listIntSet.add(1);
        _ListIntSet.assertEquals(listIntSet.toString(), "{1}");
        listIntSet.add(2);
        _ListIntSet.assertEquals(listIntSet.toString(), "{1, 2}");
    }
}

