/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.NumberFormat;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestSuite;
import junit.runner.ReloadingTestSuiteLoader;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;

public abstract class BaseTestRunner
implements TestListener {
    public static final String SUITE_METHODNAME = "suite";
    private static Properties fPreferences;
    static int fgMaxMessageLength;
    static boolean fgFilterStack;
    boolean fLoading = true;

    public synchronized void startTest(Test test) {
        this.testStarted(test.toString());
    }

    protected static void setPreferences(Properties properties) {
        fPreferences = properties;
    }

    protected static Properties getPreferences() {
        if (fPreferences == null) {
            fPreferences = new Properties();
            fPreferences.put("loading", "true");
            fPreferences.put("filterstack", "true");
            BaseTestRunner.readPreferences();
        }
        return fPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePreferences() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(BaseTestRunner.getPreferencesFile());
        try {
            BaseTestRunner.getPreferences().store(fileOutputStream, "");
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void setPreference(String string, String string2) {
        BaseTestRunner.getPreferences().setProperty(string, string2);
    }

    public synchronized void endTest(Test test) {
        this.testEnded(test.toString());
    }

    public synchronized void addError(Test test, Throwable throwable) {
        this.testFailed(1, test, throwable);
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.testFailed(2, test, assertionFailedError);
    }

    public abstract void testStarted(String var1);

    public abstract void testEnded(String var1);

    public abstract void testFailed(int var1, Test var2, Throwable var3);

    public Test getTest(String string) {
        if (string.length() <= 0) {
            this.clearStatus();
            return null;
        }
        Class clazz = null;
        try {
            clazz = this.loadSuiteClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = classNotFoundException.getMessage();
            if (string2 == null) {
                string2 = string;
            }
            this.runFailed("Class not found \"" + string2 + "\"");
            return null;
        }
        catch (Exception exception) {
            this.runFailed("Error: " + exception.toString());
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            this.clearStatus();
            return new TestSuite(clazz);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            this.runFailed("Suite() method must be static");
            return null;
        }
        Test test = null;
        try {
            test = (Test)method.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.runFailed("Failed to invoke suite():" + invocationTargetException.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.runFailed("Failed to invoke suite():" + illegalAccessException.toString());
            return null;
        }
        this.clearStatus();
        return test;
    }

    public String elapsedTimeAsString(long l) {
        return NumberFormat.getInstance().format((double)l / 1000.0);
    }

    protected String processArguments(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-noloading")) {
                this.setLoading(false);
                continue;
            }
            if (stringArray[i].equals("-nofilterstack")) {
                fgFilterStack = false;
                continue;
            }
            if (stringArray[i].equals("-c")) {
                if (stringArray.length > i + 1) {
                    string = this.extractClassName(stringArray[i + 1]);
                } else {
                    System.out.println("Missing Test class name");
                }
                ++i;
                continue;
            }
            string = stringArray[i];
        }
        return string;
    }

    public void setLoading(boolean bl) {
        this.fLoading = bl;
    }

    public String extractClassName(String string) {
        if (string.startsWith("Default package for")) {
            return string.substring(string.lastIndexOf(".") + 1);
        }
        return string;
    }

    public static String truncate(String string) {
        if (fgMaxMessageLength != -1 && string.length() > fgMaxMessageLength) {
            string = string.substring(0, fgMaxMessageLength) + "...";
        }
        return string;
    }

    protected abstract void runFailed(String var1);

    protected Class loadSuiteClass(String string) throws ClassNotFoundException {
        return this.getLoader().load(string);
    }

    protected void clearStatus() {
    }

    public TestSuiteLoader getLoader() {
        if (this.useReloadingTestSuiteLoader()) {
            return new ReloadingTestSuiteLoader();
        }
        return new StandardTestSuiteLoader();
    }

    protected boolean useReloadingTestSuiteLoader() {
        return BaseTestRunner.getPreference("loading").equals("true") && !BaseTestRunner.inVAJava() && this.fLoading;
    }

    private static File getPreferencesFile() {
        String string = System.getProperty("user.home");
        return new File(string, "junit.properties");
    }

    private static void readPreferences() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(BaseTestRunner.getPreferencesFile());
            BaseTestRunner.setPreferences(new Properties(BaseTestRunner.getPreferences()));
            BaseTestRunner.getPreferences().load(fileInputStream);
        }
        catch (IOException iOException) {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }

    public static String getPreference(String string) {
        return BaseTestRunner.getPreferences().getProperty(string);
    }

    public static int getPreference(String string, int n) {
        String string2 = BaseTestRunner.getPreference(string);
        int n2 = n;
        if (string2 == null) {
            return n2;
        }
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static boolean inVAJava() {
        try {
            Class.forName("com.ibm.uvm.tools.DebugSupport");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getFilteredTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        StringBuffer stringBuffer = stringWriter.getBuffer();
        String string = stringBuffer.toString();
        return BaseTestRunner.getFilteredTrace(string);
    }

    public static String getFilteredTrace(String string) {
        if (BaseTestRunner.showStackRaw()) {
            return string;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (BaseTestRunner.filterLine(string2)) continue;
                printWriter.println(string2);
            }
        }
        catch (Exception exception) {
            return string;
        }
        return stringWriter.toString();
    }

    protected static boolean showStackRaw() {
        return !BaseTestRunner.getPreference("filterstack").equals("true") || !fgFilterStack;
    }

    static boolean filterLine(String string) {
        String[] stringArray = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke("};
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    static {
        fgMaxMessageLength = 500;
        fgFilterStack = true;
        fgMaxMessageLength = BaseTestRunner.getPreference("maxmessage", fgMaxMessageLength);
    }
}

