/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TestCaseClassLoader
extends ClassLoader {
    private Vector<String> fPathItems;
    private String[] defaultExclusions = new String[]{"junit.framework.", "junit.extensions.", "junit.runner."};
    static final String EXCLUDED_FILE = "excluded.properties";
    private Vector<String> fExcluded;

    public TestCaseClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public TestCaseClassLoader(String string) {
        this.scanPath(string);
        this.readExcludedPackages();
    }

    private void scanPath(String string) {
        String string2 = System.getProperty("path.separator");
        this.fPathItems = new Vector(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            this.fPathItems.addElement(stringTokenizer.nextToken());
        }
    }

    public URL getResource(String string) {
        return ClassLoader.getSystemResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        return ClassLoader.getSystemResourceAsStream(string);
    }

    public boolean isExcluded(String string) {
        for (int i = 0; i < this.fExcluded.size(); ++i) {
            if (!string.startsWith(this.fExcluded.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.isExcluded(string)) {
            try {
                clazz = this.findSystemClass(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            byte[] byArray = this.lookupClassData(string);
            if (byArray == null) {
                throw new ClassNotFoundException();
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private byte[] lookupClassData(String string) throws ClassNotFoundException {
        byte[] byArray = null;
        for (int i = 0; i < this.fPathItems.size(); ++i) {
            String string2 = this.fPathItems.elementAt(i);
            String string3 = string.replace('.', '/') + ".class";
            byArray = this.isJar(string2) ? this.loadJarData(string2, string3) : this.loadFileData(string2, string3);
            if (byArray == null) continue;
            return byArray;
        }
        throw new ClassNotFoundException(string);
    }

    boolean isJar(String string) {
        return string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".apk");
    }

    private byte[] loadFileData(String string, String string2) {
        File file = new File(string, string2);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    private byte[] getClassData(File file) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
            byte[] byArray = new byte[1000];
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadJarData(String string, String string2) {
        ZipFile zipFile = null;
        InputStream inputStream = null;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(string2);
        if (zipEntry == null) {
            return null;
        }
        int n = (int)zipEntry.getSize();
        try {
            int n2;
            inputStream = zipFile.getInputStream(zipEntry);
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; i += n2) {
                n2 = inputStream.read(byArray, i, byArray.length - i);
            }
            zipFile.close();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readExcludedPackages() {
        Properties properties;
        block14: {
            this.fExcluded = new Vector(10);
            for (int i = 0; i < this.defaultExclusions.length; ++i) {
                this.fExcluded.addElement(this.defaultExclusions[i]);
            }
            InputStream inputStream = this.getClass().getResourceAsStream(EXCLUDED_FILE);
            if (inputStream == null) {
                return;
            }
            properties = new Properties();
            properties.load(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            break block14;
            catch (IOException iOException) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("excluded.")) continue;
            String string2 = properties.getProperty(string);
            if ((string2 = string2.trim()).endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() <= 0) continue;
            this.fExcluded.addElement(string2);
        }
    }
}

