/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import lombok.ast.Select;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlwaysShowActionDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("AlwaysShowAction", "Checks for uses of showAsAction=\"always\" and suggests showAsAction=\"ifRoom\" instead", "Using showAsAction=\"always\" in menu XML, or MenuItem.SHOW_AS_ACTION_ALWAYS in Java code is usually a deviation from the user interface style guide.Use \"ifRoom\" or the corresponding MenuItem.SHOW_AS_ACTION_IF_ROOM instead.\n\nIf \"always\" is used sparingly there are usually no problems and behavior is roughly equivalent to \"ifRoom\" but with preference over other \"ifRoom\" items. Using it more than twice in the same menu is a bad idea.\n\nThis check looks for menu XML files that contain more than two \"always\" actions, or some \"always\" actions and no \"ifRoom\" actions. In Java code, it looks for projects that contain references to MenuItem.SHOW_AS_ACTION_ALWAYS and no references to MenuItem.SHOW_AS_ACTION_IF_ROOM.", Category.USABILITY, 3, Severity.WARNING, AlwaysShowActionDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.JAVA_FILE)).setMoreInfo("http://developer.android.com/design/patterns/actionbar.html");
    private List<Attr> mFileAttributes;
    private List<Location> mAlwaysFields;
    public boolean mHasIfRoomRefs;

    @Override
    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.MENU;
    }

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("showAsAction");
    }

    @Override
    public void beforeCheckFile(Context context) {
        this.mFileAttributes = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterCheckFile(Context context) {
        if (this.mFileAttributes != null) {
            String[] stringArray;
            assert (context instanceof XmlContext);
            ArrayList<Attr> arrayList = new ArrayList<Attr>();
            ArrayList<Attr> arrayList2 = new ArrayList<Attr>();
            block0: for (Attr object2 : this.mFileAttributes) {
                String string = object2.getValue();
                if (string.equals("always")) {
                    arrayList.add(object2);
                    continue;
                }
                if (string.equals("ifRoom")) {
                    arrayList2.add(object2);
                    continue;
                }
                if (string.indexOf(124) == -1) continue;
                for (String string2 : stringArray = string.split("\\|")) {
                    if (string2.equals("always")) {
                        arrayList.add(object2);
                        continue block0;
                    }
                    if (!string2.equals("ifRoom")) continue;
                    arrayList2.add(object2);
                    continue block0;
                }
            }
            if (arrayList.size() > 0 && this.mFileAttributes.size() > 1 && (arrayList.size() > 2 || arrayList2.size() == 0)) {
                void var5_7;
                XmlContext xmlContext = (XmlContext)context;
                Object var5_6 = null;
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    stringArray = var5_7;
                    Location location = xmlContext.getLocation((org.w3c.dom.Node)arrayList.get(i));
                    if (stringArray == null) continue;
                    location.setSecondary((Location)stringArray);
                }
                context.report(ISSUE, (Location)var5_7, "Prefer \"ifRoom\" instead of \"always\"", null);
            }
        }
    }

    @Override
    public void afterCheckProject(Context context) {
        if (this.mAlwaysFields != null && !this.mHasIfRoomRefs) {
            for (Location location : this.mAlwaysFields) {
                context.report(ISSUE, location, "Prefer \"SHOW_AS_ACTION_IF_ROOM\" instead of \"SHOW_AS_ACTION_ALWAYS\"", null);
            }
        }
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        if (this.mFileAttributes == null) {
            this.mFileAttributes = new ArrayList<Attr>();
        }
        this.mFileAttributes.add(attr);
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(Select.class);
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext javaContext) {
        return new FieldAccessChecker(javaContext);
    }

    private class FieldAccessChecker
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public FieldAccessChecker(JavaContext javaContext) {
            this.mContext = javaContext;
        }

        public boolean visitSelect(Select select) {
            String string = select.astIdentifier().getDescription();
            boolean bl = string.equals("SHOW_AS_ACTION_IF_ROOM");
            boolean bl2 = string.equals("SHOW_AS_ACTION_ALWAYS");
            if ((bl || bl2) && select.astOperand().toString().equals("MenuItem")) {
                if (bl2) {
                    if (AlwaysShowActionDetector.this.mAlwaysFields == null) {
                        AlwaysShowActionDetector.this.mAlwaysFields = new ArrayList();
                    }
                    AlwaysShowActionDetector.this.mAlwaysFields.add(this.mContext.getLocation((Node)select));
                } else {
                    AlwaysShowActionDetector.this.mHasIfRoomRefs = true;
                }
            }
            return super.visitSelect(select);
        }
    }
}

