/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.Api;
import com.android.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiClass {
    private final String mName;
    private final int mSince;
    private final List<Pair<String, Integer>> mSuperClasses = new ArrayList<Pair<String, Integer>>();
    private final List<Pair<String, Integer>> mInterfaces = new ArrayList<Pair<String, Integer>>();
    private final Map<String, Integer> mFields = new HashMap<String, Integer>();
    private final Map<String, Integer> mMethods = new HashMap<String, Integer>();

    public ApiClass(String string, int n) {
        this.mName = string;
        this.mSince = n;
    }

    public String getName() {
        return this.mName;
    }

    public int getSince() {
        return this.mSince;
    }

    public Integer getField(String string, Api api) {
        int n;
        ApiClass apiClass;
        int n2 = Integer.MAX_VALUE;
        Integer n3 = this.mFields.get(string);
        if (n3 != null) {
            n2 = n3;
        }
        for (Pair<String, Integer> pair : this.mSuperClasses) {
            apiClass = api.getClass(pair.getFirst());
            if (apiClass == null || (n3 = apiClass.getField(string, api)) == null || (n = (pair.getSecond() > n3 ? pair.getSecond() : n3).intValue()) >= n2) continue;
            n2 = n;
        }
        for (Pair<String, Integer> pair : this.mInterfaces) {
            apiClass = api.getClass(pair.getFirst());
            if (apiClass == null || (n3 = apiClass.getField(string, api)) == null || (n = (pair.getSecond() > n3 ? pair.getSecond() : n3).intValue()) >= n2) continue;
            n2 = n;
        }
        return n2;
    }

    public int getMethod(String string, Api api) {
        int n = Integer.MAX_VALUE;
        Integer n2 = this.mMethods.get(string);
        if (n2 != null) {
            n = n2;
        }
        for (Pair<String, Integer> pair : this.mSuperClasses) {
            int n3;
            ApiClass apiClass = api.getClass(pair.getFirst());
            if (apiClass == null || (n2 = Integer.valueOf(apiClass.getMethod(string, api))) == null || (n3 = (pair.getSecond() > n2 ? pair.getSecond() : n2).intValue()) >= n) continue;
            n = n3;
        }
        return n;
    }

    public void addField(String string, int n) {
        Integer n2 = this.mFields.get(string);
        if (n2 == null || n2 > n) {
            this.mFields.put(string, n);
        }
    }

    public void addMethod(String string, int n) {
        Integer n2;
        int n3 = string.indexOf(41);
        if (n3 != -1) {
            string = string.substring(0, n3 + 1);
        }
        if ((n2 = this.mMethods.get(string)) == null || n2 > n) {
            this.mMethods.put(string, n);
        }
    }

    public void addSuperClass(String string, int n) {
        this.addToArray(this.mSuperClasses, string, n);
    }

    public void addInterface(String string, int n) {
        this.addToArray(this.mInterfaces, string, n);
    }

    void addToArray(List<Pair<String, Integer>> list, String string, int n) {
        for (Pair<String, Integer> pair : list) {
            if (!string.equals(pair.getFirst())) continue;
            return;
        }
        list.add(Pair.of(string, n));
    }

    public String toString() {
        return this.mName;
    }

    public Set<String> getAllMethods(Api api) {
        HashSet<String> hashSet = new HashSet<String>(100);
        this.addAllMethods(api, hashSet);
        return hashSet;
    }

    private void addAllMethods(Api api, Set<String> set) {
        for (String object : this.mMethods.keySet()) {
            set.add(object);
        }
        for (Pair pair : this.mSuperClasses) {
            ApiClass apiClass = api.getClass((String)pair.getFirst());
            assert (apiClass != null) : (Integer)pair.getSecond();
            if (apiClass == null) continue;
            apiClass.addAllMethods(api, set);
        }
    }

    public Set<String> getAllFields(Api api) {
        HashSet<String> hashSet = new HashSet<String>(100);
        this.addAllFields(api, hashSet);
        return hashSet;
    }

    private void addAllFields(Api api, Set<String> set) {
        for (String object : this.mFields.keySet()) {
            set.add(object);
        }
        for (Pair pair : this.mSuperClasses) {
            ApiClass apiClass = api.getClass((String)pair.getFirst());
            assert (apiClass != null) : (Integer)pair.getSecond();
            if (apiClass == null) continue;
            apiClass.addAllFields(api, set);
        }
    }
}

