/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiDetector
extends ResourceXmlDetector
implements Detector.ClassScanner {
    private static final boolean AOSP_BUILD = System.getenv("ANDROID_BUILD_TOP") != null;
    private static final String TARGET_API_VMSIG = "/TargetApi;";
    public static final Issue UNSUPPORTED = Issue.create("NewApi", "Finds API accesses to APIs that are not supported in all targeted API versions", "This check scans through all the Android API calls in the application and warns about any calls that are not available on *all* versions targeted by this application (according to its minimum SDK attribute in the manifest).\n\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the @TargetApi annotation specifying the local minimum SDK to apply, such as@TargetApi(11), such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.", Category.CORRECTNESS, 6, Severity.ERROR, ApiDetector.class, EnumSet.of(Scope.CLASS_FILE, Scope.RESOURCE_FILE));
    private ApiLookup mApiDatabase;
    private int mMinApi = -1;

    @Override
    public boolean appliesTo(Context context, File file) {
        return true;
    }

    @Override
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    public void beforeCheckProject(Context context) {
        this.mApiDatabase = ApiLookup.get(context.getClient());
    }

    @Override
    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return true;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ALL;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        int n;
        String string;
        String string2;
        int n2;
        int n3;
        if (this.mApiDatabase == null) {
            return;
        }
        String string3 = attr.getValue();
        if (string3.startsWith("@android:") && (n3 = string3.indexOf(47, "@android:".length())) != -1 && (n2 = this.mApiDatabase.getFieldVersion(string2 = "android/R$" + string3.substring("@android:".length(), n3), string = string3.substring(n3 + 1))) > (n = this.getMinSdk(xmlContext)) && n2 > xmlContext.getFolderVersion()) {
            Location location = xmlContext.getLocation(attr);
            String string4 = String.format("%1$s requires API level %2$d (current min is %3$d)", string3, n2, n);
            xmlContext.report(UNSUPPORTED, attr, location, string4, null);
        }
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        if (this.mApiDatabase == null) {
            return;
        }
        String string = element.getTagName();
        ResourceFolderType resourceFolderType = xmlContext.getResourceFolderType();
        if (resourceFolderType != ResourceFolderType.LAYOUT) {
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string2;
                String string3;
                int n3;
                int n4;
                String string4;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 3 || (string4 = node.getNodeValue()).indexOf("@android:") == -1 || (n4 = (string4 = string4.trim()).indexOf(47, "@android:".length())) == -1 || (n3 = this.mApiDatabase.getFieldVersion(string3 = "android/R$" + string4.substring("@android:".length(), n4), string2 = string4.substring(n4 + 1))) <= (n2 = this.getMinSdk(xmlContext)) || n3 <= xmlContext.getFolderVersion()) continue;
                Location location = xmlContext.getLocation(node);
                String string5 = String.format("%1$s requires API level %2$d (current min is %3$d)", string4, n3, n2);
                xmlContext.report(UNSUPPORTED, element, location, string5, null);
            }
        } else if (resourceFolderType == ResourceFolderType.LAYOUT) {
            int n;
            if (string.indexOf(46) != -1 || resourceFolderType != ResourceFolderType.LAYOUT) {
                return;
            }
            int n5 = this.mApiDatabase.getCallVersion("android/widget/" + string, "<init>", "(Landroid/content/Context;)");
            if (n5 > (n = this.getMinSdk(xmlContext)) && n5 > xmlContext.getFolderVersion()) {
                Location location = xmlContext.getLocation(element);
                String string6 = String.format("View requires API level %1$d (current min is %2$d): <%3$s>", n5, n, string);
                xmlContext.report(UNSUPPORTED, element, location, string6, null);
            }
        }
    }

    private int getMinSdk(Context context) {
        if (this.mMinApi == -1) {
            this.mMinApi = context.getMainProject().getMinSdk();
        }
        return this.mMinApi;
    }

    @Override
    public void checkClass(ClassContext classContext, ClassNode classNode) {
        if (this.mApiDatabase == null) {
            return;
        }
        if (AOSP_BUILD && classNode.name.startsWith("android/support/")) {
            return;
        }
        int n = this.getClassMinSdk(classContext, classNode);
        if (n == -1) {
            n = this.getMinSdk(classContext);
        }
        List list = classNode.methods;
        for (Object e : list) {
            int n2;
            int n3;
            String string;
            Object object;
            String string2;
            Object object2;
            Object object3;
            MethodNode methodNode = (MethodNode)e;
            int n4 = this.getLocalMinSdk(methodNode.invisibleAnnotations);
            if (n4 == -1) {
                n4 = n;
            }
            InsnList insnList = methodNode.instructions;
            List list2 = methodNode.localVariables;
            if (list2 != null) {
                object3 = list2.iterator();
                while (object3.hasNext()) {
                    int n5;
                    Object e2 = object3.next();
                    object2 = (LocalVariableNode)e2;
                    String string3 = ((LocalVariableNode)object2).desc;
                    if (string3.charAt(0) != 'L' || (n5 = this.mApiDatabase.getClassVersion(string2 = string3.substring(1, string3.length() - 1))) <= n4) continue;
                    object = string2.replace('/', '.').replace('$', '.');
                    string = String.format("Class requires API level %1$d (current min is %2$d): %3$s", n5, n4, object);
                    this.report(classContext, string, ((LocalVariableNode)object2).start, methodNode, string2.substring(string2.lastIndexOf(47) + 1), null);
                }
            }
            if ((object3 = methodNode.desc) != null && (n3 = ((String)object3).indexOf(41)) != -1 && ((String)object3).charAt(n3 + 1) == 'L' && (n2 = this.mApiDatabase.getClassVersion((String)(object2 = ((String)object3).substring(n3 + 2, ((String)object3).length() - 1)))) > n4) {
                string2 = ((String)object2).replace('/', '.').replace('$', '.');
                String string4 = String.format("Class requires API level %1$d (current min is %2$d): %3$s", n2, n4, string2);
                object = insnList.size() > 0 ? insnList.get(0) : null;
                this.report(classContext, string4, (AbstractInsnNode)object, methodNode, null, null);
            }
            int n6 = insnList.size();
            for (int i = 0; i < n6; ++i) {
                int n7;
                String string5;
                AbstractInsnNode abstractInsnNode;
                AbstractInsnNode abstractInsnNode2 = insnList.get(i);
                int n8 = abstractInsnNode2.getType();
                if (n8 == 5) {
                    abstractInsnNode = (MethodInsnNode)abstractInsnNode2;
                    object = ((MethodInsnNode)abstractInsnNode).name;
                    string = ((MethodInsnNode)abstractInsnNode).owner;
                    String string6 = ((MethodInsnNode)abstractInsnNode).desc;
                    if (abstractInsnNode.getOpcode() == 182 && string.equals(classNode.name)) {
                        string = classNode.superName;
                    }
                    do {
                        int n9;
                        if ((n9 = this.mApiDatabase.getCallVersion(string, (String)object, string6)) <= n4) continue;
                        string5 = string.replace('/', '.') + '#' + (String)object;
                        String string7 = String.format("Call requires API level %1$d (current min is %2$d): %3$s", n9, n4, string5);
                        this.report(classContext, string7, abstractInsnNode, methodNode, (String)object, null);
                    } while ((string = abstractInsnNode.getOpcode() == 182 ? classContext.getDriver().getSuperClass(string) : null) != null);
                    continue;
                }
                if (n8 == 4) {
                    abstractInsnNode = (FieldInsnNode)abstractInsnNode2;
                    string = ((FieldInsnNode)abstractInsnNode).owner;
                    object = ((FieldInsnNode)abstractInsnNode).name;
                    int n10 = this.mApiDatabase.getFieldVersion(string, (String)object);
                    if (n10 <= n4) continue;
                    String string8 = string.replace('/', '.') + '#' + (String)object;
                    string5 = String.format("Field requires API level %1$d (current min is %2$d): %3$s", n10, n4, string8);
                    this.report(classContext, string5, abstractInsnNode, methodNode, (String)object, null);
                    continue;
                }
                if (n8 != 9) continue;
                abstractInsnNode = (LdcInsnNode)abstractInsnNode2;
                if (!(((LdcInsnNode)abstractInsnNode).cst instanceof Type) || (n7 = this.mApiDatabase.getClassVersion(string = ((Type)(object = (Type)((LdcInsnNode)abstractInsnNode).cst)).getInternalName())) <= n4) continue;
                String string9 = string.replace('/', '.');
                string5 = String.format("Class requires API level %1$d (current min is %2$d): %3$s", n7, n4, string9);
                this.report(classContext, string5, abstractInsnNode, methodNode, string.substring(string.lastIndexOf(47) + 1), null);
            }
        }
    }

    private int getClassMinSdk(ClassContext classContext, ClassNode classNode) {
        int n = this.getLocalMinSdk(classNode.invisibleAnnotations);
        if (n != -1) {
            return n;
        }
        LintDriver lintDriver = classContext.getDriver();
        while (classNode != null) {
            ClassNode classNode2 = classNode;
            if ((classNode = lintDriver.getOuterClassNode(classNode)) == null) continue;
            if (classNode2.outerMethod != null) {
                List list = classNode.methods;
                for (Object e : list) {
                    MethodNode methodNode = (MethodNode)e;
                    if (!methodNode.name.equals(classNode2.outerMethod) || !methodNode.desc.equals(classNode2.outerMethodDesc)) continue;
                    int n2 = this.getLocalMinSdk(methodNode.invisibleAnnotations);
                    if (n2 == -1) break;
                    return n2;
                }
            }
            if ((n = this.getLocalMinSdk(classNode.invisibleAnnotations)) == -1) continue;
            return n;
        }
        return -1;
    }

    private int getLocalMinSdk(List list) {
        if (list != null) {
            for (AnnotationNode annotationNode : list) {
                String string = annotationNode.desc;
                if (!string.endsWith(TARGET_API_VMSIG) || annotationNode.values == null) continue;
                int n = annotationNode.values.size();
                for (int i = 0; i < n; i += 2) {
                    String string2 = (String)annotationNode.values.get(i);
                    if (!string2.equals("value")) continue;
                    Object e = annotationNode.values.get(i + 1);
                    if (e instanceof Integer) {
                        return (Integer)e;
                    }
                    if (!(e instanceof List)) continue;
                    List list2 = (List)e;
                    for (Object e2 : list2) {
                        if (!(e2 instanceof Integer)) continue;
                        return (Integer)e;
                    }
                }
            }
        }
        return -1;
    }

    private void report(ClassContext classContext, String string, AbstractInsnNode abstractInsnNode, MethodNode methodNode, String string2, String string3) {
        int n = abstractInsnNode != null ? ClassContext.findLineNumber(abstractInsnNode) : -1;
        Location location = classContext.getLocationForLine(n, string2, string3);
        classContext.report(UNSUPPORTED, methodNode, location, string, null);
    }
}

