/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.prefs.AndroidLocation;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.ArraySizeDetector;
import com.android.tools.lint.checks.ButtonDetector;
import com.android.tools.lint.checks.ChildCountDetector;
import com.android.tools.lint.checks.ColorUsageDetector;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.DetectMissingPrefix;
import com.android.tools.lint.checks.DuplicateIdDetector;
import com.android.tools.lint.checks.ExtraTextDetector;
import com.android.tools.lint.checks.FieldGetterDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.HardcodedDebugModeDetector;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.ManifestOrderDetector;
import com.android.tools.lint.checks.MathDetector;
import com.android.tools.lint.checks.MergeRootFrameLayoutDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.NestedScrollingWidgetDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.OnClickDetector;
import com.android.tools.lint.checks.OverdrawDetector;
import com.android.tools.lint.checks.PrivateResourceDetector;
import com.android.tools.lint.checks.ProguardDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.RegistrationDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SdCardDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.StateListDetector;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.checks.StyleCycleDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TooManyViewsDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UseCompoundDrawableDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.ViewConstructorDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.checks.WrongIdDetector;
import com.android.tools.lint.checks.WrongImportDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.Beta;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinIssueRegistry
extends IssueRegistry {
    private static final String LINT_FOLDER = "lint";
    private static final String MF_LINT_REGISTRY = "Lint-Registry";
    private static final List<Issue> sIssues;
    private static Set<Issue> sAdtFixes;

    @Override
    public List<Issue> getIssues() {
        return sIssues;
    }

    private static void addCustomIssues(List<Issue> list) {
        Object[] objectArray;
        Object object;
        HashSet<Object> hashSet = null;
        try {
            object = new File(AndroidLocation.getFolder() + File.separator + LINT_FOLDER);
            if (((File)object).exists() && (objectArray = ((File)object).listFiles()) != null) {
                for (Object object2 : objectArray) {
                    if (!LintUtils.endsWith(((File)object2).getName(), ".jar")) continue;
                    if (hashSet == null) {
                        hashSet = new HashSet<Object>();
                    }
                    hashSet.add(object2);
                    BuiltinIssueRegistry.addIssuesFromJar((File)object2, list);
                }
            }
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            // empty catch block
        }
        if ((object = System.getenv("ANDROID_LINT_JARS")) != null && ((String)object).length() > 0) {
            objectArray = ((String)object).split(File.pathSeparator);
            for (Object object2 : objectArray) {
                File file = new File((String)object2);
                if (!file.exists() || hashSet != null && hashSet.contains(file)) continue;
                BuiltinIssueRegistry.addIssuesFromJar(file, list);
            }
        }
    }

    private static void addIssuesFromJar(File file, List<Issue> list) {
        block7: {
            try {
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                Object object = attributes.get(new Attributes.Name(MF_LINT_REGISTRY));
                if (!(object instanceof String)) break block7;
                String string = (String)object;
                try {
                    URL uRL = file.toURI().toURL();
                    URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, BuiltinIssueRegistry.class.getClassLoader());
                    try {
                        Class<?> clazz = Class.forName(string, true, uRLClassLoader);
                        IssueRegistry issueRegistry = (IssueRegistry)clazz.newInstance();
                        for (Issue issue : issueRegistry.getIssues()) {
                            list.add(issue);
                        }
                    }
                    catch (Throwable throwable) {
                        BuiltinIssueRegistry.log(throwable);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    BuiltinIssueRegistry.log(malformedURLException);
                }
            }
            catch (IOException iOException) {
                BuiltinIssueRegistry.log(iOException);
            }
        }
    }

    private static void log(Throwable throwable) {
        throwable.printStackTrace();
    }

    @Beta
    public boolean hasAutoFix(String string, Issue issue) {
        assert (string.equals("adt"));
        if (sAdtFixes == null) {
            sAdtFixes = new HashSet<Issue>(20);
            sAdtFixes.add(InefficientWeightDetector.INEFFICIENT_WEIGHT);
            sAdtFixes.add(AccessibilityDetector.ISSUE);
            sAdtFixes.add(InefficientWeightDetector.BASELINE_WEIGHTS);
            sAdtFixes.add(HardcodedValuesDetector.ISSUE);
            sAdtFixes.add(UselessViewDetector.USELESS_LEAF);
            sAdtFixes.add(UselessViewDetector.USELESS_PARENT);
            sAdtFixes.add(PxUsageDetector.ISSUE);
            sAdtFixes.add(TextFieldDetector.ISSUE);
            sAdtFixes.add(SecurityDetector.EXPORTED_SERVICE);
            sAdtFixes.add(DetectMissingPrefix.MISSING_NAMESPACE);
            sAdtFixes.add(ScrollViewChildDetector.ISSUE);
            sAdtFixes.add(ObsoleteLayoutParamsDetector.ISSUE);
            sAdtFixes.add(TypographyDetector.DASHES);
            sAdtFixes.add(TypographyDetector.ELLIPSIS);
            sAdtFixes.add(TypographyDetector.FRACTIONS);
            sAdtFixes.add(TypographyDetector.OTHER);
            sAdtFixes.add(TypographyDetector.QUOTES);
            sAdtFixes.add(UseCompoundDrawableDetector.ISSUE);
            sAdtFixes.add(ApiDetector.UNSUPPORTED);
        }
        return sAdtFixes.contains(issue);
    }

    static {
        ArrayList<Issue> arrayList = new ArrayList<Issue>(83);
        arrayList.add(AccessibilityDetector.ISSUE);
        arrayList.add(MathDetector.ISSUE);
        arrayList.add(FieldGetterDetector.ISSUE);
        arrayList.add(SdCardDetector.ISSUE);
        arrayList.add(ApiDetector.UNSUPPORTED);
        arrayList.add(DuplicateIdDetector.CROSS_LAYOUT);
        arrayList.add(DuplicateIdDetector.WITHIN_LAYOUT);
        arrayList.add(WrongIdDetector.UNKNOWN_ID);
        arrayList.add(WrongIdDetector.UNKNOWN_ID_LAYOUT);
        arrayList.add(StateListDetector.ISSUE);
        arrayList.add(StyleCycleDetector.ISSUE);
        arrayList.add(InefficientWeightDetector.INEFFICIENT_WEIGHT);
        arrayList.add(InefficientWeightDetector.NESTED_WEIGHTS);
        arrayList.add(InefficientWeightDetector.BASELINE_WEIGHTS);
        arrayList.add(ScrollViewChildDetector.ISSUE);
        arrayList.add(DeprecationDetector.ISSUE);
        arrayList.add(ObsoleteLayoutParamsDetector.ISSUE);
        arrayList.add(MergeRootFrameLayoutDetector.ISSUE);
        arrayList.add(NestedScrollingWidgetDetector.ISSUE);
        arrayList.add(ChildCountDetector.SCROLLVIEW_ISSUE);
        arrayList.add(ChildCountDetector.ADAPTERVIEW_ISSUE);
        arrayList.add(UseCompoundDrawableDetector.ISSUE);
        arrayList.add(UselessViewDetector.USELESS_PARENT);
        arrayList.add(UselessViewDetector.USELESS_LEAF);
        arrayList.add(TooManyViewsDetector.TOO_MANY);
        arrayList.add(TooManyViewsDetector.TOO_DEEP);
        arrayList.add(GridLayoutDetector.ISSUE);
        arrayList.add(OnClickDetector.ISSUE);
        arrayList.add(RegistrationDetector.ISSUE);
        arrayList.add(TranslationDetector.EXTRA);
        arrayList.add(TranslationDetector.MISSING);
        arrayList.add(HardcodedValuesDetector.ISSUE);
        arrayList.add(Utf8Detector.ISSUE);
        arrayList.add(ProguardDetector.WRONGKEEP);
        arrayList.add(ProguardDetector.SPLITCONFIG);
        arrayList.add(PxUsageDetector.ISSUE);
        arrayList.add(TextFieldDetector.ISSUE);
        arrayList.add(TextViewDetector.ISSUE);
        arrayList.add(UnusedResourceDetector.ISSUE);
        arrayList.add(UnusedResourceDetector.ISSUE_IDS);
        arrayList.add(ExtraTextDetector.ISSUE);
        arrayList.add(PrivateResourceDetector.ISSUE);
        arrayList.add(ArraySizeDetector.INCONSISTENT);
        arrayList.add(HardcodedDebugModeDetector.ISSUE);
        arrayList.add(ManifestOrderDetector.ORDER);
        arrayList.add(ManifestOrderDetector.USES_SDK);
        arrayList.add(ManifestOrderDetector.MULTIPLE_USES_SDK);
        arrayList.add(SecurityDetector.EXPORTED_SERVICE);
        arrayList.add(SecurityDetector.OPEN_PROVIDER);
        arrayList.add(SecurityDetector.WORLD_WRITEABLE);
        arrayList.add(IconDetector.GIF_USAGE);
        arrayList.add(IconDetector.ICON_DENSITIES);
        arrayList.add(IconDetector.ICON_MISSING_FOLDER);
        arrayList.add(IconDetector.ICON_DIP_SIZE);
        arrayList.add(IconDetector.ICON_EXPECTED_SIZE);
        arrayList.add(IconDetector.ICON_LOCATION);
        arrayList.add(IconDetector.DUPLICATES_NAMES);
        arrayList.add(IconDetector.DUPLICATES_CONFIGURATIONS);
        arrayList.add(IconDetector.ICON_NODPI);
        arrayList.add(TypographyDetector.DASHES);
        arrayList.add(TypographyDetector.QUOTES);
        arrayList.add(TypographyDetector.FRACTIONS);
        arrayList.add(TypographyDetector.ELLIPSIS);
        arrayList.add(TypographyDetector.OTHER);
        arrayList.add(ButtonDetector.ORDER);
        arrayList.add(ButtonDetector.CASE);
        arrayList.add(ButtonDetector.BACKBUTTON);
        arrayList.add(DetectMissingPrefix.MISSING_NAMESPACE);
        arrayList.add(OverdrawDetector.ISSUE);
        arrayList.add(StringFormatDetector.INVALID);
        arrayList.add(StringFormatDetector.ARG_COUNT);
        arrayList.add(StringFormatDetector.ARG_TYPES);
        arrayList.add(ViewTypeDetector.ISSUE);
        arrayList.add(WrongImportDetector.ISSUE);
        arrayList.add(ViewConstructorDetector.ISSUE);
        arrayList.add(NamespaceDetector.CUSTOMVIEW);
        arrayList.add(NamespaceDetector.UNUSED);
        arrayList.add(NamespaceDetector.TYPO);
        arrayList.add(AlwaysShowActionDetector.ISSUE);
        arrayList.add(ColorUsageDetector.ISSUE);
        arrayList.add(JavaPerformanceDetector.PAINT_ALLOC);
        arrayList.add(JavaPerformanceDetector.USE_VALUEOF);
        arrayList.add(JavaPerformanceDetector.USE_SPARSEARRAY);
        assert (83 >= arrayList.size()) : arrayList.size();
        BuiltinIssueRegistry.addCustomIssues(arrayList);
        sIssues = Collections.unmodifiableList(arrayList);
        if (LintUtils.assertionsEnabled()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Issue issue : sIssues) {
                String string = issue.getId();
                assert (!hashSet.contains(string)) : "Duplicate id " + string;
                hashSet.add(string);
            }
        }
    }
}

