/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ExtraTextDetector
extends ResourceXmlDetector {
    private boolean mFoundText;
    public static final Issue ISSUE = Issue.create("ExtraText", "Looks for extraneous text in layout files", "Layout resource files should only contain elements and attributes. Any XML text content found in the file is likely accidental (and potentially dangerous if the text resembles XML and the developer believes the text to be functional)", Category.CORRECTNESS, 3, Severity.WARNING, ExtraTextDetector.class, Scope.RESOURCE_FILE_SCOPE);

    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.LAYOUT || resourceFolderType == ResourceFolderType.MENU || resourceFolderType == ResourceFolderType.ANIMATOR || resourceFolderType == ResourceFolderType.ANIMATOR || resourceFolderType == ResourceFolderType.DRAWABLE || resourceFolderType == ResourceFolderType.COLOR;
    }

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(XmlContext xmlContext, Document document) {
        this.mFoundText = false;
        this.visitNode(xmlContext, document);
    }

    private void visitNode(XmlContext xmlContext, Node node) {
        int n;
        int n2;
        Object object;
        short s = node.getNodeType();
        if (s == 3 && !this.mFoundText) {
            object = node.getNodeValue();
            n2 = ((String)object).length();
            for (n = 0; n < n2; ++n) {
                Position position;
                char c = ((String)object).charAt(n);
                if (Character.isWhitespace(c)) continue;
                String string = ((String)object).trim();
                int n3 = 100;
                if (string.length() > n3) {
                    string = string.substring(0, n3) + "...";
                }
                Location location = xmlContext.getLocation(node);
                if (n > 0 && (position = location.getStart()) != null) {
                    int n4 = position.getLine();
                    int n5 = position.getColumn();
                    int n6 = position.getOffset();
                    for (int i = 0; i < n; ++i) {
                        ++n6;
                        if (((String)object).charAt(i) == '\n') {
                            if (n4 != -1) {
                                ++n4;
                            }
                            if (n5 == -1) continue;
                            n5 = 0;
                            continue;
                        }
                        if (n5 == -1) continue;
                        ++n5;
                    }
                    position = new DefaultPosition(n4, n5, n6);
                    location = Location.create(xmlContext.file, position, location.getEnd());
                }
                xmlContext.report(ISSUE, node, location, String.format("Unexpected text found in layout file: \"%1$s\"", string), null);
                this.mFoundText = true;
                break;
            }
        }
        object = node.getChildNodes();
        n2 = object.getLength();
        for (n = 0; n < n2; ++n) {
            Node node2 = object.item(n);
            this.visitNode(xmlContext, node2);
        }
    }
}

