/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayoutDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("GridLayout", "Checks for potential GridLayout errors like declaring rows and columns outside the declared grid dimensions", "Declaring a layout_row or layout_column that falls outside the declared size of a GridLayout's rowCount or columnCount is usually an unintentional error.", Category.CORRECTNESS, 4, Severity.FATAL, GridLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("GridLayout");
    }

    private static int getInt(Element element, String string, int n) {
        String string2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", string);
        if (string2 != null && string2.length() > 0) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        int n = GridLayoutDetector.getInt(element, "rowCount", -1);
        int n2 = GridLayoutDetector.getInt(element, "columnCount", -1);
        if (n2 != -1 || n != -1) {
            for (Element element2 : LintUtils.getChildren(element)) {
                Attr attr;
                int n3;
                if (n2 != -1 && (n3 = GridLayoutDetector.getInt(element2, "layout_column", -1)) >= n2) {
                    attr = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_column");
                    xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), String.format("Column attribute (%1$d) exceeds declared grid column count (%2$d)", n3, n2), null);
                }
                if (n == -1 || (n3 = GridLayoutDetector.getInt(element2, "layout_row", -1)) <= n) continue;
                attr = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_row");
                xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), String.format("Row attribute (%1$d) exceeds declared grid row count (%2$d)", n3, n), null);
            }
        }
    }
}

