/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardcodedDebugModeDetector
extends Detector
implements Detector.XmlScanner {
    public static final Issue ISSUE = Issue.create("HardcodedDebugMode", "Checks for hardcoded values of android:debuggable in the manifest", "It's best to leave out the android:debuggable attribute from the manifest. If you do, then the tools will automatically insert android:debuggable=true when building an APK to debug on an emulator or device. And when you perform a release build, such as Exporting APK, it will automatically set it to false.\n\nIf on the other hand you specify a specific value in the manifest file, then the tools will always use it. This can lead to accidentally publishing your app with debug information.", Category.SECURITY, 5, Severity.WARNING, HardcodedDebugModeDetector.class, EnumSet.of(Scope.MANIFEST));

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singleton("debuggable");
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        if (attr.getNamespaceURI().equals("http://schemas.android.com/apk/res/android")) {
            xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), "Avoid hardcoding the debug mode; leaving it out allows debug and release builds to automatically assign one", null);
        }
    }
}

